/*
 Test for output for swiss-infras project May 2010
 Global part - emissions pathways and temperature

 1. Set parameters
 2. Collect curves
 3. Plot and export
 4. add CO2 eq plot
 4. extra data out : integrals and points
 4. data-tables out
 5. try varying carbon cycle / climate params
 */

package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import jcm.core.loop;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.cur.units;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;

import jcm.mod.resp.attribTracer;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import  static jcm.mod.obj.stabilisation.indicators.*;
import  static jcm.mod.obj.stabilisation.curvetype.*;

public class swinf_regional extends calcscript {

    globco2emit gc=gm(globco2emit.class);
    carboncycle car  = gm(carboncycle.class);
    glotemp tem= gm(glotemp.class) ;
    radfor rf= gm(radfor.class);
    stabilisation stab=gm(stabilisation.class);
    shares sha=gm(shares.class);
    pledges ple=gm(pledges.class);
    emitquota eq=gm(emitquota.class);
    controller co=gm(controller.class);

    Map<curveset, curve> curvemap= new HashMap();
    //Map<scenarios, float[]> indics = new HashMap();
    String indics=" Scenario\t\t Emit CO2eq 2020 \t Emit CO2eq  2050 \t IntegC 2050 \t IntegC 2300 \n";
    String descriptions ="Scenario Descriptions\n";

    enum scenarios { 
            fiftypercent_2C (ltgreen), fiftypercent_15C (dkgreen),  concpeak_2C(blue), stabrf3W (brown) ;
            Color col;
            String info;
            scenarios (Color c) { col=c;}
    };

    
    public void run() {

    lookandfeel.fontSize.set(12);

    //set some plotlinks to ensure model loop knows what to calculate
    link(tem.temp); link(car.conc);

    curvemap.put(new curveset("fossil_CO2_emissions", "mega&ton&carbon", 1850, 2250, 1), gc.fossil);
    curvemap.put(new curveset("CO2eq_emissions", "mega&ton&co2", 1850, 2250, 1), gc.co2eqtot); //
    curvemap.put(new curveset("CO2 concentration", "ppm", 1850, 2250, 1), car.co2atppm);
    curvemap.put(new curveset("CO2eq concn allgas+aeros", "ppm", 1850, 2250, 1), rf.co2eqghgaero);
    curvemap.put(new curveset("Temperature", "degcbase", 1850, 2250, 1), tem.avchangeby);

    // (non default) parameters shared by all scenarios
    
    stab.peaking.set(true);
    co.botuptopdo.set(controller.butd.start_bottom_up);
    sha.distribution.set(shares.distriboptions.convergence);
    sha.rate_caps.set(true);
    ple.level.set(pledges.pledgelevel.conditional);

    for (scenarios scen : scenarios.values()) { //loop through scenarios
    log("Setting parameters for "+scen.name());
    switch (scen) { //set parameters per scenario
        case fiftypercent_2C : {
            stab.indicator.set(stabilisation.indicators.define_emit);
            stab.stabemityear.set(2050);
            stab.stabemitlevel.set(3850);
            stab.stabemitendlevel.set(250);
            stab.stabemitdeclinerate.set(1.25);
            co.startyear_topdown.set(2020);
            sha.rate_constraint.set(6.5);
            scen.info="This scenario begins with a defined emissions trajectory to reach the key policy target of 50% of 1990 by 2050 (CO2eq emissions inc CH4, N2O+LUC), " +
                    "After 2050 the emissions curve continues along an trajectory in which total CO2 emissions decline exponentially at -1.25%/yr towards a minimum level of 0.25GtC. " +
                    "This trajectory is chosen to stabilise the temperature at 2°C with default model parameters. " +
                    "There is a marked relaxation in the emissions decline after 2050. "+
                    "As for other scenarios in this group, the scenario starts with  high pledges in 2020 and continues regionally by a increasing participation with convergence. " +
                    "A top-down constraint applies from 2020 onwards. " +
                    "As the decline from 2020 to 2050 is steep, the decline rate cap on individual countries cannot be set lower than 6.5%/year."
                    ;
            break;
        }
        case fiftypercent_15C : {
            stab.stabemityear.set(2050);
            stab.stabemitlevel.set(3850);
            stab.stabemitendlevel.set(0);
            stab.stabemitdeclinerate.set(4.0);
            co.startyear_topdown.set(2020);
            sha.rate_constraint.set(6.5);
            scen.info= " This scenario is similar to the fiftypercent_2C until 2050. " +
                    "Thereafter total CO2 emissions decline exponentially at -4%/yr towards zero. " +
                    "This steep decline is a smooth continuation of the earlier part of the curve. " +
                    "Temperature peaks at around 1.8C in 2060 (CHECK) and declines thereafter, falling to 1.5C in 2250 (CHECK). " +
                    "Such a scenario may be particularly interesting to low-lying states as it has a greater chance to avoid catastrophic melting of the Greenland and WAIS ice caps."
                   ;
            break;
        }
        case concpeak_2C : {
            stab.indicator.set(stabilisation.indicators.stabconc); //usualy default
            stab.stabconclevel.set(470);
            stab.stabyear.set(2110);
            stab.stabconcendlevel.set(453);
            stab.curveopt.set(padequartic);
            co.startyear_topdown.set(2045);
            sha.rate_constraint.set(4);
             scen.info= " This is a more relaxed scenario also stabilising at 2C. " +
                    "It is defined by a peaking CO2 concentration curve at 470ppm in 2110, declining thereafter towards 453ppm in 2300. " +
                    "The temperature rises to 2C faster than in the other scenarios, reaching 1.9C by 2068 (CHECK). " +
                    "Consequently emissions can be higher in 2050  - around 25GtCO2eq (CHECK), or 65% of 1990.  " +
                    "This allows more flexibility in the individual country emissions - so the top-down constraint on all countries does not apply until 2045. " +
                    "And decline rate caps can be set at 4%/yr "
                   ;
            break;
        }
        case stabrf3W : {
            stab.indicator.set(stabilisation.indicators.stabrf_allghgaero);
            stab.stabrflevel.set(3.0);
            stab.stabyear.set(2125);
            stab.curveopt.set(padequintic);
            co.startyear_topdown.set(2020);
            sha.rate_constraint.set(6.5);
             scen.info= " This scenario follows a classic stabilise CO2equivalent concentration pathway. " +
                    "The stabilisation level is 3W/m2 (about 480ppm CO2eq )for all greenhouse gases and aerosols. " +
                    "The peak CO2eq concentration is a bit higher at around 490ppm. " +
                    "The temperature rises slowly towards 2C, reaching 1.9C only in 2125,  due to the gradual uptake of heat by the ocean. " +
                    "(which is not offset by declining forcing as in the other scenarios). " +
                    " The eventual equilibrium temperature associated with this forcing will be higher than 2C (CALCULATE). " +
                    " If the equilibrium would be 2C and the final CO2eq level may not be exceeded, the emissions decline would be even steeper. " +
                    " It is this type of  scenario pathway that dominated the analyses of IPCC AR4 WG3. " +
                    " Due to this pathway shape, the emissions are constrained in early years and are just below the 50% scenarios in 2050. " +
                    " Therefore, the top-down constraint from 2020 and 6.5% decline rate cap also apply in this case. "
                   ;
            break;
        }


    } //switch

    checkbut(); // andsleep(500);
    loop.gonow(false); //run model (without changing tree-struc)
    checkbutandsleep(500);
        try {
    for (curveset dest : curvemap.keySet()) dest.addcurve(curvemap.get(dest).cloneIndependent(1850, 2250, 1, scen.name(), scen.col));
        }catch (Exception e) { deb(e); e.printStackTrace(); }
    float emit2020=gc.co2eqtot.get(2020), emit2050=gc.co2eqtot.get(2050); //note CO2eq inc CH4+N2O
    float integ2050=0; for (int y=2001; y<=2050; y++) integ2050+=gc.totemit.get(y); //note CO2only
    float integ2300=integ2050; for (int y=2051; y<=2300; y++) integ2300+=gc.totemit.get(y); //note CO2only

    indics+=scen.name()+" \t"+ emit2020+ " \t" +emit2050 +" \t " + integ2050+ " \t"+integ2300+" \n";

    descriptions+="\n======== "+scen.name()+" ========\n"+scen.info+"\n";

    } //scenario



    for (curveset dest : curvemap.keySet()) {
        lineplot plot = (lineplot)(plot(dest));
        plot.xscale.min=1850; plot.xscale.max=2250;
        plot.xscale.units.scales=100; plot.xscale.changed=true;
        showpan.toFront(plot);
        plot.doplot();
        checkbutandsleep(500);
        imagesaver.saveimage(plot, "png", new File("jcmout"+fs+"results"+fs+dest.name+".png"));
        datable.savetable(new File("jcmout"+fs+"results"+fs+dest.name+".dat"), dest, "tab");
        checkbutandsleep(500);
    }

    fileio.savetextfile("jcmout"+fs+"results"+fs+"descriptions.txt", descriptions);
    fileio.savetextfile("jcmout"+fs+"results"+fs+"indicators.txt", indics);
    end();
	log("End of script swinf_global");
	
    } //run
   
} //end class
