
package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import jcm.core.loop;
import jcm.core.cur.*;
import jcm.core.ob.infob;
import jcm.core.reg.*;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.histoplot;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.*;
import jcm.mod.cli.*;
import jcm.mod.obj.*;
import jcm.mod.regemit.*;

import jcm.mod.resp.attribTracer;
import jcm.mod.socio.popgdp;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import  static jcm.mod.obj.stabilisation.indicators.*;
import  static jcm.mod.obj.stabilisation.curvetype.*;
import static jcm.mod.regemit.pledges.pledgelevel.*;

public class swinf_pledges extends calcscript {

    globco2emit gc=gm(globco2emit.class);
    carboncycle car  = gm(carboncycle.class);
    glotemp tem= gm(glotemp.class) ;
    radfor rf= gm(radfor.class);
    stabilisation stab=gm(stabilisation.class);
    shares sha=gm(shares.class);
    pledges ple=gm(pledges.class);
    emitquota eq=gm(emitquota.class);

    void checkready() {
        try { while (stab.running) Thread.currentThread().sleep(500); } catch (InterruptedException e) {}
        checkbutandsleep(500);
    }

        float ro (float f) { return Math.round(f/100f)/10f; }

    public histoplot histoplot(curveset qq)  {
        return (histoplot) showpan.makepan(histoplot.class, qq);
    }

    public void run() {

    lookandfeel.fontSize.set(18);
   //set some plotlinks to ensure model loop knows what to calculate
   link(eq.emitequiv); link(tem.temp); link(car.conc);

   //this helps to reset it
   checkready();   loop.gonow(false);  checkready();

   int[] years = { 1990, 2005, 2010, 2020}; //, 2050};

    //Set<infob> obs = eq.emitfos.getObs();
    //deb("======="); for (infob ob : obs) deb(ob.name); deb("=======");
   curveset fospercap = new curvar(curve.Type.ratio, eq.emitfos_unitsCO2, gm(popgdp.class).pop); // ,emitluc) ;
   curveset fospergdp = new curvar(curve.Type.ratio, eq.emitfos_unitsCO2, gm(popgdp.class).gdp_ppp); // ,emitluc) ;

   eq.emitfos_unitsCO2.addOb(fospercap);
   //curveset fospercap = (curveset) eq.emitfos.find("emitfos&per&population");

  histoplot hist_pc = histoplot(fospercap);
 hist_pc.highonleft=true;
   hist_pc.xscale.min=0; hist_pc.xscale.max=7800;
   hist_pc.yscale.min=0; hist_pc.yscale.max=20;
   //histo1.xscale.units.scales=100;
   hist_pc.xscale.changed=true; hist_pc.yscale.changed=true;
   hist_pc.hidechooser();
   hist_pc.legend.forcelong=true;
   hist_pc.labels=true;

   showpan.toFront(hist_pc);
        hist_pc.doplot();
        checkready();
         loop.gonow(false); hist_pc.yscale.changed=true; hist_pc.doplot(); checkready();


   for (int y : years) {
       checkready();
       hist_pc.year.set(y);
        loop.gonow(false);  checkready();
        imagesaver.saveimage(hist_pc, "png"  /*-transparent*/, new File("jcmout"+fs+"results"+fs+"pledges"+fs+"emitpercap_"+y+".png"));
   }
   datable.savetable(new File("jcmout"+fs+"results"+fs+"pledges"+fs+"emitpercap.dat"), fospercap, "tab");
    checkready();

   histoplot hist_pg = histoplot(fospergdp);
   hist_pg.highonleft=true;
  hist_pg.xscale.min=0; hist_pg.xscale.max=90000000;
   hist_pg.yscale.min=0; hist_pg.yscale.max=0.0013; //needs to be 2.5 for 1990!
   hist_pg.xscale.changed=true; hist_pg.yscale.changed=true;
   hist_pg.hidechooser();
   hist_pg.legend.forcelong=true;
   hist_pg.labels=true;
   showpan.toFront(hist_pg);

     hist_pg.yscale.units.units= hist_pg.yscale.units.units.replace("microton", "grams");
      hist_pg.doplot();
      hist_pg.yscale.units.scales=0.001; hist_pg.yscale.changed=true; hist_pg.doplot();
      checkready();

   for (int y : years) {
       checkready();
       hist_pg.year.set(y);
        loop.gonow(false);  checkready();
        imagesaver.saveimage(hist_pg, "png"  /*-transparent*/, new File("jcmout"+fs+"results"+fs+"pledges"+fs+"emitpergdp_"+y+".png"));
   }
    datable.savetable(new File("jcmout"+fs+"results"+fs+"pledges"+fs+"emitpergdp.dat"), fospergdp, "tab");
    checkready();


    
    end();
	log("End of script swinf_pledges");
    } //run

} //end class
