/*3.85
 Test for output for swiss-infras project May 2010
 Global part - emissions pathways and temperature

 1. Set parameters
 2. Collect curves
 3. Plot and export
 4. add CO2 eq plot
 4. extra data out : integrals and points
 4. data-tables out
 5. try varying carbon cycle / climate params

 
 Scenarios for EU paper:
 if pledges off, start topdown 2015 and converge starts AxB only => reasonable low scenario passing 44.8 if emit => -50%
 if  pledges off, start topdown 2020 and int particip group = none and remove join if high GDP => 54.4, effectively BAU
 *
 *
*/
package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import jcm.core.loop;
import jcm.core.cur.*;
import jcm.core.reg.*;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.*;
import jcm.mod.cli.*;
import jcm.mod.obj.*;
import jcm.mod.regemit.*;

import jcm.mod.resp.attribTracer;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import  static jcm.script.swinf_global.scenarios.*;
import  static jcm.mod.obj.stabilisation.indicators.*;
import  static jcm.mod.obj.stabilisation.curvetype.*;
import static jcm.mod.regemit.pledges.pledgelevel.*;

public class swinf_global extends calcscript {

    globco2emit gc=gm(globco2emit.class);
    carboncycle car  = gm(carboncycle.class);
    glotemp tem= gm(glotemp.class) ;
    radfor rf= gm(radfor.class);
    stabilisation stab=gm(stabilisation.class);
    shares sha=gm(shares.class);
    pledges ple=gm(pledges.class);
    emitquota eq=gm(emitquota.class);
    sealevel sl=gm(sealevel.class);
    controller co=gm(controller.class);

    Map<curveset, Object> curvemap= new HashMap();
    //Map<scenarios, float[]> indics = new HashMap();

    param[] scenparam={stab.indicator};
    enum scenarios {
            fiftypc2050_2C (blue, stabilisation.indicators.define_emit, "dummy", 12345),
            fiftypc2050_15C(green),
            stabtemp_225C_2C(red),
            stabtemp_2C(purple),
            stabtemp_2C_175C(cyan),
            stabtemp_15C(dkgreen),
            stabCO2eq500 (brown) ,
            stabCO2eq450 (orange);
            //concpeak_2C(blue),
            Color col;
            String info;
            Object[] params;
            scenarios (Color c, Object ... o) { col=c; params=o; for (Object oo : params) deb(oo.toString()); }
    };


    public void run() {

    lookandfeel.fontSize.set(18);

    //set some plotlinks to ensure model loop knows what to calculate
    link(tem.temp); link(car.conc); link(sl.sealevel);
    curvar integ=new  curvar(curve.Type.integral, gc.co2eqcurves);
    link(integ);
    int sy=1950, ey=2300;
    curvemap.put(new curveset("fossil_CO2_emissions", "mega&ton&carbon", sy, ey, 1), gc.fossil);
    curvemap.put(new curveset("CO2eq_emissions", "mega&ton&co2eq", sy, ey, 1), new curve[]{gc.co2eqtot, gc.co2fos}); //

    curvemap.put(new curveset("CO2eq_emissions_integral", "giga&ton&co2eq", sy, ey, 1), integ.getcurve(gc.co2eqtot.name)); //
    curvemap.put(new curveset("CO2 concentration", "ppm&co2", sy, ey, 1), car.co2atppm);
    curvemap.put(new curveset("CO2eq concn allgas+aeros", "ppm&co2eq", sy, ey, 1), new curve[]{rf.co2eqghgaero, car.co2atppm});
    curvemap.put(new curveset("RF allgas+aeros", "w&per&m2", sy, ey, 1), rf.totalrf);
    curvemap.put(new curveset("Temperature", "degc&above&1835-65", sy, ey, 1), tem.avchangeby);
    curvemap.put(new curveset("Sea-Level", "metres", sy, ey, 1), sl.total);
    // (non default) parameters shared by all scenarios
    
    
    co.botuptopdo.set(controller.butd.start_bottom_up);
    sha.distribution.set(shares.distriboptions.convergence);
    sha.rate_caps.set(true);
    ple.level.set(pledges.pledgelevel.conditional);

    for (scenarios scen : scenarios.values()) { //loop through scenarios

        //this helps to reset it
   checkready();
    stab.indicator.set(stabilisation.indicators.stabconc);
    loop.gonow(false);
    checkready();
    
    log("Setting parameters for "+scen.name());
    switch (scen) { //set parameters per scenario
        case fiftypc2050_2C : {
            stab.indicator.set(stabilisation.indicators.define_emit);
            stab.stabemityear.set(2050);
            stab.peaking.set(true);
            stab.stabemitlevel.set(3500); // lowered from 3850 since added HFCs
            stab.stabemitendlevel.set(250);
            stab.stabemitdeclinerate.set(1.1); //lowered from 1.25 to compensate
            co.startyear_topdown.set(2020);
            sha.rate_constraint.set(6.5);
            ple.usepledges.set(true);
            scen.info="This scenario begins with a defined emissions trajectory to reach the key policy target of 50% of 1990 by 2050 (CO2eq emissions inc CH4, N2O+LUC), " +
                    "After 2050 the emissions curve continues along an trajectory in which total CO2 emissions decline exponentially at -1.25%/yr towards a minimum level of 0.25GtC. " +
                    "This trajectory is chosen to stabilise the temperature at 2°C with default model parameters. " +
                    "There is a marked relaxation in the emissions decline after 2050. "+
                    "As for other scenarios in this group, the scenario starts with  high pledges in 2020 and continues regionally by a increasing participation with convergence. " +
                    "A top-down constraint applies from 2020 onwards. " +
                    "As the decline from 2020 to 2050 is steep, the decline rate cap on individual countries cannot be set lower than 6.5%/year."
                    ;
            break;
        }
        case fiftypc2050_15C : {
            stab.indicator.set(stabilisation.indicators.define_emit);
            stab.stabemityear.set(2050);
            stab.stabemitlevel.set(3500); //was 3850
            stab.peaking.set(true);
            stab.stabemitendlevel.set(0);
            stab.stabemitdeclinerate.set(3.5); // was 4.0
            co.startyear_topdown.set(2020);
            sha.rate_constraint.set(6.5);
            scen.info= " This scenario is similar to the fiftypercent_2C until 2050. " +
                    "Thereafter total CO2 emissions decline exponentially at -4%/yr towards zero. " +
                    "This steep decline is a smooth continuation of the earlier part of the curve. " +
                    "Temperature peaks at around 1.8C in 2060 (CHECK) and declines thereafter, falling to 1.5C in 2250 (CHECK). " +
                    "Such a scenario may be particularly interesting to low-lying states as it has a greater chance to avoid catastrophic melting of the Greenland and WAIS ice caps."
                   ;
            break;
        }

        case stabtemp_225C_2C: {

            //if  pledges off, start topdown 2020 and int particip group = none and remove join if high GDP => 54.4, effectively BAU
            stab.indicator.set(stabilisation.indicators.stabtemp);
            
            stab.stabyear.set(2100);
            stab.stabtemplevel.set(2.25);
            stab.peaking.set(true);
            stab.stabtempend.set(2.0);
            ple.usepledges.set(false);
            co.startyear_topdown.set(2020);
             sha.initgroup.set(shares.igroup.none);
             sha.richjoin.set(false);
            sha.rate_caps.set(false);
            ;
            break;
        }

               case stabtemp_2C : {
             stab.indicator.set(stabilisation.indicators.stabtemp);
             stab.peaking.set(false);
            stab.stabyear.set(2125);
            stab.stabtemplevel.set(2.0);
            ple.usepledges.set(true);
            co.startyear_topdown.set(2020);
            sha.initgroup.set(shares.igroup.all_CA_pledges);
            sha.rate_caps.set(true);
            sha.richjoin.set(true);
            sha.rate_constraint.set(4);
            scen.info= " "
                   ;
            break;
        }

                case stabtemp_2C_175C : {
             stab.indicator.set(stabilisation.indicators.stabtemp);
             stab.peaking.set(true);
            stab.stabyear.set(2100);
            stab.stabtemplevel.set(2.0);
            stab.stabtempend.set(1.75);
            co.startyear_topdown.set(2020);
            sha.rate_constraint.set(4);
            scen.info= " "
                   ;
            break;
        }

        case stabtemp_15C : {
            //if pledges off, start botttom up 2015 and converge starts AxB only => reasonable low scenario passing 44.8 if emit => -50%
             stab.indicator.set(stabilisation.indicators.stabtemp);
             stab.peaking.set(false);
            stab.stabyear.set(2075);
            stab.stabtemplevel.set(1.5);
            ple.usepledges.set(false);
             co.startyear_topdown.set(2015);
             sha.initgroup.set(shares.igroup.Kyoto_Annex_B);
            sha.rate_caps.set(false);
            scen.info= " "
                   ;
            break;
        }

        case stabCO2eq500 : {
            //note if RF/2CO2 = 3.64, 450=> ln(500/278)*3.64/ln(2) = 3.08 (3.14 if RF/2CO2=3.71)
             
            stab.indicator.set(stabilisation.indicators.stabrf_allghgaero);
            stab.stabrflevel.set(3.14);
            stab.peaking.set(false);
            stab.stabyear.set(2100); //was 2125 then 2050
            stab.curveopt.set(padequintic);
            ple.usepledges.set(true);
             sha.initgroup.set(shares.igroup.all_CA_pledges);
            co.startyear_topdown.set(2020);
            sha.rate_caps.set(true);
            sha.rate_constraint.set(6.5);
             scen.info= " This scenario follows a classic stabilise CO2equivalent concentration pathway. " +
                    "The stabilisation level is 3W/m2 (about 480ppm CO2eq )for all greenhouse gases and aerosols. " +
                    "The peak CO2eq concentration is a bit higher at around 490ppm. " +
                    "The temperature rises slowly towards 2C, reaching 1.9C only in 2125,  due to the gradual uptake of heat by the ocean. " +
                    "(which is not offset by declining forcing as in the other scenarios). " +
                    " The eventual equilibrium temperature associated with this forcing will be higher than 2C (CALCULATE). " +
                    " If the equilibrium would be 2C and the final CO2eq level may not be exceeded, the emissions decline would be even steeper. " +
                    " It is this type of  scenario pathway that dominated the analyses of IPCC AR4 WG3. " +
                    " Due to this pathway shape, the emissions are constrained in early years and are just below the 50% scenarios in 2050. " +
                    " Therefore, the top-down constraint from 2020 and 6.5% decline rate cap also apply in this case. "
                   ;
            break;
        }

         case stabCO2eq450 : {
             //note if RF/2CO2 = 3.64, 450=> ln(450/278)*3.64/ln(2) = 2.53 (2.58 if RF/2CO2=3.71)
             stab.indicator.set(stabilisation.indicators.stabrf_allghgaero);
            stab.stabrflevel.set(2.58);
            stab.peaking.set(false);
            stab.stabyear.set(2060);
            stab.curveopt.set(padequintic); 
            ple.usepledges.set(false);
             co.startyear_topdown.set(2015);
             sha.initgroup.set(shares.igroup.Kyoto_Annex_B);
            sha.rate_caps.set(false);
             scen.info= "";
         }

        /**
        case concpeak_2C : {
            stab.indicator.set(stabilisation.indicators.stabconc); //usualy default
            stab.stabconclevel.set(470);
            stab.stabyear.set(2110);
            stab.peaking.set(true);
            stab.stabconcendlevel.set(453);
            stab.curveopt.set(padequartic);
            sha.startyear_topdown.set(2045);
            sha.rate_constraint.set(4);
             scen.info= " This is a more relaxed scenario also stabilising at 2C. " +
                    "It is defined by a peaking CO2 concentration curve at 470ppm in 2110, declining thereafter towards 453ppm in 2300. " +
                    "The temperature rises to 2C faster than in the other scenarios, reaching 1.9C by 2068 (CHECK). " +
                    "Consequently emissions can be higher in 2050  - around 25GtCO2eq (CHECK), or 65% of 1990.  " +
                    "This allows more flexibility in the individual country emissions - so the top-down constraint on all countries does not apply until 2045. " +
                    "And decline rate caps can be set at 4%/yr "
                   ;
            break;
        }

         */


    } //switch

    for (pledges.pledgelevel pl : EnumSet.of(conditional, unconditional) ) {
        boolean cp=(scen==fiftypc2050_2C || scen== stabtemp_2C ), inc= (pl==conditional) || cp;
        if (inc) {
        checkready();
        ple.level.set(pl);
    loop.gonow(false); //run model (without changing tree-struc)
    checkready();

    Color col=(pl == conditional ? scen.col : scen.col.darker() );
    String name=scen.name()+" "+(cp ? pl.name().replace("effort", "pledge") : "");
        
    for (curveset dest : curvemap.keySet()) try {
        if (curvemap.get(dest) instanceof curve) dest.addcurve(((curve)curvemap.get(dest)).cloneIndependent(sy, ey, 1, name, col ));
        if (curvemap.get(dest) instanceof curve[]) {
            curve[] cc=(curve[])curvemap.get(dest);
            for (int i=0; i<cc.length; i++){
            curve c=cc[i].cloneIndependent(sy, ey, 1, name+"_"+i, col );
            c.style=curve.linestyle.values()[i % curve.linestyle.values().length];
            dest.addcurve(c);
            }
        }
        }catch (Exception e) { deb(e); e.printStackTrace(); }
    
    float inteq2050=0; for (int y=2001; y<=2050; y++) inteq2050+=gc.co2eqtot.get(y);
    float inteq2300=inteq2050; for (int y=2051; y<=2300; y++) inteq2300+=gc.co2eqtot.get(y);
    float intc2050=0; for (int y=2001; y<=2050; y++) intc2050+=gc.co2fos.get(y);
    float intc2300=intc2050; for (int y=2051; y<=2300; y++) intc2300+=gc.co2fos.get(y);
    float ratedeceq=100f*(1f-(float)Math.pow(gc.co2eqtot.get(2045)/gc.co2eqtot.get(2025), 1f/20f));
    float ratedecc=100f*(1f-(float)Math.pow(gc.co2fos.get(2045)/gc.co2fos.get(2025), 1f/20f));
    
    float maxc=0,  maxcy=0, maxce=0,  maxcey=0, maxt=0, maxty=0;
    for (int y=2040; y<2300; y++) {
        if (car.co2atppm.get(y)>maxc) { maxc=car.co2atppm.get(y); maxcy=y; }
        if (rf.co2eqghgaero.get(y)>maxce) { maxce=rf.co2eqghgaero.get(y); maxcey=y; }
        if (tem.avchangeby.get(y)>maxt) { maxt=tem.avchangeby.get(y); maxty=y; }
    }

    float[] indicf=new float[]{
        ro(gc.co2eqtot.get(2020)),ro(gc.co2eqtot.get(2050)),ro(gc.co2eqtot.get(2100)),
        ro(gc.co2fos.get(2020)), ro(gc.co2fos.get(2050)), ro(gc.co2fos.get(2100)),
        ro(inteq2050), ro(inteq2300),
        ro(intc2050), ro(intc2300),
        ratedeceq, ratedecc,
        maxce, maxcey, rf.co2eqghgaero.get(2300),
        maxc, maxcy, car.co2atppm.get(2300),
        maxt, maxty,  tem.avchangeby.get(2300),
        sl.total.get(2100), sl.total.get(2300)
    };


    indics+=name+"\t";
    for (float f : indicf) indics+=" \t"+ f;
    indics+="\n";

    descriptions+="\n======== "+scen.name()+" ========\n"+scen.info+"\n";

    }//inc
    } //pledge
    } //scenario



    for (curveset dest : curvemap.keySet()) {
        lineplot plot = (lineplot)(plot(dest));
        plot.xscale.min=sy; plot.xscale.max=ey;
        plot.xscale.units.scales=100; plot.xscale.changed=true;
        showpan.toFront(plot);
        plot.doplot();
        checkready();
        imagesaver.saveimage(plot, "png", new File("jcmout"+fs+"results"+fs+dest.name+".png"));
        datable.savetable(new File("jcmout"+fs+"results"+fs+dest.name+".dat"), dest, "tab");
        checkready();
    }

    fileio.savetextfile("jcmout"+fs+"results"+fs+"descriptions.txt", descriptions);
    fileio.savetextfile("jcmout"+fs+"results"+fs+"indicators.csv", indics);
    end();
	log("End of script swinf_global");
	
    } //run

       void checkready() {
        try { while (stab.running) Thread.currentThread().sleep(500); } catch (InterruptedException e) {}
        checkbutandsleep(500);
    }

  String indics=
          " Scenario\t"
            +"\t Emit CO2eq 2020 \t Emit CO2eq  2050 \t Emit CO2eq  2100  "
            +"\t Emit CO2 2020 \t Emit CO2  2050 \t Emit CO2  2100  "
            +"\t IntegCO2eq 2050 \t IntegCO2eq 2300  "
            +"\t IntegCO2 2050 \t IntegCO2 2300  "
            +"\t Decline_CO2eq \t Decline_CO2 "
            +"\t Peak CO2eq-conc \t year \t CO2eq-conc 2300"
            +"\t Peak CO2-conc \t year \t CO2-conc 2300"
            +"\t Peak Temperature \t year \t Temperature 2300"
            +"\t Sea-level-rise 2100 \t Sea-level-rise 2300 "
            +"\n";
          //" Scenario\t\t Emit CO2eq 2020 \t Emit CO2eq  2050 \t IntegCO2eq 2050 \t IntegCO2eq 2300 \n IntegCO2 2050 \t IntegCO2 2300 \n ";
    String descriptions ="Scenario Descriptions\n";

    float ro (float f) { return Math.round(f/100f)/10f; }

} //end class
