/*3.85
 Test for output for swiss-infras project May 2010
 Global part - emissions pathways and temperature

 1. Set parameters
 2. Collect curves
 3. Plot and export
 4. add CO2 eq plot
 4. extra data out : integrals and points
 4. data-tables out
 5. try varying carbon cycle / climate params

 
 Scenarios for EU paper:
 if pledges off, start topdown 2015 and converge starts AxB only => reasonable low scenario passing 44.8 if emit => -50%
 if  pledges off, start topdown 2020 and int particip group = none and remove join if high GDP => 54.4, effectively BAU
 *
 *
*/
package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JComponent;

import jcm.core.loop;
import jcm.core.cur.*;
import jcm.core.reg.*;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.*;
import jcm.mod.cli.*;
import jcm.mod.obj.*;
import jcm.mod.regemit.*;
import jcm.mod.resp.attribTracer;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import  static jcm.script.oxf15_global.scenarios.*;
import  static jcm.mod.obj.stabilisation.indicators.*;
import  static jcm.mod.obj.stabilisation.curvetype.*;
import static jcm.mod.regemit.pledges.pledgelevel.*;

public class oxf15_global extends calcscript {

    globco2emit gc=gm(globco2emit.class);
    carboncycle car  = gm(carboncycle.class);
    glotemp tem= gm(glotemp.class) ;
    radfor rf= gm(radfor.class);
    stabilisation stab=gm(stabilisation.class);
    shares sha=gm(shares.class);
    pledges ple=gm(pledges.class);
    emitquota eq=gm(emitquota.class);
    sealevel sl=gm(sealevel.class);
    controller con=gm(controller.class);

    Map<curveset, Object> curvemap= new HashMap();
    //Map<scenarios, float[]> indics = new HashMap();

    param[] scenparam={stab.indicator};
    enum scenarios {
    	A_StabTemp15(blue), B_Peak175_Drop15 (green), C_StabTemp175(yellow ), D_Peak20_Drop15(orange), E_StabTemp20(red);
            
            Color col;
            String info;
            Object[] params;
            scenarios (Color c, Object ... o) { col=c; params=o; for (Object oo : params) deb(oo.toString()); }
    };


    public void run() {

    lookandfeel.fontSize.set(18);

    //set some plotlinks to ensure model loop knows what to calculate
    link(tem.temp); link(car.conc); link(sl.sealevel);
    curvar integ=new  curvar(curve.Type.integral, gc.co2eqcurves);
    link(integ);
    int sy=1950, ey=2250;
    curvemap.put(new curveset("fossil_CO2_emissions", "mega&ton&carbon", sy, ey, 1), gc.fossil);
    curvemap.put(new curveset("CO2eq_emissions", "mega&ton&co2eq", sy, ey, 1), new curve[]{gc.co2eqtot, gc.co2fos}); //

    curvemap.put(new curveset("CO2eq_emissions_integral", "giga&ton&co2eq", sy, ey, 1), integ.getcurve(gc.co2eqtot.name)); //
    curvemap.put(new curveset("CO2 concentration", "ppm&co2", sy, ey, 1), car.co2atppm);
    curvemap.put(new curveset("CO2eq concentration all_gases+aerosols", "ppm&co2eq", sy, ey, 1), new curve[]{rf.co2eqghgaero, car.co2atppm});
    curvemap.put(new curveset("RF allgas+aeros", "w&per&m2", sy, ey, 1), rf.totalrf);
    curvemap.put(new curveset("Temperature", "Global Avg Temperature ºC&above&1835-65", sy, ey, 1), tem.avchangeby);
    curvemap.put(new curveset("Sea-Level", "metres", sy, ey, 1), sl.total);
    // (non default) parameters shared by all scenarios
    
    
    con.botuptopdo.set(controller.butd.start_bottom_up);
    sha.distribution.set(shares.distriboptions.convergence);
    ple.level.set(pledges.pledgelevel.mixed);
    //sha.rate_caps.set(true);
    
    for (scenarios scen : scenarios.values()) { //loop through scenarios

    	//this helps to reset it
    	checkready();
    	stab.indicator.set(stabilisation.indicators.stabconc);
    	loop.gonow(false);
    	checkready();

    	log("Setting parameters for "+scen.name());
    	switch (scen) { //set parameters per scenario
    	case A_StabTemp15 : {
    		stab.indicator.set(stabilisation.indicators.stabtemp);
    		stab.peaking.set(false);
    		stab.stabyear.set(2075);
    		stab.stabtemplevel.set(1.5);
    		con.startyear_topdown.set(2016);
    		break;
    	}

    	case B_Peak175_Drop15 : {
    		stab.indicator.set(stabilisation.indicators.stabtemp);
    		stab.peaking.set(true);
    		stab.stabyear.set(2075);
    		stab.stabtemplevel.set(1.75);
    		stab.stabtempend.set(1.5);
    		con.startyear_topdown.set(2020);
    		break;
    	}

    	case C_StabTemp175 : {
    		stab.indicator.set(stabilisation.indicators.stabtemp);
    		stab.peaking.set(false);
    		stab.stabyear.set(2075);
    		stab.stabtemplevel.set(1.75); 
    		con.startyear_topdown.set(2020);
    		break;
    	}

    	case D_Peak20_Drop15 : {
    		stab.indicator.set(stabilisation.indicators.stabtemp);
    		stab.peaking.set(true);
    		stab.stabyear.set(2075);
    		stab.stabtemplevel.set(2.0);
    		stab.stabtempend.set(1.5);
    		con.startyear_topdown.set(2030);
    		break;
    	}

    	case E_StabTemp20  : {
    		stab.indicator.set(stabilisation.indicators.stabtemp);
    		stab.peaking.set(false);
    		stab.stabyear.set(2075);
    		stab.stabtemplevel.set(2.0);
    		con.startyear_topdown.set(2030);
    		break;
    	}


    	} //switch

    	/*
    for (pledges.pledgelevel pl : EnumSet.of(conditional, unconditional) ) {
    	boolean cp=(scen==fiftypc2050_2C || scen== stabtemp_2C ), inc= (pl==conditional) || cp;
    	if (inc) {
    		ple.level.set(pl);
    	 */
    	checkready();
    	loop.gonow(false); //run model (without changing tree-struc)
    	checkready();

    	Color col=scen.col; //(pl == conditional ? scen.col : scen.col.darker() );
    	String name=scen.name(); //+" "+(cp ? pl.name().replace("effort", "pledge") : "");

    	for (curveset dest : curvemap.keySet()) try {
    		if (curvemap.get(dest) instanceof curve) dest.addcurve(((curve)curvemap.get(dest)).cloneIndependent(sy, ey, 1, name, col ));
    		if (curvemap.get(dest) instanceof curve[]) {
    			curve[] cc=(curve[])curvemap.get(dest);
    			for (int i=0; i<cc.length; i++){
    				curve c=cc[i].cloneIndependent(sy, ey, 1, name+"_"+i, col );
    				c.style=curve.linestyle.values()[i % curve.linestyle.values().length];
    				dest.addcurve(c);
    			}
    		}
    	}catch (Exception e) { deb(e); e.printStackTrace(); }

    	float inteq2050=0; for (int y=2001; y<=2050; y++) inteq2050+=gc.co2eqtot.get(y);
    	float inteq2250=inteq2050; for (int y=2051; y<=2250; y++) inteq2250+=gc.co2eqtot.get(y);
    	float intc2050=0; for (int y=2001; y<=2050; y++) intc2050+=gc.co2fos.get(y);
    	float intc2250=intc2050; for (int y=2051; y<=2250; y++) intc2250+=gc.co2fos.get(y);
    	float ratedeceq=100f*(1f-(float)Math.pow(gc.co2eqtot.get(2045)/gc.co2eqtot.get(2025), 1f/20f));
    	float ratedecc=100f*(1f-(float)Math.pow(gc.co2fos.get(2045)/gc.co2fos.get(2025), 1f/20f));

    	float maxc=0,  maxcy=0, maxce=0,  maxcey=0, maxt=0, maxty=0;
    	for (int y=2040; y<2250; y++) {
    		if (car.co2atppm.get(y)>maxc) { maxc=car.co2atppm.get(y); maxcy=y; }
    		if (rf.co2eqghgaero.get(y)>maxce) { maxce=rf.co2eqghgaero.get(y); maxcey=y; }
    		if (tem.avchangeby.get(y)>maxt) { maxt=tem.avchangeby.get(y); maxty=y; }
    	}

    	float[] indicf=new float[]{
    			ro(gc.co2eqtot.get(2020)),ro(gc.co2eqtot.get(2030)), ro(gc.co2eqtot.get(2050)),ro(gc.co2eqtot.get(2100)),
    			ro(gc.co2fos.get(2020)), ro(gc.co2eqtot.get(2030)), ro(gc.co2fos.get(2050)), ro(gc.co2fos.get(2100)),
    			ro(inteq2050), ro(inteq2250),
    			ro(intc2050), ro(intc2250),
    			ratedeceq, ratedecc,
    			maxce, maxcey, rf.co2eqghgaero.get(2250),
    			maxc, maxcy, car.co2atppm.get(2250),
    			maxt, maxty,  tem.avchangeby.get(2250),
    			sl.total.get(2100), sl.total.get(2250)
    	};


    	indics+=name+"\t";
    	for (float f : indicf) indics+=" \t"+ f;
    	indics+="\n";

    	descriptions+="\n======== "+scen.name()+" ========\n"+scen.info+"\n";

    	//}//inc
    	//} //pledge
    
    } //scenario loop

    String filebase="jcmout"+fs+"results"+fs+"oxford15"+fs;

    for (curveset dest : curvemap.keySet()) {
        lineplot plot = (lineplot)(plot(dest));
        plot.xscale.min=sy; plot.xscale.max=ey;
        plot.xscale.units.scales=100; plot.xscale.changed=true;
        if (dest.name.startsWith("Temp")) { plot.yscale.max=2.15; plot.yscale.changed=true; plot.yscale.units.allowfac=false;} 
        showpan.toFront(plot);
        plot.doplot();
        checkready();
        imagesaver.saveimage(plot, "png-transparent", new File(filebase+dest.name+".png"));
        datable.savetable(new File(filebase+dest.name+".dat"), dest, "tab");
        checkready();
    }

    fileio.savetextfile(filebase+"descriptions.txt", descriptions);
    fileio.savetextfile(filebase+fs+"indicators.csv", indics);
    end();
	log("End of script oxf15_global");
	
    } //run

       void checkready() {
        try { while (stab.running) Thread.currentThread().sleep(500); } catch (InterruptedException e) {}
        checkbutandsleep(500);
    }

  String indics=
          " Scenario\t"
            +"\t Emit CO2eq 2020 \t Emit CO2eq  2030 \t Emit CO2eq  2050 \t Emit CO2eq  2100  "
            +"\t Emit CO2 2020 \t Emit CO2  2030 \t Emit CO2  2050 \t Emit CO2  2100  "
            +"\t IntegCO2eq 2050 \t IntegCO2eq 2250  "
            +"\t IntegCO2 2050 \t IntegCO2 2250  "
            +"\t Decline_CO2eq \t Decline_CO2 "
            +"\t Peak CO2eq-conc \t year \t CO2eq-conc 2250"
            +"\t Peak CO2-conc \t year \t CO2-conc 2250"
            +"\t Peak Temperature \t year \t Temperature 2250"
            +"\t Sea-level-rise 2100 \t Sea-level-rise 2250 "
            +"\n";
          //" Scenario\t\t Emit CO2eq 2020 \t Emit CO2eq  2050 \t IntegCO2eq 2050 \t IntegCO2eq 2250 \n IntegCO2 2050 \t IntegCO2 2250 \n ";
    String descriptions ="Scenario Descriptions\n";

    float ro (float f) { return Math.round(f/100f)/10f; }

} //end class
