/*
 *
 * One set of many scenarios => spaghetti, recolor to highlight different factors?
 * Table of combinations + color 1,2,3,4
 * or just vary systematically - climsens, diffusivity, ...
 * start by list of shares params ...
 *
 *
*/
package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.JComponent;

import jcm.core.loop;
import jcm.core.cur.*;
import jcm.core.reg.*;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.baseplot;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.*;
import jcm.mod.cli.*;
import jcm.mod.energy.enerData;
import jcm.mod.energy.enerGeneral;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.*;
import jcm.mod.regemit.*;
import jcm.mod.resp.attribTracer;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresdata;
import jcm.mod.scen.sspChooser;
import jcm.mod.scen.sspData;
import jcm.mod.socio.popgdp;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import  static jcm.script.oxf15_anal.scenario.*;
import  static jcm.mod.obj.stabilisation.indicators.*;
import  static jcm.mod.obj.stabilisation.curvetype.*;
import static jcm.mod.regemit.pledges.pledgelevel.*;
import static jcm.mod.scen.sresimgdata.scen.*;

public class oxf15_anal extends calcscript {

    globco2emit gc=gm(globco2emit.class);
    berncarbon carb  = gm(berncarbon.class);
    udebclimod cli=gm(udebclimod.class);
    glotemp tem= gm(glotemp.class) ;
    radfor rf= gm(radfor.class);
    stabilisation stab=gm(stabilisation.class);
    shares sha=gm(shares.class);
    pledges ple=gm(pledges.class);
    emitquota eq=gm(emitquota.class);
    sealevel sl=gm(sealevel.class);
    controller co=gm(controller.class);
    sresBase bs=gm(sresBase.class);
    enerGeneral ea=gm(enerGeneral.class);
    sspChooser sspcho=gm(sspChooser.class);
    futureLUC futluc=gm(futureLUC.class);
    controller con=gm(controller.class);

    int sy=1990, ey=2070;
    List<region> regforplot=new ArrayList();
    Map<curveset, Object> curvemap= new LinkedHashMap(); //dest, orig

    Map<curveset, Float> curveymax= new LinkedHashMap();
    Map<curveset, curveset> avg= new LinkedHashMap();
    Map<Object, Color[]> colormap= new LinkedHashMap();
  
    String[] regplot= new String[]{"Europe_All", "China", "India", "Africa" }; //"Brazil", 
     int weightneeded=9 ; //9 is good 
     boolean savefacplots=true;

    enum scenario {
    		
            A_stabtemp15(blue), B_peaktemp175drop15 (green), C_stabtemp175(yellow ), D_peaktemp20drop15(orange), E_stabtemp20 (red),    
            carbdefault(black, 1f), highfb(brown), lowfb(green), fastoc(blue), slowoc(purple),
            AR4_average(black, 1f), HadGEM1(red), MIROC3_2_MED(orange), ECHAM5_MPIOM(yellow), HadCM3(green), CSIRO_Mk3(cyan), GISS_EH(blue),
            cond_pledge(green), uncond_pledge(red), mix(yellow, 1f),
            SSP_1(green), SSP_2(blue, 1f), SSP_4(red), //SSP3 and SSP5 high challenge mitign => unlikely to work with 1.5 scenarios ...
            IMAGE(blue, 1f), MESGLO(green), GCAM4(yellow), WITGLO(orange), AIMCGE(red),  REMMAG (purple), 
            SRES_B1(green, 1f), SRES_B2(yellow), SRES_A1B(blue), //WEO_NP_B2(green),  WEO_NP_A1B(blue, 1f),
            alltogether(blue), gdp_low(green), gdp_mid(yellow, 1f), gdp_high(red),
            cv_55(blue), cv_65(yellow, 1f), cv_75(red), 
            cv_percap(cyan, 1f), cv_pergdp(yellow),
            rrb_0(red), rrb_10(orange ), rrb_15(yellow ), rrb_20(green, 1f), rrb_30(cyan),
            potluchi(green), potlucmid(yellow, 1f), potluclo(red) 
            ;
            Color col;
            String info;
            float weight;
            scenario (Color c) { this(c,0); }
            scenario (Color c, float  f) { 
                col=c; weight=f;
            }
    };

    scenario[] 
            globscen={ /* A_stabtemp15,  */ B_peaktemp175drop15 , /* D_peaktemp20drop15 */ }, //3
            carbon = {carbdefault, highfb, lowfb, fastoc}, // slowoc}, //5
            climod={ AR4_average, HadGEM1, MIROC3_2_MED, ECHAM5_MPIOM, HadCM3, CSIRO_Mk3, GISS_EH}, //7- the list "AR4selection" from udebclimod
            
            basescen={SRES_B1, SRES_B2, SRES_A1B}, //3   
            SSP_scen={SSP_1, SSP_2, SSP_4}, //3
            SSP_mod={IMAGE, MESGLO, GCAM4, WITGLO, AIMCGE,  REMMAG},//6
    
            potlucfrac={potluchi, potlucmid, potluclo}, //3
            
            pledgescen={cond_pledge, uncond_pledge, mix}, //3
            sharing={alltogether,  gdp_low, gdp_mid, gdp_high},  //4
            cvy= {cv_55, cv_65, cv_75}, //3
            cvi={cv_percap, cv_pergdp}, //2
            rrb = {rrb_15, rrb_20,  rrb_30}; //3 //rrb_0, rrb_10, 
    
    

  scenario[][] sets={ globscen, carbon, climod,  basescen, SSP_scen, SSP_mod, potlucfrac, pledgescen, sharing, cvy,  cvi, rrb};
  int globi=0, carbi=1, climi=2;

  int focus=-1;
  
  int nsets=sets.length, nscen=scenario.values().length;
   int[] ci = new int[nsets], pi= new int[nsets]; //current, previous
   
   int nadd=0, nskip=0, nnosense=0;
   EnumMap<scenario, Integer> ninc=new EnumMap(scenario.class);
   

void setscen(scenario scen) {
    deb(" =>"+scen.name()+": ");
    switch (scen) { //set parameters per scenario
        case A_stabtemp15 : {
             stab.indicator.set(stabilisation.indicators.stabtemp);
             stab.peaking.set(false);
            stab.stabyear.set(2075);
            stab.stabtemplevel.set(1.5);
            con.startyear_topdown.set(2016);
            break;
        }
       
        case B_peaktemp175drop15 : {
            stab.indicator.set(stabilisation.indicators.stabtemp);
            stab.peaking.set(true);
           stab.stabyear.set(2075);
           stab.stabtemplevel.set(1.75);
           stab.stabtempend.set(1.5);
           con.startyear_topdown.set(2020);
           break;
       }

        case C_stabtemp175 : {
            stab.indicator.set(stabilisation.indicators.stabtemp);
            stab.peaking.set(false);
           stab.stabyear.set(2075);
           stab.stabtemplevel.set(1.75); 
           con.startyear_topdown.set(2020);
           break;
       }

        case D_peaktemp20drop15 : {
            stab.indicator.set(stabilisation.indicators.stabtemp);
            stab.peaking.set(true);
           stab.stabyear.set(2075);
           stab.stabtemplevel.set(2.0);
           stab.stabtempend.set(1.5);
           con.startyear_topdown.set(2030);
           break;
       }

        case E_stabtemp20  : {
            stab.indicator.set(stabilisation.indicators.stabtemp);
            stab.peaking.set(false);
           stab.stabyear.set(2075);
           stab.stabtemplevel.set(1.2);
           con.startyear_topdown.set(2030);
           break;
       }

        

        case AR4_average : { cli.climod.set(udebclimod.gcm.AR4_average); break; }
        case HadGEM1 : { cli.climod.set(udebclimod.gcm.HadGEM1); break; }
        case MIROC3_2_MED : { cli.climod.set(udebclimod.gcm.MIROC3_2_MED); break; }
        case ECHAM5_MPIOM : { cli.climod.set(udebclimod.gcm.ECHAM5_MPIOM); break; }
        case HadCM3 : { cli.climod.set(udebclimod.gcm.HadCM3); break; }
        case CSIRO_Mk3 : { cli.climod.set(udebclimod.gcm.CSIRO_Mk3); break; }
        case GISS_EH : { cli.climod.set(udebclimod.gcm.GISS_EH); break; }

        case carbdefault : {
            carb.beta.set(0.5);
            carb.respq10.set(1.4);
            carb.diffufac.set(1.0);
            break;
        }
        case highfb : {
            carb.beta.set(0.6);
            carb.respq10.set(2.0);
            carb.diffufac.set(1.0);
            break;
        }
        case lowfb : {
            carb.beta.set(0.4);
            carb.respq10.set(1.0);
            carb.diffufac.set(1.0);
            break;
        }
        case fastoc : {
            carb.beta.set(0.5);
            carb.respq10.set(1.4);
            carb.diffufac.set(1.25);
            break;
        }
        case slowoc : {
            carb.beta.set(0.5);
            carb.respq10.set(1.4);
            carb.diffufac.set(0.75);
            break;
        }

        case cond_pledge : { ple.level.set(conditional); break; }
        case uncond_pledge : {  ple.level.set(unconditional);  break; }
        case mix : {ple.level.set(mixed); break;}
        
        case SRES_B1 : { bs.scenario.set(B1); break; }
        case SRES_B2 : { bs.scenario.set(B2); break; }
        case SRES_A1B : { bs.scenario.set(A1B); break; }
        

        case IMAGE : {sspcho.choomod.set(sspData.models.IMAGE); break; }
        case MESGLO : { sspcho.choomod.set(sspData.models.MESGLO ); break; }
        case GCAM4 : { sspcho.choomod.set(sspData.models.GCAM4 ); break; }
        case WITGLO : { sspcho.choomod.set(sspData.models.WITGLO ); break; }
        case AIMCGE : { sspcho.choomod.set(sspData.models.AIMCGE ); break; }
        case REMMAG : { sspcho.choomod.set(sspData.models.REMMAG ); break; }
        
        case SSP_1 : { sspcho.choossp.set(sspData.ssps.SSP1); break; }
        case SSP_2 : { sspcho.choossp.set(sspData.ssps.SSP2); break; }
        case SSP_4 : { sspcho.choossp.set(sspData.ssps.SSP4); break; }
        
        case potluchi : {futluc.potlucfrac.set(0.9f); break; }
        case potlucmid : {futluc.potlucfrac.set(0.75f); break; }
        case potluclo : {futluc.potlucfrac.set(0.6f); break; }
        
        case rrb_0 : {
            sha.dc_reduction.set(0); break;
        }
        case rrb_10 : {
            sha.dc_reduction.set(0.7); break; //approx -10% wrt baseline if applied 2005-20
        }
        case rrb_15 : {
            sha.dc_reduction.set(1.1); break; //approx -15% wrt baseline if applied 2005-20
        }
        case rrb_20 : {
            sha.dc_reduction.set(1.5); break; //approx -20% wrt baseline if applied 2005-20
        }
        case rrb_30 : {
            sha.dc_reduction.set(2.35); break; //approx -30% wrt baseline if applied 2005-20
        }
        case cv_55 : { sha.convergey.set(2055); break; }
       case cv_65 : { sha.convergey.set(2065); break;  }
       case cv_75 : { sha.convergey.set(2075); break; }

        case cv_percap : { sha.conv_criteria.set(shares.convcrit.emissionspercapita); break; }
        case cv_pergdp : {sha.conv_criteria.set(shares.convcrit.emissionspergdp); break; }
        
        case alltogether : { sha.initgroup.set(shares.igroup.all_from_start); break; } 
        case gdp_low: { sha.initgroup.set(shares.igroup.none); sha.axb_gdp_threshold.set(15000); break; }
        case gdp_mid: { sha.initgroup.set(shares.igroup.none); sha.axb_gdp_threshold.set(20000); break; }
        case gdp_high: { sha.initgroup.set(shares.igroup.none); sha.axb_gdp_threshold.set(25000); break; }
        default : deb (scen.name()+" - case not found !!!!!!!"  );
  } //switch
}//setscen

 public void run() {

	 setup();	
	 for (int q=0;q<2;q++) {
	 		
		 	nadd=0; nskip=0; nnosense=0;
	        for (int i=0; i<nsets; i++) {ci[i]=0; pi[i]=-1; }
	        int j=nsets-1;
	
	        scenloop: do {
	            setscen(j,q>0);
	            
	            j=nsets-1;  ci[j]++;
	            while(ci[j]==sets[j].length) { ci[j]=0; j--; if (j<0) break scenloop; ci[j]++; }
	        } while (true);
	
	          log("\n=========================================\n"
	                  +"added "+nadd+" skipped "+nskip+ " no-sense "+nnosense+" \n");
	 	}
          
          String nums=""; for (scenario s : scenario.values()) nums+=" "+s+": "+ninc.get(s);
          log(nums);
          
          makeav();
          savefiles();
          end();
          
          log("End of script of15_sensanal");
    } //run

    void setscen(int j, boolean apply) {
        String name="";
        int weight=0;
        Color[] cols=new Color[nsets]; Color col;

        boolean makessense=true; 
        /*(
             (globscen[ci[globi]]== stabtemp_2C) 
             || (globscen[ci[globi]] == stabconc450 && climod[ci[climi]] == AR4_average)
             || (climod[ci[climi]] == AR4_average && carbon[ci[carbi]] == carbdefault)
             );*/
        
        for (int i=0; i<nsets; i++) {
            scenario s=sets[i][ci[i]];
            name+=(i>0 ? "_" : "")+s.name();
            cols[i]=s.col;
            weight+= s.weight; //   (i==focus) ? 1f : s.weight;
            
        }
        boolean accepted= makessense && weight>=weightneeded;
        
        if (accepted)  {
            nadd++;
            if (apply) {
            	deb ("\n === ADD "+nadd+":  "+name+" ===\n");
            	report(""+nadd+" "+name);
            	for (int i=0; i<nsets; i++) if (ci[i]!=pi[i]) setscen(sets[i][ci[i]]); //setscen - but only  if changed since previous accepted
            	for (int i=0; i<nsets; i++) pi[i]=ci[i]; //store previous accepted case
            	//col=  (focus>=0) ? cols[focus] : mixcol(cols);
            	//just to test how many cases will run... comment addcurves
            	//for (int i=0; i<nsets; i++)
            	addcurves(name, cols);
            	for (int i=0; i<nsets; i++)   ninc.put(sets[i][ci[i]], ninc.get(sets[i][ci[i]])+1);
            } //apply
        } //accepted
        if (!accepted && makessense) {
            nskip++;
             //deb(" \t\t\t === skipped: "+name+" ===");
        }
        if (!makessense) nnosense++;
    }

 void setup() {
     loop.checkperform.set(true);
    lookandfeel.fontSize.set(18);
    gm(regset.class).regions.set(regman.allreg.findreg("JCM10"));
    loop.gonow(false);
    checkready(500);

    curveset percap=new curvar(curve.Type.ratio, eq.emitfos_unitsCO2, gm(popgdp.class).pop);
        link(percap);
     //uncomment to watch calc in progress
        lineplot plot = (lineplot)(plot(percap));
        plot.xscale.min=sy; plot.xscale.max=ey;
        plot.xscale.units.scales=10; plot.xscale.changed=true;
        showpan.toFront(plot);
        plot.doplot();
        checkready(500);
    
    //set some plotlinks to ensure model loop knows what to calculate
    link(tem.temp); link(eq.emitequiv);
    //this helps to reset it
   checkready(500);
    stab.indicator.set(stabilisation.indicators.stabconc);

    loop.gonow(false);
    checkready(500);

    for (String s : regplot) regforplot.add(regman.allreg.findreg(s));
    curveset[] plots={eq.emitfos_unitsCO2, eq.emitequiv,  percap};
    deb("\n\n"+percap.name+" "+percap.units+"\n\n");

    for (curveset c : plots) {
        curvemap.put(new curveset(c.name, c.units, sy, ey, 1), c);
        for (region r : regforplot) {
            curve cr=c.getcurve(r);
            /*
            for (int f=0; f<nsets; f++) {
                curvemap.put(new curveset(r.name+"_"+f+"_"+c.name, c.units, sy, ey, 1), new Object[]{cr, f});
            }
              curvemap.put(new curveset(r.name+"_"+c.name, c.units, sy, ey, 1), new Object[]{cr, -1});
             */
            curvemap.put(new curveset(r.name+"_"+c.name, c.units, sy, ey, 1), cr);
        }
        avg.put(c, new curveset(c.name+"_average", c.units, sy, ey, 1)); //note - map other way around
    }
    curveymax.put(eq.emitfos_unitsCO2, 12000f );
    curveymax.put(eq.emitequiv, 14000f );
    curveymax.put(percap, 21f );
    
    for (scenario s : scenario.values()) ninc.put(s, 0);
    
} //setup


void addcurves(String name, Color[] col) {
        //checkready(500);
        loop.gonow(false); //run model (without changing tree-struc)
        checkready(200);
        log("start add curve");
        colormap.put(name, col);

           for (curveset dest : curvemap.keySet()) try {
               Object o = curvemap.get(dest);
               if (o instanceof curve ) {
                   curve cr= (curve)o;
                   dest.addcurve(cr.cloneIndependent(sy, ey, 1, name, palecol(mixcol(col), 32)));           
               }
               /*
               if (o instanceof Object[] ) {
                   curve cr= (curve)((Object[])o)[0];
                   Integer f=(Integer)((Object[])o)[1];
                   if (f==-1) dest.addcurve(cr.cloneIndependent(sy, ey, 1, name, palecol(mixcol(col), 32)));
                   else dest.addcurve(cr.cloneIndependent(sy, ey, 1, name, palecol(col[f], 32)));
               }
                */
               if (o instanceof curveset) {
                   curveset source=(curveset)o;
                   curveset av=avg.get(source);
                   for (Object key : source.map.keySet()) {
                   curve c=source.getcurve(key);
                    dest.addcurve(c.cloneIndependent(sy, ey, 1, c.name+"_"+name, palecol(c.color, 16)));
                    if (!av.map.containsKey(key)) { av.addNewCurve(key); for (int y=sy; y<ey; y++) av.set(key, y, 0);}
                    float[] d=av.getcurve(key).geta(); for (int y=sy; y<=ey; y++)  d[y-sy]+=c.get(y);
                    }
               }
        } catch (Exception e) { deb(e); e.printStackTrace(); }
}

//deb("\n\n FOUND"+curvemap.get(dest).name);
//c.style=curve.linestyle.values()[i % curve.linestyle.values().length];

void makeav() {
    for (curveset c : avg.keySet()) {
        curveset av=avg.get(c);
        for (Object key : c.map.keySet()) {
            float[] d=av.getcurve(key).geta(); for (int y=sy; y<=ey; y++)  d[y-sy]/=nadd;
        }
        // add average to the plot of all curves - but without special thickness, may be confusing?
        for (curveset call : curvemap.keySet()) if (curvemap.get(call) ==c) {
            for (Object key : av.map.keySet()) {
                curve a=av.getcurve(key);
                call.addcurve(a);
            }
       }
        curvemap.put(av, c);
    }
}

void savefiles() {
        baseplot.hidelegend=true;
    plot: for (curveset c : curvemap.keySet()) { try {
        //if (curvemap.get(c) instanceof curve) continue plot;
    	int nc=c.map.size();
        lineplot plot = (lineplot)(plot(c));
        plot.xscale.min=sy; plot.xscale.max=ey;
        plot.xscale.units.scales=10; plot.xscale.changed=true;
        plot.yscale.min=0;
        if (curveymax.containsKey(curvemap.get(c))) plot.yscale.max=curveymax.get(curvemap.get(c));
        plot.yscale.changed=true;
        if (curvemap.get(c) instanceof curve) {
            if (savefacplots) for (int i=0; i<nsets; i++) {
                for (Object key : colormap.keySet()) c.getcurve(key).color=palecol(colormap.get(key)[i], 32);
                save (plot, c.name+"_"+i, nc);
            }
            for (Object key : colormap.keySet()) c.getcurve(key).color=palecol(mixcol(colormap.get(key)), 32);
        }
        save (plot, c.name, nc);
        } catch (Exception e) { e.printStackTrace(); }
    }
}

    //fileio.savetextfile("jcmout"+fs+"results"+fs+"descriptions.txt", descriptions);
    //fileio.savetextfile("jcmout"+fs+"results"+fs+"indicators.csv", indics);

void save (lineplot plot, String name, int nc) {
         checkready(300);
        showpan.toFront(plot);
        checkready(300+nc);
        plot.doplot();
        checkready(300+nc);

        String path="jcmout"+fs+"results"+fs+"oxford15"+fs;
        imagesaver.saveimage(plot, "png", new File(path+name+".png"));
        //datable.savetable(new File(path+dest.name+".dat"), dest, "tab");
        checkready(300);
}

//======== small methods =========s
    void checkready(int delay) {
        try { while (stab.running) Thread.currentThread().sleep(delay); } catch (InterruptedException e) {}
        checkbutandsleep(delay);
    }

    float ro (float f) { return Math.round(f/100f)/10f; }

    Color mixcol(Color ... c) {
        int n=c.length;
        int r=0, g=0, b=0; for (int i=0; i<n; i++) { r+=c[i].getRed(); g+=c[i].getGreen(); b+=c[i].getBlue();  }
        return new Color(r/n, g/n, b/n);
    }

    Color palecol(Color c, int a) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

} //end class

/*
 *
        for (scenario scen1 : globscen) {
                for (scenario scen2 : pledgescen) {
                    for (scenario scen3 : basescen) {
                        for (scenario scen4 : rrb) {
                            for (scenario scen5 : cv) {
                    setscen(scen1); setscen(scen2);  setscen(scen3); setscen(scen4); setscen(scen5);
                    String name=scen1.name()+"_"+scen2.name()+"_"+scen3.name()+"_"+scen4.name()+scen5.name() ;
                    Color col=mixcol(scen1.col, scen2.col, scen3.col, scen4.col, scen5.col);
                addcurves(name, col);
            }}}}}
   */

