/*
 *
 * One set of many scenarios => spaghetti, recolor to highlight different factors?
 * Table of combinations + color 1,2,3,4
 * or just vary systematically - climsens, diffusivity, ...
 * start by list of shares params ...
 *
 *
*/
package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.JComponent;

import jcm.core.loop;
import jcm.core.cur.*;
import jcm.core.reg.*;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.baseplot;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.*;
import jcm.mod.cli.*;
import jcm.mod.energy.enerData;
import jcm.mod.energy.enerGeneral;
import jcm.mod.obj.*;
import jcm.mod.regemit.*;
import jcm.mod.resp.attribTracer;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresdata;
import jcm.mod.socio.popgdp;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import  static jcm.script.brazil_sensanal.scenario.*;
import  static jcm.mod.obj.stabilisation.indicators.*;
import  static jcm.mod.obj.stabilisation.curvetype.*;
import static jcm.mod.regemit.pledges.pledgelevel.*;
import static jcm.mod.scen.sresimgdata.scen.*;

public class brazil_sensanal extends calcscript {

    globco2emit gc=gm(globco2emit.class);
    berncarbon carb  = gm(berncarbon.class);
    udebclimod cli=gm(udebclimod.class);
    glotemp tem= gm(glotemp.class) ;
    radfor rf= gm(radfor.class);
    stabilisation stab=gm(stabilisation.class);
    shares sha=gm(shares.class);
    pledges ple=gm(pledges.class);
    emitquota eq=gm(emitquota.class);
    sealevel sl=gm(sealevel.class);
    controller co=gm(controller.class);
    sresBase bs=gm(sresBase.class);
    enerGeneral ea=gm(enerGeneral.class);

    int sy=1990, ey=2070;
    List<region> regforplot=new ArrayList();
    Map<curveset, Object> curvemap= new LinkedHashMap(); //dest, orig

    Map<curveset, Float> curveymax= new LinkedHashMap();
    Map<curveset, curveset> avg= new LinkedHashMap();
    Map<Object, Color[]> colormap= new LinkedHashMap();

    String[] regplot= new String[]{};//"Brazil", "China", "Europe_All"};
     int weightneeded=7;

    enum scenario {
            stabtemp_2C(blue), fiftypc2050_2C (green, 2f), stabconc450(yellow, 1f),    
            carbdefault(black), highfb(brown), lowfb(green), fastoc(blue), slowoc(purple),
            AR4_average(black), HadGEM1(red), MIROC3_2_MED(orange), ECHAM5_MPIOM(yellow), HadCM3(green), CSIRO_Mk3(cyan), GISS_EH(blue),
            cond_pledge(blue), uncond_pledge(green), nopledge(red),
            SRES_B2(yellow, 1f), WEO_NP_B2(green), SRES_A1B(red), WEO_NP_A1B(blue, 1f),
            gdp_low(green), gdp_mid(yellow, 1f), gdp_high(red),
            cv_50(blue), cv_65(yellow, 1f), cv_80(red, -1f),
            cv_partav(blue, 1f), cv_globav(magenta),
            cv_percap(cyan, 1f), cv_pergdp(yellow),
            rrb_0(red), rrb_10(orange, 1f), rrb_15(yellow, 2f), rrb_20(green, 1f), rrb_30(cyan),
            ;
            Color col;
            String info;
            float weight;
            scenario (Color c) { this(c,0); }
            scenario (Color c, float  f) { 
                col=c; weight=f;
            }
    };

    scenario[] 
            globscen={stabtemp_2C, fiftypc2050_2C, stabconc450}, //3
            carbon = {carbdefault, highfb, lowfb, fastoc, slowoc}, //5
            climod={ AR4_average, HadGEM1, MIROC3_2_MED, ECHAM5_MPIOM, HadCM3, CSIRO_Mk3, GISS_EH}, //7- the list "AR4selection" from udebclimod
            pledgescen={cond_pledge, uncond_pledge, nopledge}, //3
            basescen={SRES_B2, WEO_NP_B2, SRES_A1B,  WEO_NP_A1B}, //4
            gdp ={gdp_low, gdp_mid, gdp_high},  //3
            cvy= {cv_50, cv_65, cv_80}, //3
            cvg={cv_partav, cv_globav}, //2
            cvi={cv_percap, cv_pergdp}, //2
            rrb = {rrb_0, rrb_10, rrb_15, rrb_20, rrb_30}; //5

  scenario[][] sets={ globscen, carbon, climod, pledgescen, basescen,   gdp, cvy, cvg, cvi, rrb};
  int globi=0, carbi=1, climi=2;

  int focus=-1;
  
  int nsets=sets.length, nscen=scenario.values().length;
   int[] ci = new int[nsets], pi= new int[nsets]; //current, previous
   
   int nadd=0, nskip=0, nnosense=0;
   EnumMap<scenario, Integer> ninc=new EnumMap(scenario.class);
   

void setscen(scenario scen) {
    deb(" =>"+scen.name()+": ");
    switch (scen) { //set parameters per scenario
        case stabtemp_2C : {
             stab.indicator.set(stabilisation.indicators.stabtemp);
             stab.peaking.set(false);
            stab.stabyear.set(2125);
            stab.stabtemplevel.set(2.0);
            break;
        }
       
         case stabconc450 : {
            stab.indicator.set(stabilisation.indicators.stabconc);
            stab.stabconclevel.set(450);
            stab.peaking.set(false);
            stab.stabyear.set(2100);
            stab.curveopt.set(padequintic);
            break;
        }

         case fiftypc2050_2C : {
            stab.indicator.set(stabilisation.indicators.define_emit);
            stab.stabemityear.set(2050);
            stab.peaking.set(true);
            stab.stabemitlevel.set(3500); // lowered from 3850 since added HFCs
            stab.stabemitendlevel.set(250);
            stab.stabemitdeclinerate.set(1.1); //lowered from 1.25 to compensate
            break;
        }

        case AR4_average : { cli.climod.set(udebclimod.gcm.AR4_average); break; }
        case HadGEM1 : { cli.climod.set(udebclimod.gcm.HadGEM1); break; }
        case MIROC3_2_MED : { cli.climod.set(udebclimod.gcm.MIROC3_2_MED); break; }
        case ECHAM5_MPIOM : { cli.climod.set(udebclimod.gcm.ECHAM5_MPIOM); break; }
        case HadCM3 : { cli.climod.set(udebclimod.gcm.HadCM3); break; }
        case CSIRO_Mk3 : { cli.climod.set(udebclimod.gcm.CSIRO_Mk3); break; }
        case GISS_EH : { cli.climod.set(udebclimod.gcm.GISS_EH); break; }

        case carbdefault : {
            carb.beta.set(0.5);
            carb.respq10.set(1.4);
            carb.diffufac.set(1.0);
            break;
        }
        case highfb : {
            carb.beta.set(0.6);
            carb.respq10.set(2.0);
            carb.diffufac.set(1.0);
            break;
        }
        case lowfb : {
            carb.beta.set(0.4);
            carb.respq10.set(1.0);
            carb.diffufac.set(1.0);
            break;
        }
        case fastoc : {
            carb.beta.set(0.5);
            carb.respq10.set(1.4);
            carb.diffufac.set(1.25);
            break;
        }
        case slowoc : {
            carb.beta.set(0.5);
            carb.respq10.set(1.4);
            carb.diffufac.set(0.75);
            break;
        }

        case cond_pledge : {
            ple.usepledges.set(true);
            ple.level.set(conditional);
            ple.kyoto.set(pledges.kyoto_opts.Kyoto_targets_excUSA_prolonged);
            co.botuptopdo.set(controller.butd.start_bottom_up);
            ea.WEOscenario.set(enerData.WEO_scenario.New_Policies);
            sha.smoothjumpbase.set(shares.smoothbaseopt.intensity_based);
            break;
        }
        case uncond_pledge : {
            ple.usepledges.set(true);
            ple.level.set(unconditional);
            ple.kyoto.set(pledges.kyoto_opts.real_emissions);
            co.botuptopdo.set(controller.butd.start_bottom_up);
            ea.WEOscenario.set(enerData.WEO_scenario.New_Policies);
            sha.smoothjumpbase.set(shares.smoothbaseopt.intensity_based);
            break;
        }
        case nopledge : {
            ple.usepledges.set(false);
            ple.kyoto.set(pledges.kyoto_opts.real_emissions);
            co.botuptopdo.set(controller.butd.top_down_only);
            ea.WEOscenario.set(enerData.WEO_scenario.Current_Policies);
            sha.smoothjumpbase.set(shares.smoothbaseopt.no_smooth);
            break;
        }
        case WEO_NP_B2 : {
                bs.useWEO.set(true); bs.scenario.set(B2); break;
            }
        case WEO_NP_A1B : {
                bs.useWEO.set(true); bs.scenario.set(A1B); break;
            }
        case SRES_B2 : {
            bs.useWEO.set(false); bs.scenario.set(B2); break;
        }
         case SRES_A1B : {
            bs.useWEO.set(false); bs.scenario.set(A1B); break;
        }
        case rrb_0 : {
            sha.dc_reduction.set(0); break;
        }
        case rrb_10 : {
            sha.dc_reduction.set(0.7); break; //approx -10% wrt baseline if applied 2005-20
        }
        case rrb_15 : {
            sha.dc_reduction.set(1.1); break; //approx -15% wrt baseline if applied 2005-20
        }
        case rrb_20 : {
            sha.dc_reduction.set(1.5); break; //approx -20% wrt baseline if applied 2005-20
        }
        case rrb_30 : {
            sha.dc_reduction.set(2.35); break; //approx -30% wrt baseline if applied 2005-20
        }
        case cv_50 : {
            sha.convergey.set(2050); break;
        }
       case cv_65 : {
            sha.convergey.set(2065); break;
        }
       case cv_80 : {
            sha.convergey.set(2080); break;
        }

        case cv_globav : {
            sha.emitlim.set(shares.emitthreshold.worldemitpercap); break;
        }
       case cv_partav : {
            sha.emitlim.set(shares.emitthreshold.particip_emitpercap); break;
        }
        case cv_percap : {
            sha.conv_criteria.set(shares.convcrit.emissionspercapita); break;
        }
        case cv_pergdp : {
            sha.conv_criteria.set(shares.convcrit.emissionspergdp); break;
        }
        case gdp_low: {
            sha.axb_gdp_threshold.set(15000); break;
        }
        case gdp_mid: {
            sha.axb_gdp_threshold.set(20000); break;
        }
        case gdp_high: {
            sha.axb_gdp_threshold.set(25000); break;
        }
  } //switch
}//setscen

 public void run() {
        setup();

        for (int i=0; i<nsets; i++) {ci[i]=0; pi[i]=-1; }
        int j=nsets-1;

        scenloop: do {
            setscen(j);
            j=nsets-1;  ci[j]++;
            while(ci[j]==sets[j].length) { ci[j]=0; j--; if (j<0) break scenloop; ci[j]++; }
        } while (true);

          log("\n=========================================\n"
                  +"added "+nadd+" skipped "+nskip+ " no-sense "+nnosense+" \n");
          String nums=""; for (scenario s : scenario.values()) nums+=" "+s+": "+ninc.get(s);
          log(nums);
          
          makeav();
          savefiles();
          end();
          
          log("End of script braz_sensanal");
    } //run

    void setscen(int j) {
        String name="";
        int weight=0;
        Color[] cols=new Color[nsets]; Color col;

        boolean makessense=(
             (globscen[ci[globi]]== stabtemp_2C) 
             || (globscen[ci[globi]] == stabconc450 && climod[ci[climi]] == AR4_average)
             || (climod[ci[climi]] == AR4_average && carbon[ci[carbi]] == carbdefault)
             );
        
        for (int i=0; i<nsets; i++) {
            scenario s=sets[i][ci[i]];
            name+=(i>0 ? "_" : "")+s.name();
            cols[i]=s.col;
            weight+= s.weight; //   (i==focus) ? 1f : s.weight;
        }
        boolean accepted= makessense && weight>=weightneeded;
        
        if (accepted)  {
            nadd++;
            deb ("\n === ADD "+nadd+":  "+name+" ===\n");
            for (int i=0; i<nsets; i++) if (ci[i]!=pi[i]) setscen(sets[i][ci[i]]); //setscen - but only  if changed since previous accepted
            for (int i=0; i<nsets; i++) pi[i]=ci[i]; //store previous accepted case
            //col=  (focus>=0) ? cols[focus] : mixcol(cols);
            //just to test how many cases will run... comment addcurves
            //for (int i=0; i<nsets; i++)
            addcurves(name, cols);
            for (int i=0; i<nsets; i++)  ninc.put(sets[i][ci[i]], ninc.get(sets[i][ci[i]])+1);
        } //accepted
        if (!accepted && makessense) {
            nskip++;
             //deb(" \t\t\t === skipped: "+name+" ===");
        }
        if (!makessense) nnosense++;
    }

 void setup() {
     loop.checkperform.set(true);
    lookandfeel.fontSize.set(18);
    gm(regset.class).regions.set(regman.allreg.findreg("JCM16"));
    loop.gonow(false);
    checkready(500);

    curveset percap=new curvar(curve.Type.ratio, eq.emitfos_unitsCO2, gm(popgdp.class).pop);
        link(percap);
     //uncomment to watch calc in progress
        lineplot plot = (lineplot)(plot(percap));
        plot.xscale.min=sy; plot.xscale.max=ey;
        plot.xscale.units.scales=10; plot.xscale.changed=true;
        showpan.toFront(plot);
        plot.doplot();
        checkready(500);
    
    //set some plotlinks to ensure model loop knows what to calculate
    link(tem.temp); link(eq.emitequiv);
    //this helps to reset it
   checkready(500);
    stab.indicator.set(stabilisation.indicators.stabconc);

    loop.gonow(false);
    checkready(500);

    for (String s : regplot) regforplot.add(regman.allreg.findreg(s));
    curveset[] plots={eq.emitfos_unitsCO2, eq.emitequiv,  percap};
    deb("\n\n"+percap.name+" "+percap.units+"\n\n");

    for (curveset c : plots) {
        curvemap.put(new curveset(c.name, c.units, sy, ey, 1), c);
        for (region r : regforplot) {
            curve cr=c.getcurve(r);
            /*
            for (int f=0; f<nsets; f++) {
                curvemap.put(new curveset(r.name+"_"+f+"_"+c.name, c.units, sy, ey, 1), new Object[]{cr, f});
            }
              curvemap.put(new curveset(r.name+"_"+c.name, c.units, sy, ey, 1), new Object[]{cr, -1});
             */
            curvemap.put(new curveset(r.name+"_"+c.name, c.units, sy, ey, 1), cr);
        }
        avg.put(c, new curveset(c.name+"_average", c.units, sy, ey, 1)); //note - map other way around
    }
    curveymax.put(eq.emitfos_unitsCO2, 12000f );
    curveymax.put(eq.emitequiv, 14000f );
    curveymax.put(percap, 21f );
    
    for (scenario s : scenario.values()) ninc.put(s, 0);
    
} //setup


void addcurves(String name, Color[] col) {
        //checkready(500);
        loop.gonow(false); //run model (without changing tree-struc)
        checkready(200);
        log("start add curve");
        colormap.put(name, col);

           for (curveset dest : curvemap.keySet()) try {
               Object o = curvemap.get(dest);
               if (o instanceof curve ) {
                   curve cr= (curve)o;
                   dest.addcurve(cr.cloneIndependent(sy, ey, 1, name, palecol(mixcol(col), 32)));           
               }
               /*
               if (o instanceof Object[] ) {
                   curve cr= (curve)((Object[])o)[0];
                   Integer f=(Integer)((Object[])o)[1];
                   if (f==-1) dest.addcurve(cr.cloneIndependent(sy, ey, 1, name, palecol(mixcol(col), 32)));
                   else dest.addcurve(cr.cloneIndependent(sy, ey, 1, name, palecol(col[f], 32)));
               }
                */
               if (o instanceof curveset) {
                   curveset source=(curveset)o;
                   curveset av=avg.get(source);
                   for (Object key : source.map.keySet()) {
                   curve c=source.getcurve(key);
                    dest.addcurve(c.cloneIndependent(sy, ey, 1, c.name+"_"+name, palecol(c.color, 16)));
                    if (!av.map.containsKey(key)) { av.addNewCurve(key); for (int y=sy; y<ey; y++) av.set(key, y, 0);}
                    float[] d=av.getcurve(key).geta(); for (int y=sy; y<=ey; y++)  d[y-sy]+=c.get(y);
                    }
               }
        } catch (Exception e) { deb(e); e.printStackTrace(); }
}

//deb("\n\n FOUND"+curvemap.get(dest).name);
//c.style=curve.linestyle.values()[i % curve.linestyle.values().length];

void makeav() {
    for (curveset c : avg.keySet()) {
        curveset av=avg.get(c);
        for (Object key : c.map.keySet()) {
            float[] d=av.getcurve(key).geta(); for (int y=sy; y<=ey; y++)  d[y-sy]/=nadd;
        }
        // add average to the plot of all curves - but without special thickness, may be confusing?
        for (curveset call : curvemap.keySet()) if (curvemap.get(call) ==c) {
            for (Object key : av.map.keySet()) {
                curve a=av.getcurve(key);
                call.addcurve(a);
            }
       }
        curvemap.put(av, c);
    }
}

void savefiles() {
        baseplot.hidelegend=true;
    plot: for (curveset c : curvemap.keySet()) { try {
        //if (curvemap.get(c) instanceof curve) continue plot;

        lineplot plot = (lineplot)(plot(c));
        plot.xscale.min=sy; plot.xscale.max=ey;
        plot.xscale.units.scales=10; plot.xscale.changed=true;
        plot.yscale.min=0;
        if (curveymax.containsKey(curvemap.get(c))) plot.yscale.max=curveymax.get(curvemap.get(c));
        plot.yscale.changed=true;
        if (curvemap.get(c) instanceof curve) {
            for (int i=0; i<nsets; i++) {
                for (Object key : colormap.keySet()) c.getcurve(key).color=palecol(colormap.get(key)[i], 32);
                save (plot, c.name+"_"+i);
            }
            for (Object key : colormap.keySet()) c.getcurve(key).color=palecol(mixcol(colormap.get(key)), 32);
        }
        save (plot, c.name);
        } catch (Exception e) { e.printStackTrace(); }
    }
}

    //fileio.savetextfile("jcmout"+fs+"results"+fs+"descriptions.txt", descriptions);
    //fileio.savetextfile("jcmout"+fs+"results"+fs+"indicators.csv", indics);

void save (lineplot plot, String name) {
         checkready(500);
        showpan.toFront(plot);
        checkready(1000);
        plot.doplot();
        checkready(500);

        String path="jcmout"+fs+"results"+fs+"brazil"+fs;
        imagesaver.saveimage(plot, "png", new File(path+name+".png"));
        //datable.savetable(new File(path+dest.name+".dat"), dest, "tab");
        checkready(500);
}

//======== small methods =========s
    void checkready(int delay) {
        try { while (stab.running) Thread.currentThread().sleep(delay); } catch (InterruptedException e) {}
        checkbutandsleep(delay);
    }

    float ro (float f) { return Math.round(f/100f)/10f; }

    Color mixcol(Color ... c) {
        int n=c.length;
        int r=0, g=0, b=0; for (int i=0; i<n; i++) { r+=c[i].getRed(); g+=c[i].getGreen(); b+=c[i].getBlue();  }
        return new Color(r/n, g/n, b/n);
    }

    Color palecol(Color c, int a) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

} //end class

/*
 *
        for (scenario scen1 : globscen) {
                for (scenario scen2 : pledgescen) {
                    for (scenario scen3 : basescen) {
                        for (scenario scen4 : rrb) {
                            for (scenario scen5 : cv) {
                    setscen(scen1); setscen(scen2);  setscen(scen3); setscen(scen4); setscen(scen5);
                    String name=scen1.name()+"_"+scen2.name()+"_"+scen3.name()+"_"+scen4.name()+scen5.name() ;
                    Color col=mixcol(scen1.col, scen2.col, scen3.col, scen4.col, scen5.col);
                addcurves(name, col);
            }}}}}
   */

