/*  module containing curvesets of  regional population, gdp, energy use, 
and methods to extrapolate these data from national historical data and future scenario data
 */
package jcm.mod.socio;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jcm.mod.obj.regset;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.*;
import jcm.mod.obj.controller;
import jcm.mod.scen.sresBase;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static jcm.mod.scen.sresimgdata.*;
import static java.lang.Math.*;


public class popgdp extends module {
    
	public void initsetup() {  
		modpop=gm(demog.class);
		modec=gm(economy.class);
		regsetm=gm(regset.class);
		sb=gm(sresBase.class);
		
        history.setaffectedby(gm(regset.class).regions);
        history.setaffectedby(histsocdata.joinyear);
        future.follows(history);
         
        future.setaffectedby(sb.scenario);
        setaffectedby(sb.sresext); //only the curves are affected, not the calcn
	    future.setaffectedby(sb.socconv); 
    	future.setaffectedby(ppp_convfac, ppp_powfac, usemod);
    	connect.setaffectedby(usemod);;
	    connect.follows(gm(demog.class )); 
    	connect.follows(gm(economy.class ));
    	future.follows(connect);
    	/*
    	connect should be between future and all that depend on it ... but how to insert?
    	other modules expect to depend on future    
    	
    	if future follows connect will solve interactions but overwrite curve data  
    	 in principle, connect doesnt need history and future, except to the extent they affect popu and econ
    	 note history affects econ (  init capital, forecehist method)  
    	 anyway note popu,econ uses calcstep due feedbacks whereas hist/fut use precalc
    	 
    	but as econ doesn't have mer/ppp distinction - still need to use scendata for scaling ...   
    	
    	so for the moment have to insert after future, by amending future method ...
    	
    	note also: msr curves only work and needed when usemod, should disappear otherwise 
    	*/
     } 
    
    public void setinteractions() {  
    	setaffectedby(connect, usemod.istrue() ); 
    	 
    }
    
    //=================== CURVES =================
    public curveset pop = new curveset("population", "mega&person", simplest), //
            //energy =new qtset("energy", "tera&joule&per&year"), removed since data is old / low res and plays no role in calculations
             gdp_ppp = new curveset("gdp_ppp", "mega&dollar&(2000)&per&year", 1950), //
             gdp_mer = new curveset("gdp_mer", "mega&dollar&(2000)&per&year", 1950), //
             gdp_msr = new curveset("gdp_model_scen_ratio", "untiless", 1950); //
    public curveset pop_nat = new curveset("population&national", "mega&person", 1995, 2050, expert), //
             gdp_ppp_nat = new curveset("gdp_ppp&national", "mega&dollar&(2000)&per&year", 1995, 2050, expert), //
             gdp_mer_nat = new curveset("gdp_mer&national", "mega&dollar&(2000)&per&year", 1995, 2050, expert); //
     //=================== PARAMS =================
 
     public param ppp_convfac = new param("ppp_convfac", "%&per&yr", 2, 0, 100, experimental);
     public param ppp_powfac = new param("ppp_powfac", "", 0.3, 0.1, 1, experimental);

     public param usemod = new param("use model pop and gdp", true); 
     
     //=========== ref variables ===============================
     //region regset;
     demog modpop; 
 	 economy modec; 
 	 regset regsetm;
 	 sresBase sb;
     
    //==========================================
    
    /* History and Future are separate loopcalcs to enable 
    different interactions (don't always need to recalc history if change future) 
    and different calculation order in loop: bottom-up history and top-down future
     */
    //*************** HISTORY *************
    public loopcalc history = new loopcalc("socio-history") {
        public void precalc() {

            region regset  = regsetm.regions.chosen;

            regsetm.clearoldregions(this);
                    
            histsocdata.realgdp(); //note: as there is a param there!
                    
            interpolator.fillregdata(histsocdata.histpop, pop, regset , 0.001f);
            interpolator.fillregdata(histsocdata.GDP_MER, gdp_mer, regset , 1f);
            interpolator.fillregdata(histsocdata.GDP_PPP, gdp_ppp, regset , 1f);
            //P2 not efficient to put this in same precalc - only need to do once on initsetup, but after histsocdata full
            interpolator.fillregdata(histsocdata.histpop, pop_nat, regman.nations, 0.001f);
            interpolator.fillregdata(histsocdata.GDP_MER, gdp_mer_nat, regman.nations, 1f);
            interpolator.fillregdata(histsocdata.GDP_PPP, gdp_ppp_nat, regman.nations, 1f);


            for (int y = gsy; y < fsypop; y++) pop.calctot(y);
            for (int y = gsy; y < fsygdp; y++) {
                gdp_mer.calctot(y);
                gdp_ppp.calctot(y);
            }
        }
    }; //end history 
    //************** FUTURE **********
    public loopcalc future = new loopcalc("socio-future") {
        public void precalc() {
        	
       
        float socconv = (float) sb.socconv.getval();
        region regset  = regsetm.regions.chosen;

            interpolator popsource=new interpolator(sres_image_popn.get(sb.scpop));
            popsource.fill(pop_nat, regman.nations, fsypop, 2050, histsocdata.histpop, socconv);
            interpolator.fillregdata(pop_nat, pop, regset , fsypop, 2050);
            popsource.fill(pop, regset , 2051, 2100, pop_nat, socconv);

            
            for (int y = fsypop; y <= 2100; y++) pop.calctot(y);

            //note:  IMAGE was based on 1995$ , whilst the PWT_MER is based on 2000$, 0.9211 is the deflator from WEO (see histregdata)
            float inflator = 1f / 0.9211f;
            interpolator gdpsource=new interpolator(sres_image_gdp.get(sb.scgdp), inflator);
            gdpsource.fill(gdp_mer_nat, regman.nations, fsygdp, 2050, histsocdata.GDP_MER, socconv);
            interpolator.fillregdata(gdp_mer_nat, gdp_mer, regset , fsygdp, 2050);
            gdpsource.fill(gdp_mer, regset , 2051, 2100, gdp_mer_nat, socconv);

            futureppp(gdp_mer_nat, gdp_ppp_nat, pop_nat, regman.nations.reg, fsygdp-1, 2050);
            interpolator.fillregdata(gdp_ppp_nat, gdp_ppp, regset , fsygdp, 2050);
            /*for (region r : regset.reg) { //add up to get bigger regions
                Set<region> rs=r.subreg(regman.nations); 
                for (int y=fsygdp; y<2051; y++) {  float gp=0; for (region rr : rs) gp+=gdp_ppp_nat.get(rr, y); gdp_ppp.set(r, y, gp); }
            }*/
            futureppp(gdp_mer, gdp_ppp, pop, gm(regset.class).regions.chosen.reg, 2050, 2100); //continue bigger regions only

            for (int y = fsygdp; y <= 2100; y++) {    gdp_mer.calctot(y); gdp_ppp.calctot(y);      }
        }
        public void calcstep() { if (usemod.istrue()) connectpopuecon(); }
        
    }; //end future
    
    //************** CONNECT ***********
    /* uses model popn and gdp rather than scenario 
     * - will overwrite pop and gdp above  
      */
    public loopcalc connect = new loopcalc("socio-connect") {
    	public void precalc() {
    		 deb("running popgdp connect");
    	}
    	public void calcstep() {
    		
    	}
    	 
    };
    
    //the real calcstep method
    void connectpopuecon() {
    	region regset  = regsetm.regions.chosen;
    	for (region r : regset.reg) { 
    		//try{
    			//	1000 convert kilo to mega
    			float mp= modpop.modpop.get(r)/1000f, pr=mp/pop.get(r); 
    			pop.set(r,  mp); 
    			float me=modec.gdp_mod.get(r), mr=me/gdp_ppp.get(r); 
    			 gdp_ppp.set(r,  me);
    			 gdp_msr.set(r, mr);
    			 gdp_mer.set(r,  gdp_mer.get(r)*mr); 
    		//} catch (Exception e) { deb ("problem popgdp connect in "+r+" "+year); }
// temporary fix - scale nations acc to the ratio of model/scen for whole region       			 
    		for (region rr : r.subreg(regman.nations))  { 
    			pop_nat.set(rr, pop_nat.get(rr)*pr );
    			gdp_ppp_nat.set(rr, gdp_ppp_nat.get(rr)*mr );
     			gdp_mer_nat.set(rr, gdp_mer_nat.get(rr)*mr );
    		}
    	} //r

    	pop.calctot(year);
    	gdp_ppp.calctot(year);
    	gdp_mer.calctot(year);
    	//do we need tot of the nats too? 
    } 

    
    
    // end connect
    
    
    public void futureppp(curveset mer, curveset ppp, curveset pop, List<region> regset, int sy, int ey) {
        //see notes below!
        //note: this will only work for regionsets containing USA - i.e. not SRES4 or Kyoto!!
        
        region USA = regman.nations.findreg("USA");
        if (!mer.map.keySet().contains(USA)) {
            deb("\nCan't calculate future PPP without USA in the chosen regionset!! ");
            return;
        }

        Map<region, Float> alpha = new HashMap();
        float a, p, m, u, dm, du, dp, da;
        float acf = (float) ppp_convfac.getval() / 100f;
        float b = (float) -ppp_powfac.getval();


        for (int y = sy; y < ey; y++) {
            u = mer.get(USA, y) / pop.get(USA, y);
            du = (mer.get(USA, y + 1) / pop.get(USA, y + 1) - u) / u;
            ppp.set(USA, y + 1, mer.get(USA, y + 1));

            for (region r : regset) if (r != USA) {
                    m = mer.get(r, y) / pop.get(r, y);
                    dm = (mer.get(r, y + 1) / pop.get(r, y + 1) - m) / m;
                    p = ppp.get(r, y) / pop.get(r, y);


                    if (y == sy) {
                        a = (float) ((p / m) / pow((m / u), b));   /* deb(r.name+"gdp a= "+a); */ } else a = alpha.get(r);

                    da = acf * (1f - a); //converge alphas towards 1 by convfac% per year
                    alpha.put(r, a + da);

                    dp = p * (dm * (1f + b) - b * du + da / a);
                    ppp.set(r, y + 1, pop.get(r, y + 1) * (p + dp));
                } //r
        }//y



    } //fppp
    
    /**
    Notes 
    Calculate the future GDP in Purchasing Power Parity
    There is not yet any accepted way to estimate future PPP rates, and few SRES models reported them
    
    So we assume:
    p/m = a. (m/u)^b
    
    p =gdp-ppp/cap, m=gdp-mer/cap  and u  =gdpUS/cap (same for both mer and ppp)
    
    a is country-specific, fixed from initial data, and gradually converges towards 1 (at a rate et by convfac)
    b (negative) is an adjustable factor (powfac)
   (note: if b = -1, all countries equally rich, if b=0 ppp=mer)
 
    start with b = - 0.3 ? or -0.5
    and da/dt = 0.02(1-a)
 
    r=p/m = a.(m/u)^b
    
    => p =  a. m^(1+b) / u^b
    => dp/dt = a. (1+b) (m/u)^b dm/dt  - a.b (m/u)(m/u)^b du/dt +da/dt . p/a
    => dp/dt  = p ( (1+b) dm/m.dt  - b  du/u.dt + da/a.dt )
    
    in future use dm/m.dt and du/u.dt from image data, but don't constrain the totals
        
    Note: original formula had beta tuned from 
    this formula is problematic for Japan: m>u but p<u => p/m < u/m => beta <-1 i.e. the richer Japan gets wrt US, the lower the ppp wrt  US
    Also, problem if m and u are almost same => log (1)/log(1) = 0/0...
    P2 recheck for extreme countries - eg Japan, Burma...? 
     * 
    Alternative approach: could calculate PPP for image regions and then use interpolator for others, but would give poorer continuity (betas would no longer compensate for smaller countries)
     */
    
    
    
} // end class
    
