package jcm.mod.socio;

 import java.util.*;

import jcm.mod.obj.regset;
import jcm.mod.scen.sspData.plots;
import jcm.core.data.interpolator;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.*;
import jcm.core.complexity;
import jcm.core.tls.fileio;
import jcm.mod.math.regress;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static java.lang.Math.*;
import static jcm.mod.scen.sresdata.*;
import static jcm.mod.socio.demog.fertopts.*;

//should separate a hist section implements dataholder? together with popu
public class migration extends module { 
	 
	static String[]  periods = { "1960s", "1970s", "1980s", "1990s",  "1990_95", "1995_00", "2000_05", "2005_10" } ;
	boolean gotdata=false;

	//static Map<String, Integer> coderef=   new HashMap() ; 
	static Map<Integer, String> tabcode=   new HashMap() ; //index original table rows/cols - not all same ! 
	static Map<String, region>  codereg = new HashMap();
	static Map<region, Integer> regref = new TreeMap(); //index mfd data
	static int[][][] mfd;// period, from, to
	
	int migsy=1963, migey=2203, migstep=5;
 	 
	 public curveset migflow=new curveset("Migration Flows", "people moved in 5yrs", migsy, migey, 5  ); 
	 public curveset netmig =new curveset("net mign by country ", "kilo&person&per&year", migsy, migey, 5); 
	 
	 enum migopts  { constrate, constabs  }
	 enum miglevs { high, med, low }
	
	 public param csy= new param("start converge mign", "year", 2050, 2010, 2100, 5);
	 public param cey= new param("end converge mign", "year", 2150, 2010, migey, 5);
	 public param<region> countryview;  
	 public param<migopts> migopt=new param("fut mign type", migopts.values(), migopts.constrate);
	 public param<miglevs> miglev=new param("fut mign level", miglevs.values(), miglevs.med);
	 
	 
	 demog pop;
	 
	//=============== module methods =============
	public void initsetup() {
		if (!gotdata){ loadhistdata(); gotdata=true;}
		  
		countryview=new param("Country for migration plot", regref.keySet(), regman.nations.findreg( "Belgium"));
		pop=gm(demog.class);
		
	}
	public void setinteractions() {
		setaffectedby(pop );
	}
	
	
	public void precalc() {
		curveshist();
	}
	 
	/*
	 * problem is that pop calcs 5 yrs in advance due to feedback with econ... and other mods depend
	 * so mign should do same - otherwise have to run twice ..
	 * or find another way to do feedback ...
	 * also the two +5 yy are out of sync - hence use +10 to avoid lag fb
	 * 
	 */
	public void calcstep() {
		int yy=year+10;  
		if (yy>migsy && yy <=migey &&  ((yy-3) % migstep==0 )) {
			calcnetmig(yy); 	
		} 
	}
	
	 
	void curveshist() {
		migflow.map.clear();
		
		region cr = countryview.chosen ;
          
        		int c=regref.get(cr);
        		for (region r : regref.keySet()) {
        			 
        			if (r.equals(cr) || r.equals(regman.world)) continue;
        			//if (refreg.get(ss)==cr) { deb("migration skipped between "+s+" and " +ss);  continue; } //skip between bits of same nation (eg applies UK, China etc.) 
        			
 
         				String fn="from "+r.getName(), tn="to "+r.getName();
        				int cc=regref.get(r);

        				for (int y = 1965; y<=2010; y+=5 ) {
        					int i=mfpi(y); 
        					float fac= y<1995 ? 2 : 1 ; //becos 10-yr periods
        					try {
        					//y is the end yr of 5yr period, plot 2 yrs before consist with popn module 	
         					migflow.set( fn, y-2, mfd[i][cc][c]/fac);
        					migflow.set( tn, y-2, -mfd[i][c][cc]/fac);
            				//deb("make curve for "+s+" - "+ ss + " - "+i);
        					} catch (Exception e) {deb ("migration data problem "+cr+" - "+ r +" in "+ y); }
        				}  
        				migflow.getcurve(fn).color=r.color; 
        				migflow.getcurve(tn).color=r.color;
         		}       	  
   } 
	

	 
	void calcnetmig(int yy) {
		int i=mfpi(yy);
		int sy=(int)csy.getval(), ey=(int)cey.getval(), ly  ;
		sy=sy  - (sy+2) % migstep ; ey=ey -  (ey+2) % migstep  ; 
		float f, m;
			
		curveset p=pop.modpop_nat;


		for (region r : regref.keySet()){ 
			float nm=0; 
			//note use -10 and 2003 due to the async steps issues... (and pop calcs after this) else drops down a lot
			float pr=p.get(r, yy-10)/p.get(r, 2003);   
			if (yy<=sy) {
				   
				 
				for (region rr : regref.keySet()) {
					if (r.equals(rr) || rr.equals(regman.world) ) continue;
					int c=regref.get(r), cc=regref.get(rr);

					if (yy<=2008) { 
						float fac= yy<1995 ? 2 : 1 ; //earlier 10-yr periods 
						nm+= (mfd[i][cc][c] -mfd[i][c][cc])/fac;
					}
					else  {
						if (migopt.chosen==migopts.constrate) nm+=mfd[7][cc][c]*p.get(rr, yy-10)/p.get(rr, 2003) -mfd[7][c][cc]*pr;
						if (migopt.chosen==migopts.constabs) nm+=mfd[7][cc][c] -mfd[7][c][cc];
					}
				} //rr
				
				if (yy>2008) {
					m=(miglev.chosen==miglevs.high ? 2f : miglev.chosen==miglevs.med ? 1f :  0 );
					f=0.67f* (yy>2025 ? m : (m*(float)(yy-2013)+(2028-yy))/15f);
					//the 0.67 is because WPP suggests it  drops by fac about 2/3 in 2010-15 cf 2005-10  
				} 
				else f=1f;
				netmig.set( r, yy, nm*f/5000f); //to convert to kilopersons per year
				
 			}
			else { //after sy
				//be careful not use in between years   
				f=(float)(ey - yy )/(float)(ey-sy);
				netmig.set(r, yy, ((yy<ey) ? netmig.get(r, sy) * f : 0 ));
			}
		} //r
	}
	
	int mfpi(int yy) { //mfd period index, acc to END year of 5yr period
		return  (yy<1995 ?  (yy-1965) / 10  : 4 + (yy-1995)/5 );
	} 
	
	//=============== load migration flow data ==================
	static void loadhistdata() { 
		
			String filebase="data/pop/MigFlow_";
			String codefr="", codeto= "";
			int nc=1, d, cf, ct; //nc is counter of regions - 0 is total
			mfd =new int[10][200][200]; //do here - to make sure empty as accumulate later
			
			region w=regman.world; regref.put(w,0); tabcode.put(0,"TOTAL"); codereg.put("TOTAL", w);
			String[][] extra={{"TWN", "Taiwan"},{"ANT","Netherlands Antilles"},{"SCG","Serbia & Montenegro"}};
 			for (String[] e : extra  ) { region r=regman.nations.findreg(e[1]); codereg.put(e[0],r ); regref.put(r, nc); nc++; }  
 
			//start with the last period - get the country names and link with JCM regions
			String[][] tab=fileio.loadtab(filebase+periods[7]+".dat", "\t"); 
			for (int j=3; j<tab.length-1; j++) {
				String name=tab[j][0].trim(), code=tab[j][1].trim();
				region r=regman.nations.findreg(name);
				if (r==null) { deb("migration "+ name +" no JCM region - made new!" ); r=regman.allreg.findormakereg(name); } 
				codereg.put(code,  r); 
				if (! regref.keySet().contains(r) ) { regref.put(r,nc); nc++; } //so only one index per JCM reg
			}
			
			
			int p=-1;
			for (String period : periods) {    
				p++;
				try {
					 tab=fileio.loadtab(filebase+period+".dat", "\t"); 

					for (int i=0; i<tab[2].length; i++) { //note - loadtab doesn't count initial blanks
						codeto=tab[2][i].trim();
						tabcode.put(i,codeto);  
	 				}
					 

					for (int j=3; j<tab.length; j++) {
						int o=(p<4 || j==tab.length-1 ? 0 : 1); //offset if there is a name before
 						codefr =tab[j][o].trim(); cf =regref.get(codereg.get(codefr));
 						if (!codereg.containsKey(codefr)) { deb("migration - code " +codefr+ " unrecognised! "); continue; }
 						for (int i=1+o; i<tab[j].length; i++) { 
							codeto=tabcode.get(i-(1+o)); ct=regref.get(codereg.get(codeto));
							d=Integer.valueOf( tab[j][i].trim()) ; 
							 mfd[p][cf][ct] =  d + (mfd[p][cf][ct] >0 ? mfd[p][cf][ct] : 0); 
							  //if (d>1000000) deb("from "+codefr+ " to " +codeto+ " in "+period +" = " +d); //enable this to check numbers matched ok
						}	 
					}

				} catch (Exception e) { deb("problem in "+period+" from "+codefr+" to "+codeto); e.printStackTrace(); }
			} //period loop

			deb ("loaded migration data OK");
	}//loadhistdata

 	
	 

}

/*
Region Issues:
regions TWN ANT SCG are only in the older tables 
MAC and HKG are separate (not in JCM)
CHI is Channel Islands

JCM Small Island Regions: (4 of them) have many
Serbia + Montenegro is separated
Sudan is separated   
   
So -  better to auto merge these together while loading
 (then some eg S&M, Sudan will sort self out if change JCM-nations)    
problem is while loading data - only know codes  - so go through all last table first
 
 */


