package jcm.mod.socio;

import java.util.*;
import jcm.mod.obj.regset;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.*;
import static jcm.mod.socio.histsocdata.*;
import static jcm.mod.math.regress.*;
import static jcm.core.complexity.*;

public class economy extends module {
    
int eey=gey;
    
    public curveset //
        gdp_mod=new curveset("gdp model", "mega&dollar&PPP(05)", 1950, eey, 1),
        gdp_percap, //ratio
        captot=new curveset("capital", "mega&dollar&PPP(05)", 1950, eey, 1),    
        capstruc=new curveset("capital: infrastructure", "mega&dollar", 1950, eey, 1),
        capmach=new curveset("capital: machines", "mega&dollar", 1950, eey, 1),    
        caphitec=new curveset("capital: hitech", "mega&dollar", 1950, eey, 1),        
        humcap=new curveset("human capital", " factor", 1950, eey, 1),
        laborshare=new curveset("labour share", "", 1950, eey, 1),    
        savings=new curveset("savings ratio", "", 1950, eey, 1),    
        tfp=new curveset("total factor productivity", "", 1950, eey, 1)
        ; 

public param forcehist = new param("force model fit history", true, expert);
public param constantalpha= new param("constant alpha (cap/lab share)", true);
public param dr_sav_fb = new param("dependency ratio affects savings?", true);

public param fracinv_inf = new param("investment infrastructure", "fraction", 0.4f, 0.2, 0.6f);
public param fracinv_hitec = new param("investment hitec", "fraction", 0.2f, 0f, 0.5f);
public param tfp_lim2300= new param("tfp limit 2300", "", 5.5f, 5.0f, 6.0f); 
public param humcap_lim= new param("humcap limit ", "", 4.0f, 3.5f, 5.0f);
public param savings_lim= new param("savings limit ", "", 0.25f, 0.1f, 0.5f);

List<region> regs; 
curveset datagdp, datapop; 
curveset workpop, deprat;

//info for splitting capital
int nc=3;
curveset[] cap={capstruc, capmach, caphitec}; 
float[] capinit={2.2f, 0.4f, 0}; //factors from PWT8 capital_labour_and_tfp table 4
float[] deprec={0.02f, 0.12f, 0.3f}; 
float[] fracinv={0.4f, 0.4f, 0.2f }; //fractions of investment
//note capinv just a temporary guess - put better later    

class regdat {
    boolean started=false;
    float sav;
    float labsh, labshold;
    float humc, humcold;
    float tfp_mod;
    float[] tfp_reg; 
    float[] hum_reg;
    float[] lab_reg;
}
Map<region, regdat> rd=new HashMap();

public void initsetup() {
    setaffectedby(gm(regset.class).regions);
    follows(demog.class);
    follows(gm(popgdp.class).history); //as datagdp used in capinit and forcehist
    
    //follows(sres_base.class); //rely on future gdp???
    datagdp=gm(popgdp.class).gdp_ppp;
    workpop=gm(demog.class).workpop;
    deprat=gm(demog.class).deprat;
    gdp_percap=new curvar(curve.Type.ratio, gdp_mod, gm(demog.class).modpop);
}

public void setinteractions() {
}

public void precalc() { 
    regs=((region) gm(regset.class).regions.chosen).reg;
    gm(regset.class).clearoldregions(this);
    for (region r : regs) rd.put(r, new regdat());
    fracinv[0]=(float)fracinv_inf.val;
    fracinv[2]=(float)fracinv_hitec.val;
    fracinv[1]=1f-(fracinv[2]+fracinv[0]);
}
 
public void calcstep() {
    regloop: for (region r : regs) {
        if (!rd.get(r).started) { 
            if  (!datagdp.gotdata(r, year) || datagdp.get(r, year)==0) continue regloop; 
            rd.get(r).started=true;
            capinit(r, year);
        }
        else {
        capital(r);
        }
        product(r);
    }    
}

//problem when countries join a group not all at once (eg east-europe) they don't get the initial capital!
void capinit(region r, int y) {
        float gdpinit=datagdp.get(r,y), capt=0;
        //deb(r.name+" "+year+" "+gdpinit);
        for (int c=0; c<nc; c++)  { cap[c].set(r, y, gdpinit*capinit[c]); capt+=cap[c].get(r,y); }
        captot.set(r,y, capt );
}


void capital(region r) {
    regdat d= rd.get(r);
    
    if (year<=weo_ey) {
        if (year<=pwt_ey) d.sav = sumreg(PWT_inv, PWT_RGDPO, r, year); 
        else  d.sav = sumreg(WEOinvest, WEOGDP_PPP, r, year)/100f; 
        if (Float.isNaN(d.sav) || d.sav==0) d.sav=0.4f; //1980-92 for FSU, EEU - note higher than avg, but typical for communist
    }
    else {
        //this 0.5 and 0.4 come from scatteplot - should replace stat regression and link to param
        float sav_target= dr_sav_fb.istrue()? 0.5f-0.4f*deprat.get(r) : (float)savings_lim.val; //longterm savings lower if high dependency ratio
        d.sav+=0.1f*(sav_target-d.sav);
    }
    
    //could also use WEO invest after 1980 - try as a param   
    savings.set(r, d.sav);
    float invest=gdp_mod.get(r, year-1)*d.sav, capt=0;
    for (int c=0; c<nc; c++) { cap[c].set(r, year, cap[c].get(r, year-1)*(1f-deprec[c])+invest*fracinv[c]); capt+=cap[c].get(r,year); }
    captot.set(r,year, capt );
}

void product(region r) {
    regdat d= rd.get(r);
    float lrt=20;
    if (year==pwt_ey) d.lab_reg=reglin(laborshare, r, pwt_ey-(int)lrt, pwt_ey);
    if (year<=pwt_ey) d.labsh = sumreg(PWT_labsh, PWT_pop, r, year); 
    else if (year<=pwt_ey+lrt) d.labsh+=d.lab_reg[0]*(lrt+pwt_ey-year)/lrt+0.02f*(0.6f-d.labsh)*(year-pwt_ey)/lrt;    
    else d.labsh+=0.02f*(0.6f-d.labsh); 
    if (Float.isNaN(d.labsh) || d.labsh==0) d.labsh=0.6f; //1980-92 for FSU, EEU
    if (constantalpha.istrue()) d.labsh=0.6f;
    laborshare.set(r, d.labsh);
    
    float hrt=20;
    if (year==pwt_ey) d.hum_reg=reglin(humcap, r, pwt_ey-(int)lrt, pwt_ey);
    if (year<=pwt_ey) d.humc = sumreg(PWT_hc, PWT_pop, r, year); 
    else if (year<=pwt_ey+hrt) d.humc+=d.hum_reg[0]*(hrt+pwt_ey-year)/hrt+0.01f*((float)humcap_lim.val-d.humc)*(year-pwt_ey)/hrt;    
    else d.humc+=0.01f*((float)humcap_lim.val-d.humc); 
    if (Float.isNaN(d.humc) || d.humc==0) d.humc=2.5f; //1980-92 for FSU, EEU
    humcap.set(r, d.humc);
    
    float lab=workpop.get(r);
    //deb("lab: "+year+" "+r.name+" "+lab);
    float product= (float) ( Math.pow(d.humc*lab, d.labsh) * Math.pow(captot.get(r), (1f-d.labsh)) );
    
    float trt=25;
    if (year==weo_ey) { 
        d.tfp_reg=reglin(tfp, r, weo_ey-(int)trt, weo_ey);
        //d.tfp_histav=0; for (int y=weo_ey-5; y<weo_ey; y++ ) d.tfp_histav+=tfp.get(r,y); d.tfp_histav/=5f;
        //d.tfp_trend=0; for (int y=weo_ey-25; y<weo_ey-20; y++) d.tfp_trend+=tfp.get(r,y); d.tfp_trend= (d.tfp_histav-d.tfp_trend/5f)/20f; ; 
        }
    
    float tfp_target=(9f/8f)*(float)tfp_lim2300.val*(year-1900)/(year-1850); //gradually increasing target - the only very-long-term growth in gdp/capita
    if (forcehist.istrue()) {
        if (year<=pwt_ey) d.tfp_mod=datagdp.get(r)/product;
        else if (year<=weo_ey) d.tfp_mod=datagdp.get(r)/product; //should get weo data until 2019
        else if (year<=weo_ey+trt) d.tfp_mod+=d.tfp_reg[0]*(trt+weo_ey-year)/trt+0.015f*(tfp_target-d.tfp_mod)*(year-weo_ey)/trt;    
            //year*d.tfp_reg[0]+d.tfp_reg[1];
            //d.tfp_mod+=0.2f*((d.tfp_histav+(3+year-weo_ey)*d.tfp_trend)-d.tfp_mod); //for first >20yrs future converge to hist trend of last 20 yrs
        else d.tfp_mod+=0.015f*(tfp_target-d.tfp_mod); 
    }
    else     d.tfp_mod=tfp_target; //use target from start
    
    tfp.set(r, d.tfp_mod);
    gdp_mod.set(r, product*d.tfp_mod);
    
}



float sumreg(curveset source, curveset weight, region reg, int y) {
    float tot=0, totw=0, w=0, d=0;
    for (region r : reg.subreg(source)) {
        if (weight.gotdata(r, y)) { 
            w=weight.get(r,y); 
            if (source.gotdata(r, y)) { d= source.get(r,y); tot+=d*w; totw+=w; }
        }
    }
    if (Float.isNaN(tot) || Float.isNaN(totw) || totw==0) return Float.NaN;
    return tot/totw;
}


}//end class
