

package jcm.mod.socio;

import java.util.*;

import jcm.mod.obj.regset;
import jcm.mod.socio.migration.migopts;
import jcm.core.data.interpolator;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.*;
import jcm.core.complexity;
import jcm.core.tls.fileio;
import jcm.mod.math.regress;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static java.lang.Math.*;
import static jcm.mod.scen.sresdata.*;
import static jcm.mod.socio.demog.fertopts.*;

//should separate a hist section implements dataholder?
public class demog extends module {

    
public curveset //
        wppmed=new curveset("wpp_med_pop", "kilo&person", 1950, 2100, 5),
        modpop=new curveset("model_pop", "kilo&person", 1950, gey, 5), 
        modpop_nat=new curveset("model_pop_nat", "kilo&person", 1950, gey, 5),
        enpop=new curveset("energy_pop", "kilo&person", 1950, gey, 5),
        netmig=new curveset("net migration", "kilo&person&per&year", 1953, 2098, 5), 
        tfr=new curveset("total fertility rate", "births&per&woman", 1953, gey, 5), 
        workpop=new curveset("workage_pop", "kilo&person", 1950, gey, 5),
        deprat=new curveset("dependency ratio", "", 1950, gey, 5),
        ov60survrate =new curveset("over-60 survival rate", "", 1950, gey, 5),
        pyramid=new curveset("pyramid", "kilo&person", 0, 100, 5); 
        

public enum fertopts {WPP_only, gdppercap_by2100, gdppercap_instant } // blend }
public enum migsources {no_migration, migflows, wpp }
	//low_scen, mid_scen, high_scen, extrapolate, economic }
 

//public param migration = new param("migration", true);
public param fertility = new param("fertility factor", "%", 100, 75, 125);
public param<fertopts> future_fertility = new param("fertility", fertopts.values(), gdppercap_by2100, normal); 
public param<migsources> migsource=new param("source migration", migsources.values(), migsources.migflows);
public param normpy = new param("normalise pyramid", false);
public param pyramidyear= new param("year for pyramid", "%", 2010, 1950, gey);

//basic data for population pyramid, data in thousands
//1 for female, 0 for male
//could this be int instead float?    
Map<region, float[][]> snappy=new HashMap(); //snapshot of pyramid - M/F and 21 5yr-age groups (0-100) 
static Map<region, float[][][]> datapy=new HashMap(); //from wpp data - M/F covering 31 periods from 1950 to 2100
static Map<region, float[][]> bir=new HashMap(); //from wpp data - Births per kwoman (7 groups age 15-50) and immigration - for mid of following period
static Map<region, float[]> mig=new HashMap(); //from wpp data - migration


static float[][] migfrac= {{6,4,2,10, 16,20,16,10, 6,6,5,5, 4,3,2,1, 0,0,0,0,0 }, {6,4,2,8, 12,16,14,9, 5,5,5,5, 4,3,2,1, 0,0,0,0,0 }}; //relative likelihood of migration, M/F per 5yr age group
static float[] enfac={1,2,3,4, 5,5,6,6, 7,7,8,8, 7,6,5,5, 4,4,3,3,3 }; //relative energy use per 5yr age group
static float totmig=0, totef=0;

boolean done=false;
List<region> natset=new ArrayList(); 
List<region> regset;
Map<region, List<region>> regmap=new HashMap();
float[] fertreg_gdp=null; 
Map<region, float[]> fertreg=new HashMap();
Map<region, Float> fertfacadj=new HashMap();


public void initsetup() {
    if (!done) fillhistdata(); done =true;
    setregs();
    setaffectedby(gm(regset.class).regions); //should split into history and future as for popgdp
    setaffectedby(gm(economy.class));
    follows(gm(migration.class));
}

public void setinteractions() {

}



public void precalc() { 
    regset = ((region) gm(regset.class).regions.chosen).reg;
    gm(regset.class).clearoldregions(this);
    //Set<region> checknatinc=new HashSet();
    for (region r : regset) { List<region> rl=new ArrayList(); for (region nr : natset) { 
        if (r.contains(nr)) {rl.add(nr); /*checknatinc.add(nr);*/} 
    } regmap.put(r, rl); }
    //for jcm25 this check only finds cyprus and malta missing
    //for (region r : natset) if (!checknatinc.contains(r)) deb("\n!!! --- not included: "+r.getName()+"\n\n" );
    
    fillwpp(); // filling wppmed should never be repeated if nothing changes - maybe regions...?
    initsnap();
    for (region r : regset) fertfacadj.put(r,1f);
    
}

public void calcstep() {
    if (year==1950) shiftmod(1950);
    //note regression maybe slow - should split loopcalc hist and future so don't redo unless history changes
    if (year==2013) regressfertility(); //note econ calc after pop in loop so apply in 2013 to 2012 data (actually 2010)
    if (year % 5 ==0) shiftmod(year+5); //calc for 5yrs in advance, so that other modules which depend on result can interpolate forwards 
    if (year % 5 ==0 && year>2013) adjustfertility(year+5); 
    if ((year+5) == (int)(pyramidyear.val) ) fillpyramid();
}

void setregs() {
    //put the regions in the right order
    for (region r : regman.nations.reg) if (datapy.keySet().contains(r)) natset.add(r); 
}

//!! should shift enpop and netmig to be based on modpop not wpp
void fillwpp() {
    totef=0; for (int g=0; g<21; g++) totef+=enfac[g];  //should normalise so that total in 2010 is same? - but it is anyway, very close
    for (region r : regset) {
    for (int y=0; y<31; y++) {
        int yr=1950+y*5; 
        float wppmedtot=0;     
        for (region rn : regmap.get(r)) {
        float[][] p = datapy.get(rn)[y];    
            float tot=0;
            for (int g=0; g<21; g++) {
                    tot+=p[0][g]+p[1][g];
                }
                wppmedtot+=tot;
            } //rn
            wppmed.set(r, yr, wppmedtot);
    } //y
    } //r
}

void initsnap() {
    for (region reg : natset) {
        float[][] py=snappy.get(reg);
        if (py==null) {py=new float[2][21]; snappy.put(reg, py);}
    
    for (int g=0;g<21; g++) { py[0][g]=datapy.get(reg)[0][0][g]; py[1][g]=datapy.get(reg)[0][1][g]; }     
    }
    totmig=0; for (int x=0;x<2;x++) for (int g=0; g<21; g++) totmig+=migfrac[x][g];
    
}

void shiftmod(int yy) {
    int yi=(yy-1950)/5; if (yi>30) yi=30; 
    float[] totbir=new float[7], totwom=new float[7]; //to calculate ASFR => TFR
    float fertfacparam=(float)(yy > 2010 ? fertility.getval()/100f : 1f);
    
    boolean migrate=(migsource.chosen!=migsources.no_migration || yy<2010);
    for (region r : regset) {
        float totreg=0, mi=0, enpoptot=0,  netmigtot=0, totdep=0, totwork=0, asfr, wom, ov60surv=0, ov60all=0, survadjfac, saf2100 ;
        saf2100=ov60survrate.get(r,2100);
        survadjfac= (yy<=2100) ? 1f : (yy<2200) ? ((yy-2100)*0.9f + (2200-yy)*saf2100 ) /(100f*saf2100) : 0.9f/saf2100 ;
        for (int g=0; g<7; g++) { totbir[g]=0; totwom[g]=0;}           

        for (region rn : regmap.get(r)) {
        float[][] p=snappy.get(rn);
        if (yi>0) {    
            float[][] d=datapy.get(rn)[yi], d0=datapy.get(rn)[yi-1];
            float[] b=bir.get(rn)[yi-1]; 
            
            //below inefficent - also why not use abel b4 2010?
            if (migsource.chosen==migsources.migflows) mi=gm(migration.class).netmig.get(rn, yy)*5f; //for five-yr cohort  
            if (migsource.chosen==migsources.no_migration) mi=0; 
            if (migsource.chosen==migsources.wpp || yy<2010) mi=mig.get(rn)[yi-1];  
             
 
            //note - in this section p starts representing previous period y-1, but shifts to next during the g countdown
            //calc births acc to women (but put in p later - after previous infants grow up) 
            float borng=0, born=0, dborn=0;
            for (int g=0; g<7; g++) {
                //maybe to get tfr more accurate, need to consider avg num women, not num who enter that period...
                //only makes big difference for countries with high mortality of young women
                //but in general - experiments show need more careful consideration of the 'calculus' with 5yr groups
                dborn+=b[g]; asfr=b[g]/d0[1][g+3]; wom=p[1][g+3] /*(p[1][g+3]+p[1][g+4])/2f*/; 
                
                borng=asfr*wom*fertfacparam*fertfacadj.get(r);  
                born+=borng; 
                totbir[g]+=borng; totwom[g]+=wom; //sum over subreg for calc tfr later
            }
            
            for (int x=0;x<2;x++) { //M/F
                for (int g=20; g>0; g--) { 
                    //prior to 1990 (yi=8), no data above 80year old (g=17)
                    float immigrate=mi*migfrac[x][g]/totmig;
                    float survive= (g< 18 || yi>8) ? (d[x][g]-immigrate)/d0[x][g-1] : (yi==8 && g>17) ? (d[x][g]-immigrate)/d[x][g-1] : 0;
                    if (Float.isNaN(survive)) survive=0;
                    survive*=survadjfac; if (survive>1f) survive=1f;
                    if (g>=12) { ov60surv+=p[x][g-1]*survive; ov60all+=p[x][g-1];}
                    p[x][g] =p[x][g-1]* survive;
                }
                
                p[x][0]=born * d[x][0]/dborn; //to get sex ratio at birth, and take into account infant mortality (gives survivors at end of 5yr period)
                //note 'pure' sex ratio at birth typically 1.06m, but selective...
            } //mf
                //tried assume migration equal spread M/F over 15-44 yrs (temp fix) => overincrease popn immigrn countries
                //try with migfrac skewed a bit to (younger) men
                //check observe spikes eg bangladesh 1970 - the data (read correctly - checked) shows 3.0 million 
                //aha problem is that "survive" above is calculated without compensating for migration

            if (migrate) for (int x=0;x<2;x++) for (int g=0; g<21; g++) p[x][g]+= mi*migfrac[x][g]/totmig; 
            //for (int x=0;x<2;x++) for (int g=0; g<21; g++) p[x][g]=d[x][g]; //temp fix to force fit data to test tfr etc
        } //yi>0
            float tot=0, etot=0, dep=0, work=0;
            for (int x=0;x<2;x++) for (int g=0; g<21; g++) { tot+=p[x][g];  etot+=p[x][g]*enfac[g]; if(g<3 || g>12) dep+=p[x][g]; else work+=p[x][g]; }
            totreg+=tot;
            enpoptot+= etot*21f/totef;
            totdep+=dep; totwork+=work;
            //note - at the moment mig is fixed => no dependence on model params - but leave it here as likely add later
            netmigtot+=mi/5f; //divide five because graph implies annual flows, and data is for middle of period

            modpop_nat.set(rn, yy,tot);
        } //natreg
        
        ov60survrate.set(r, yy, ov60surv/ov60all);
        modpop.set(r, yy, totreg);
        enpop.set(r, yy, enpoptot);
        workpop.set(r, yy, totwork);
        deprat.set(r, yy, totdep/totwork);
        if (yi>0) { //year-2 because mi is the netmig from previous five years
            netmig.set(r, yy-2, netmigtot);
            //tfr is sum of age-specific fertility rates - need to add up over fertile ages, outside the subregion loop
            float rtfr=0; for (int g=0; g<7; g++) { rtfr+=(totbir[g]/totwom[g]); } 
            tfr.set(r, yy-2, rtfr);
        } 

    } //reg
}

void fillpyramid() {
    float[][] pop=new float[2][21];
    for (region r : regset) {
        infob f= new infob(r.name+" Wom", r.color), m = new infob(r.name+" Men", r.color);
        float tot=0;
        for (int g=0; g<21; g++) {pop[0][g]=0; pop[1][g]=0; }
        for (region rn : regmap.get(r)) {
        float[][] p=snappy.get(rn);    
            for (int g=0; g<21; g++) { pop[0][g]+=p[0][g];  pop[1][g]+=p[1][g]; tot+=p[0][g]+p[1][g]; }  
        }
    float nf= (normpy.istrue() ? 10000000f/tot : 1f);    
    for (int g=0; g<21; g++) { pyramid.set(f, g*5, pop[1][g]*nf/5f);pyramid.set(m, g*5, -pop[0][g]*nf/5f); }    //divide 5 so it shows the pop per year
    }    
}

void regressfertility() {
    //note: start global regression from 1970, after contraceptives become available
    //note result will depend on region set, with all regions equally weighted, => use balanced set better than nations 
    fertreg_gdp=regress.reglin(gm(economy.class).gdp_percap, tfr, null, 1970, 2010, true, true);
    //deb("\n Fertility regression"+fertreg_gdp[0]+" "+fertreg_gdp[1]); 
    for (region r : regset) { //regional shorterm trend
        fertreg.put(r, regress.reglin(tfr, r, 2000, 2010));    
        fertfacadj.put(r,1f);
    }
}

void adjustfertility(int yy) {
    for (region r : regset) { 
        //use old gdp_percap as econ follows popu in loop - note yy= year+5 
        float target=(float)Math.exp(fertreg_gdp[0]*(float)Math.log(gm(economy.class).gdp_percap.get(r, yy-6))+fertreg_gdp[1]);
        //float trend=fertreg.get(r)[0]*(yy-5)+fertreg.get(r)[1];
        float current=tfr.get(r,yy-2); //halfway previous period = the last calc
        float adj=fertfacadj.get(r), oldf=current/adj; 
        if (future_fertility.chosen==WPP_only) { //converge gradually after 2100 - as no more data 
            if (yy<=2100) adj=1f;
            if (yy>2100 && yy<2150)  adj=((yy-2100)/50f)*1.95f/oldf + (2150-yy)/50f; 
            if (yy>2150) adj= 1.95f/oldf; 
            //if (yy>2100 && current>2) deb("fertadj "+yy+" "+r.name+" "+adj+" "+current);
        }
        if (future_fertility.chosen==gdppercap_by2100) {
            float frac=yy<2100 ? (yy-2010)/90f : 1f;
            adj= frac*target/oldf+ (1f-frac);
        }
        if (future_fertility.chosen==gdppercap_instant) {
            adj=target/oldf;
        }
        
        /*
        if (future_fertility.chosen==blend) adj= 0.2f*target/oldf+ 0.8f;
        //implies converge 20% towards target per five years
        */
        
        fertfacadj.put(r,adj);    
    }
}


static void fillhistdata() {
	try {
	String filename="data/pop/wpp12_popquin.csv";
	String[][] tab=fileio.loadtab(filename, ","); 
        //consider whether this is efficient for such big table?? - maybe better process as go along, not keep so many String objects
	
	int nreg=(tab.length-2)/31, ri=2, r;
	for (int i=0; i<nreg; i++) {
            region reg=regman.allreg.findreg(tab[ri][0]);
            float[][][] py = new float[31][2][21]; float[][] b = new float[31][7]; float[] m = new float[31];
            datapy.put(reg,py); 
            bir.put(reg, b); 
            mig.put(reg, m);
            for (int yi=0; yi<31; yi++ ) {
                r=ri+yi;
                for(int g=0; g<21; g++) {
                    py[yi][0][g]=Float.valueOf(tab[r][g+3])/10f;
                    py[yi][1][g]=Float.valueOf(tab[r][g+25])/10f;
                }
                for(int g=0; g<7; g++) b[yi][g]= Float.valueOf(tab[r][g+47])/10f;
                m[yi]=Float.valueOf(tab[r][55])/10f;
            } 
            ri+=31;
        } //reg
        } catch (Exception e) { e.printStackTrace(); }
    } //fill histdata
    
} //class
