    /*
Abatement (mitigation) and damage (or adaptation?) costs
Experimental!  Developed with Clim-Neg II project Louvain-la-neuve 2002-2005
Please note, the author of JCM does not trust these simple formulae!
 See todo/sci/costs.todo
    */
   
package jcm.mod.socio;


import java.util.*;

import jcm.core.par.*;
import jcm.core.cur.*;
import jcm.core.data.interpolator;
import jcm.core.ob.*;
import jcm.core.reg.*;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.regemit.*;
import jcm.mod.scen.sresBase;
import jcm.mod.scen.sresdata;
import jcm.mod.obj.*;
import static jcm.core.report.*;
import static jcm.core.complexity.*;

public class costs extends module {    
    
    public void initsetup() {
        eq = gm(emitquota.class);
        follows(eq.regfuture);
        follows(gm(glotemp.class));
        //		follows(sealevel);
        affectsfutureonly = true; //check?  not for initial impacts costs, but irrelevant to optim etc.
    }

    public void setinteractions() {
        setaffects(prtp, constdisc.istrue());
        setaffects(effdisc2000, !constdisc.istrue());
        setaffectedby(prtp, useprtp.istrue());
        setaffectedby(backstop, usebackstop.istrue());
        setaffectedby(scaleabate, abatefunc.chosen.equals("macgem"));
        setaffectedby(abatepow, abatefunc.chosen.equals("rice99"));
        setaffectedby(damagepow, impfunc.chosen.equals("cws"));
    }
    public curveset //
            abatecost = new curveset("abatecost", "mega&dollar&per&year"), //
             damagecost = new curveset("damagecost", "mega&dollar&per&year"), //
             totalcost = new curveset("totalcost", "mega&dollar&per&year"), //
             abatewelch = new curveset("abatewelch", "mega&dollar&per&year"), //
             damagewelch = new curveset("damagewelch", "mega&dollar&per&year"), //
             totalwelch = new curveset("totalwelch", "mega&dollar&per&year"), //
             reducedgdp = new curveset("reducedgdp", "mega&dollar&per&year"), //
             origwelf = new curveset("welfare no-cli", expert);//
    //
    public param prtp = new param("pure rate time pref", "%", 1.5, 0, 6), //set to 1.72 makes effective discount rate =3 at 2000 with ineqav=1
             ineqav = new param("inequality-aversion", "", 1.0, 0, 2), //
             effdisc2000 = new param("effdisc2000", "%", 2.78, 0, 6), //
             constdisc = new param("fix-effdisc2000", false), //
             useprtp = new param("useprtp", true, expert), //
             abatefunc= new param("abatefunc", new String[]{"macgem", "rice99"}, "macgem", expert), //add others
             impfunc = new param("impfunc", new String[]{"cws", "rice99"}, "rice99", expert), //add others
             incch4 = new param("incch4", false, experimental), // P3 CH4 cost too low - should there be an extra 1000 since refactoring?
             dyngdp = new param("dyngdp", true, expert), //
             usebackstop = new param("usebackstop", false, expert), //
             backstop = new param("backstop", "$&per&ton", 500, 0, 1000, expert), //
             scaleabate = new param("scaledown abatement", "", 1.0, 0, 1, expert), //changed default from 0.33 to 1.0  jan09 - safer initial run with optimiser - this was a param to take into account some learning by doing
             abatepow = new param("abatepow", "", 2.887, 0, 6, expert), // 
             abatelin = new param("abatelin", "", 1, 0, 3, expert), //
             damagepow = new param("damagecostpow", "", 1.5, 0, 6, expert), // 
             damagelin = new param("damagelin", "", 1, 0, 3, expert); //
    ;
    //***************************************************
    //for objective functions
    public float base,  idw,  iaw,  iac,  itw,  iow,  cumprtp,  gtc,  igwp,  scaledownfac;
    boolean firsttime = true;
    List<region> regions;
    Map<region, Float> a1, b1, th1, th2, macgema, macgemb;
    emitquota eq;
    popgdp soc;
  
    //***************************************************
    public void precalc() {
        soc= gm(popgdp.class);
        if (!firsttime) adjdisc();
        for (curveset qq : curvesets) gm(regset.class).clearoldregions(qq);
        regions = ((region) (gm(regset.class).regions.chosen)).reg;
        curveset histpop=histsocdata.histpop;
        
        a1 = interpolatefac(a1_jcm12, "JCM12", histpop);
        b1 = interpolatefac(b1_jcm12, "JCM12", histpop);
        th1 = interpolatefac(th1_jcm12, "JCM12", histpop);
        th2 = interpolatefac(th2_jcm12, "JCM12", histpop);
        macgema = interpolatefac(macgema_jcm12, "JCM12", histpop);
        macgemb = interpolatefac(macgemb_jcm12, "JCM12", histpop);
    }

    public void postcalc() {
        if (firsttime) adjdisc();
//		if(scaleimcp.istrue()) scaledown();
    }
    //	debug("welfarechange: total, damage, abate :, "+(int) itw+", "+(int)idw+ ", "+(int)iaw);
    public void reportcosts() {
        log("emit2050fos, emit2050tot, conc, temp2150, iaw, idw,  =" + gm(carboncycle.class).fossil.get(2050) + "\t" + gm(carboncycle.class).totemit.get(2050) + "\t" + gm(carboncycle.class).co2atppm.get(2200) + "\t" + gm(glotemp.class).avchangeby.get(2150) + "\t" + iaw + "\t" + idw);
    }

    /*****************************************
     * ADJUST DISCOUNT
     * Either fix discount rate 2000 or prtp, the other will change depening on ineqav
     * Note: this only works after first socreg calcstep! Hence firsttime flag;
     *
     * old method: adjust prtp by dweight/dt at 2000 to keep effective discount rate constant
     * prtp.setval( prtp.getval() - 100f*(ineqav.getval()-oldineqav)*dgpcdt );
     * //double  oldineqav=-1; //initial flag -1 prevents running this before initial socreg. calcstep
     */
    void adjdisc() {
        float dgpcdt = ((soc.gdp_ppp.get(regman.world, 2000) / soc.pop.get(regman.world, 2000)) / (soc.gdp_ppp.get(regman.world, 1990) / soc.pop.get(regman.world, 1990)) - 1f) / 10f;
//		System.err.println("dgpcdt="+dgpcdt);
        firsttime = false;
        if (constdisc.istrue()) {
            prtp.putval(effdisc2000.getval() - 100f * dgpcdt * ineqav.getval());
            prtp.changed = true;
        } else {
            effdisc2000.putval(prtp.getval() + 100f * dgpcdt * ineqav.getval());
            effdisc2000.changed = true;
        }
    }
    //***********************************************************
    public void calcstep() {
        if (year >= fsyfos) {
            if (year == fsyfos) ewbase();
            if (year == fsyfos) {
                cumprtp = 1f;
                iaw = 0;
                idw = 0;
                itw = 0;
                iow = 0;
                gtc = 0;
                iac = 0;
                igwp = 0;
            }
            if (year > fsyfos && useprtp.istrue()) cumprtp *= (1f - prtp.getval() / 100f);

            for (region r : regions) {
                float weight = ew(r);
                damagecost.set(r, dc(r));
                abatecost.set(r, ac(r));
                totalcost.set(r, damagecost.get(r) + abatecost.get(r));
                reducedgdp.set(r, soc.gdp_ppp.get(r) - totalcost.get(r));
                origwelf.set(r, soc.gdp_ppp.get(r) * weight * cumprtp);
                damagewelch.set(r, damagecost.get(r) * weight * cumprtp);
                abatewelch.set(r, abatecost.get(r) * weight * cumprtp);
                totalwelch.set(r, abatewelch.get(r) + damagewelch.get(r));
                iaw += abatewelch.get(r);
                idw += damagewelch.get(r);
                itw += totalwelch.get(r);
                iow += origwelf.get(r);

                iac += abatecost.get(r) * cumprtp;
                igwp += soc.gdp_ppp.get(r) * cumprtp;
                if (year <= 2100) gtc += eq.emitfosabate.get(r) * 0.001f;
            } //nr
            for (curveset qq : curvesets) qq.calctot();

            if (year == 2100) {
                scaledownfac = 0.0007f * gtc / (100f * iaw / iow);
            //deb(" gtc="+gtc+" \t\t awelfloss= "+100f*iaw/iow+"% \t\t gwploss= " + 100f*iac/igwp+  " \t\t scaledown= "+scaledownfac);
            }

        } //if
    } //end calcstep
    //************************************************
    /*start by scaling to 0.7% per 1000GtC
    but cannot optimise unless have a curve, so marginal is increasing
    problem is that scaledownfac decreases (effect increases) as make more abatement => marginal costs decrease!
      => method not currently used
     */

    public void scaledown() { //not very efficient!
        scaledownfac = 0.0007f * gtc / (100f * iaw / iow);
        deb(" gtc=" + gtc + " \t\t gwploss= " + 100f * iaw / iow + "% /t/t scaledown= " + scaledownfac);
        iaw *= scaledownfac;
        itw = iaw + idw;
        for (int y = fsyfos; y <= gey; y++) for (region r : regions) {
                abatecost.set(r, y, abatecost.get(r, y) * scaledownfac);
                abatewelch.set(r, y, abatewelch.get(r, y) * scaledownfac);

                totalcost.set(r, y, damagecost.get(r, y) + abatecost.get(r, y));
                reducedgdp.set(r, y, soc.gdp_ppp.get(r, y) - totalcost.get(r, y));
                totalwelch.set(r, y, abatewelch.get(r, y) + damagewelch.get(r, y));
            }
    }

    public int nr(region r) {
        return regions.indexOf(r);
    }
    //temporary fix - rather inefficient
    public float beta(region r) {
        return (float) (abatefunc.chosen.equals("macgem") ? (1f + scaleabate.getval() * (macgemb.get(r) - 1f)) : abatepow.getval());
    }

    public float gdp(region r) {
        
        if (dyngdp.istrue() && year > fsyfos) return soc.gdp_ppp.get(r) * reducedgdp.get(r, year - 1) / soc.gdp_ppp.get(r, year - 1);
        else return soc.gdp_ppp.get(r);
    }

    public float alpha(region r) {
        return (float) (abatelin.getval() * 
                (abatefunc.chosen.equals("macgem") ? //
                1000f * macgema.get(r) * scaleabate.getval() / Math.pow(1000f, beta(r)) // first 1000 to convert gigadollar to megadollar, second to compensate for emit in megaton
                : gdp(r) * b1.get(r) / Math.pow(gm(emitbase.class).emitfosbase.get(r), beta(r)) //
                ));
    }

    public float ac(region r) {
        
        if (eq.emitfos.get(r) < 0) return Float.MAX_VALUE;
        float ac = (eq.emitfosabate.get(r) > 0) ? (float) (alpha(r) * Math.pow(eq.emitfosabate.get(r), beta(r))) : 0;
        if (usebackstop.istrue() && ac / eq.emitfosabate.get(r) > (float) backstop.getval()) ac = (float) backstop.getval() * eq.emitfosabate.get(r);

        if (incch4.istrue()) {
            //note - inefficient - should calculcate global func outside region loop
            //cost functions from Aaheim04 - but something wrong with power exponents!
            //			float ch4cost=(float)Math.pow(sres.interp(sres.ch4emit, year)*(1f-scale) / 61.18f , (1f/0.23f) ) * 1000f;
            //			float n2ocost=(float)Math.pow(sres.interp(sres.n2oemit, year)*(1f-scale) / 0.46f , (1f/0.12f) ) * 1000f;
            float scale = gm(carboncycle.class).fossil.get(year) / (1000f * interpolator.sresinterp(sresdata.fosemit, gm(sresBase.class).sci, year));
            //from curve in Chesnaye
            //get global cost of CH4 reduction
            float ch4red = interpolator.sresinterp(sresdata.ch4emit, gm(sresBase.class).sci, year) * (1f - scale) - 22; //first 22 are free
            if (ch4red < 0) ch4red = 0; 
            float ch4cost = 0.003f * ch4red * ch4red + 0.0002f * ch4red * ch4red * ch4red;
            //multiply by fraction of the total - this is assuming a proportional reduction based on 1990 emissions
            ac += ch4cost * eq.emitch4.get(r, 1990) / eq.emitch4.calctot(1990);
        //			ac+=n2ocost*get(regemit.class).emitn2o[nr(r)][1990-gsy]/calctot(get(regemit.class).emitn2o , 1990);
            //deb("reg="+r+ " scale="+scale +" ch4red="+ch4red);
        }

        return ac;
    }

    public float mac(region r) {
        return mac(r, module.year);
    }

    public float mac(region r, int year) {	//year-1 used by get(eq.class)
        return (float) (beta(r) * alpha(r) * Math.pow(eq.emitfosabate.get(r, year - 1), beta(r) - 1f));
    }

    public float dc(region r) {
        if (impfunc.chosen == "cws") return (float) (gdp(r) * damagelin.getval() * a1.get(r) * Math.pow(gm(glotemp.class).avchange.get(year) / 2.5, damagepow.getval()));
        if (impfunc.chosen == "rice99") {
            float dt = gm(glotemp.class).avchange.get(year) - gm(glotemp.class).avchange.get(1990), df = (float) (th1.get(r) * dt + th2.get(r) * dt * dt);
            return gdp(r) * (float) damagelin.getval() * (df / 1f + df);
        }
        return 0;
    }

    public float ew(region r) {
        return ew(r, module.year);
    }

    public float ew(region r, int year) { //year-1 used by get(eq.class)
        //		if (welfarelog.istrue()) return (1f / gdp(nr));  this needs more thought!
        return (float) Math.pow((soc.pop.get(r) / gdp(r)) * base, ineqav.getval());
    }

    void ewbase() {
        if (dyngdp.istrue()) {
            base = 0;
            for (region r : regions) base += gdp(r);
            base /=soc.pop.get(regman.world);
        } else base = soc.gdp_ppp.get(regman.world) / soc.pop.get(regman.world);
    //if apply weights over time, keep the base from 2000, otherwise recalc each year
    }

    Map<region, Float> interpolatefac(double[] source, String sourcesetname, curveset weights) {
        int year = 2002; //for the moment use weights only from 2002
        Map<region, Float> dest = new HashMap();
        List<region> sourceset = regman.allreg.findreg(sourcesetname).reg;

        for (region r : regions) {
            float sumfac = 0, sumweight = 0;
            Set<region> regnat = r.subreg(regman.nations);
            for (region sr : sourceset) {
                int ri = sourceset.indexOf(sr);
                for (region nat : sr.subreg(regman.nations)) if (regnat.contains(nat)) {
//			    System.err.println(r+" "+sr+" "+nat+" "+source[ri]+" "+weights.get(nat, year));
                        sumfac += source[ri] * weights.get(nat, year);
                        sumweight += weights.get(nat, year);
                    }
            }
            dest.put(r, sumfac / sumweight);
//		    System.err.println(source+" "+r+" "+sumfac/sumweight);
        }
        return dest;
    }
  //***************************************************
    //these functions have been interpolated to fit JCM12 regions
    //nordhaus abate cost b1 b1*GDP*frac abatement^b2 -see climnegWP19
    static double[] b1_jcm12 = {0.07, 0.07, 0.05, 0.05, 0.10, 0.15, 0.10, 0.15, 0.10, 0.10, 0.10, 0.10}, //note b2 = 2.887 for all regions
            //nordhaus damagecost cost a1*GDP*(DT/2.5)^a2
             a1_jcm12 = {0.01102, 0.01102, 0.01174, 0.01174, 0.01000, 0.00857, 0.02093, 0.01523, 0.02903, 0.02903, 0.02903, 0.02903}, //
            //note climnegWP19 has 0.015523 for China
            //note a2=1.5 (default), raised to 2.0 in some climneg papers
            //functions from Nordhaus99:
             th1_jcm12 = {-0.0026, -0.0070, -0.0070, -0.0010, -0.0076, -0.0076, 0.0039, -0.0041, 0.0022, 0.0039, 0.0100, 0.0100}, //
             th2_jcm12 = {0.0017, 0.0030, 0.0030, 0.0049, 0.0025, 0.0025, 0.0013, 0.0020, 0.0026, 0.0013, 0.0027, 0.0027}, //
            //johan paper abatement cost G$ =a*R^b R in GtC
             macgema_jcm12 = {373.612, 337, 290.224, 241.278, 694.559, 694.559, 269.217, 199.020, 523.793, 496.158, 500, 235.499}, //
             macgemb_jcm12 = {1.220, 1.372, 1.251, 1.426, 1.100, 1.100, 1.279, 1.634, 1.209, 1.180, 1.2, 1.846};
} //end costs


