 
package jcm.mod.scen;

import java.util.*; 

import jcm.core.cur.*;
import jcm.core.itf.dataholder;
import jcm.core.ob.*;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import static jcm.core.complexity.*;
import static  jcm.core.report.*;
import static jcm.mod.scen.sspData.gases.*;
 
  /* 
     usable, but still to fix:
     labels for some models and regions - due to uses in older modules
     plots should have consistent colors   
     plot scale should reset when change compare, but modules dont have link to plots - would need to add a flag in curveset and check it in lineplot
            *** or possibly just set the plot scale param affectedby this ? or use interactions to find them?
     plot title should change too - similar problem - otherwise better set it ssp-plot1 etc
     
    */
public class sspData extends module implements dataholder {

    public enum socio {GDP_PPP, POP_TOT, Urban_Fraction} 
    public enum gases {CO2_TOT, CO2_FFI, CO2_LUC, CO2_CCS, CO2_CCSBio, CH4_TOT, CH4_LUC, N2O_TOT, N2O_LUC, Fgas, CO, NOx, VOC, Sulfur, BC, OC }
     
    public enum regions  {ASIA,LAM, MAF, OECD, REF, World} //Note regions.txt specifies OECDSSP and REFSSP - due other earlier definitions
    public enum models {IMAGE, MESGLO, GCAM4, WITGLO, AIMCGE,  REMMAG  }  
    public enum ssps {SSP1, SSP2, SSP3, SSP4, SSP5}
    public enum rcps {RCP26, RCP34, RCP45, RCP60, RCP85, Ref}
    
    public enum types { models, ssps, rcps, gases, regions}
    public enum plots  {plot1, plot2, plot3, plot4} 
      
    static boolean gotsspdata=false;
    
    static Set<run> alldata = new HashSet();  
    
    //static Class[] types= { models.class , ssps.class , rcps.class, gases.class , regions.class  };
    
    public static List<region>  scenreg;
    
     //**************************************************
    
    public  void initsetup() {
        if (!gotsspdata) loadSSPData(); 
        scenreg=regman.allreg.findreg("SSP5").reg;
    }
    
    
    
    static void loadSSPData() {
        regions reg ; models mod; ssps ssp; rcps rcp;
        for (gases gas : gases.values()  ) { 
            String[][] tab=fileio.loadtab("data/ssp/"+gas.name()+".tab", "\t"); //row, column
            for (String[] row : tab) { 
                try {
                reg  =regions.valueOf(row[0]); 
                String[] s=row[1].replace("~", "-").split("-");
                mod=models.valueOf(s[0].trim().replace("/", ""));
                ssp=ssps.valueOf(s[1].trim());
                rcp=  rcps.valueOf(s[2].equals("Ref")? s[2] : "RCP"+s[2]);
                //deb(" "+sec+"-"+reg+"-"+mod+"-"+scen+"-"+rcp);
                 
                run r = find(mod,ssp,rcp); 
                if (r==null) { r=new run(mod,ssp,rcp); alldata.add(r); }
                float[] f= r.get(gas, reg );
                for (int i=0; i<11; i++) { //11 data values: 2005 + 2010-2100 
                    try {
                        f[i]=Float.parseFloat(row[i+2]);   
                    } catch (RuntimeException e) { f[i]=curve.dud;  } // ignore parser errors - dud => NaN
                } 
                } catch (IllegalArgumentException e)  { /*deb(e);*/ continue;} //will catch - skip  first two lines of each file 
            } 
        }
        //for (run r: alldata ) deb("got "+r.mod+" "+r.ssp+" "+r.rcp);  
    } //load 
    
    public static run find(models mod, ssps ssp, rcps rcp) {
        for (run r : alldata) {
            if (r.mod==mod && r.ssp==ssp && r.rcp==rcp) return r;
        }
        return null;
    }
    
    
    public static class run {
        run(models m , ssps s , rcps r ) {mod=m; ssp=s; rcp=r; }
        models mod; ssps ssp; rcps rcp;
        public float[][][] data=new float[gases.values().length][regions.values().length][11];
        public float[][] get(gases g) {  return data[g.ordinal()];  } 
        public float[] get(gases g, regions r) { return data[g.ordinal()][r.ordinal()];  } 
    }
    
 
    
 } //end class
    
   
