package jcm.mod.scen;

import static jcm.core.complexity.*;
import static jcm.core.report.deb;
import static jcm.mod.scen.sspData.gases.*;

import java.util.EnumSet;

import jcm.core.cur.curveset;
import jcm.core.ob.*;
import jcm.core.par.param;
import jcm.mod.scen.sspData.*;

public class sspChooser extends module {

	  
    public param<plots> chooplot = new param("applyto", plots.values(), plots.plot1);
    public param<types> compare = new param("compare", types.values(), types.regions);  
    
    public param<models> choomod = new param("iam_model", models.values(), models.IMAGE );        
    public param<ssps> choossp = new param("ssp", ssps.values(), ssps.SSP2 );        
    public param<rcps> choorcp  = new param("rcp",  rcps.values(), rcps.Ref  );    
    public param<gases> choogas  = new param("gas",  gases.values(), gases.CO2_TOT  );    
    public param<regions> chooreg  = new param("region", regions.values(), regions.World   );    
    
    param[] pp= { choomod, choossp, choorcp, choogas, chooreg };
     
    types lastvary=null;   

     public sspData.run chosenSSPrun; 
     gases gas; regions reg; models mod; ssps ssp; rcps rcp;
     
     public void initsetup() {
     	makecurves();
         chooplot.chosen=plots.plot1; //more intuitive on restart
         //setchoices(); setcurve(curvesets.get(chooplot.chosen.ordinal()));
     }
     
     
     public void setinteractions() {
    	 
     }
     
     public void precalc() { 
    	 setchoices();
         setcurve(curvesets.get(chooplot.chosen.ordinal()));
       //for (curveset c : curvesets) if (c.name.equals(chooplot.chosen.name()))  setcurve(c);
     }
     
    void setchoices() {
    	gas=choogas.chosen; reg=chooreg.chosen ; mod=choomod.chosen; ssp=choossp.chosen; rcp=choorcp.chosen;
         
         //select the run used by other modules
         //note - not all combis have data - else avoids crash elsewhere due to null pointer, but may give misleading results!!!
         run r =sspData.find(mod,ssp,rcp);
         if (r==null) deb ("No SSP data for "+mod+" "+ssp+" "+rcp+", continue using old run!");
         else chosenSSPrun=r;   
    }
     
    void makecurves() {
         for (plots p : plots.values()) {   
         curveset c = new curveset( p.name(), "units_to_fix", 2010, 2100, 10, expert );  
        //because module won't find  automatically, as not constant
        curvesets.add(c); addOb(c); c.owner=this;   c.setaffectedby(this); 
         }
    } 
       
       public String getunits (gases g) { 
           String s=  EnumSet.of(N2O_TOT, N2O_LUC).contains(g) ? "kilo&ton&" : "mega&ton&";
           String m= g ==Fgas ? "CO2eq" : g ==Sulfur ? "SO2" : g ==NOx ? "NO2" :   EnumSet.of(CO, VOC, BC, OC).contains(g) ? g.name() : g.name().substring(0, 3);
           return s+m+"&per&year";
       } 
    

       //note for a visible plot, this changes the data OK, but not the title shown in the tab
       void setcurve( curveset c) {
           try {
            
            Enum[] ch ={mod , ssp , rcp , gas , reg };
            types vary=compare.chosen;
     
            String name="";
            Enum[] set=null;
            for (Enum e : ch) { 
                if (vary.name().equals(e.getClass().getSimpleName()))  set=e.getClass().getEnumConstants();
                else name +="_"+e.name() ;
            }     
            
           name+=": "+vary.name() ;
           c.name=name;
           // if (lastvary !=vary )  also needed if change applyto-plot
            c.map.clear(); 
            c.units=getunits(gas);
           
           
           for ( Enum v : set) { //go through set of what's varying between curves
                for (int i=0; i<ch .length; i++) if (ch[i].getClass().equals(v.getClass())) ch[i]=v; 
               //deb(""+ch[0]+ch[1]+ch[2]+ch[3]+ch[4]);  
               run r =  sspData.find((models)ch[0],(ssps)ch[1],(rcps)ch[2]);
               if (r==null) { deb ("-no data");  continue;}
               float[] d=r.get((gases)ch[3], (regions)ch[4]);
               for (int i=1; i<11; i++) c.set(v, 2000+i*10, d[i]); 
           }
            
           lastvary=vary;
           
           deb("ssp_data made curveset: "+name);
           } catch (Exception e) { e.printStackTrace();}
       } 
        
        
       
       
       
} //end class
