package jcm.mod.scen;

import static jcm.core.complexity.expert;
import static jcm.core.report.deb;
import static jcm.mod.scen.sresimgdata.scen.*;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import jcm.core.cur.curveset;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;

public class sresimgdata extends module implements dataholder  {
	
   //**************************************************
    
    public  void initsetup() {
        if (!gotimagedata) loadImageData();
        addcurvesets();
    }
    
    
    //********** IMAGEdata **************************
    public enum scen { A1B, A1T, A1F, A2, B1, B2, A1, IS92A, TGCIA450, CPI, none }
    public static EnumSet<scen> 
            sresscen=EnumSet.of(A1B, A1T, A1F, A2, B1, B2),
            popscen =EnumSet.of(A1, A2, B2),
            gdpscen =EnumSet.of(A1, A2, B1, B2);
    
    public static Map<scen, curveset> sres_image_popn = new HashMap<scen, curveset>();
    public static Map<scen, curveset> sres_image_gdp = new HashMap<scen, curveset>();
    public static Map<scen, curveset> sres_image_fos = new HashMap<scen, curveset>();
    static boolean gotimagedata=false;
    
    static void loadImageData() {
        deb("loading image data");
        for (scen s : popscen) {
            curveset q = new curveset("pop_"+s, "mega&person", 1995, 2100, 5, expert );
            sres_image_popn.put(s, q);
            loadtable.loaddata(q, "data/sres/POP"+s+".csv", "\t", false, true, 1f, 1995, 2100, 1995, 5);
        }
        for (scen s : gdpscen) {
            curveset q = new curveset("gdp_"+s, "mega&dollar", 1995, 2100, 5, expert );
            sres_image_gdp.put(s, q);
            loadtable.loaddata(q, "data/sres/GDP"+s+".csv", "\t", false, true, 1f, 1995, 2100, 1995, 5);
            //multiply by population because data was percapita
            curveset pop=sres_image_popn.get(s==B1 ? A1 : s);
            for (Object o : q.map.keySet()) for (int y=1995; y<=2100; y+=5) try { q.set(o, y, pop.get(o,y)*q.get(o,y));  } catch (Exception e) { deb(e); }
        }
	for (scen s : sresscen) {
            curveset q = new curveset("fos_"+s, "giga&ton&carbon", 1995, 2100, 5, expert );
            sres_image_fos.put(s, q);
            loadtable.loaddata(q, "data/sres/FOS"+s+".csv", "\t", false, true, 1f, 1995, 2100, 1995, 5);
        }
        gotimagedata=true;
    }
    
    //because module won't find them automatically inside the map
    void addcurvesets() {
        for (curveset q : sres_image_popn.values())  { curvesets.add(q); addOb(q); q.owner=this; }
        for (curveset q : sres_image_gdp.values())  { curvesets.add(q); addOb(q); q.owner=this; }
	for (curveset q : sres_image_fos.values())  { curvesets.add(q); addOb(q); q.owner=this; }
    }
    

}
