/*
SRES baseline scenarios
module added during may11 tidyup of interface to group together sres-related parameters
 container for former code:
 * sres scenario parameter (moved from controller) and related sc-variables
 * sres-ext (extension post 2100) module converted to a loopcalc
 * parameter about blending history to scenario moved from globco2emit and popgdp
 */

package jcm.mod.scen;

import java.util.HashMap;
import java.util.Map;

import jcm.core.cur.curveset;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.mod.scen.sresimgdata.*;
import jcm.mod.socio.popgdp;

import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import static jcm.mod.scen.sresimgdata.*;
import static jcm.mod.scen.sresimgdata.scen.*;


public class sresBase extends module {

        public param useWEO=new param("useWEOscenario", false); //true); true looks wrong with 2030 pledges redn from baseline...
        public param<scen> scenario = new param("sresmenu", sresscen, scen.A1B, simplest) {
              public void precalc() {
            scen sc = scenario.chosen;
            //P2 be careful using index - as scenario now uses enum, order may change?
            sci = scenario.getchosenindex();
            scemit = sresscen.contains(sc) ? sc : sc == TGCIA450 ? B1 : A1B; //other eg IS92A uses A1B by default
            scre = scemit.ordinal();
            scpop = popscen.contains(sc) ? sc : A1;
            scgdp = gdpscen.contains(sc) ? sc : sc == TGCIA450 ? B1 : A1;
                        }
                 };    //scenario.setcomplexity("IS92a", expert); scenario.setcomplexity("CPI", expert); scenario.setcomplexity("TGCIA450", experimental );
    
      public param  socconv = new param("socioconv", "percent&per&year", dkgreen, 2f, 0f, 100f, expert),    //
                             fosconv = new param("foshistscenconv", "percent&per&year", dkbrown, 4f, 0f, 100f, expert), //
                             fosconv_WEO = new param("fosWEOscenconv", "percent&per&year", dkbrown, 4f, 0f, 100f, expert); //
      
     public param sres_extend=new param("extend", new String[] {	"fixed-ext", "linear-ext", "exp-const", "exp-reg"}, "exp-reg", expert);
    
       //indexes shared by socio, regemit and futureLUC
    public scen scemit,  scpop,  scgdp;
    public int sci,  scre;
    //references
    curveset pop, gdp, efb;
    region regset;
   
 

    public void initsetup() {
        scenario.priority+=0.1; // moves it to top in the tree
        popgdp popgdp=gm(popgdp.class);
        pop=popgdp.pop; gdp=popgdp.gdp_ppp;
        emitbase eb=gm(emitbase.class);
         efb=eb.emitfosbase;

        sresext.setaffectedby(sres_extend);
        sresext.setaffectedby(popgdp.usemod);
        sresext.follows(popgdp.future);
        sresext.follows(eb.future); // which also follows aviation emitbase

        //note sresext also affected by scaling in globco2emit - but that shouldn't change unless futbasescen or aviaship does - and doesn't apply in same year so no order problem

    }
    public void setinteractions() {
        setaffectedby(fosconv_WEO, useWEO.istrue());
    }

    

    public loopcalc sresext = new loopcalc("sres-extension") {

 //factors for trends
    Map<region, Float> popfac=new HashMap(), gpcfac=new HashMap(), epgfac=new HashMap();


    public void precalc() {
        regset=(region) gm(regset.class).regions.chosen;
    }


    public void calcstep() {
    	if (year>2100 ) {
    		boolean cpg=   !gm(popgdp.class).usemod.istrue(); // change gdp&pop ? (or just efb)
    		for (region r : regset.reg)  {
    			pop.select(r); gdp.select(r); efb.select(r);
    			String ext=(String)sres_extend.chosen;

    			//calculate rates of change at end of SRES - store in facs
    			if (year==2101) {
    				if (ext.equals("linear-ext")) {
    					if (cpg) {
    						popfac.put(r, (pop.get(2100) - pop.get(2090))/10f);
    						gpcfac.put(r, ((gdp.get(2100)/pop.get(2100)) - (gdp.get(2090)/pop.get(2090)) )/10f);
    					}
    					epgfac.put(r, ((efb.get(2100)/gdp.get(2100)) - (efb.get(2090)/gdp.get(2090)) )/10f);
    				}
    				if (ext.equals("exp-const") || ext.equals("exp-reg")  ){
    					if (cpg) {
    						popfac.put(r, pop.get(2100) / pop.get(2099));
    						gpcfac.put(r, (gdp.get(2100)/pop.get(2100)) / (gdp.get(2099)/pop.get(2099)));
    					}
    					epgfac.put(r, (efb.get(2100)/gdp.get(2100)) / (efb.get(2099)/gdp.get(2099)));
    				}
    			}

    			if (ext.equals("fixed-ext")) {	//could replace this with linear and facs set to zero
    				if (cpg) {
    					pop.set(pop.get(year-1));
    					gdp.set(gdp.get(year-1));
    				}
    				efb.set(efb.get(year-1));
    			}

    			if (ext.equals("linear-ext")) {
    				if (cpg) {
    					pop.set(pop.get(year-1)+popfac.get(r));
    					gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1)+gpcfac.get(r)));
    				}
    				efb.set(gdp.get()*(efb.get(year-1)/gdp.get(year-1)+epgfac.get(r)));
    			}

    			if (ext.equals("exp-const") || ext.equals("exp-reg")  ){
    				if (cpg) {
    					pop.set(pop.get(year-1)*popfac.get(r));
    					gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1))* gpcfac.get(r));
    				}
    				efb.set(gdp.get()*(efb.get(year-1)/gdp.get(year-1))*epgfac.get(r));
    			}

    			if (ext.equals("exp-reg") ){
    				
    				float gpc=0.00092f*gdp.get()/pop.get(); //0.00092 as reg facs were calculated for 1995 giga$ instead of 2000 mega$
    				if (cpg) {
    					popfac.put(r, (1f-sfpop)*popfac.get(r)+ sfpop*(popreg1-popreg2*(float)Math.log(gpc)));
    					gpcfac.put(r,  (1f-sfgpc)*gpcfac.get(r)+ sfgpc*(1f+gpcgrow0[sci]*(float)Math.exp(-gpc*gpcgrowk[sci])));
    				}
    				epgfac.put(r, (1f-sfepg)*epgfac.get(r)+ sfepg*(1f+epggrow0[sci]*(float)Math.exp(-gpc*epggrowk[sci])));
    			}
    		} //reg

    		if (cpg) { pop.calctot(); gdp.calctot(); }
    		efb.calctot(); // note global set in globco2emit which follows this
    	} //>2100


    } //sresext calcstep
}; //sresext loopcalc

//***************** DATA FOR SRESEXT**********************************
    //OLD - regressions based on 2045-2095 (all 12 JCM regions together), for six scenarios A1B, T, F, A2, B1, B2
    static final float[] gpcgrow0={	0.075f, 0.075f, 0.075f, 0.030f, 0.064f, 0.030f }; //growth in gdp/cap (frac) if gdp/cap=0
    static final float[] gpcgrowk={	0.0143f, 0.0143f, 0.0143f, 0.0179f, 0.0255f, 0.0179f }; //exp decay rate of growth as function of 0.001*gdp/cap
    static final float[] epggrow0={	-0.033f, -0.037f, -0.025f, -0.018f, -0.042f, -0.018f }; //decline in emit/gdp (frac) if gdp/cap=0
    static final float[] epggrowk={	0.00606f, 0.00114f, 0.00916f, 0.0128f, 0.0110f, 0.00944f }; //exp decay rate of decline as function of 0.001*gdp/cap

    static final float popreg1=1.013f , popreg2=0.004f; //as gpcreg but for popn growth, based on B2 scenario only
//note: for other scenarios there is no clear correlation
//eventually should replace these with (convergence to) UN2300 scenarios - eg high for A2, mid for B2, low for A1+ ?

    static final float sfgpc=0.05f, sfepg=0.05f, sfpop=0.02f; // amount by which growth rates tend towards regression function each year

    //***************************************************

    /*

 theory of exp reg is that  growth rate of  population, gdp-per-capita and emissions-per-gdp  converge slowly towards functions of gdp_ppp/capita
 these functions are derived from linear regression over original scenario data,
 using data from all regions (i.e. its a global function, assuming some convergence)
 and from 2050-2100 (to avoid short-term effects)

 pf = 1+dp/p.dt
 pf =>  a + b.ln(g/p)
 use  to find a and b

 note: use original image data 2050-2100 (NOT interpolated to regset), as this is a global function
 BUT can't do that as don't have image data for GDP_PPP...!
 */

    static Map<scen, Float> popa, popb;

    static void calcreg(scen sc) {
        float sumx=0, sumy=0, sumx2=0, sumxy=0, x, y, n;
        curveset p=sres_image_popn.get(sc);

        for (int year=2050; year<2100; year+=5) {
            for (Object r : p.map.keySet()) {

            }
        }
    }
}
