package jcm.mod.resp;

import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.core.anno.*;
import jcm.core.ob.*;
import jcm.core.cur.*;
import jcm.core.reg.region;
import jcm.mod.carbon.*;
import jcm.mod.ogas.*;
import jcm.mod.cli.*;
import jcm.core.par.*;
import jcm.mod.regemit.emitquota;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.core.anno.todo.type.*;
import static jcm.core.anno.todo.goal.*;

/**
 Responsibility of each region for climate change
 developed for UNFCCC Brazilian proposal exercise
 Developed Louvain-la-neuve July 2002, updated for all regions 2005 + added timeslice etc.
 
 Note, this module comes at the end of the calculation step loop, so it can draw on results from other modules, but it should not affect them.
 It can use a lot of memory / take a long time, if many regions are calculated, but won't be called unless an attribution plot is visible.
 
 See also src/todo/sci/responsibility & match07.todo 
  */


public class responsibility extends module  {
    
    public param method=new param("attmeth", new String[]{	"tracer",  "timeslice","normarg" }, "tracer", experimental);
    //"tracer+differentialRF", removed since not  working since restruc -check
    
    public param
	    startyear=new param("startyear", "", 1900, 1890, 2000),
	    endyear=new param("endyear", "", 2012, 1990, 2100), //changed from 2002 to 2012 jan09, more policy relevant
	    includeLUC=new param("attributeLUC-CO2", true),
	    includeCH4N2O=new param("attributeCH4N2O", true),
	    removeextrareg=new param("regionsonly", false);
    //simplecarbon=new param("simplecarbon", false, experimental); //ignore back fluxes
    
    //************************
    
    attribMarginal marg;
    attribTracer trace;
    public int nregs;
    
    
    //************* SETUP ****************
    
    public void initsetup() {
	follows(gm(emitquota.class).regfuture); //which follows carboncycle, futureLUC etc.
	follows(gm(radfor.class)); //will catch any gas-changed
	follows(gm(glotemp.class));
	marg=gm(attribMarginal.class);
	trace=gm(attribTracer.class);
    }
    
    public void setinteractions() {
	setaffectedby(marg, (method.chosen.equals("timeslice") || method.chosen.equals("normarg" )));
	setaffectedby(trace, method.chosen.equals("tracer"));
    }
    
     
    //***************** PRECALC *****************
    public void precalc() {
	if (!marg.intimesliceloop) {
	    nregs=((region) (gm(regset.class).regions.chosen)).reg.size();
	}
    }
    
    //*********** EXTRA REGIONS  *****************
    
    region bestafen=new region("Before start/After End", dkgrey );
    region othgasreg=new region("Unattributed gases (inc F-gases, Ozone)", greygreen );
    region aerosolreg=new region("Aerosols", cyan );
    region solvolreg=new region("Solar and Volcano", yellow );
    
    //would be clearer to use an extended region set and enums for the keys instead of ints
    region reg(int nr) {
	if (nr<nregs) return ((region) (gm(regset.class).regions.chosen)).reg.get(nr);
	if (nr==nregs) return bestafen;
	if (nr==nregs+1) return othgasreg;
	if (nr==nregs+2) return aerosolreg;
	if (nr==nregs+3) return solvolreg;
	return null;
    }
    
//#######################
//EMISSIONS
    
    boolean attrib(int y) { return (y>=startyear.getval() && y <=endyear.getval()); }
    
    float totco2emit(region r, int y) {
	if (y<gsy) return 0; //oldtotemit at start
	if (r==bestafen) return attrib(y) ? 0 : gm(carboncycle.class).fossil.get(y)  +( includeLUC.istrue() ?  gm(carboncycle.class).lucf.get(y) : 0  ) - gm(emitquota.class).emitfos.get("bunker", y) ;
	if (r==othgasreg)  return gm(emitquota.class).emitfos.get("bunker", y) +( includeLUC.istrue() ? 0 :  gm(carboncycle.class).lucf.get(y));
	if (r==aerosolreg || r==solvolreg) return 0;//- no emissions, but effect from temperature feedbacks
	else return attrib(y) ? gm(emitquota.class).emitfos.get(r, y) + (includeLUC.istrue() ? gm(emitquota.class).emitluc.get(r, y) : 0 ) : 0;
    }
    float ch4emit(region r, int y) {
	if (r==bestafen) return attrib(y) ? 0 : gm(othgasemit.class).ch4emit.get(y);
	else return attrib(y) ?  gm(emitquota.class).emitch4.get(r, y) : 0;
    }
    float n2oemit(region r, int y) {
	if (r==bestafen) return attrib(y) ? 0 : gm(othgasemit.class).n2oemit.get(y);
	else return attrib(y) ?  gm(emitquota.class).emitn2o.get(r, y) : 0;
    }
    
    
   
    
} //end responsibility



