package jcm.mod.resp;

/*OK P4 CHECK: total temperature is higher than from main temperature calculation - why?
 Note that radiative forcing and concentration seem OK
 Part of difference can be explained by baseyear (here it's always 1750) but not all
 
 Temp: for 500ppm CO2 scenario, in 2100 attrib => 2.48 (2.91-0.43), main  => 2.21, and 1750 attrib => zero, whereas main => -0.1 => real diff is about 8%
 RF: for 500ppm CO2 scenario, in 2100 attrib RF =>3.58 (3.94-0.36), main => 3.62, and  in 2050 attrib => 3.36 (4.27 - 0.91), main => 3.43: so RF cannot explain it
 it's funny that in 2050 attrib solar RF is about double main solar??

 But there is no upwelling feedback in the attrib module (see doc notes in this page below)
 Switching it off =>  Temp: for 500ppm CO2 scenario, in 2100 attrib => 2.49 (2.90-0.41), main  => 2.34
 add the 0.1 in 1750 => main (wrt 1750) = 2.44  => remaining difference only 2%
 conclusion - no fundamental issue
 */

import jcm.mod.obj.regset;
import java.util.List;
import jcm.core.*;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;

import jcm.core.reg.region;
import jcm.mod.carbon.*;
import jcm.mod.ogas.*;
import jcm.mod.cli.*;
import static jcm.core.report.*;

public class attribTracer extends module {

    //************** CURVES ****************
    public curveset //
            atco2 = new curveset("atco2", "ppm"),  //
            atch4 = new curveset("atch4", "ppb"),  //
            atn2o = new curveset("atn2o", "ppb"),  //
            rfco2 = new curveset("rfco2", "w&per&m2"), //
            rfch4 = new curveset("rfch4", "w&per&m2"),  //
            rfn2o = new curveset("rfn2o", "w&per&m2"),  //
            rftot = new curveset("rftot", "w&per&m2"),  //
            surftemp = new curveset("surftemp", "degrees&C"),  //
            surftemprel = new curveset("surftemp&relative", "%"),  //
            sealevte = new curveset("sealevte", "metres"); //
    //
    //*************** VARIABLES ************
    final static int ncb = berncarbon.ncb,  nhb = udebclimod.nhb;
    float[] ls, hs, so, hu;
    float[][] ciq;
    float[][][] hiq;
    float[][] acccbox;
    int nregs, oldnregs = 0, nrf, nemit, oth;
    List<region> reg;
    responsibility resp;
    carboncycle carbon;
    regset socreg;
    region bestafen, othgasreg, aerosolreg, solvolreg;

    //********************* SETUP  **********************
    public void initsetup() {
        resp = gm(responsibility.class);
        carbon = gm(carboncycle.class);
        socreg = gm(regset.class);
        bestafen = resp.bestafen;
        othgasreg = resp.othgasreg;
        aerosolreg = resp.aerosolreg;
        solvolreg = resp.solvolreg;
        follows(resp);
        register.requires(this, carbon, true);
        register.requires(this, gm(glotemp.class), true);
        register.requires(this, gm(berncarbon.class), true);
        register.requires(this, gm(udebclimod.class), true);
    //the requires force carboncycle and get glotemp to recalc, so that this module can access their temporary state of boxes/fluxes within the timestep loop
    //but these modules are not set affectedby responsibility (would be very inefficient because force other dependent modules to recalc too)
    //not clear if the refs to berncarbon and udebclimod are also necessary - will force makign the setup matrix
    }

//********************* CALCSTEP  **********************
    public void precalc() {
        makeboxes();
        loop.calcfutureonly = false;
        for (curveset qq : curvesets) gm(regset.class).clearoldregions(qq);
        for (curveset qq : curvesets) qq.associate(resp.startyear, resp.endyear);
    }

    public void calcstep() {
        if (year > 2100 && year > resp.endyear.getval()) return; //makes it faster and plots lower
        carbonstep();
        atchemstep();
        rfstep();
        glotempstep();
        tottemp();
    }

    public void postcalc() {
        if (resp.removeextrareg.istrue())  for (curveset qq : curvesets) { qq.map.remove(bestafen); qq.map.remove(aerosolreg); qq.map.remove(othgasreg); qq.map.remove(solvolreg); }
    }

    //    ************ surftemprel**************
    //make surfremprel for convenient comparison with absolute
    //note another way would be to make a pointer qt of type frac, which would save on memory, but would have to adjust the method to get the total (since mapwithouttotal is not right)
    void tottemp() {
        float totattrib = 0;
        for (region r : reg) totattrib += surftemp.get(r);
        for (region r : reg) surftemprel.set(r, 100f * surftemp.get(r) / totattrib);
    }

    //********************** ARRAYS ******************************
    region reg(int n) {
        return resp.reg(n);
    }

    public void makeboxes() {
        reg = ((region) (gm(regset.class).regions.chosen)).reg;
        nregs = resp.nregs;
        if (nregs != oldnregs) {
            oldnregs = nregs;
            nemit = nregs + 1;
            nrf = nregs + 4;
            oth = nregs;
        //note +1 for other/unattributed before start, after end, +4 adds also other gas, get(aerosol.class), solvol
        }

        //for carbon cycle
        ciq = new float[nrf][ncb];
        ls = new float[nrf];
        hs = new float[nrf];
        so = new float[nrf];
        hu = new float[nrf];
        acccbox = new float[nrf][4];
        //for heat fluxes
        hiq = new float[nrf][2][nhb];
    }
    //#######################
//CARBON CYCLE
    float sink, atinc, lsinc, hsinc, fracco2rise, fracls, frachs, totls, toths, totat, npinc, dls, dhs, dnp, dat;
    float soinc, huinc, totso, tothu, dso, dhu;
    float glotemprise, gloco2rise, fraccarbfb, fractemprise;

    void carbonstep() {

        //simple ACCC model
        if (carbon.accccarbon.istrue()) {
            if (year == gsy) for (int i = 0; i < 4; i++) {
                    acccbox[oth][i] = carbon.acccbox[i];
                    for (int nr = 0; nr < nregs; nr++) acccbox[nr][i] = 0;
                }
            for (int nr = 0; nr < nrf; nr++) atco2.set(reg(nr), carbon.acccmod(acccbox[nr], resp.totco2emit(reg(nr), year)));
            return;
        }

        /*
        Adapt BernCarbon
        Since this module follows carboncycle - berncarbon in same step loop,
        we can scale the global nonlinear fluxes in proportion to the attributed fraction from the source box,
        i.e. fraction of the atmosphere for npinc (fertilisation air=>bio),
        and of ls and hs boxes for lsinc and hsinc which are sea=>air fluxes (the extra due to carbonate chemistry).
        This proportionality based on previous timestep to avoid iteration.
        (the iteration and chemistry are the slow parts of carbon calcstep)
        Note that this only works if carbon module always calculated!
         */

        /* Apportioning non-linear fluxes:
        Attribution of temp feedback on soil carbon is apportioned by shares of temperature
        (noting that mostly non-anthropogenic carbon is released)
        Fraction of heat from other gases/aerosols/solar/volcano are included
        Fertilisation feedback and non-linear flux from atmosphere to ocean are apportioned to atmospheric CO2
        But feedback on ocean chemistry is response to both CO2 and temperature - complex equilibria!
        In A2 scenario by 2100,  ocean sink is 13.3 with linear model, 7.26 with chemistry but no temp-feedback, 6.44 with temp-feedback too.
        So non-lin flux (when CF on) could be apportioned as 88% to carbon in that box, and 12% to surface temperature
        But this only applies when high CO2 (pCO2rise=appx550, temprise = appx5.0), not in early years when temp matters more.
        try 0.008 * co2rise / temprise
        NOTE May06 changed from former value 0.0016 * co2rise (alone)
        check lsinc- gets more negative with feedback=>  implies greater flux out of ocean
        check npinc - gets more and more negative  - because it's the difference once you subtract the linear part (prop to at?)
        check soinc - gets negative when there is a feedback - its a flux out of soil
        Note that to get ocean chemistry feedbacks to work, it's important that non-linear fluxes start at zero,
        not starting with offset to put more flux into linear part averaged over run (an efficiency trick used in berncabon - now removed)
         */


        berncarbon bc = gm(berncarbon.class);
        carboncycle cc = carbon;
        boolean feedback = gm(carbonatechemistry.class).chemfeedback.istrue();

        gloco2rise = cc.co2atppm.get(year - 1) - (float) cc.atppmprein;
        glotemprise = gm(glotemp.class).avchange.get(year - 1);

        if (!feedback || Math.abs(glotemprise) < 0.02) {
            fraccarbfb = 1f;
        } else {
            fraccarbfb = Math.abs(0.008f * gloco2rise / glotemprise);
            if (fraccarbfb > 1) fraccarbfb = 1f;
        }

        regloop:
        for (int nr = 0; nr < nrf; nr++) {
            region r = reg(nr);
            //set starting state
            if (year == gsy) for (int n = 0; n < ncb; n++) ciq[nr][n] = (nr == oth ? (float) bc.ciq[n] : 0);

            if (year < resp.startyear.getval() && nr < nregs) {
                atco2.set(r, 0);
                continue regloop;
            }

            //******* use contribution to atCO2 and temp rise (from previous timestep) ****
            /*should think harder about implication of these fractions being negative...
            temporary fixes:
            attribute all of first 50 years nonlinear temperature feedback effects to solar+volcano
            ignore feedbacks from very small co2 and temperature rises 
             */
            fracco2rise = (year > gsy) ? atco2.get(r, year - 1) / gloco2rise : 0;
            fractemprise = (year > gsy) ? surftemp.get(r, year - 1) / glotemprise : 0;
            //if (year>gsy && (year - gsy) < 50) fractemprise = (r == resp.solvolreg) ? 1f : 0;  

            if (Math.abs(gloco2rise) < 10) fracco2rise = 0;  // if (fracco2rise > 1) fracco2rise = 1;
            if (Math.abs(glotemprise) < 0.1) fractemprise = 0;  //if (fractemprise > 1) fractemprise = 1;

            //******** attribute fracls & frachs *********

            fracls = (year > gsy) ? fraccarbfb * ls[nr] / totls + (1f - fraccarbfb) * fractemprise : 0;
            frachs = (year > gsy) ? fraccarbfb * hs[nr] / toths + (1f - fraccarbfb) * fractemprise : 0;

            //*********  apply nonlinear parts *********


            atco2.set(r, 0);
            ls[nr] = 0;
            hs[nr] = 0;
            so[nr] = 0;
            hu[nr] = 0;

            //use the *old* values for the step function
            lsinc = (float) bc.oldlsinc * fracls;
            hsinc = (float) bc.oldhsinc * frachs;
            npinc = (float) bc.oldnpinc * fracco2rise;
            soinc = (float) bc.oldsoinc * fractemprise;
            huinc = (float) bc.oldhuinc * fractemprise;
            atinc = resp.totco2emit(r, year - 1) - (lsinc + hsinc + npinc + soinc + huinc);
            //and changes for the ramp function
            dls = (float) bc.dls * fracls;
            dhs = (float) bc.dhs * frachs;
            dnp = (float) bc.dnp * fracco2rise;
            dso = (float) bc.dso * fractemprise;
            dhu = (float) bc.dhu * fractemprise;

            dat = (resp.totco2emit(r, year) - resp.totco2emit(r, year - 1)) - (dls + dhs + dnp + dso + dhu);

            for (int n = 0; n < ncb; n++) {

                //apply the prop & step & ramp functions
                ciq[nr][n] = (float) (ciq[nr][n] * bc.cpropf[n] + bc.scicAT[n] * atinc + bc.scicLS[n] * lsinc + bc.scicHS[n] * hsinc + bc.scicNP[n] * npinc + bc.rcicAT[n] * dat + bc.rcicLS[n] * dls + bc.rcicHS[n] * dhs + bc.rcicNP[n] * dnp + bc.scicSO[n] * soinc + bc.rcicSO[n] * dso + bc.scicHU[n] * huinc + bc.rcicHU[n] * dhu);
                //and calculate new concentration
                atco2.set(r, atco2.get(r) + (float) bc.crAT[n] * ciq[nr][n]);
                ls[nr] += (float) bc.crLS[n] * ciq[nr][n];
                hs[nr] += (float) bc.crHS[n] * ciq[nr][n];
                so[nr] += (float) bc.crSO[n] * ciq[nr][n];
                hu[nr] += (float) bc.crHU[n] * ciq[nr][n];
            } //n

            atco2.set(r, atco2.get(r) * (float) cc.ppmpmtc);

        } //nr

        //new totals
        totls = 0;
        toths = 0;
        totat = 0;
        totso = 0;
        tothu = 0;
        for (int nr = 0; nr < nrf; nr++) {
            totls += ls[nr];
            toths += hs[nr];
            totat += atco2.get(reg(nr));
            totso += so[nr];
            tothu += hu[nr];
        }

    } //carbonstep
//####################################
//ATMOSPHERIC CHEMISTRY
    float extrach4, extran2o, fracn2o;

    void atchemstep() {
        if (year == gsy) {
            for (int nr = 0; nr < nregs; nr++) {
                atch4.set(reg(nr), 0);
                atn2o.set(reg(nr), 0);
            }
            atch4.set(bestafen, gm(atchem.class).ch4conc.get() - gm(atchem.class).ch4prein);
            atch4.set(othgasreg, 0);
            atn2o.set(bestafen, gm(atchem.class).n2oconc.get() - gm(atchem.class).n2oprein);
            atn2o.set(othgasreg, 0);
        } else {

            for (int nr = 0; nr < nemit; nr++) {
                region r = reg(nr);
                atch4.set(r, atch4.get(r, year - 1) * (1f - 1f / gm(atchem.class).ch4life(year)) + (float) (gm(atchem.class).ppbpmtch4 * resp.ch4emit(r, year)));
                atn2o.set(r, atn2o.get(r, year - 1) * (1f - 1f / gm(atchem.class).n2olife(year)) + (float) (gm(atchem.class).ppbpmtn2o * resp.n2oemit(r, year)));
            } //nr


            /*account for any effect of changing lifetime on natural emissions,
            or (if we use fixed 2000 lifetimes) discrepancy between preindustrial concn and natural emissions
            This should ensure consistency with concentrations in main JCM calculations.
            But how to attribute this extra change in concentration?
            for ch4, this is due to changing OH which is affected by several gases
            - so until we can attribute OH, assign this to "other gas" category (nemit)
             */

            extrach4 = (gm(atchem.class).ppbpmtch4 * gm(atchem.class).ch4emitnat() - gm(atchem.class).ch4prein / gm(atchem.class).ch4life(year));
            atch4.set(othgasreg, atch4.get(othgasreg, year - 1) * (1f - 1f / gm(atchem.class).ch4life(year)) + extrach4); //other gas category

            //apply same rule to n2o
            extran2o = (gm(atchem.class).ppbpmtn2o * gm(atchem.class).n2oemitnat() - gm(atchem.class).n2oprein / gm(atchem.class).n2olife(year));
            atn2o.set(othgasreg, atn2o.get(othgasreg, year - 1) * (1f - 1f / gm(atchem.class).n2olife(year)) + extran2o); //other gas category

        /* old method
        for co2 extra (nonlinear) sea-air flux attributed according to fraction of extra carbon in mixed layer
        for n2o which affects its own lifetime, apply similar principle as CO2, according to concentration
        fracn2o=(get(atchem.class).n2oconc[ns]-get(atchem.class).n2oprein); //avoid dividing by tiny quantities
        if (fracn2o>0.1) for (int nr=0; nr<(nemit); nr++) atn2o[nr][ns]+= extran2o*atn2o[nr][ns]/fracn2o;
         */
        } //ns>0
    } //get(atchem.class)step
//####################################
//RADIATIVE FORCING
    /* differential RF formula taken from Enting papers,
    not bad for CO2,
    however causes a long "memory" with CH4
    beware total emissions must be consistent with oghga if use oghga concs!
     */
    float dc;

    void rfstep() {
        atchem atchem = gm(atchem.class);
        for (int nr = 0; nr < nrf; nr++) {
            region r = reg(nr);

            if (resp.method.equals("tracer+differentialRF") && year > (resp.startyear.getval() + 1)) {
                //year because first step is too big to apply differential rate
                int yy = (year > gsy ? year - 1 : gsy);
                dc = (carbon.co2atppm.get() - carbon.co2atppm.get(yy));
                rfco2.set(r, yy/* check! */, rfco2.get(r, yy) + ((Math.abs(dc) > 0.0001) ? (carbon.co2rf.get() - carbon.co2rf.get(yy)) * (atco2.get(r) - atco2.get(r, yy)) / dc : 0));

                if (nr < nemit + 1) {	//n2o and ch4 no effect from aerosol/solvar
                    dc = (atchem.n2oconc.get() - atchem.n2oconc.get(yy));
                    rfn2o.set(r, rfn2o.get(r, yy) + ((Math.abs(dc) > 0.0001) ? (atchem.n2orf.get() - atchem.n2orf.get(yy)) * (atn2o.get(r) - atn2o.get(r, yy)) / dc : 0));
                    dc = (atchem.ch4conc.get() - atchem.ch4conc.get(yy));
                    rfch4.set(r, rfch4.get(r, yy) + ((Math.abs(dc) > 0.0001) ? (atchem.ch4rf.get() - atchem.ch4rf.get(yy)) * (atch4.get(r) - atch4.get(r, yy)) / dc : 0));
                }
            } else {	//normal tracer method
                dc = (carbon.co2atppm.get() - (float) carbon.atppmprein);
                rfco2.set(r, atco2.get(r) * ((Math.abs(dc) > 0.0001) ? carbon.co2rf.get() / dc : 0));
                if (nr < nemit + 1) {
                    dc = (atchem.n2oconc.get() - atchem.n2oprein);
                    rfn2o.set(r, atn2o.get(r) * ((Math.abs(dc) > 0.0001) ? atchem.n2orf.get() / dc : 0));
                    dc = (atchem.ch4conc.get() - atchem.ch4prein);
                    rfch4.set(r, atch4.get(r) * ((Math.abs(dc) > 0.0001) ? atchem.ch4rf.get() / dc : 0));
                }
            }
        } //nr

        //total
        for (int nr = 0; nr < nemit; nr++) rftot.set(reg(nr), rfco2.get(reg(nr)) + (resp.includeCH4N2O.istrue() ? rfch4.get(reg(nr)) + rfn2o.get(reg(nr)) : 0));
        //other gases
        rftot.set(othgasreg,
                rfco2.get(othgasreg) + rfch4.get(othgasreg) + rfn2o.get(othgasreg) + gm(fgas.class).cfcrf.get() + gm(fgas.class).hfcrf.get() + atchem.strath2orf.get() + atchem.tropo3rf.get() + gm(fgas.class).strato3rf.get());
        if (!resp.includeCH4N2O.istrue()) for (int nr = 0; nr < nemit; nr++) rftot.set(othgasreg, rftot.get(othgasreg) + rfch4.get(reg(nr)) + rfn2o.get(reg(nr)));

        //aerosol and solar - include feedback effect on carbon
        rftot.set(aerosolreg, rfco2.get(aerosolreg) + gm(aerosol.class).aerorf.get());
        rftot.set(solvolreg, rfco2.get(solvolreg) + gm(aerosol.class).natvrf.get());

    } //rfstep
    /*
    Note: RF from other gases includes any due to accumulated conc before start
    also includes effect of changing CH4 lifetime (see note above)!
    not problem if start-date before 1970 (as no fgases and ozone has short life)
    but if start much later should calc separately to shift to "other" category
     */
//####################################
	/*
    HEAT FLUXES: surface temp and sealevel
    adapted from udebclimod.java but a bit simpler:
    no upwelling feedback (yet)
    only well mixed rf same for all surface boxes
    no north-south flux (as setting the rate to zero makes hardly any difference to global temp)
    (note the two oceans are still different as northern has more land => cools/warms faster).
     */
    float qin, qinold, dqin;
    float[] rff = new float[2], sf = new float[2], mlt = new float[2], boxtemp = new float[4];

    void udebclimodsetup() {
        udebclimod udeb = gm(udebclimod.class);
        for (int o = 0; o < 2; o++) {
            //factor to combine direct input from rf + input via land
            rff[o] = (float) (1f + (udeb.frac[o * 3] / udeb.frac[o + 1]) * udeb.klo / (udeb.kls * udeb.frac[o * 3] + udeb.klo));
            sf[o] = (float) (udeb.spaceflux[o] * udeb.qpt * udeb.tstart);
            for (int n = 0; n < nhb; n++) {
                //fill boxes: oth gets all the heat already accumulated, others start with steady-state
                for (int nr = 0; nr < (nrf); nr++)
                    hiq[nr][o][n] = (float) ((nr == oth) ? udeb.hiq[o][n] : udeb.hiqstart[o][n]);
            }
        } //o
    } //hf setup

    void glotempstep() {

        if (year == gsy) udebclimodsetup();

        //below lets it start in 1750 accumulating aerosols etc.

        udebclimod udeb = gm(udebclimod.class);

        regloop:
        for (int nr = 0; nr < nrf; nr++) {
            region r = reg(nr);
            surftemp.set(r, 0);
            sealevte.set(r, 0);

            if (year < resp.startyear.getval() && nr < nregs) continue regloop;
            if (year == gsy && r == resp.othgasreg) continue regloop;

            for (int o = 0; o < 2; o++) {	//for each ocean

                mlt[o] = 0;

                //calc heat input to each ocean mixed layer (watt-year per m2)
                qinold = sf[o] + (year > gsy ? rftot.get(r, year - 1) : 0) * rff[o];
                qin = sf[o] + rftot.get(r) * rff[o];
                dqin = qin - qinold;

                for (int n = 0; n < nhb; n++) {	//for each layer

                    //apply prop, step, ramp functions
                    hiq[nr][o][n] = (float) (udeb.hpropf[o][n] * hiq[nr][o][n] + udeb.shicML[o][n] * qinold + udeb.rhicML[o][n] * dqin);

                    //calc new surface temperatures
                    mlt[o] += (float) udeb.hrML[o][n] * hiq[nr][o][n];
                    //sea-level rise due to thermal expansion (averages both oceans)
                    sealevte.set(r, sealevte.get(r) + (float) udeb.hrsl[o][n] * hiq[nr][o][n]);

                } //nhb

                mlt[o] = (float) (mlt[o] / udeb.qpt - udeb.tstart); //convert to temp rise
            } //o

            //P2 CHECK sealevteinit seems to be not working!
            sealevte.set(r, sealevte.get(r) - (float) udeb.sealevteinit); //convert to change

            boxtemp[0] = (float) ((mlt[0] * udeb.cice * udeb.klo + udeb.frac[0] * rftot.get(r)) / (udeb.kls * udeb.frac[0] + udeb.klo));
            boxtemp[3] = (float) ((mlt[1] * udeb.cice * udeb.klo + udeb.frac[3] * rftot.get(r)) / (udeb.kls * udeb.frac[3] + udeb.klo));
            boxtemp[1] = (float) (mlt[0] * udeb.cice);
            boxtemp[2] = (float) (mlt[1] * udeb.cice);
            for (int i = 0; i < 4; i++) surftemp.set(r, surftemp.get(r) + (float) (boxtemp[i] * udeb.frac[i]));
        } //nr

    } //end get(glotemp.class)step
}
