/*
Shares module calculates regional emissions quotas (for a policy scenario) according to various sharing-schemes
Currently most rules apply only to fossil CO2, needs to be extended to other gases (which are simply scaled by sres baseline)

 Note "newmix" option moved to shares_cut - won't work
 likewise leascost method
 */
package jcm.mod.regemit;

import java.util.*;
import jcm.core.*;
import jcm.core.cur.*;
import jcm.core.ob.loopcalc;
import jcm.core.par.param;
import jcm.core.ob.module;
import jcm.core.reg.*;
import jcm.mod.obj.regset;
import jcm.mod.socio.*;
import jcm.mod.resp.*;
import jcm.mod.obj.controller;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.globco2emit;
import jcm.mod.ogas.othgasemit;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static jcm.mod.regemit.shares.distriboptions.*;
import static jcm.mod.regemit.shares.convcrit.*;
import static jcm.mod.regemit.shares.igroup.*;
import static jcm.mod.regemit.shares.emitthreshold.*;
import static jcm.mod.regemit.shares.intensity.*;
import static jcm.mod.ogas.othgasemit.gwp.*;
import static jcm.mod.obj.controller.objopt.*;
import static jcm.mod.obj.controller.butd.*;

public class shares extends module {    //
    // =========== ENUMS ============
    public enum distriboptions {
        sresdist, convergence, newmix, grandfather, responsibility, leastcost, unspecified
    };
        complexity[] distribcomplex = new complexity[]{normal, simplest, normal,  expert, experimental, experimental, experimental}; //note responsibility experimental until fixed for new structure


    public enum convcrit {
        emissionspercapita, emissionspergdp
    };

    public enum igroup {
        all_from_start, Kyoto_Annex_B, all_CA_pledges, none
    };
    complexity[]  igcomplex= new complexity[]{ };

    public enum emitthreshold {
        worldemitpercap, particip_emitpercap, nolim
    };

    public enum intensity {
        redint, redrelbase, no_deviation
    };

    

    //================ PARAMS ===============================
 
    
     public param<igroup> initgroup = new param("initial participating group", igroup.values(), all_from_start); // Kyoto_Annex_B); //
    
    public param<emitthreshold> emitlim = new param("emissions threshold", emitthreshold.values(), particip_emitpercap);  //
    public param
            richjoin = new param("join if high GDP", true), //
             axb_gdp_threshold = new param("upper_GDP_threshold", "dollar&per&person", 20000, 10000, 30000), //
             ldc_gdp_threshold = new param("lower_GDP_threshold", "dollar&per&person", 5000, 0, 20000, expert); //`

    public param<distriboptions> distribution = new param("distribmenu", distriboptions.values(), convergence, distribcomplex); //
    
    public param<convcrit> conv_criteria = new param("convergence criteria", convcrit.values(), emissionspercapita, expert); //
    public param
            convifred = new param("converge only if below base", true),
            convergey = new param("convyear", "", 2065, 2010, 2100), //
             exponential = new param("expconvopt", false, expert), //
             cvf = new param("convfac", "", 6, 1, 13, expert), //
             popcoyoption = new param("popcoyopt", false, expert), //  
             popcoy = new param("popcoy", "", 2040, 1990, 2100, expert), //
             percap_target=new param("per_capita target bottom-up", "ton&per&person", 0.4, 0, 2), // approx half 2000 fossil emissions divided 9bn popn
             pergdp_target=new param("intensity target bottom-up", "gram&per&dollar", 25, 0, 100);


    public param<intensity> midincaction = new param("middle-income early action", intensity.values(), redrelbase/*no_deviation*/, expert);  //default changed 25aug11
    public param
             dc_reduction = new param("midinc intensity reduction", "percent&per&yr", 1.5, 0, 5, expert); //note - 1.5% per yr over 15yrs 2005-20 is approx equiv halfway 15-30% redn baseline range
    
    public param         lc_iterative = new param("iterative", false, experimental); //least-cost by iterative method

    public enum smoothbaseopt { no_smooth, intensity_based, exp_convergence }
    public param<smoothbaseopt> smoothjumpbase = new param("smooth jumps to baseline", smoothbaseopt.values(), smoothbaseopt.intensity_based, expert); //constrain for non pledged

    public param
             rate_caps = new param("use rate caps", false, expert), //
             rate_constraint = new param("max decline rate", "percent&per&yr", 4, 2, 20, expert), //
             d2rate_constraint = new param("max deceleration", "percent&per&yr", 3, 0.5, 5, expert); //

public param
             logparticip = new param("record_transitions", false, expert), //set true to see participation threshold changes in log
             checkscaling = new param("topdownscale", true, experimental); //use this to test if the final topdownscale makes a difference - it shouldn't


    //==================== INTERACTIONS ===========
    //
    public void initsetup() {
        eq=gm(emitquota.class);
        eb=gm(emitbase.class);
        attr = gm(attribTracer.class);
        resp = gm(responsibility.class);
        pl=gm(pledges.class);
        co=gm(controller.class);

        follows(popgdp.class);  // per capita etc. - although not always needed
        follows(emitbase.class);  // baseline emissions
        setaffectedby(co.objective);
        distribution.setaffectedby(co.objective);
        setaffectedby(emitquota.class); //forces that to run - because dependencies from other modules linked to shares not to emitquota
        setaffectedby(gm(othgasemit.class).gwp_source);

        topdown.follows(this);
        topdown.follows(gm(AviaShipEmit.class).emitmitig); // as the mitigated bunker will affect emissions available to regions
        topdown.follows(gm(futureLUC.class).quota); // CHECK if this order works?
        topdown.follows(gm(globco2emit.class));
        topdown.follows(gm(othgasemit.class));

    //   
    //====== arrow controls ======
    //.associate(convergey); //this needs to be a derived qtset, therefore how to make it (unless permanently in regemit?)
    //.associate(popcoy);
    }

    public void setinteractions() { //changing interactions (put permanent in initsetup)

        follows(pledges.class, co.objective.chosen!=nopolicy );

        boolean policyscen = !(gm(controller.class).objective.chosen == controller.objopt.nopolicy);
        boolean incpart = policyscen && initgroup.chosen != all_from_start;
        distriboptions dc = distribution.chosen;

        setaffectedby(gm(attribTracer.class), policyscen && dc == responsibility);
        setaffectedby(gm(costs.class), policyscen && dc == leastcost);
        setaffectedby(distribution, policyscen);
        setaffectedby(initgroup, policyscen);
        setaffectedby(co.startyear_topdown, policyscen && co.botuptopdo.chosen==start_bottom_up);
        setaffectedby(emitlim, incpart);
        setaffectedby(conv_criteria, policyscen && dc == convergence);
        setaffectedby(convergey, policyscen && dc == convergence);
        setaffectedby(percap_target, policyscen && dc == convergence && conv_criteria.chosen == emissionspercapita&& co.botuptopdo.chosen!=top_down_only);
        setaffectedby(pergdp_target, policyscen && dc == convergence && conv_criteria.chosen == emissionspergdp && co.botuptopdo.chosen!=top_down_only);
        setaffectedby(popcoyoption, policyscen && dc == convergence && conv_criteria.chosen == emissionspercapita);
        setaffectedby(popcoy, policyscen && dc == convergence && conv_criteria.chosen == emissionspercapita && popcoyoption.istrue());
        setaffectedby(exponential, policyscen && dc == convergence);
        setaffectedby(cvf, policyscen && dc == convergence && exponential.istrue());
        //setaffectedby(incusa, policyscen && kyotop.istrue());
        setaffectedby(lc_iterative, policyscen && dc == leastcost);
        setaffectedby(richjoin, incpart);
        setaffectedby(axb_gdp_threshold, incpart && richjoin.istrue());
        setaffectedby(midincaction, incpart);
        setaffectedby(rate_caps, policyscen);
        setaffectedby(rate_constraint, policyscen && (rate_caps.istrue() || dc==newmix));
        setaffectedby(d2rate_constraint, policyscen && rate_caps.istrue());
        setaffectedby(ldc_gdp_threshold, incpart && (midincaction.chosen != no_deviation || rate_caps.istrue()));
        setaffectedby(dc_reduction, incpart && midincaction.chosen != no_deviation);
    

    }    //
    //***************** WORKING VARIABLES *********************
    
    attribTracer attr;
    responsibility resp;
    pledges pl;
    emitquota eq; emitbase eb;
    curveset efq, efb, elq, elb, emq, emb, enq, eeq, enb, pop, gdp;

    List<region> reg_all, reg_allnb = new ArrayList();
    Set<region> particip = new HashSet(), notparticip = new HashSet(), capped = new HashSet(), pledged = new HashSet(), expledged= new HashSet();
    Set<region> AXB = new HashSet(); 
    Map<region, Float> mac = new HashMap(), abateshare = new HashMap(),  intensitydecline =new HashMap(), adjbase=new HashMap();
    Map<region, Integer> midinc_sy = new HashMap();
    Map<region,Integer> dur=new HashMap(50);

   
    float participtot;
    boolean policyscenario;
    controller co;
    
    
    //================ SET CURVES =================
    void setnational() {
            efq =eq.emitfos_nat;
            elq=eq.emitluc_nat;
            emq=eq.emitch4_nat;
            enq=eq.emitn2o_nat;
            eeq= eq.emitequiv_nat;
            efb = eb.emitfosbase_nat;
            emb =eb.emitch4base_nat;
            enb =eb.emitn2obase_nat;
            pop=gm(popgdp.class).pop_nat;
            gdp=gm(popgdp.class).gdp_ppp_nat;
    }
    void setregional() {
        //note - also used by calcequiv?
             efq=eq.emitfos;
             elq=eq.emitluc;
             emq=eq.emitch4;
             enq=eq.emitn2o;
             eeq= eq.emitequiv;
             efb=eb.emitfosbase;
             emb=eb.emitch4base;
             enb=eb.emitn2obase;
             pop=gm(popgdp.class).pop;
            gdp=gm(popgdp.class).gdp_ppp;
    }
    

    //**************** PRE CALC (future) ***********************************
    public void precalc() {
        setnational(); //start using nations - until  2050
        initregions(true);
        //moved from objective - prob if affects other modules before this in loop?
        dur.clear();
        policyscenario = !(gm(controller.class).objective.chosen == controller.objopt.nopolicy);
    }

    //**************** CALC LOOP (bottom-up part)  ***********************************
    public void calcstep() {
        if (year >= fsyfos) { //history is filled in pledges or emitquota
    
// note: exclude bunker, this is now set in AviaShipEmit future-mitigated loopcalc which must be calculated *before* shares

            //after 2051 apply shares rules to regions, rather than to nations
            if (year==2051){ setregional(); initregions(false); }
            
            //maybe only need if (year<sy || distribution.chosen=="sresdist") but skipping this causes some problems with convergence (depending on sequence of parameter changes)
            if (!policyscenario) { settobase(); settobase_ogas(); }
            if (policyscenario) {
                setparticipate(); //must do before set-to-base
                settobase(); //excludes pledged - so have to know which these are first
                settobase_ogas();
                if (midincaction.chosen != no_deviation) developing_bottomup(); //this affects the mid-income group - also calculates what's left for particip
                distriboptions dc = distribution.chosen;
                //if (dc==newmix) newmix();
                //options below should all affect the particip group only
                if (dc == grandfather) for (region r : particip) efq.set(r, efq.get(r, year - 1));
                if (dc == sresdist) for (region r : particip) efq.set(r, efb.get(r)); //shouldn't be necessary              
         //               if (year ==2020) for (region r : reg_allnb) deb(" " +year +" "+r+" "+efq.get(r));
                if (dc == convergence) converge();
         
                //if (dc == leastcost) leastcost(); //CHECK ONLY AFFECTS PARTICIP
                if (dc == responsibility) responsibility(); //CHECK - depends on emittot & participtot previously set in developing_bottomup
                } //policyscenario

            if (co.botuptopdo.chosen==bottom_up_only ||  (co.botuptopdo.chosen==start_bottom_up && year<(int)co.startyear_topdown.getval())) bottomup_total();

            } //future
    } //end main calcstep

    //**************** CALC LOOP (top-down part)  ***********************************
public loopcalc topdown=new loopcalc("shares-topdown-scaling") {

  public void calcstep() {
      if (year >= fsyfos) {

          if ( co.botuptopdo.chosen==top_down_only ||  (co.botuptopdo.chosen==start_bottom_up && year>=(int)co.startyear_topdown.getval())) {
                 if (policyscenario) scaleandcapparticip();
     if (checkscaling.istrue()) {
                /* now topdownscale converts all to correct global total
                true=exclude bunker (which was scaled in AviaShipEmit)
                if (distribution.chosen!=brazilian) - this exclusion should't make a difference - check! P3
                 */
             //deb("year="+year +" bunker="+efq.get("bunker"));
            //if (year<=2050) efq.set("bunker", eq.emitfosquota.get("bunker"));
             // }
         /**
          * This is no longer correct - exclude bunker reduces what's available to all countries including pledges - although it only applies after startyear_topdown
          */

                efq.topdownscale(gm(carboncycle.class).fossil.get(), true);
                }
            }
          efq.calctot();
          //moved out of the botupdodo if - as for the moment there is no other bottom-up formula applied to these gases
          emq.topdownscale(gm(othgasemit.class).ch4emit.get());
           enq.topdownscale(gm(othgasemit.class).n2oemit.get());

            //calcequiv(); //also calctot for other gases - moved to emit quota
           
        } //future
      

    } //end calcstep

 }; //end topdown loopcalc

    //===== SET TO BASE ============
        void settobase() {
        //first fill the emitquota to a baseline - for both history and future
       if (year==fsyfos) for (region r : reg_allnb) adjbase.put(r, efb.get(r, year-1));
       if (year==2016 || year ==2021 /*|| year==2036*/ ||year == 2051) {
                intensitydecline.clear();
               for (region r : reg_allnb) {
                        // this is the decline rate (lambda) A=A0 exp{-lt} => - lambda = log (2020/2005) / 15
                intensitydecline.put(r, intensdeclinefac(r, 15) );
               //deb("id for "+r+" in " +year +" = "+intensitydecline.get(r) + " oldgdp= "+gdp.get(r,year-16)+ " oldemit=" + efq.get(r,year-16));
               }
       }
//changed May2016 2012=>2016, also 2013 => 2016 above ( maybe should be 2017 but gives error ??)
       int baseyr=(year>2050 ? 2050 : /*year>2036 ? 2036 :*/ year>2030 ? 2030 : 2016), convtime=20;
       float f=convfac(baseyr, baseyr+convtime, (float)cvf.getval());
        for (region r : reg_allnb) {
                    if (!pledged.contains(r)) {
                        switch (smoothjumpbase.chosen) {
                            case no_smooth : { efq.set(r, efb.get(r)); break; }
                            case exp_convergence : {
                                if (year>=baseyr+convtime) efq.set(r, efb.get(r)); 
                                else {
                                    efq.set(r,  zeroifnan(  adjbase.get(r) - f * (adjbase.get(r) - efb.get(r))));
                                    //if (r.name.equals("IND")) deb("conv "+year +" "+r.name+" "+er+" "+efb.get(r)+" "+f +" "+efq.get(r));
                                }
                                break; }
                            case intensity_based :  {
                                
                                float intensity_based_emit = gdp.get(r)*(efq.get(r, baseyr)/gdp.get(r,baseyr))* (float)Math.exp(intensitydecline.get(r)*(year-baseyr));
                                //float  intensity_based_emit = gdp.get(r)*(efq.get(r, year-1)/gdp.get(r,year-1))*(float)Math.exp( intensdeclinefac(r, 5)*1f);
                                //if (intensity_based_emit <  efb.get(r) ) efq.set(r,  intensity_based_emit); //( intensity_based_emit+ efb.get(r)) /2f); //average
                                //if (expledged.contains(r) )  efq.set(r, intensity_based_emit);
                                if (Float.isNaN(intensity_based_emit) || Float.isInfinite(intensity_based_emit)) intensity_based_emit= efb.get(r);
                                //deb("intensity based smooth r="+r.name+ " "+year+" "+intensity_based_emit);
                                float frac = (float)Math.exp(-(float)(year-baseyr)/convtime);
                                efq.set(r, frac*intensity_based_emit + (1f-frac)*efb.get(r));
                                        //(intensity_based_emit*(baseyr+convtime - year)+ efb.get(r)*(year - baseyr))/convtime);
                                break; }
                 } //switch
                 adjbase.put(r, efq.get(r)); //store before other methods adust it
                 } //if !pledged
                 else adjbase.put(r, efb.get(r)); // in case relevant to pledged...
            }//r
     } //settobase

    float intensdeclinefac(region r, int gap) {
        return (float)Math.log((efq.get(r,year-1)/gdp.get(r, year-1))/(efq.get(r,year-(1+gap))/gdp.get(r,year-(1+gap)))) /(float)gap ;
    }

    void settobase_ogas() {
            for (region r : reg_allnb) {
           // if (incbunk) efq.set("bunker", efb.get("bunker"));
            emq.set(r, emb.get(r));
            enq.set(r, enb.get(r));
        }
    }

        //===== BOTTOM UP TOTAL ============
        void bottomup_total() {
            float emittot=0;
            for (region r : reg_all) emittot+=efq.get(r); 
            emittot+=efq.get("bunker",year-1);
            //temporary fix to use year-1 - as bunker is set by aviashipemit mitig which runs after this (depending on total!) (note reg_all should include bunker)
            gm(carboncycle.class).fossil.set(emittot);
        }


    //******** INCREASING PARTICIPATION **********
    /* Set up initial participants lists
     * Now called twice - at beginning (init=true), and in 2051 when switch from nations BU to regions
     */
    void initregions(boolean init) {
        if (init && logparticip.istrue()) deb("\n===========================");
        reg_all = init? regman.nations.reg : (gm(regset.class).regions.chosen).reg;
        reg_allnb.clear();
        reg_allnb.addAll(reg_all);
        reg_allnb.remove("bunker");
        if (init) makeKyotoAxB();

        if (!init && logparticip.istrue() && !notparticip.isEmpty()) {  // write info before clear nations
            String finparticip = "\nAfter 2050 all join participating group, adding: ";
            for (region r : pledged) finparticip+=r+" (end pledge), ";
            for (region r : notparticip) finparticip+=r+", ";
            deb(finparticip+"\n============================\n");
        }

           particip.clear();
           notparticip.clear();
           pledged.clear();
           expledged.clear();
           midinc_sy.clear();
            mac.clear();
            abateshare.clear();  //probably not necessary - check leastcost code

          if (!init) {
             //assume all participate after 2050 - difficult to continue mixed mode after transition to regions
            particip.addAll(reg_allnb);
            notparticip.clear();
            return;
        }

            Set<region>hastarget=pl.targets.keySet();
            boolean usepledges=pl.usepledges.istrue();
            if (usepledges) pledged.addAll(hastarget);

            if (initgroup.chosen == all_from_start && usepledges ) particip.addAll(pl.notarget);   
            if (initgroup.chosen == all_from_start && !usepledges )  particip.addAll(reg_allnb);
            if (initgroup.chosen == all_CA_pledges && usepledges )  notparticip.addAll(pl.notarget);   //no other particip - all pledged
            if (initgroup.chosen == all_CA_pledges && !usepledges ) { particip.addAll(hastarget); notparticip.addAll(pl.notarget); } //bizarre combination - use pledge list but not numbers!
            if (initgroup.chosen == Kyoto_Annex_B && usepledges ) { particip.addAll(AXB);  particip.removeAll(pledged); notparticip.addAll(pl.notarget); notparticip.removeAll(AXB);  }
            if (initgroup.chosen == Kyoto_Annex_B && !usepledges ) { particip.addAll(AXB); notparticip.addAll(reg_allnb);  notparticip.removeAll(AXB);  }
            if (initgroup.chosen == none && usepledges )  notparticip.addAll(pl.notarget); //starts same as third option - but differs later
            if (initgroup.chosen == none && !usepledges ) notparticip.addAll(reg_allnb);
           //
            if (logparticip.istrue()) {
                String initparticip="";
                if (!pledged.isEmpty()) initparticip+="\nWith pledges: ";  for (region r: pledged) initparticip+=r+", ";
                if (!particip.isEmpty()) initparticip+="\nOthers in initial group ("+initgroup.chosen+") : ";  for (region r: particip) initparticip+=r+", ";
                deb(initparticip);
                }
    }


    //set initial state - participating or not - depending on initgroup parameter - called at start and after pledges expire
    boolean init_participate(region r) {
            if (initgroup.chosen == all_from_start) return true;
            if (initgroup.chosen == Kyoto_Annex_B) return (AXB).contains(r);
            if (initgroup.chosen == all_CA_pledges) return pl.targets.keySet().contains(r);
            return false; // option none
    }


    //Work out changes in  participation - based on previous years data (easier to compute and more realistic policy)
    void setparticipate() {
        String [] names=new String[] {"","","",""};

        //first handle expiring pledges
        if (pl.usepledges.istrue()) {
         if (year<=2020) return; //prevent any further participation changes before 2020
        //if (year<=2015) return; //prevent any further participation changes before 2015 review...? as problem when only small set not particip
        boolean skip= (year>2030 && pl.beyond2030.isfalse());
        	//for (region r : reg_allnb) deb(r.name + pledged.contains(r) + pl.endtarget.get(r));
        
            for (region r : reg_allnb) try { if ( pledged.contains(r) && (year>pl.endtarget.get(r) || skip)) { //avoid concurrent modification error when removing from within for (region r: pledged)
                pledged.remove(r);
                if (init_participate(r)) {
                particip.add(r);
                names[0]+=r.getName()+", ";
                }
                else  {
                notparticip.add(r);
                expledged.add(r); 
                names[1]+=r.getName()+", ";
                }
             }
        } catch (Exception e) { deb(r.getName()+" "+year); e.printStackTrace();  }
       }//expiring pledges

        float poptot = 0, fostot = 0, fracpop, fracemit;
        if (notparticip.isEmpty()) return;
        //participate if emissions / capita (last year) > average
        if (emitlim.chosen != nolim) {
            for (region r : reg_allnb) {
                if (emitlim.chosen == worldemitpercap || init_participate(r) || particip.contains(r)) {  // include initial participating group, and those that joined particip, but not all pledged
                    poptot += pop.get(r, year - 1);
                    fostot +=  efq.get(r, year - 1);
                    }
                }

            for (region r : notparticip) if (efq.get(r, year - 1) /pop.get(r, year - 1) > fostot / poptot) {
                particip.add(r);
                names[2]+=r.getName()+", ";
                }
            notparticip.removeAll(particip); //can't include in loop => concurrent modification error
        }
        for (region r : notparticip) {
            float gdppercap = gdp.get(r) / pop.get(r);
            //participate if pass gdp/cap threshold
            if (richjoin.istrue() && gdppercap > axb_gdp_threshold.getval()) {
                particip.add(r);
                names[3]+=r.getName()+", ";
            }

            //if country leaves LDC category, start counting years for cumulative reduction
            if (!midinc_sy.containsKey(r) && gdppercap > ldc_gdp_threshold.getval()) midinc_sy.put(r, 0);
        }

        notparticip.removeAll(particip); //can't include in loop => concurrent modification error
        expledged.removeAll(particip);

        if (logparticip.istrue()) {
              String[] info =new String[]{
            ""+year+": end pledge & continue participating (within initial-group "+initgroup.chosen+") : ", //
            ""+year+ ": end pledge & leave participating group : ", //
            ""+year+ ": participate as emit/cap > avg (" + fostot / poptot + ") : ", //
            ""+year+ ": participate as GDP/cap > " + axb_gdp_threshold.getval()+" : "
        };
          for (int i=0; i<4; i++) if (!names[i].equals("")) deb(info[i]+names[i]);
            if (notparticip.isEmpty()) deb("\n ============================\n");
        }

      }

        //midinc_sy.keySet().removeAll(particip); //keep to avoid sudden jump up
        /**
        if (year>2019 && year<2024) { deb(""+year+":");
            String info="pledged= "; for (region r: pledged) info+=r+" "; deb(info);
            info="particip= "; for (region r: particip) info+=r+" "; deb(info);
            info="notparticip= "; for (region r: notparticip) info+=r+" "; deb(info);
            }
        **/

      //this code was needed when starting with regions rather than nations,  may be unnecessarily complicated now
    //note just one nation in AXB is enough to classify whole region!
    void makeKyotoAxB() {
        Set<region> A1nat = regman.allreg.findreg("AXB").subreg(regman.nations); //set of Nations
        checkreg:
        for (region r : reg_allnb) {
            Set<region> rn = r.subreg(regman.nations);

            for (region rr : rn) if (A1nat.contains(rr)) {
                AXB.add(r);
                    continue checkreg;
                }
        }
    }

    void developing_bottomup() {
        /* reduce emissions of dc that are in the middle income group (gdp/cap> lower threshold, not yet particpants)
         * option redrelbase: reduce emissions (and hence intensity) by  x%/yr wrt baseline
         * note this reduction should continue even after they join particip group (otherwise sudden jump up!), but the year- gap doesn't keep increasing
         * option redint: reduce emissions intensity by x%/yr (absolute) - but only apply if less than baseline
         * note efq first set to efb in calcstep
         */
            for (region r : midinc_sy.keySet()) {
                int yd = midinc_sy.get(r);
                if (notparticip.contains(r)) {
                    yd++;
                    midinc_sy.put(r, yd);
                }

                float fracreduce = (float) Math.pow((1.0 - dc_reduction.getval() / 100f), yd);
                if (midincaction.chosen == redrelbase && yd > 0) efq.set(r, (adjbase.get(r) * fracreduce)); //was efq - but this may diverge from adjbase
                if (midincaction.chosen == redint && yd > 0) {
                    //not properly adusted to use adjbase rather than efq - expect problems if conbine exp_conv smoothing
                    float intensity = (efq.get(r, (year - yd)) / gdp.get(r, (year - yd))) * fracreduce;
                    efq.set(r, Math.min(intensity * gdp.get(r), adjbase.get(r)));
                }

            }
        
       //calculating participtot used to be done here
    }

    void scaleandcapparticip() {
         //add up all DC emissions to calculate what's left for the particip group
        //this moved from develop_bottomup - now it comes at beginning of topdown loopcalc in order to follow stabilisation
        float emittot = 0;
        for (region r : notparticip) emittot += efq.get(r);
        for (region r : pledged) emittot += efq.get(r);
        participtot =      gm(carboncycle.class).fossil.get() - efq.get("bunker") - emittot;

        float excess = scaleandcap(particip, participtot);
        /* 
        if excess <0, it's because total after capping is greater than available to the participating group
        by this stage, all must be capped, we have to reduce more in the medium-income DCs
        P3 in theory a better alternative here would be to exceed the global target temporarily - but that could break the stabilisation iteration
         */
        if (excess < 0) {
            float midinctot = 0;
            Set<region> midinc = new HashSet(midinc_sy.keySet());
            midinc.removeAll(particip);
            for (region r : midinc) midinctot += efq.get(r);
            excess =scaleandcap(midinc, midinctot + excess);
        }
        /*
        if excess still <0 have really run out of emissions space, have to scale all down!
         */

        if (excess < 0) {
            float alltot = 0;
            for (region r : reg_allnb) alltot += efq.get(r);
            float fac = (gm(carboncycle.class).fossil.get() - efq.get("bunker")) / alltot;
            for (region r : reg_allnb) efq.set(r, efq.get(r) * fac);
        }
    }

    float scaleandcap(Set<region> group, float grouptot) {
        boolean somechange;
        Set<region> group2=new HashSet(group), toremove=new HashSet(5);
        float emittot, rate, oldrate, fac;
        capped.clear();
        float rc = (float) rate_constraint.getval() / 100f;
        float d2rc = (float) d2rate_constraint.getval() / 100f;

        itloop: do {
            somechange = false;
            emittot = 0;

            //scale to fit within group total
            for (region r : group2) if (!capped.contains(r)) emittot += efq.get(r);
            fac =  grouptot / emittot;
            for (region r : group2) if (!capped.contains(r)) efq.set(r, efq.get(r) * fac);

            //check for efq>efb
            if (convifred.istrue()) {
                for (region r : group2) if (efq.get(r)>adjbase.get(r)) {
                    efq.set(r, adjbase.get(r));
                    toremove.add(r);
                    grouptot-=adjbase.get(r);
                    somechange=true;
                }
                for (region r : toremove) group2.remove(r); toremove.clear();
                if (somechange) continue itloop;
            }

            //===== rate caps =========
            if (!(rate_caps.istrue()) || year < fsyfos + 10) return 0; //ignore caps at beginning - due to initial fluctuations
            //apply rate constraints
            checkreg:
            for (region r : group2) if (!capped.contains(r)) {
                    rate = efq.get(r, year) - efq.get(r, year - 1);
                    oldrate =efq.get(r, year - 1) - efq.get(r, year - 2);

                    //deceleration rate cap - note this can cause problems as countries hit bottom
                    if (rate < 0 && (rate - oldrate) / efq.get(r) < -d2rc) {
                        efq.set(r, efq.get(r, year - 1) * (1f - d2rc) + oldrate);
                        somechange =true;
                    }

                    //max decline rate cap
                    rate = efq.get(r, year) - efq.get(r, year - 1);
                    if (rate / efq.get(r) < -rc) {
                        efq.set(r, efq.get(r, year - 1) * (1f - rc));
                        somechange = true;
                    }

                    if (somechange) {
                        capped.add(r);
                        if (efq.get(r) < 0) efq.set(r, 0);
                        //if (efq.get(r) > efb.get(r)) efq.set(r, efb.get(r)); // shouldn't be necessary!
                        grouptot -=efq.get(r);
                    }

                }
        } while (somechange);
        return grouptot;
    }


//******** CONVERGENCE *****************************
    void converge() {
        int cyear = (conv_criteria.chosen == emissionspercapita && year > (int)popcoy.getval() && popcoyoption.istrue()) ? (int) (popcoy.getval()) : year;

        float f =
                (year >= convergey.getval()) ? 1
                : (exponential.istrue()) ? convfac(fsyfos, (int)convergey.getval(), (float)cvf.getval())
                : convfac((int)convergey.getval());

        float poptot = 0, gdptot = 0, emittot = 0; //note if implement  a standard world total region for all regional data, can use this instead

        for (region r : particip) {
            poptot += zeroifnan( pop.get(r, cyear) );
            gdptot += zeroifnan( gdp.get(r, cyear) );
            emittot += zeroifnan( efq.get(r, year - 1) ); 
        }
        
//main convergence formula
                          float cr = 1, er;
        for (region r : particip) {
            if (co.botuptopdo.chosen==bottom_up_only ||  (co.botuptopdo.chosen==start_bottom_up && year<(int)co.startyear_topdown.getval()))  {
                 // bottom up case - aim for a target
                if (conv_criteria.chosen == emissionspercapita) cr = (float) ( pop.get(r, cyear) * percap_target.getval());
                if (conv_criteria.chosen == emissionspergdp) cr = (float) (gdp.get(r, cyear) * pergdp_target.getval())/1000000f;
                er =  efq.get(r, year - 1);
             }
             else {
             //topdown case: this sets a fractional share -  normalising to correct total done later by topdownscale
            if (conv_criteria.chosen == emissionspercapita) cr = (float) pop.get(r, cyear) / poptot;
            if (conv_criteria.chosen == emissionspergdp) cr = (float) gdp.get(r, cyear) / gdptot;
            er =  (Float.isNaN(efq.get(r, year - 1)) ? 0 : efq.get(r, year - 1)) / emittot;
            }
            efq.set(r, zeroifnan( (float) (er - f * (er - cr))));
        } //r
    } //end convergence

    //linear convergence
    float convfac(int ey) {
        return 1f / (float)(1 + ey - year);
    }

    //exponential convergence
    // in ey-1 => 1, in sy+1 =>  exp(-cvf), in general = exp(yr*cvf/(ey-sy) * const
    float convfac (int sy, int ey, float cvf) {
         float cf = cvf /   (float) (ey -sy);
        return (float) Math.exp(cf * (float)(year - ey - 1));
    }

    float zeroifnan(float i) {
        if (Float.isNaN(i)) return 0; else return i;
    }

    //********** RESPONSIBILITY ****************
    /*
    Based on Brazilian proposal
    Reduction in each year is proportional to share of cumulative responsibility
    
    Note responsibility endyear should be set to 2100!
    Otherwise the relative increase in DC responsibility isn't considered    
     */
    void responsibility() {

        float tempinctot = 0, tempincp = 0, oldemittot = 0, totreduce;

        int respyear = (int) Math.min(year - 1, (int)resp.endyear.getval());

        for (region r : particip) if (efq.get(r, year - 1) > 0) {
                tempinctot += attr.surftemp.get(r, respyear);
                oldemittot +=
                        efq.get(r, year - 1);
            }

        totreduce = oldemittot - participtot;
        if (totreduce < 0) {
            deb("Problem applying Brazilian proposal: total reduction positive in " + year);
            return;
        }
        for (region r : particip) {

            float fr = attr.surftemp.get(r, respyear) / tempinctot; //fraction responsibility
            efq.set(r, efq.get(r, year - 1) - totreduce * fr);
            if (efq.get(r, year) < 0) efq.set(r, 0);
        //if (efq.get(r,year)>efb.get(r,year)) efq.set(r, efb.get(r,year));
        }

    } //end responsibility


 } //end  class
//*************************************

