/** This module loads files of historical socioeconomic and emissions data and blends them together to fill some gaps.
 * The data is kept here in the original countries - the conversion to larger regions is doee in history.java using seperate curvesets 
 * This national data is never changed after startup, so there are no interactions and the curvesets are static
 * Their contents can be viewed in expert complexity level
 
 */
package jcm.mod.regemit;

import java.util.HashMap;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.*;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.*;
import jcm.core.tls.fileio;
import jcm.mod.socio.histsocdata;
import static jcm.core.data.loadtable.*;
import static jcm.core.report.*;

public class histemitdata extends module implements dataholder {
    boolean done = false;
    static int cdiacey=2013, fosey=histsocdata.weo_ey;
    public static curveset //
            fosCO2 = new curveset("fosCO2", "kilo&ton&carbon", 1750, fosey, complexity.expert), //extrapolated using gdp for last years  
            fosCO2BP= new curveset("fosCO2BP", "mega&ton&carbon", 1965, 2010, complexity.expert),
             epaCH4 = new curveset("epaCH4", "mega&ton&CH4", 1990, 2020, 5, complexity.expert), //
             epaN2O = new curveset("epaN2O", "mega&ton&N2O", 1990, 2020, 5, complexity.expert); //

    /*Note: this module fillhistdata must be done *after* histsocdata fills the GDP
     * Likewise, this module fillhistdata must be done before aviashipemit history
     * => put all three here
     */ 
    public void initsetup() {
        if (!done) {
            histsocdata.fillhistdata(); 
            fillhistdata();
            gm(AviaShipEmit.class).aviashiphistory();
            done = true;
        }
    }

    public static void fillhistdata() {
        loaddata(fosCO2, "data/hist/cdiacrows.csv", ",", false, 1f, 1750, cdiacey, 1750);
       // remove a few negative values at end of WW2 esp in Carribean - but note small positive spike remains - were the negative values offsetting something else?
        for (Object o : fosCO2.map.keySet())  for (int y=1750 ; y<=cdiacey; y++) if (fosCO2.get(o,y)<0)  fosCO2.set(o,y,0);
        
        //REMOVED UNFCCC data - needs update!
        //loaddata(fosCO2, "data/hist/UNFCCC_CO2emit.csv", ",", false, 12f / 44f, 1990, 2002, 1990);    // use 1990-2002 for countries with data
        //extrapBP();
        //extendFos2007(); - no longer needed as CDIAC goes to 2008
        
        loadtable.oldsplit(fosCO2, 2000);    // split former soviet union, czech, yugoslavia
         extendfos(2014,2016);  
        extrapfosecon(cdiacey+1, fosey, 4); // based on last X years trend in emissions intensity - set to avoid strange years eg 2008-9
        for (int y = 1750; y <= fosey; y++) fosCO2.calctot(y);
        
        // original data was mega ton CO2eq, divide by GWP=23 to get mega ton CH4
        //corrected jun2010 - EPA report used SAR GWPs = 21 !!
        loaddata(epaCH4, "data/hist/EPA_CH4.csv", "\t", false, true, 1f / 21f /**23**/, 1990, 2020, 1990, 5);

        // original data was mega ton CO2eq, divide by GWP=296 to get mega tonN2O, 
        //corrected jun2010 - EPA report used SAR GWPs = 310 !!  
        //OLD! then multiply 28/44 for N2O=> N (for consistent units with rest of JCM, as IPCC)  removed after change units to Mt N2O
        loaddata(epaN2O, "data/hist/EPA_N2O.csv", "\t", false, true, /**(28f / 44f)* **/ (1f / 310f /**296**/), 1990, 2020, 1990, 5);

    }

    static Map<region, Integer>  lastdata=new HashMap();
    static void extendfos(int ys, int ye) {
        String[][] tab= fileio.loadtab("data/hist/CO2_2014_2016.tab", "\t");
        for (int i=4; i<tab.length; i++ ){

            if(tab[i].length==0) continue;            
            String cn=tab[i][0];
            if (cn.equals("") || cn.startsWith("Total") || cn.startsWith("Other") || cn.startsWith("China Hong Kong")) continue;
            //JCM doesn't have a separate region for HK, be careful not to scale China with HK data
            region r=regman.nations.findreg(cn);
            if (r!=null) {
                curve c=fosCO2.getcurve(r);
                if (c!=null) {
                    int y=ys-1;
                    float e=c.get(y);
                    for (int j=1; j<(2+ye-ys); j++) {
                        if (tab[i].length<=j || tab[i][j].length()==0) continue;
                        e*=(1f+0.01f*Float.parseFloat(tab[i][j].replace("%", "").replace(",",".")));
                        y=ys-1+j;
                        c.set(y, e);
                        //deb("extendfos "+r.getName()+" "+y+": "+e);
                        lastdata.put(r, y);
                    }
                }
            }
        }
    }

    /* try {
        } catch (Exception e) {
            deb("problem at line"+i+" "+e);
                for (int j=0; j<tab[i].length; j++) deb(tab[i][j]);
            }*/


    /* extrapolate fossil CO2 using GDP_PPP growth rate * emissions intensity
     * extrapolate emissions intensity assuming exponential decay  calibrated from previous X years
     * if EI increased in calib period, cap it constant   
     * if problem with GDP data (very small countries), assume constant emissions
     */
    static void extrapfosecon(int ys, int ye, int histy) {
        String lackdata = "";
        curveset GDP_PPP = histsocdata.GDP_PPP;
        for (region r : regman.nations.reg) {
            int y0= lastdata.containsKey(r) ?  lastdata.get(r): ys-1;  /*fosCO2.gotdata(r, 2009) */
            float gdp, gdp0 = GDP_PPP.get(r, y0 - histy), ei, rate = 0;
            boolean ok = true;
            ylp:
            for (int y = y0+1; y <= ye; y++) {
                gdp = GDP_PPP.get(r, y-1);
                if (ok && !(gdp > 0 && gdp0 > 0)) {
                    ok = false;
                    lackdata += r.name + " ";
                }
                if (!ok) {
                    fosCO2.set(r, y, fosCO2.get(r, y-1));
                    continue ylp;
                }
                ei = fosCO2.get(r, y - 1) / gdp;
                if (rate == 0)   rate = (float) Math.pow(ei / (fosCO2.get(r, y - 1 - histy) / gdp0), (1f/histy)); //deb(r.getName()+" rate "+rate+" in "+y );}
                if (rate >1.02f) rate =1.02f; else if (rate <0.94f) rate =0.94f; //cap between +2% and -6%, noting -2% is about average 
                ei *= rate;
                fosCO2.set(r, y , ei * GDP_PPP.get(r, y ));
            }
        }
        if (lackdata.length() > 0) deb("Lacking GDP data to extrapolate to "+ye+" for: " + lackdata);
    }

    /*
    static Set<region>  gotBP=new HashSet();
    static void extrapBP() {
        loaddata(fosCO2BP, "data/hist/BP_CO2_to2010.txt", "\t", false, 12f / 44f, 1965, 2010, 1965);
        for (Object o : fosCO2BP.map.keySet()) {
            curve c=fosCO2.getcurve(o);
            if (c!=null) {
                gotBP.add((region)o);
                float r=c.get(2008)/fosCO2BP.get(o, 2008);
                //c.set(2009, r*fosCO2BP.get(o, 2009));
                c.set(2010, r*fosCO2BP.get(o, 2010));
            }
        }
    }
    */
    
}    // end class

 //*************** Extend Emissions *******************
    /*
     * note since CDIAC update this is now only used for 2007! - see change in extend method
     * extension of fossil CO2 from 2004 to 2007 based on table published by MNP Netherlands 2008, derived from BP energy use statistics
     * data is from 2004 to 2007 in GtCO2 (not C)
     * note this includes cement production (unlike the previous version) - hence bigger especially in China
     * just use % change, not absolute numbers
     * have not yet applied bunker data!

    static void extendFos2007() {
        double[][] d = {
            {5.84, 5.87, 5.80, 5.90}, {3.42, 3.38, 3.39, 3.32}, {1.23, 1.25, 1.23, 1.25},
            {0.56, 0.56, 0.55, 0.55}, {0.48, 0.50, 0.52, 0.51}, {1.58, 1.59, 1.67, 1.67},
            {1.57, 1.57, 1.61, 1.61}, {5.03, 5.57, 6.23, 6.72}, {1.18, 1.22, 1.28, 1.36},
            {0.36, 0.36, 0.37, 0.39}, {0.35, 0.38, 0.38, 0.37}, {1.51, 1.54, 1.56, 1.64},
            {1.04, 1.11, 1.17, 1.23}, {0.91, 0.96, 0.99, 1.05}
        };
        Object[] sets = {
            "USA", "West Europe", "Japan",
            "Canada", "Oceania", "Russia",
            new String[]{"East Europe +Ukraine", "Central Asia Stans", "Turkey"}, "China", "India",
            "Brazil",
            new String[]{"Mexico", "South Africa", "Saudi Arabia", "Iran"},
            new String[]{"Indonesia", "Singapore", "Malaysia", "Thailand", "South Korea", "Taiwan"},
            "Other", "Bunker"
        };

        ss:
        for (int i = 0; i < 12; i++) {
            if (sets[i] instanceof String) {
                extend((String) sets[i], d[i]);
                continue ss;
            }

            for (String s : (String[]) sets[i]) {
                extend(s, d[i]);
            }
        }    // ss

        for (region r : regman.nations.reg) {
            if (!(fosCO2.get(r, 2007) > 0)) {
                extend(r, d[11]);    // other
            }
        }

    // extend(regman.allreg.find("Bunker"), d[12]);
    }

    static void extend(String s, double[] d) {
        region r = regman.allreg.findreg(s);

        if (r == null) {
            deb("extendfos can't find region set " + s);
            return;
        }

        if (regman.nations.contains(r)) {
            extend(r, d);
            return;
        }

        for (region rr : r.subreg(regman.nations)) {
            extend(rr, d);
        }
    }

    static void extend(region r, double[] d) {
        fosCO2.set(r, 2007, (float) (fosCO2.get(r, 2006) * d[3] / d[2]));
    }

    */
