/*
 * Policy emissions, per region
 * (note per_nation is in pledges module)
 * Calcs CO2equiv, adds up the totals, normalises inc bunker etc.

P3 a more efficient way to organise this: if use no-policy, use pointers in curvesets to emitbase curves  - also have only one AAUsurplus, bunker etc.
alternatively: don't change emitquota and just use emitbase for global - make emitquota curves disappear if nopolicy
 P3 maybe AAUsurplus and bunker should be objects - how to search for all instances to convert? also be careful wrt topdownscale
 */

package jcm.mod.regemit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.ogas.othgasemit;
import jcm.mod.socio.popgdp;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import static jcm.mod.obj.controller.objopt.*;

public class emitquota extends module {

 //================= CURVES ==============================
    //those ending in _nat are national 1990-2050, others are regional for full time period
    public curveset 
            emitfos = new curveset("emitfos", "mega&ton&carbon", simplest), //
            emitfos_unitsCO2 = new curveset("emitfos&unitsCO2", "mega&ton&CO2", 1890, 2100, expert), //
            emitfos_nat = new curveset("emitfos&national", "mega&ton&carbon", 1990, 2050, expert),
             emitluc = new curveset("emitluc", "mega&ton&carbon"), //
             emitluc_nat = new curveset("emitluc&national", "mega&ton&carbon", 1990, 2050, experimental),
             emitch4 = new curveset("emitch4", "mega&ton&CH4"), //
             emitch4_nat = new curveset("emitch4&national", "mega&ton&CH4", 1990, 2050, expert),
             emitn2o = new curveset("emitn2o", "mega&ton&N2O"), //note changed units - was N
             emitn2o_nat = new curveset("emitn2o&national", "mega&ton&N2O", 1990, 2050, expert),
             emitequiv = new curveset("emitCO2eq", "mega&ton&CO2&eq", 1890, 2100,  normal),
             emitequiv_nat = new curveset("emitCO2eq&national", "mega&ton&CO2&eq", 1990, 2050, experimental), //CHECK is this ever filled??
             emitfosabate; //

curveset[] regional=new curveset[]{ emitfos, emitluc, emitch4, emitn2o, emitequiv, emitfos_unitsCO2, emitfosabate };
curveset[] national=new curveset[]{ emitfos_nat, emitluc_nat, emitch4_nat, emitn2o_nat, emitequiv_nat};


    //================= INTERACTIONS ======================

public void initsetup() {
        eb=gm(emitbase.class);
        emitfosabate = new curvar(curve.Type.difference, eb.emitfosbase, emitfos);
        regional[regional.length-1]=emitfosabate; //otherwise null!
        emitfosabate.mycomplexity = expert;
        emitfos.addOb(new curvar(curve.Type.ratio, emitfos, gm(popgdp.class).pop, emitluc));
        emitfos_unitsCO2.addOb(new curvar(curve.Type.ratio, emitfos_unitsCO2, gm(popgdp.class).pop, emitluc));
        emitequiv.addOb(new curvar(curve.Type.ratio, emitequiv, gm(popgdp.class).pop));

        fixregions.setaffectedby(gm(regset.class).regions);
        reghistory.setaffectedby(gm(regset.class).regions);
        reghistory.follows(eb.history);
        //note: history is not affectedby anything else, including params here

        regfuture.follows(reghistory); //necessary to specify or automatic?
        //regfuture.follows(gm(pledges.class)); //shouldn't be necessary as shares follows pledges
        regfuture.follows(gm(globco2emit.class).calcco2eq);
        //setaffectedby(reghistory); setaffectedby(regfuture); //should be automatic
}

public void setinteractions() {
    //P3 what's the point of this dependency of reghistory on pledges - kyoto period is before fsyfos? + check dependencies - re other gases?
    policyscenario= (gm(controller.class)).objective.chosen!=nopolicy;
    reghistory.setaffectedby(gm(pledges.class), policyscenario);
    reghistory.setaffectedby(gm(controller.class).objective); //because when go to sres, need to re-run from 1990
    regfuture.follows(gm(shares.class).topdown ,policyscenario);
}

//======= VARIABLES ======
Map<region, Set<region>> reg_all_nb=new HashMap();
region regset;
emitbase eb;
boolean policyscenario=true;

    // *********** HISTORY  LOOP METHODS ************
    // note history methods only run when regions or regemit history changes!
    public loopcalc reghistory = new loopcalc("regional-emitquota-history") {
        
        public void calcstep() {

            if (year<fsyfos) {
            if (year>=1990 && year<fsyfos && !policyscenario) { settobase_nat();  } //cut- use pledges instead
            if (year>=1990 && year<fsyfos) { gm(shares.class).settobase_ogas(); } //temporarily here - maybe should move?
           //changed order so now included in the total!
           emitfos.set("bunker",eb.emitfosbase.get("bunker"));
           emitfos_nat.set("bunker",eb.emitfosbase.get("bunker"));

            if (year<1990) { settobase(); emitfos.calctot(); }
            if (year>=1990 &&  year < fsyfos) addupnat(); //should be same effect as settobase, but later base might diverge from 1990
            fillemitCO2();
            }
        }
    }; //reghistory



//******** FUTURE LOOP METHODS *************
public loopcalc regfuture = new loopcalc("regional-emitquota-future") {
public void precalc()   {
}

public void calcstep() {
    if (year>=fsyfos) {

    //replace what shares used to do in case of !policyscenario
    if (!policyscenario) {
    if (year<=2050) settobase_nat(); else settobase();
    }

     if(year<=2050) addupnat(); //after this, is filled directly by shares 
     fillemitCO2();
    }
    calcequiv(); //?? check old note: maybe redundant - but needs to be at end of calc order - remove from shares
}
}; //end regfuture

//******** FIX REGIONS *************
public loopcalc fixregions = new loopcalc("fix-regions") {
    public void precalc()   {

            for (curveset c : regional) try {  gm(regset.class).clearoldregions(c); } catch (Exception e) { deb("errror clearing "+c); log(e); }
            //needed for mappings of emitfosabate, -  maybe not most efficient method - and make sure done *after* emitfosbase...

            regset = (region) gm(regset.class).regions.chosen;
            reg_all_nb.clear() ;
            for (region r : regset.reg)  reg_all_nb.put(r, r.subreg(regman.nations));
            reg_all_nb.remove("bunker"); //shouldn't be necessary?

            // we want these on top of the stack 
            emitfos.getOrAddCurve("bunker").color = grey;
            emitfos_nat.getOrAddCurve("bunker").color = grey;
            emitfos_unitsCO2.getOrAddCurve("bunker").color = grey;
            emitequiv.getOrAddCurve("bunker").color = grey;
            emitequiv_nat.getOrAddCurve("bunker").color = grey;
            emitfos.getOrAddCurve("AAUsurplus").color =black;
            emitfos_nat.getOrAddCurve("AAUsurplus").color = grey;
            emitfos_unitsCO2.getOrAddCurve("AAUsurplus").color =black;
            emitequiv.getOrAddCurve("AAUsurplus").color =black;
            emitequiv_nat.getOrAddCurve("AAUsurplus").color =black;
            emitequiv.getOrAddCurve("HFC").color =pink;
            emitequiv_nat.getOrAddCurve("HFC").color=pink;
            emitequiv.getOrAddCurve("CFC").color =purple;
            emitequiv_nat.getOrAddCurve("CFC").color =purple;

    }
}; // end fixregions

//=========== ADD UP NATIONS =========
    //note could use interpolator fillregdata method instead (this may be slightly more efficient if for only one timestep - but is that necessary?)
//Map<curveset, curveset> addup= new HashMap();

void addupnat() {
        for (region r : reg_all_nb.keySet()) {
            for (int i=0; i<5; i++ ) if (i!=1 && i!=4) { //skip LUC and equiv temporarily - just use regions from futureluc module
                float sum=0;
            for (region rr : reg_all_nb.get(r)) sum+=(Float.isNaN(national[i].get(rr)) ? 0 : national[i].get(rr));
            regional[i].set(r, sum);
            }
        }
        for (int i=0; i<5; i++ ) regional[i].calctot(); //important for convergence to work first time in 2050 (and for plot)
        emitfos.set("bunker", emitfos_nat.get("bunker"));
        emitfos.set("AAUsurplus",  emitfos_nat.get("AAUsurplus"));
    }

    void settobase() {
        for (region r : reg_all_nb.keySet()) {
             emitfos.set(r, eb.emitfosbase.get(r));
             emitluc.set(r, eb.emitlucbase.get(r));
             emitch4.set(r, eb.emitch4base.get(r));
             emitn2o.set(r, eb.emitn2obase.get(r));
             }
         emitfos.set("bunker", eb.emitfosbase.get("bunker"));
         emitfos.set("AAUsurplus", 0);
    }

    void settobase_nat () {
        for (region r : reg_all_nb.keySet())  {
            emitluc.set(r, eb.emitlucbase.get(r)); //don't use nations for LUC
            for (region rr : reg_all_nb.get(r))  {
             emitfos_nat.set(rr, eb.emitfosbase_nat.get(rr));
             //emitluc_nat.set(rr, eb.emitlucbase_nat.get(rr));
             emitch4_nat.set(rr, eb.emitch4base_nat.get(rr));
             emitn2o_nat.set(rr, eb.emitn2obase_nat.get(rr));
             }
        }
        emitfos_nat.set("bunker", eb.emitfosbase.get("bunker"));
        emitfos_nat.set("AAUsurplus", 0); 
    }


    //might be better to have a param, to swap units CO2 or carbon, but then need to adjust all applications - eg in costs, responsibility, adding up total etc.
    //unless one set of curves can be a derivative of the other -without any extra memory / overhead?
    void fillemitCO2() { //all this does is provide convenient curve in units of CO2 rather than Carbon
        for (region r : regset.reg) emitfos_unitsCO2.set(r, emitfos.get(r) * 44f / 12f);
        emitfos_unitsCO2.set("bunker", emitfos.get("bunker")* 44f / 12f);
        emitfos_unitsCO2.calctot();
    }


    //************* EQUIV *****
     //calculate CO2 equivalent - see othgasemit for values used and adjustable parameter //
    void calcequiv() {
        if (year >= 1890 && year <= 2100) { //note year range because of lack of other gas data
        List<region> rr = (gm(regset.class).regions.chosen).reg; rr.remove("bunker");
        for (region r : rr) {
            //note N2O conversion corrected jun 2010
            othgasemit.gwp gwp_chosen=gm(othgasemit.class).gwp_source.chosen;
            emitequiv.set(r, (emitfos.get(r) + emitluc.get(r)) * 44f / 12f + emitch4.get(r) * gwp_chosen.ch4 +emitn2o.get(r) * gwp_chosen.n2o); // * 44f / 28f);
            //deb("set" +r+" "+year+" ="+eeq.get(r));
        }
        emitequiv.set("bunker", emitfos.get("bunker")* 44f / 12f);
        globco2emit gc= gm(globco2emit.class);
        emitequiv.set("HFC", gc.hfc_CO2eq.get());
        emitequiv.set("CFC", gc.cfc_CO2eq.get());

         emitequiv.calctot();
         emitch4.calctot();
         emitn2o.calctot();
         emitluc.calctot();
        }
    }


 } //end class
