package jcm.mod.regemit;

import jcm.mod.obj.globco2emit;

import java.util.List;

import jcm.mod.scen.sresBase;
import jcm.mod.scen.sspChooser;
import jcm.mod.scen.sspData;
import jcm.mod.socio.economy;
import jcm.mod.socio.popgdp;
import jcm.core.cur.*;
import jcm.core.data.interpolator;
import jcm.indata.matchdataOld;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.carbon.carboncycle;
import jcm.mod.energy.enerData;
import jcm.mod.energy.enerGeneral;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.*;
import jcm.mod.ogas.othgasemit;
import jcm.mod.obj.regset;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.mod.regemit.histemitdata.*;
import static jcm.mod.scen.sresimgdata.*;

public class emitbase extends module { //
    // ********* CURVES ******************
    //those ending in _nat are national 1990-2050, others are regional for full time period
    public curveset // by region
            emitfosbase = new curveset("emitfos&base", "mega&ton&carbon"), //
             emitfosbase_nat = new curveset("emitfos&base&national", "mega&ton&carbon", 1990, 2050, expert), //
             emitlucbase = new curveset("emitluc&base", "mega&ton&carbon"), //
             //emitlucbase_nat = new curveset("emitluc&base&national", "mega&ton&carbon", 1990, 2050,expert), //
             emitch4base = new curveset("emitch4&base", "mega&ton&CH4"), //
             emitch4base_nat = new curveset("emitch4&base&national", "mega&ton&CH4", 1990, 2050, expert), //
             emitn2obase = new curveset("emitn2o&base", "mega&ton&N2O"), //note units changed
             emitn2obase_nat = new curveset("emitn2o&base&national", "mega&ton&N2O", 1990, 2050, expert); //

    public param usemod = new param("scale to model gdp", true);        

    sresBase srb;
    CalcLucEmit CLE;
    
    // *********** SETUP ******************

    public void initsetup() {
    	srb=gm(sresBase.class);  
    	CLE=gm(CalcLucEmit.class);
    	
    	
        history.setaffectedby(gm(regset.class).regions);

        history.follows(gm(CalcLucEmit.class));
        //P2 reconsider inverse carbon feedback affects history: inefficient because we don't need to recalc *regional* LUC if only exploring the global feedbacks
        history.setaffectedby(gm(carboncycle.class), CLE.lucsource.chosen.equals("Inverse") || CLE.lucsource.chosen.equals("Houghton"));

        future.follows(history);
        future.follows(gm(sspChooser.class)); //ch4 n2o
        future.setaffectedby(srb);  //  .scenario); //setaffectedby(gm(sres_base.class).sresext);
        //Changed May 2011 - generalised as also affected by other params inc fosconv, lucconv maybenot socconv but not important inefficiency
        future.setaffectedby(usemod);
        future.follows(gm(AviaShipEmit.class).emitbase);
        //note history also needs bunker set before calctot - but aviaemit history is run in initsetup
        follows(future);
        follows(srb.sresext);
        //futluc and sresext affect the curvesets but not the future method
        setaffectedby(gm(futureLUC.class).base);
        
        //future.setaffectedby(gm(popgdp.class).usemod); // not sure why necessary - something with sresext ? 
        

        emitfosbase.addOb(new curvar(curve.Type.ratio, emitfosbase, gm(popgdp.class).pop, emitlucbase));
    // emitfosbase.addAction(showpan.pan("percap histogram", histoplot.class, new qtset[]{emitfosbase, pop, emitlucbase }));
       
    }    //

    public void setinteractions() {
        //in case use IEA scenarios
        future.follows(gm(enerGeneral.class), gm(sresBase.class).useWEO.istrue());
        setaffectedby(economy.class, usemod.istrue());
    }

    //============== ref variables ============================
    region regset;
    //==========================================
    /* History and Future are separate loopcalcs to enable 
    different interactions (don't always need to recalc history if change future) 
    and different calculation order in loop: bottom-up history and top-down future
     * */
    // *********** HISTORY ************
    public loopcalc history = new loopcalc("emitbase-history") {
        public void precalc() {

            regset = (region) gm(regset.class).regions.chosen;
            List<region> reg = regset.reg;

            gm(regset.class).clearoldregions(this);
            for (region r : reg) emitfosbase.getOrAddCurve(r); // necessary so that shares emitfosabate works ... check still ok now in sep precalc

            interpolator.fillregdata(fosCO2, emitfosbase, regset, 0.001f);
            interpolator.fillregdata(fosCO2, emitfosbase_nat, regman.nations, 0.001f);
            fillhistluc();
            fillhistch4n2o();

            emitfosbase.getOrAddCurve("bunker").color = grey;


        } //end precalc
        //======= CALCSTEP ========
        //note: pledges depends on assumption not affected by emitbase calcstep, only precalc
        public void calcstep() {

            if (year < fsyfos) {
                float bunker = year > 1900 ? gm(AviaShipEmit.class).seb.get(AviaShipEmit.sec.tot_int) : 0;
                emitfosbase.set("bunker", bunker);
                gm(globco2emit.class).fossil.set(emitfosbase.calctot());
            }

            if (year < fsyog) {
                emitch4base.calctot();
                emitn2obase.calctot();
            }

        } //end calcstep
    }; // end history
    //
    //
    // *********** FUTURE ************
    public loopcalc future = new loopcalc("emitbase-future") {
        public void precalc() {

            regset = (region) gm(regset.class).regions.chosen;
            
            regemitfosbase();
            regch4n2o();    

        }//precalc

        public void calcstep() {
        	
        	if (usemod.istrue() && year > fsyfos) scalefosmod();
        	
            emitch4base.calctot();
            emitn2obase.calctot();
        }
    }; //end future

  //************ FUTURE REGIONAL CO2 ****************
    //note also top-downscaling in globco2emit, which includes correction to original sres and subtraction of bunker, also emitfosbase calctot 

    void regemitfosbase() {
 
    	interpolator in_fos=new interpolator(sres_image_fos.get(srb.scemit), 1000f);
        
        if (srb.useWEO.istrue()) {
        	
        	 curveset ebn=  emitfosbase_nat, g=gm(popgdp.class).gdp_ppp_nat; int gap=10;
            interpolator in_weo=new interpolator(gm(enerGeneral.class).IEAtotCO2);
             in_weo.fill(ebn, regman.nations, fsyfos, 2035, histemitdata.fosCO2, (float) srb.fosconv_WEO.getval());
             in_fos.fill(ebn, regman.nations, 2036, 2050, ebn, 2035, 100f); //2035 is end year for weights, 100= instant convergence
             //apply emissions intensity decline post 2035
            
             for (region r : regman.nations.reg) { 
                        float ei=ebn.get(r,2035)/g.get(r, 2035), eio=ebn.get(r, 2035-gap)/g.get(r, 2035-gap);
                        float declrate= (float)Math.log(ei/eio) /(float)gap ;
                        for (int y=2036; y<2051; y++) {
                            float intensity_based_emit = Float.isNaN(declrate) ? ebn.get(r, 2035) : g.get(r, y)* ei*(float)Math.exp(declrate*(y-2035));
                            //e.set(r, y, intensity_based_emit);
                            // smoother fraction - convergence by 2100
                            float frac=(1f+(float)Math.sin(Math.PI*(0.5f + (float)(y-2035)/65f  )  ) )/2f;
                            //jcm.core.report.deb(" "+y+ " "+frac);
                            //float frac=1f;
                            ebn.set(r, y, frac*intensity_based_emit+(1f-frac)*ebn.get(r, y));
                        }
             }
        }
        else {
            in_fos.fill(emitfosbase_nat, regman.nations, fsyfos, 2050, histemitdata.fosCO2, (float) srb.fosconv.getval());
        }
        interpolator.fillregdata(emitfosbase_nat, emitfosbase, regset, fsyfos, 2050);
        in_fos.fill(emitfosbase, regset, 2051, 2100, emitfosbase_nat, (float) srb.fosconv.getval());

    } //regemitfosbase

    //========== SCALE TO MODEL GDP (preserving scenario emissions intensity) =========
    void scalefosmod() {

    	for (region r : regset.reg) { 
    		float ratio =  gm(popgdp.class).gdp_msr.get(r);
    		emitfosbase.set(r, emitfosbase.get(r)*ratio);
     		// temporary fix - scale nations acc to the ratio of model/scen for whole region       			 
    		for (region rr : r.subreg(regman.nations))  { 
    			emitfosbase_nat.set(r, emitfosbase_nat.get(r)*ratio);
     		}
    	} //r
    	
    	//calctot still in globco2emit  - after added bunker - but diff option for usemod 
 
    }     

    
    //************ FUTURE REGIONAL CH4 N2O ****************

    /* P3 Note EPA data is available for most countries until 2020 - could shift beginning of SRES to then, with some kind of convergence 
     * note also othgasemit - which uses just a global dataset - is there any topdownscaling to ensure consistency?
     * alternatively - could use IMAGE data (& ditto for LUC)??
     * see also todo note in history.java
     */
    //note that SSP data starts in 2005, then 2010 and 10yr intervals
    
    void regch4n2o() {
        
        sspData.run ssprun=  gm(sspChooser.class).chosenSSPrun;
        
        interpolator in_ch4=new interpolator(ssprun.get(sspData.gases.CH4_TOT), sspData.scenreg, 2000, 10, 1f ); 
        //interpolator in_ch4=new interpolator(sresdata.sres4ch4, "SRES4", 1990, 10, sb.scre, 1f);
        in_ch4.fill(emitch4base_nat, regman.nations, 2001, 2050, histemitdata.epaCH4, 2020);
        interpolator.fillregdata(emitch4base_nat, emitch4base, regset, 2001, 2050);
        in_ch4.fill(emitch4base, regset, 2051, 2100, emitch4base_nat);
        
        interpolator in_n2o=new interpolator(ssprun.get(sspData.gases.N2O_TOT), sspData.scenreg, 2000, 10, 0.001f ); //because ssp data in kt N2O 
        //interpolator in_n2o=new interpolator(sresdata.sres4n2o, "SRES4", 1990, 10, sb.scre, 1f);
        in_n2o.fill(emitn2obase_nat, regman.nations, 2001, 2050, histemitdata.epaN2O, 2020);
        interpolator.fillregdata(emitn2obase_nat, emitn2obase, regset, 2001, 2050);
        in_n2o.fill(emitn2obase, regset, 2051, 2100, emitn2obase_nat);

    }
    
    
    
    
    //======= INTENSITY DECLINE =======


    //******* EQUIV ***********
    //calc equiv code similar to emitequiv method in emitquota - for national not regional!
    float equiv(region r, int ty) {
        othgasemit.gwp gwp_chosen=gm(othgasemit.class).gwp_source.chosen;
        //note: may return null after fysluc  if regionset doesn't contain r!
        curve elb=((ty<fsyluc) ? gm(CalcLucEmit.class).lucemit.getcurve(r) :  emitlucbase.getcurve(r) ); 
        return (emitfosbase_nat.get(r, ty)+elb.get(ty)) * 44f / 12f + emitch4base_nat.get(r, ty) * gwp_chosen.ch4 + emitn2obase_nat.get(r,ty) * gwp_chosen.n2o;
        //removed from n2o as changed curve units:  * 44f / 28f;
    }

    //
    //********** LUC ********************
    void fillhistluc() {
        //note: these methods are here rather than in CalcLucEmit, because they change with the socio regionset
        //note todo in regemit.todo re mixing sources of LUC data
         

        if (CLE.lucsource.chosen.equals("Houghton")) {
            float scalefactor = (float) gm(CalcLucEmit.class).landuseemit1990.getval() / 2158.09f;
            new interpolator(LUCdata.lucCO2Houghton, 1950, 1f, scalefactor).fill(emitlucbase, regset, 1750, 2000, LUCdata.lucCO2CAIT);
        }
        if (CLE.lucsource.chosen.equals("EDGAR")) interpolator.fillregdata(LUCdata.edgarluc, emitlucbase, regset, 1f);
        if (CLE.lucsource.chosen.equals("IVIGmodel")) {
             
            interpolator.fillregdata(CLE.lucemit, emitlucbase, regset, 0.001f);
        }
        if (CLE.LULUCF_UNFCCC_on.istrue())
            interpolator.fillregdata(LUCdata.lucCO2UNFCCC, emitlucbase, regset, 1f);
    /*
    if (lucsource.chosen.equals("MATCH"))
    new interpolator(matchdata.matchco2luc, 1890, 1).fill(emitluc, regset, 1890, 2000, histdata.lucCO2IVIG);
    if (lucsource.chosen.equals("IVIGdata")) interpolator.fillregdata(get(CalcLucEmit.class).lucCO2IVIG, emitluc, regset, 0.001f);
    } else if (year<=2002) { lucf.set(0); for (qt q : histdata.lucCO2.map.values()) lucf.set(lucf.get()+q.get()/1000f); }
     */
    }//luc


    //**************** CH4, N2O *******************
    void fillhistch4n2o() {
        //Note EH CH4 in Tg CH4, N2O in TgN
        //see todo in regemit.todo re interpolator errors - EPA is insufficient source for weighting    

        new interpolator(matchdataOld.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true).fill(emitch4base, regset, 1890, 1970, epaCH4);
        new interpolator(matchdataOld.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true).fill(emitch4base, regset, 1971, 2000, epaCH4);
        for (int y = 1890; y < 2000; y++) gm(othgasemit.class).ch4emit.set(y, emitch4base.calctot(y));
        new interpolator(matchdataOld.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true).fill(emitch4base_nat, regman.nations, 1990, 2000, epaCH4);

        float fac=(44f/28f)*0.9f; //convert TgN to Tg N2O	 - but scale down 10% to reduce jump to scenario data 
        new interpolator(matchdataOld.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true, fac).fill(emitn2obase, regset, 1890, 1970, epaN2O);
        new interpolator(matchdataOld.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true, fac ).fill(emitn2obase, regset, 1971, 2000, epaN2O);
        for (int y = 1890; y < 2000; y++) gm(othgasemit.class).n2oemit.set(y, emitn2obase.calctot(y));
        new interpolator(matchdataOld.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true, fac ).fill(emitn2obase_nat, regman.nations,  1990, 2000, epaN2O);

    } //ch4n2o
} // end class





