/*
Aviation and Shipping emissions, history and future
note history is run in initsetup and never changes (hence no interactions)
future depends on scenario from IPCC SR + stabilisation scaledown, assumed to be within SRES, hence globco2emit follows this, in order to subtract the bunker part

see text file in climate/data/gases/bunker for more info on history and scenarios

spring 08: added constant after 2050 option

 */
package jcm.mod.regemit;

import java.awt.Color;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.mod.obj.globco2emit;
import static jcm.gui.gen.colfont.*;
import static jcm.mod.regemit.AviaShipEmit.sec.*;
import static jcm.core.report.*;

public class AviaShipEmit extends module {
    public static int sy = 1900; //note beware non-standard sy and ey can cause problem in derivative qtsets!

    //****************************** PARAMS ************************************
    public param<scen> aviascen = new param("Aviation Scenario", scen.values(), scen.Fa1);
    public param tranlongterm = new param("Transport Longterm", longterm.values(), longterm.mitigate_for_stabilisation);
    public param endgrowth = new param("End Growth Year", "year", orange, 2100, 2010, 2200);
    //****************************** CURVES ************************************
    public curveset seb = new curveset("AviaShipEmitCurves-base", "mega&ton&carbon&per&yr", sy, gey);
    public curveset sem = new curveset("AviaShipEmitCurves-mitig", "mega&ton&carbon&per&yr", sy, gey);    //
    //****************************** working variables  ************************************
    float oldscalea;
    float avtotbase = 0, matotbase = 0, mainc = 1, favdom = 1, favA1 = 1, fmadom = 1, fmaA1 = 1;
    scen sc;
    int scenyear = 0;

    emitquota eq; emitbase eb;

    globco2emit gc;
    //****************************** ENUMS ************************************
    // note av=aviation, ma=marine, A1=Annex1, DC=others, int=international, dom=domestic, mil=military
    public enum longterm {
        mitigate_for_stabilisation, business_as_usual; //constant_after_2050
        // PhM : this is not about 2050 anymore, just mitigation ?
    }

    public enum sec {
        Ship_A1_int(dkblue), Ship_DC_int(dkcyan), Ship_A1_dom(ltblue), Ship_DC_dom(cyan), Ship_mil(dkyellowgreen),
        Avia_A1_int(dkred), Avia_DC_int(dkorange), Avia_A1_dom(pink), Avia_DC_dom(orange), Avia_mil(yellow),
        tot_int(dkgrey), tot_dom(grey), tot_Ship(blue), tot_Avia(red), tot_all(black);
        Color col;

        sec(Color c) {
            col = c;
        }
    }
    //below taken from table 6-2 of IPCC special report -- in GtC
    public enum scen {
        Fa1(new float[]{0.147f, 0.187f, 0.279f, 0.315f, 0.405f}, new float[]{2.0f, 2.8f, 4.3f, 5.1f, 7.2f}),
        Fa2(new float[]{0.147f, 0.187f, 0.279f, 0.319f, 0.419f}, new float[]{2.0f, 2.8f, 4.3f, 4.7f, 5.6f}),
        Fc1(new float[]{0.147f, 0.187f, 0.279f, 0.265f, 0.231f}, new float[]{2.0f, 2.8f, 4.3f, 4.2f, 4.0f}),
        Fe1(new float[]{0.147f, 0.187f, 0.279f, 0.382f, 0.640f}, new float[]{2.0f, 2.8f, 4.3f, 6.4f, 11.4f}),
        Eab(new float[]{0.147f, 0.179f, 0.255f, 0.463f, 0.983f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        Edh(new float[]{0.147f, 0.224f, 0.385f, 0.690f, 1.452f}, new float[]{2.0f, 2.8f, 4.3f, 6.4f, 11.6f}),
        FAST_A1(new float[]{0.090f, 0.131f, 0.200f, 0.311f, 0.810f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        FAST_B2(new float[]{0.090f, 0.131f, 0.200f, 0.277f, 0.544f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        C_ULS(new float[]{0.090f, 0.131f, 0.218f, 0.317f, 0.666f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        C_RPP(new float[]{0.090f, 0.131f, 0.186f, 0.245f, 0.451f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        C_FW(new float[]{0.090f, 0.131f, 0.161f, 0.185f, 0.260f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        C_DtE(new float[]{0.090f, 0.131f, 0.161f, 0.175f, 0.196f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f}),
        Scenic(new float[]{0.090f, 0.131f, 0.255f, 0.338f, 0.583f}, new float[]{2.0f, 2.2f, 2.9f, 4.3f, 7.9f});
        //FA1h(new float[] {0.147f,0.187f, 0.279f, 0.344f, 0.479f}, new float[]{2.0f, 2.8f, 4.3f, 5.0f , 7.0f}  ), 
        //note supersonic scenario, effect of NOx quite different, but paste data for use later
        public static int y[] = {1990, 2000, 2015, 2025, 2050};
        public float[] co2,  nox;
        //note nox emissions in Mt(NO2)!
        scen(float[] fco2, float[] fnox) {
            nox = fnox;
            co2 = fco2;
            // scale the selected scenario so that its value in 2000 is consistent with JCM past
            // (remember military is not included here)
            // !! values for the past not checked yet - experimental !!
            //float bscale = 0.187f/co2[1];
            float btrans = 0.255f - co2[2]; // test = translate rather than scale, and use 2015 as base year.
            for (int iy = 0; iy < 5; iy++) {
                // co2[iy] *= bscale;
                co2[iy] += btrans;
            }
        }
    }
    //********************* SETUP ***************************
    //note that bunker not shown in simplest complexity level!!!
    public void initsetup() {

        eq=gm(emitquota.class);
        eb=gm(emitbase.class);
        gc = gm(globco2emit.class);
        //
        emitbase.setaffectedby(aviascen);
        emitbase.setaffectedby(endgrowth);
        emitmitig.follows(emitbase);
        emitmitig.setaffectedby(tranlongterm);
        emitmitig.follows(gc);
        this.follows(emitmitig);
        //
        for (sec s : sec.values()) {
            seb.getOrAddCurve(s).color = s.col;
            sem.getOrAddCurve(s).color = s.col;
            if (s.name().startsWith("tot")) {
                seb.getOrAddCurve(s).type = curve.Type.total;
                sem.getOrAddCurve(s).type = curve.Type.total;
            }
        }
       
    // aviashiphistory(); //since this never changes, and run before rest, does not need to be in history interactions - now called from histemitdata to ensure correct calc order
    //P3 but check - if make a new world, aviashiphistory won't be re-run => data empty?
    }
    //************************************ HISTORY **************************
    public void aviashiphistory() {
        //note: called from histemitdata initsetup to ensure correct order  

        float CO2fac = 12f / 44f;

        /*
        2002 emissions (in MtCO2) from UNFCCC for 2002 for Annex 1
        No data for developing countries, so assume shipping same as Ax1, and aviation is half Ax1
        (note: earlier version used fractions DC/Ax1 Sh=1.2 and Av=0.6)
         */
        sec[] esecs = {Ship_A1_int, Ship_A1_dom, Avia_A1_int, Avia_A1_dom, Ship_DC_int, Ship_DC_dom, Avia_DC_int, Avia_DC_dom};
        float[] emit2002 = {204, 100, 205, 240, 204, 100, 102.5f, 120};
        // Note : Avia A1 int + dom = 445, avia DC dom + int = 222.5 MtCO2
        // this is because DC is assumed to be half Ax 1 !
        for (int i = 0; i < 8; i++) seb.set(esecs[i], 2002, emit2002[i] * CO2fac);


        /* OLD no longer used
        OLD - this causes too big a discrepancy with IPCC -see bunkernotes.txt
        set 2002 data, corrected such that total international bunker starts at 3.3% of fossil as per IEA data
        note IEA assumes military is domestic, acc to UNFCCC05
        float cf=0; for (sector s : sector.tot_int.subsec) cf+=s.emit_CO2_2002; cf=history.fosCO2.calctot(2002)*0.001f*0.033f/cf; //(1f-fracmil(2002))
         */

        //scale aviation total to IPCC SR 187MtC in 2000 (assume inc mil) - note this must be changed if above fracs change
        // numerator 187 MtC -> complete total, IPCC based
        // denominator 445 MtCO2 * (1+ DC total+military) ->  complete total, UNFCCC based, converted to MtC by "CO2fac"
        float cf = 187f * (histemitdata.fosCO2.calctot(2002) / histemitdata.fosCO2.calctot(2000)) / (445f * (1f + 0.5f * 0.97f) * CO2fac * (1f + fracmil(2000, false)));
        for (sec s : sec.values()) if (s.name().contains("Avia") && !s.name().contains("mil")) seb.set(s, 2002, seb.get(s, 2002) * cf);
        //System.err.println("aviation scaled down from UNFCCC by "+cf); //currently about 0.92

        /*
        extrapolate back in time, also add the military emissions, and sum the totals
        % relative increase per year (as fraction of global total emissions) - note orig 4%/yr for Ax1-av pre 2000 & 6% for DC, now reduced to 2.5% & 4% (so avg 3% as IPCC)
        also adds a linear increase 2003-6
        (note: MNP data for 2006 suggests decreasing bunker fuel, but other sources suggest big increase, need to check several sources)
         */
        for (int y = fsyfos - 1; y >= sy; y--) {
            float rtot = histemitdata.fosCO2.calctot(y) / histemitdata.fosCO2.calctot(y < 2002 ? y + 1 : 2002);
            float atot = 0, mtot = 0;
            for (sec s : sec.values()) {
                boolean mil = s.name().contains("mil"), tot = s.name().contains("tot"), avia = s.name().contains("Avia");

                if (!mil && !tot) {
                    float incperyr = (avia && y < 2000 ? 2.5f : 0) + (s.name().contains("DC") ? 1.5f : 0);
                    if (y < 2002) seb.set(s, y, seb.get(s, y + 1) * (100f / (100f + incperyr)) * rtot);
                    if (y > 2002) seb.set(s, y, seb.get(s, 2002) * (100f / (100f + incperyr * (y - 2002))) * rtot);
                    if (avia) atot += seb.get(s, y);
                    else mtot += seb.get(s, y);
                }
            } //s
            seb.set(Avia_mil, y, atot * fracmil(y, false));
            seb.set(Ship_mil, y, mtot * fracmil(y, true));
            calctots(seb, y);
        } //y

        for (int y = sy; y <= fsyfos; y++) for (sec s : sec.values()) sem.set(s, y, seb.get(s, y));

    } //history

    //********************************** FUTURE  - BASELINE ************************

    /* This part needs to run *before* globco2emit in loop, while the mitig part runs after
     * It sets the baseline emissions
     * P2 check! added jun 08 limit to growth at 2100 (for any option)
     * Although baseline doesn't change due to stabilisation etc., this part needs to run to calculate the mitigated part, because working variables not stored
     * However we don't want it to trigger that efb.bunker has changed if it hasn't! 
     */
    public loopcalc emitbase = new loopcalc("avia-baseline") {
        public void calcstep() {

            if (year == fsyfos) {
                sc = aviascen.chosen;
                scenyear = 1;
                mainc = 0.01f; //temporary guess to continue trend
                favdom = seb.get(Avia_A1_dom, fsyfos - 1) / (seb.get(Avia_A1_int, fsyfos - 1) + seb.get(Avia_A1_dom, fsyfos - 1));
                favA1 = seb.get(Avia_A1_int, fsyfos - 1) / (seb.get(Avia_A1_int, fsyfos - 1) + seb.get(Avia_DC_int, fsyfos - 1));
                fmadom = seb.get(Ship_A1_dom, fsyfos - 1) / (seb.get(Ship_A1_int, fsyfos - 1) + seb.get(Ship_A1_dom, fsyfos - 1));
                fmaA1 = seb.get(Ship_A1_int, fsyfos - 1) / (seb.get(Ship_A1_int, fsyfos - 1) + seb.get(Ship_DC_int, fsyfos - 1));
            }

            if (year >= fsyfos) {
                if (year <= endgrowth.getval()) {
                    favdom *= 0.99f;
                    favA1 *= 0.99f; //temporarily  changing fracs are guesses, later should extrapolate trends
                    fmadom *= 0.99f;// Important hypothese = how fractions are changing in the future (eg A1 / DC)
                    fmaA1 *= 0.99f;
                    mainc *= 0.99f;

                    while (year > sc.y[scenyear] && year < 2050) scenyear++;

                    avtotbase = 1000f * ((year - sc.y[scenyear - 1]) * sc.co2[scenyear] + (sc.y[scenyear] - year) * sc.co2[scenyear - 1]) / (sc.y[scenyear] - sc.y[scenyear - 1]);
                    matotbase = (year == fsyfos) ? seb.get(tot_Ship, fsyfos - 1) : matotbase * (1f + mainc);
                }
                //
                int fmy = (int) (year < endgrowth.getval() ? year : endgrowth.getval());
                float avnomil = avtotbase / (1f + fracmil(fmy, false));
                float manomil = matotbase / (1f + fracmil(fmy, true));

                seb.set(tot_Avia, year, avtotbase);
                seb.set(Avia_mil, year, avnomil * fracmil(year, false));
                seb.set(Avia_A1_int, year, avnomil * (1f - favdom) * favA1);
                seb.set(Avia_A1_dom, year, avnomil * favdom * favA1);
                seb.set(Avia_DC_int, year, avnomil * (1f - favdom) * (1f - favA1));
                seb.set(Avia_DC_dom, year, avnomil * favdom * (1f - favA1));

                seb.set(tot_Ship, year, matotbase);
                seb.set(Ship_mil, year, manomil * fracmil(year, true));
                seb.set(Ship_A1_int, year, manomil * (1f - fmadom) * fmaA1);
                seb.set(Ship_A1_dom, year, manomil * fmadom * fmaA1);
                seb.set(Ship_DC_int, year, manomil * (1f - fmadom) * (1f - fmaA1));
                seb.set(Ship_DC_dom, year, manomil * fmadom * (1f - fmaA1));

                calctots(seb, year);

                //set bunker - which will influence globco2emit
                //note - the total SRES emissions are adjusted in globco2emit so that this is included in total but not changed
                //totbunk = avnomil * (1f - favdom) + manomil * (1f - fmadom);
                eb.emitfosbase.set("bunker", seb.get(tot_int));

            } // year

        } //calcstep _ base
    }; //baseline

    //********************************** FUTURE  - MITIGATED ************************
    /* scaledown is for mitigation scenarios
     * needs to run after globco2emit in loop, but before shares
     * secemit sets the curves used for AviaForcing and subtracted from regional emissions in shares
     * see notes about scaling in globco2emit code
     * note scalea is similar to scale in othgasemit - maybe they should be linked?
     */
    public loopcalc emitmitig = new loopcalc("avia-mitigated") {
        public void calcstep() {
            if (year >= fsyfos) {
                float scalea = 1f;
                float scalem = 1f;

                if (tranlongterm.chosen == longterm.mitigate_for_stabilisation) {
                    scalea = gc.fossil.get() / gc.fossilbase.get();
                    if (scalea > oldscalea && year > 2050) scalea = oldscalea; //prevent emissions rising again as gap between base and quota reduces in longterm
                    else oldscalea = scalea;
                    scalem = scalea;
                }

                for (sec s : sec.values()) {
                    if (s.name().contains("Ship")) sem.set(s, seb.get(s) * scalem);
                    else if (s.name().contains("Avia")) sem.set(s, seb.get(s) * scalea);
                }
                calctots(sem, year);
                eq.emitfos.set("bunker", sem.get(tot_int));
                if (year<=2050) eq.emitfos_nat.set("bunker", sem.get(tot_int));

            } //year
        } //calcstep 
    }; //mitigated (scaledown)

    /* OLD
    if (year > 2050 && tranlongterm.chosen == longterm.constant_after_2050) {
    scalea = secemit.get(tot_Avia, 2050) / avtotbase;
    scalem = secemit.get(tot_Ship, 2050) / matotbase;
    }
     */
    // ============= CALCTOTS ==========
    void calctots(curveset cu, int y) {
        for (sec s : sec.values()) {
            if (s.name().contains("tot")) {
                String tt = s.name().substring(4);
                float t = 0;
                for (sec ss : s.values()) if (!ss.name().contains("tot") && (tt.equals("all") || ss.name().contains(tt))) t += cu.get(ss, y);
                cu.set(s, y, t);
            } //tot
        } //s
    }    //

    /*============ FRACMIL ===========
    fraction military as proportion of non-military, decreasing over time
    data for aviation  from IPCC SR, +guess pre-1976
    guess frac for shipping is 0.25 * frac for aviation
     */
    float fracmil(int year, boolean forship) {
        int[] y = {0, 1945, 1976, 1992, 2015, 2050, 9999};
        float[] f = {0.4f, 0.6f, 0.36f, 0.18f, 0.07f, 0.03f, 0.03f};
        int i = 0;
        while (year >= y[i]) i++;
        float ff = ((year - y[i - 1]) * f[i] + (y[i] - year) * f[i - 1]) / (y[i] - y[i - 1]);
        return (forship ? 0.25f : 1f) * ff / (1f - ff);
    }
} //class


//	float emit02;//CO2 Emissions 2002, in MtC
//	sec(Color c, float f1) {col=c; emit02=f1*12f/44f;}//convert CO2 to C
//	sec(Color c, sec ...ss ) {col=c;subsec=new HashSet(4);for (sec s : ss )subsec.add(s);}

