package jcm.mod.ogas;

import java.util.List;
import java.util.Map;

import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;
import jcm.mod.scen.*;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.globco2emit;

import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import  static jcm.mod.ogas.othgasemit.gwp.*;
import static jcm.mod.ogas.othgasemit.emitoptions.*;
import static jcm.mod.scen.sspData.gases.*;

public class othgasemit extends module  {
    
    //********* INTERACTIONS *************

    public void setinteractions() {
    	follows(gm(emitbase.class).history);
    	setaffectedby(gm(sspChooser.class) , emitoption.chosen==fixscen || emitoption.chosen==scalescen); 
    	setaffectedby(gm(sresBase.class).scenario, emitoption.chosen==fixscen || emitoption.chosen==scalescen); // only for f-gases!
    	follows(gm(globco2emit.class), emitoption.chosen==scale2000 || emitoption.chosen==scalescen);
    }
    
    //********** PARAMETERS **************	
 
    public enum emitoptions {	fixscen,  scalescen,  fix2000,  scale2000, donothing} //note: donothing added for attribution experiments
    complexity[] emitcomplex={ normal, normal, normal, normal, experimental};
    
    public param<emitoptions> emitoption=new param("othgasemitoptions", emitoptions.values(), scalescen, emitcomplex);
	public param    addpermafrost=new param("addpermafrost", false, experimental);

	//*********** GWP  PARAM ********************
    /*P3 note could merge with ogas.gas enum (currently used for efficacies)
    === equivalents using GWP === 
    created for comparison with attribution of temperature, therefore only including CO2, inc all LUC, CH4 and N2O
    may be extended for other applications later
    GWPs from TAR 100 year time horizon (for 10yr: 62 & 275, for 500yr: 7 & 156)
     *44/12 => mass CO2, *44/28 => mass N2O, note ch4emit was already in MtCH4
     * SAR values were 21 and 310
     * TAR 23 and 296
     * AR4 25 and 298
     */
    public enum gwp {
        SAR (21,310), TAR (23,296), AR4(25,298);
        gwp(float a, float b) { ch4=a; n2o=b; }
        public float ch4, n2o;
    };

    public param<gwp> gwp_source = new param("gwp_source", gwp.values(), AR4);

    
    //*********** CURVES *****************************

    public curve
	    ch4emit=new curve( "ch4" , green, simplest ),
	    n2oemit=new curve( "n2o" , brown),
	    soxemit=new curve( "sox" ,  blue, simplest ),
	    coemit=new curve(  "co" , dkgrey ),
	    vocemit=new curve( "voc" ,  yellowgreen ),
	    noxemit=new curve(  "nox",  orange);
    
    public curveset emitcurves=new curveset( 	ch4emit, n2oemit, soxemit, coemit, vocemit, noxemit, "othgasemitcurves", "tera&gram&per&yr");
    
    // *********** misc **********
    sspChooser sspc;
    float oldscale=0; 
    
    //********** LOOP CALCS ******************

    
    //note initsetep must come after loaddata which fills ch4emit, coemit, soxemit
    public void initsetup() {
	
    	histadjust();
    	histnoxvoc();
    	sspc=gm(sspChooser.class);
    	//scenreg=regman.allreg.findreg("SSP5").reg;
    }
    
    public void precalc() { 
    	//scaleis92a(); // needed for set scgas for old sres data     
    	
    }
    
    public void calcstep() {
    	
    	if (year==1890) fixEdgar();
    		
         if ( !emitoption.chosen.equals(donothing) &&  year>=2000) {
        	 scalescenemit(); // to SSP
        	 	
         }	 
	
         //experiment, add emissions from melting permafrost, apparently 700Gt on average over next century, note not yet any feedback from temperature
         if (addpermafrost.istrue() && year>fsyog) { 
        	 float extrach4=700f*(16f/12f)*(year-2000)/50f; 
        	 ch4emit.set(ch4emit.get()+extrach4); 
         }

    }
    
    //********************** FUTURE **************************
    /* 
    	scaling sres starts in 2000 - it should start in fsyog, ie when the (updated) data finishes 
    	
    	SSP datasets start in 2005, then 2010 and 10yr intervals 
    	=> method below is assuming 2005 data was 2000 - WRONG -but expect overwritten by more recent data  
    	
    	in principle we have ch4 and n2O data from EPA until 2020 - better use this to 2105 ? 
		reCHECK interactions  with "donothing" othgasemit option
     */
	
     
    
    float interpssp (sspData.gases g, int y) {
    	return interpolator.simpinterp(sspc.chosenSSPrun.get(g, sspData.regions.World), y); 
    }
    
    void scalescenemit() {
    	//scale to CO2 - note use fossil CO2 emissions not total (inc landuse)
    	float scale =1f;

    	//note: if <fsyfos (even if >fsyog) scale factor should be 1, fossilbase doesn't start before fsyfos!
    	if (year>=fsyfos && emitoption.chosen==scalescen) scale=gm(carboncycle.class).fossil.get(year)/gm(globco2emit.class).fossilbase.get(); //(1000f*sres.interp(sres.fosemit, sc, year)
    	if (year>2000 && emitoption.chosen==scale2000 ) scale=gm(carboncycle.class).fossil.get(year)/gm(carboncycle.class).fossil.get(2000);
    	if (scale>oldscale && year>2100) scale=oldscale; //prevent increase after 2100
    	else oldscale=scale;

    	int year1= (emitoption.chosen==fix2000 ||  emitoption.chosen==scale2000)  ? 2000 : year;

    	//check units: input data from SSPs in in Mt X / yr, same as Tg/yr specified in emitcurves   
    	//exception is N2O where orig data was kt / yr => need to divide by 1000 
    	//plot units suggest JCM atchem  expects sulphur in Mt S whereas SSP in Mt SO2 => * 32.07 / 64.07 to remove the oxygen
    	//plot also suggest JCM atchem  expects NOx in Mt N whereas SSP in Mt NO2 => * 14 / 46 to remove the oxygen
    	soxemit.set(year, interpssp(Sulfur, year1)*scale * (32.07f/64.07f));
    	ch4emit.set(year, interpssp(CH4_TOT, year1)*scale);
    	n2oemit.set(year, interpssp(N2O_TOT, year1)*scale/1000f);
    	coemit.set(year, interpssp(CO, year1)*scale);
    	vocemit.set(year, interpssp(VOC, year1)*scale);
    	noxemit.set(year, interpssp(NOx, year1)*scale* (14f/46f));
    	
    	scaleHFC(scale);
    	
    }
	
  //HFCs (note cfcs constant)
  	//this still depends on SRES as only fgas total saved in SSP !
  	//could move to fgas module? but would complicate interactions!
  	//interpolation unnecessarily complicated as only use in 5-yr intervals?
  	void scaleHFC(float scale) {
  		int sc=gm(sresBase.class).sci;
  		int schfc=(sc<3 ? 0 : sc<7 ? sc-2 : 2); //all A1 same, for TGCIA450 use B1
  		int yeara=year+5, yearb=((emitoption.chosen==fixscen ||  emitoption.chosen==scalescen) ? yeara : 2000);
  		if ((yeara%5)==0 && yeara>1930 && yeara<=gey)
  		    for (int g=0; g<12; g++) {
  		    	gm(fgas.class).fgemit[g].set(yeara,  (sc==6 && (g<4 || g>6)) ?  0 :  interpolator.interphfc(sresdata.hfcemit, g, schfc, yearb)*scale);
  		    	//note is92a only has data for 3 gases
  		    }
  	}
  	    	
    
    
    
  //************************ HISTORY *******************************
    
    
	//adjust methane to match sres at 2000
	//NOTE: CH4 and N2O data  now overwritten by the sum from EDGAR from 1890 to 2000
    //Note EPA data 1990-2020 loaded in histemitdata - applied in emitbase
    //note histn2o in atchem - inverse
	 //see emitbase - history - fillhistch4n2o()
    void histadjust() { 	   
        	for (int y=1860; y<2001; y++) ch4emit.set(y, ch4emit.get(y)* 323f / 380f); 
        	//fill 1750-1860
        	for (int y=1750; y<1860; y++) ch4emit.set(y, ch4emit.get(1860) * (y-1750) / 110f);
        	/*OLD soxemit data only goes to 1990 and is higher than scenarios
        	SRES had SOx = 1990 (70.9) and 2000 (69.0)
        	SSPs: IAM models don't agree on initial SOx! but typically ~56 MtS in 2005, and ~50 in 2010 
        	Smith & vArdenne (2010) give peak 1980, 64 in 1990, 53 in 2000, 58 in 2005
        	Drops in europe but rises in Asia (+shipping) with dip between - its not smooth! 
        	scale down and and connect linearly to 2000
        	note have to change the value for se2000 in aerosol accordingly
        	*/
        	for (int y=0; y<1991; y++) soxemit.set(y, soxemit.get(y)*64f/soxemit.get(1990));
        	for (int y=1991; y<2001; y++) soxemit.set(y, ((y-1990)*53f+(2000-y)*64f)/10f);
        	//IAMs don't agree on initial CO either - this 850 is a compromise... 
        	for (int y=1991; y<2001; y++) coemit.set(y, ((y-1990)*850f+(2000-y)*coemit.get(1990))/10f);
        	//IAMs agree even less on VOCs... and even CH4 ...
        	//check out RCP harmonised versions - what was done there?
    }
    
 	//scaling N2O emissions prior to 1890 - do we still need this old fix for edgar?
     void fixEdgar() {	
    	if (((region) (gm(regset.class).regions.chosen)).name.equals("EDGAR") && year==1890)  {
    		float emit1890=gm(emitbase.class).emitn2obase.calctot();
    		for (int y=1750; y<=1890; y++)  n2oemit.set(y, emit1890*((float)(y-1750) / (float)(1890-1750)));
    	}
    }
     
    //calculate historical nox & voc by scaling to CO, only for plot not further calculations
     //note this used to use SRES data scenario 0
    void histnoxvoc() {
    	int fy=2000;
    	sspData.run base=sspData.find(sspData.models.IMAGE, sspData.ssps.SSP2, sspData.rcps.Ref); 
    	noxemit.set(fy, base.get(NOx, sspData.regions.World)[0] *(14f/46f)); //14/46 is NO2=>N change
    	vocemit.set(fy, base.get(VOC, sspData.regions.World)[0]);
    	for (int year=1750; year<fy; year++) {
    		noxemit.set(year, noxemit.get(fy)*coemit.get(year)/coemit.get(fy));
    		vocemit.set(year, vocemit.get(fy)*coemit.get(year)/coemit.get(fy));
	}}
    


    
    
} //end class

//====================== OLD SRES ==========================
/* old scale to SRES
    //note scgas set in the scaleis92a method
    float scale, oldscale; float[] scgas=new float[6];
    
    void scalesresemit() {
	//scale to CO2 - note use fossil CO2 emissions not total (inc landuse)
	scale =1f;
	int sc=gm(sres_base.class).sci;
        //note: if <fsyfos (even if >fsyog) scale factor should be 1, fossilbase doesn't start before fsyfos!
	if (year>=fsyfos && emitoption.chosen==scalescen) scale=gm(carboncycle.class).fossil.get(year)/gm(globco2emit.class).fossilbase.get(); //(1000f*sres.interp(sres.fosemit, sc, year)
	if (year>2000 && emitoption.chosen==scale2000 ) scale=gm(carboncycle.class).fossil.get(year)/gm(carboncycle.class).fossil.get(2000);
	if (scale>oldscale && year>2100) scale=oldscale; //prevent increase after 2100
        else oldscale=scale;
        
	int year1= (emitoption.chosen==fix2000 ||  emitoption.chosen==scale2000)  ? 2000 : year;
	
	soxemit.set(year, interpolator.sceninterp(sresdata.soxemit, sc, year1)*scale*scgas[0]);
	ch4emit.set(year, interpolator.sceninterp(sresdata.ch4emit, sc, year1)*scale); //*scgas[1]; //scgas doesn't help for CH4 is92a!
	n2oemit.set(year, interpolator.sceninterp(sresdata.n2oemit, sc, year1)*scale*scgas[2]);
	coemit.set(year, interpolator.sceninterp(sresdata.coemit, sc, year1)*scale*scgas[3]);
	vocemit.set(year, interpolator.sceninterp(sresdata.vocemit, sc, year1)*scale*scgas[4]);
	noxemit.set(year, interpolator.sceninterp(sresdata.noxemit, sc,  year1)*scale*scgas[5]);

//P2 note othgasemit scaleis92a is never used since IS92A no longer in the scenario menu - can't get index==6
//scale is92a to same 2000 values as SRES to match TAR calculations
float[][][] scgasdata={	sresdata.soxemit, sresdata.ch4emit, sresdata.n2oemit, sresdata.coemit, sresdata.vocemit, sresdata.noxemit};

void scaleis92a() {	for (int i=0; i<6; i++) {
if (gm(sres_base.class).sci==6) scgas[i]=(float)(scgasdata[i][0][0]/scgasdata[i][6][0]);
else scgas[i]=1f;
}}
*/


