/*
F GASES (HFCs CFCs etc)
 
first 12 PFC/HFC emissions vary with sres, are included in kyoto etc.
SF6, CF4, C2F6, HFC23,   				(yearly data pre 1960-1989)
HFC134a, HFC152a, HFC125, 			(only 3 included in is92a, 152a not in sres)
HFC32, HFC143a, HFC227ea, HFC245ca, HFC4310mee,
 
14 montreal protocol gases (contain Cl/Br damages ozone)
concentrations prescribed by data, emissions calc by inverse
HCFC22, HCFC141b, HCFC142b, HCFC123, CH3CCl3, hcfcs h=> shorter lifetimes
CFC11, CFC12, CFC113, CFC114, CFC115, CCl4, cfcs
CF2BrCl, CF3Br, 							(br gases data to 2100 only)
EESCL 		effective equivalent stratospheric chlorine -affects ozone loss -data to 2100 only

note chemical formulae for CFCs: first digit = # C - 1 (missing if zero) ; second digit = # H + 1; third digit = # F
 
 P1 CHECK EESCL before 1970: conc seems to start rather high, whilst RF (defined relative to 1070 is zero) - is this related to natural CF4?
 
 */

package jcm.mod.ogas;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;

import java.awt.Color;

import jcm.mod.cli.radfor;
import jcm.mod.scen.sresdata;
import static jcm.core.report.*;

public class fgas extends module  {
    
    //*******************************************************
    
    
    //PARAM
    
    public param strato3base1930=new param("o3s1930", false, complexity.expert) { public void precalc() { cfcrf(); }    }; //if not 1930, 1970 as ipcc
    
    
    //*******************************************************
    //PLOTARRAYS
    public	curve[] fgemit=new curve[26], fgconc=new curve[26], fgrf=new curve[26], fgemit_CO2eq=new curve[26];
    //fgas emit/conc/rf arrays in 5 year intervals from 1930 to end
    //filled in makeqt
    
    //totals below are in 1-year timesteps
    public	curve
	    cfcrf= new curve( "cfcrf", pink),
	    hfcrf= new curve("hfc" , magenta),
	    strato3rf=new curve("strato3" , lilac),
	    fgasrf= new curve( "fgasrf",  purple, curve.Type.total),
        cfc_CO2eq = new curve("cfc_CO2eq", pink, curve.Type.total),
        hfc_CO2eq = new curve("hfc_CO2eq", magenta, curve.Type.total);
    
    public curveset emit, emit_CO2eq, conc, rf;
    public curveset sumrf=new curveset(	cfcrf, hfcrf, strato3rf, fgasrf, "fgasrftotals", "w&per&m2");
    float newefficacy, lastefficacy=1f;
    
	/*
	//SCALES
	//xscale
	int[] fgy=new int[(gey-1925)/5]; for (int i=0; i<(gey-1925)/5; i++) fgy[i]=1930+i*5;
	 */
    
    //LOOP CALCS
    //emit in get(othgasemit.class)?
    
    //unusually, this module has a constructor, so that curvesets exist before loaddata has to fill them
    public fgas() {
	makecurves();
    }
    
    //need to force recalc here, because cfcrf not normally called within loop
    public void changeendyear(int oldey, int newey) { cfcrf(); }
    
    public void initsetup() {
	super.initsetup(); //must come after made qt - so get put in list
	fgashist();
	cfcrf();
	follows(gm(othgasemit.class)); //scaling
	follows(gm(atchem.class)); //reloh
	setaffectedby(gm(radfor.class).applyefficacy);
    }
    
    public void calcstep(){
	//if (year>=2000)
	hfcconc();
	hfcrf();
	newefficacy=gm(radfor.class).getefficacy(gas.cfc);
	cfcrf.set(cfcrf.get()*newefficacy/lastefficacy); lastefficacy=newefficacy;
	hfcrf.set(hfcrf.get()*newefficacy);
	fgasrf.set(year, cfcrf.get(year)+ hfcrf.get(year)+strato3rf.get(year)) ;
    calcCO2eq();
    }
    
    
    //*******************************************************
    
    
    void makecurves() {
	//name and color based on chemical formulae
	Color gcolor; String gname;
	for (int g=0; g<26; g++) {
	    if (g==25) {	gcolor=yellow; gname="eescl"; } else {
		//0=S 1=C 2=H 3=F 4=Cl 5=Br
		byte[] f=fo[g];
		float tot= f[2]+f[3]+f[4]+f[5], cs=(0.5f+f[1]+1.5f*f[0])/1.5f;
		float	green=f[3], blue=(f[4]+f[5])*(2f+1f/(1f+green)), red=f[2]*(2f+1f/(1f+green)),
			max=(green>red ? green>blue ? green : blue : red>blue ? red : blue );
		gcolor=new Color(red/(cs*max),green/(cs*max),blue/(cs*max));
		gname=""; for (int i=0; i<6; i++) gname+= (f[i]>0 ? atom[i]+ (f[i]>1 ? String.valueOf(f[i]) :"") :"");
	    }
	    fgemit[g]=new curve(gname, gcolor, 1930, gey, 5); //new float[(gey-1925)/5],
	    fgconc[g]=new curve(gname, gcolor, 1930, gey, 5); //note: data loaded from loaddata goes to 2300, space to load it all just in case need after change endyear
	    fgrf[g]=new curve(gname, gcolor, 1930, gey, 5);
        fgemit_CO2eq[g]=new curve(gname, gcolor, 1930, gey, 5);
	}
	emit=new curveset(fgemit, this.name+"&emit", "kilo&ton&per&yr");
	conc=new curveset(fgconc, this.name+"&conc", "ppt");
	rf=new curveset(fgrf, this.name+"&rf", "w&per&m2");
    emit_CO2eq=new curveset(fgemit_CO2eq, this.name+"&emit&CO2eq", "mega&ton&CO2eq&per&yr");
    emit_CO2eq.addcurve(hfc_CO2eq);
    emit_CO2eq.addcurve(cfc_CO2eq);
    }
    
    //********************* STATIC DATA *************
    
    //note info below used to make labels and colors on plot
    static final public String[] atom={	"S","C","H","F","Cl","Br"};
    static final public  byte[][] fo={
	{	1,0,0,6,0,0},{	0,1,0,4,0,0},{	0,2,0,6,0,0},{	0,1,1,3,0,0},
	{	0,2,2,4,0,0},{	0,2,4,2,0,0},{	0,2,1,5,0,0},
	{	0,1,2,2,0,0},{	0,2,3,3,0,0},{	0,3,1,7,0,0},{	0,3,3,5,0,0},{	0,5,2,10,0,0},
	{	0,1,1,2,1,0},{	0,2,3,1,2,0},{	0,2,3,2,1,0},{	0,2,1,3,2,0},{	0,2,3,0,3,0},
	{	0,1,0,1,3,0},{	0,1,0,2,2,0},{	0,2,0,3,3,0},{	0,2,0,4,2,0},{	0,2,0,5,1,0},{	0,1,0,0,4,0},
	{	0,1,0,2,1,1},{	0,1,0,3,0,1},
	{	0,0,0,0,1,0}
    };
    
    //radiative forcing impact W/m2/ppb, note concs in ppt (now including eescl!)
    static final double[] fgrfalpha={
	0.52, 0.08, 0.26, 0.16,
	0.15, 0.09, 0.23,
	0.09, 0.13, 0.30, 0.23, 0.40,
	0.20, 0.14, 0.20, 0.20, 0.06,
	0.25, 0.32, 0.30, 0.31, 0.18, 0.13,
	0.30, 0.32,
	-0.07317
    };
    
    //lifetime years
    static final double[] fglt={
	3200, 50000, 10000, 257,
	13.7, 1.4, 29.4,
	5.0, 51.6, 33.0, 5.9, 1.56,
	11.9, 9.3, 19, 1.4, 4.8,
	45, 100, 85, 300, 1700, 35,
	11, 65,
	0
    };
    
    //kiloton per ppt or Tg/ppb or Gt/ppm
    static final double[] fgktpppt={
	25.3, 15.3, 23.9, 12.1, 17.7, 10.9, 20.8, 8.56, 14.6, 29.5, 22.1, 41.5, //hfcs joos data slightly higher than equiv to CO2(C)=2.123 ?
	15.31, 20.71, 17.79, 32.92, 23.6, 24.34, 21.41, 33.17, 30.27, 27.35, 27.26, 29.28, 26.36, 0  //cfcs (used for inverse emit only) -scaled to C=2.123
    };
	/*
	chemical formulae for CFCs: first digit = # C - 1 (missing if zero); second digit = # H + 1; third digit = # F
	so mol mass xyz = 12(x+1) + (y-1) +19z +35.5(5+ 2x -y -z) = 188.5 + 83x -34.5y - 16.5z  Note Br=79.9
	F11 =137.5 , F12=121 , F113=187.5 , F114=171 , F115=154.5 ,
	F10(CCl4)=154, F140(CH3CCl3)=133.5,  F22 =86.5, F141=117, F142=100.5, F123=186
	CF2BrCl=165.4, CF3Br=148.9
	 */
    //added july 2010 for sake of CO2eq curves to add to pledges total
    //taken from AR4 WG1 ch2 - note also SROC http://www.ipcc.ch/pdf/special-reports/sroc/sroc_spm.pdf
    //SROC fig SPM4 =>  total Fgas CO2eq 2002 = 2.5, 2015 =2.3 GtCO2eq under BAU - JCM agrees  in 2002 about 2.6, but drops to about 1.8 in 2015 maybe due to recession
    //Note also fig TS-9 CO2eq over history - peak in 1988 about 8 GtCO2eq! - JCM is lower and peaks 1985
    //- note also fig TS-4 suggests CFC11 underestimated in JCM? but fig 1.3 in underlying suggests CFC11 & CFC12 swapped in TS fig!!
    // Note fig 1.18 RF plots over time, and 1.7 mixing ratios
    static final float[] fggwp_SAR= {
 23900, 6500, 9200, 11700,
 1300, 140, 2800,
 650, 3800, 2900, 560, 1300,
 1500, 600, 1800, 90, 100, //HCFCs
 3800, 8100, 4800, 10000, 7370, 1400, // note AR4 values used for CFC113&114
 1890, 5400, //note AR4 val for CBrClF2
 0 }; // EESCL - need to think about this- should be negative ?
 
    //    static final float[] fggwp_AR4= {
// note - more elegant to merge with gas enum and gwp enum in shares ?

    static final float cf4natconc=44; //preindustrial background concn CF4 =44 ppt
    //cf4natemit=15.3*44f/50000f; 0.01 so small we can ignore compared to anthropogenic
    //note c4f10 removed as only in old sres-p
    //CH3Br = 9.06 ppt constant (so no rf?)
    
    //holds yearly concentration data for sf6, cf4, c2f6, hfc23 from 1960-1990
    public static final float[][] hfchistconc=new float[4][31];
    
    //***********************
    //HFCHIST
    void fgashist() {
	//historical concentrations for hfcs and cfcs
	//note original data for montreal gases 5-yr, and sres 10-yr intervals
	
	//1930-1955 -only CF4 	//P1 check, if this is natconc, it shouldn't count towards forcing
	for (int y=1930; y<1960; y+=5) for (int g=0; g<12; g++) fgconc[g].set(y, g==1 ? cf4natconc : 0);
	//1960-1990 -use historical conc data for first 4 gases, otherwise zero
	for (int y=1960; y<1995; y+=5) for (int g=0; g<12; g++) fgconc[g].set(y, g<4 ? hfchistconc[g][y-1960] : 0);
	//data for 2000 for first six, otherwise zero, interpolate 1995
	float[] hfc2000={	4.4f, 80f, 3.1f, 15f, 10f, 0.5f};
	for (int g=0; g<6; g++) {	fgconc[g].set(2000, hfc2000[g]); fgconc[g].set(1995, (fgconc[g].get(2000)+fgconc[g].get(1990))/2f); }
	for (int g=6; g<12; g++) {	fgconc[g].set(2000, 0); fgconc[g].set(1995, 0); }
	
	//calc emissions by inverse: just history for hfcs, all for cfcs (except eescl)
	for (int g=0; g<25; g++) {
	    if (g<12) fgemit[g].set(2000, (float)sresdata.hfcemit[g][0][0]); //but note different for hfc134a in is92a!
	    else fgemit[g].set(gey, 0);
	    //hfcs 4-12 emissions zero pre 2000, 0.001 makes line start
	    if (g>3 && g<12) {
		for (int y=1930; y<2000; y+=5) fgemit[g].set(y, 0); fgemit[g].set(2000, 0.001f);
	    } else {	//not zero
		double fac1=Math.exp(-5.0/fglt[g]), fac2=(1.0-fac1)*fglt[g]/5.0;
		
		for (int y=(g<12 ? 1995 : gey-5); y>=1930; y-=5) {
		    double fac3=fgktpppt[g]*(fgconc[g].get(y+5)-fac1*fgconc[g].get(y));
		    if (fac3>0.001) fgemit[g].set(y, 0.5f*(float)( (fac3 + fgemit[g].get(y+5)*fglt[g]*(fac2 - 1.0) ) / (fglt[g]*(fac2 - fac1)) ));
		    else fgemit[g].set(y,0);
		    if (fgemit[g].get(y)<0) fgemit[g].set(y, 0);
		}
	    } //else
	} //g
	
	//smooth oscillations
	for (int g=0; g<25; g++) {
	    curve fgemit2=fgemit[g].cloneIndependent();
	    for (int y=1940; y<(g<12 ? 1995 : gey-10); y+=5) fgemit[g].set(y, (fgemit2.get(y-10) +4f*fgemit2.get(y-5) +6f*fgemit2.get(y) +4f*fgemit2.get(y+5) +fgemit2.get(y+10))/12f);
	}
    } //end fgashist
    
    //***********************
    //future hfc emissions=>concentration
    //calculates in 5 years steps AHEAD
    //(using reloh for starting year, but little difference)
    void hfcconc() {
	if ((year % 5)==0 && year>=2000	     && year<=gey-5) { 
	    for (int g=0; g<12; g++) {
		double deltaemit= (fgemit[g].get(year+5) - fgemit[g].get(year));
		double fglta=(g<4 ? fglt[g] : fglt[g]/gm(atchem.class).reloh.get(year)); //scale to reloh except for sf6, cf2, c2f6
		double fac=Math.exp(-5.0/fglta);
		if (year<=2300) fgconc[g].set(year+5, (float)(
			fac*fgconc[g].get(year)
			+(fglta/fgktpppt[g])*(deltaemit+(1.0-fac)*(fgemit[g].get(year)-deltaemit*fglta/5.0)) )
			);
                else fgconc[g].set(year, fgconc[g].get(year-5));
	    } //g
	} //if
    } //end calchfc
    
    void cfcrf() {
	//if change eesclbaseyear, still get correct 2000rf
	curve eescl=fgconc[25];
	float eesclbase=eescl.get(strato3base1930.istrue() ? 1930 : 1970);
	fgrfalpha[25]=-0.15f*1000f/(eescl.get(2000)-eesclbase);
	//eescl scale to cfc12 after 2100
	for (int y=2100; y<=gey; y+=5) eescl.set(y, eesclbase +(eescl.get(2100)-eesclbase)*fgconc[18].get(y)/fgconc[18].get(2100));
	
	//calc radiative forcing
	for (int y=1930; y<=gey; y+=5) {
	    for (int g=12; g<25; g++) fgrf[g].set(y, fgconc[g].get(y)*(float)fgrfalpha[g]/1000f);
	    fgrf[25].set(y, (eescl.get(y)-eesclbase)*(float)fgrfalpha[25]/1000f);
	    if (fgrf[25].get(y)>0) fgrf[25].set(y, -0.0001f);
	}
	//fill cfcrf & strato3rf (interpolating linearly)
	for (int y=1930; y<=gey; y+=5) {
	    cfcrf.set(y, 0); for (int g=12; g<25; g++) cfcrf.set(y, cfcrf.get(y) +fgrf[g].get(y));
	    strato3rf.set(y, fgrf[25].get(y));
	    if (y>1930) for (int j=1; j<5; j++) cfcrf.set(y-j, (cfcrf.get(y)*(5-j)+cfcrf.get(y-5)*j)/5f);
	    if (y>1930) for (int j=1; j<5; j++) strato3rf.set(y-j, (strato3rf.get(y)*(5-j)+strato3rf.get(y-5)*j)/5f);
	}
    } //end  cfcrf
    
    void hfcrf() {
	//works in 5 year steps AHEAD (note concs also calculated 5yr ahead)
	if ((year%5)==0 && year>=1925 && year<=gey-5) {
	    //calc radiative forcing
	    hfcrf.set(year+5, 0);
	    for (int g=0; g<12; g++) {
		fgrf[g].set(year+5, (fgconc[g].get(year+5) - (g==1 ? cf4natconc : 0)) *(float)fgrfalpha[g]/1000f);
		hfcrf.set(year+5, hfcrf.get(year+5)+fgrf[g].get(year+5));
	    } //g
	    if (year>=1930) for (int j=1; j<5; j++) hfcrf.set(year+j, (hfcrf.get(year)*(5-j)+hfcrf.get(year+5)*j)/5f);
	} //ifs
    } //end hfcrf
    
    void calcCO2eq() {
        //works in 5 years steps AHEAD because need interpolated yearly data before other modules round loop
        if ((year%5)==0 && year>=1925 && year<=gey-5) {
            float hfctot=0, cfctot=0, val;
        for (int g=0; g<25; g++) {
            val=fgemit[g].get(year+5)*fggwp_SAR[g]/1000f;
            fgemit_CO2eq[g].set(year+5,val);
            if (g<12) hfctot+=val; else cfctot+=val;
            }
            hfc_CO2eq.set(year+5,hfctot); cfc_CO2eq.set(year+5,cfctot);
            // this could be skipped as interpolation should work automatically in curve get method - but slightly more efficient to avoid repeating it?
             if (year >=1930) for (int j=1; j<5; j++) {
                hfc_CO2eq.set(year+j, (hfc_CO2eq.get(year)*(5-j)+hfctot*j)/5f);
                cfc_CO2eq.set(year+j, (cfc_CO2eq.get(year)*(5-j)+cfctot*j)/5f);
                //deb("year="+(year+j)+" hfc="+hfc_CO2eq.get(year+j));
            }
        }
    }
    //*******************************************************
}//end class


