 /*
contains a parameter to choose the set of  socioeconomic regions 
temporary -later to be part of scenario setup, so can diminsh resolution over time 

note clearoldregions (loopcalc) is called from socio, regemit and shares precalc, in order to calc before anything else, 
clearoldregions (curvset) also used by costs, attribMarginal/Tracer, futureluc and SLRimpact

P3 - note clearoldregions doesn't work for derived curvesets! - these are not in m.curvesets, they belong to parent curvesets and calculate on demand...
 */
package jcm.mod.obj;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jcm.core.par.*;
import jcm.core.cur.*;
import jcm.core.ob.loopcalc;
import jcm.core.reg.*;
import jcm.core.ob.module;

public class regset extends module {    //************ REGIONS ****************
    public param<region> regions = regman.makeregionparam("socregions");

    public void clearoldregions(loopcalc lc) {
        module m = (lc instanceof module) ? (module) lc : (module) lc.owner;
        for (curveset qq : m.curvesets) clearoldregions(qq);
    }

    public void clearoldregions(curveset qq) {
        String[] excluded =new String[]{ "bunker", "AAUsurplus", "HFC", "CFC" };
        LinkedHashMap<Object, curve>  map=qq.map;
        List<region> regset=((region) regions.chosen).reg;
        //adapted so it keeps the ones that are not cleared in sep map, then puts them back
        LinkedHashMap<Object, curve> store=new LinkedHashMap();
        //store curves for regions that don't change - avoid losing data and wasting memory
        loopob: for (Object o : map.keySet()) {
            if (map.get(o).type==curve.Type.total) { store.put(o, map.get(o)); continue loopob; }
            for (String s : excluded) if (o.equals(s)) { store.put(s, map.get(o)); continue loopob; }
            if (regset.contains(o)) { store.put(o, map.get(o)); continue loopob; }
        }
        map.clear();
        //put them back in the order of new regset
        for (region r : regset) {
            if (store.containsKey(r)) map.put(r, store.get(r)); else qq.getOrAddCurve(r);
        }
        //put back others at the end
        for (Object o  : store.keySet()) if (!map.containsKey(o)) map.put(o, store.get(o));
    }
} //end socreg class









