/*
 * runAverage.java
 */
package jcm.mod.math;

/**
 * store 1D data vectors and allow linear interpolation from these
 * Very stupid algorithm, did not take time for it.
 */
public class runAverage {
    private float [] svals;
    private float rtot;
    private int cvl, fvl, nvl;
    
    /** Creates a new instance of runAverage, over set_nvl values */
    public runAverage(int set_nvl) {
        nvl=set_nvl; // # total values
        svals=new float[nvl];
        reset();
    }
    
    /** Reset averaging data table */
    public void reset() {
        cvl=-1; //previous value index (starts at -1 : no previous, next is 0)
        fvl=0;  //# already filled values
        rtot=0f;//"running total" for computing averages
        for (int ii=0; ii<nvl; ii++) {svals[ii]=0f;}
    }
    
    /** Include new data in the averaging and get current result */
    public float average(float xx) {
        int erv;
        cvl+=1;
        cvl=cvl-cvl*(int)Math.floor(cvl/nvl);
        fvl=Math.max(fvl,cvl+1); // number of values currently into the total
        svals[cvl]=xx; // store received data in stack 
        erv=cvl+1; // erv will be index of last in stack before current
        erv=erv-erv*(int)Math.floor(erv/nvl);
        rtot=rtot+xx-svals[erv]; // note : if "erv" points to empty values, these are 0s
        return rtot/fvl;
    }
    
}