package jcm.mod.math;
import static jcm.core.ob.module.*; //for time constants

public class mathcurve  {
	/*
	General mathematical curves used for stabilisation etc. (see jcm/mod/mitigation)
	Note, to keep equations simple, usually scale to make x=0 at x0 and x=1 at xs.
	 */
    public static double xr, xd, yd, r, a ,b, c ,d, e, f, k, p;
    
    //************************************************
    public static float padequartic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0,  double ys, double dys) {
		/*
		Make Padé type quartic curve  y = ( a + b.x + c.x.x ) / ( 1 + d.x + e.x.x ) as used by Enting et al (1994) for IPCC S scenarios
		Constrained by y & dy/dx at beginning and end of curve, plus initial d2y/dx2 which is a more general solution for a smooth start than the arbitrary point of Enting et al.
		Make the final dy/dx zero for stabilisation. The final d2y/dx is not controlled, and its value is returned
		 */
	
	xd=(double)xs-x0; yd=ys-y0;
	dy0*=xd; dys*=xd; d2y0*=(xd*xd);
	
	a= y0;
	d= (dy0 - 2.0*yd + dys*((dy0 / yd) + d2y0 / (2.0*yd)  )) / (yd - dys*dy0 / yd);
	b= y0*d + dy0;
	e= (1.0+d) * (dy0/yd - 1.0) + d2y0/(2.0*yd);
	c= e*y0 + d*dy0 + d2y0/2.0;
	
	for (int x=x0; x<=gey/*(xs < gey ? xs : gey)*/; x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)((a + b*xr + c*xr*xr)/(1.0 + d*xr + e*xr*xr));
	}
	
	double d2ys= (2.0 * (c - e*ys  - (d+2.0*e)*dys) / (1.0 + d + e) );
	d2ys /=  (xd*xd) ;
	//debug (" xd "+aa(xd)+" yd "+aa(yd)+" dy0 "+aa(dy0/ (xd))+" d2y0 "+aa(d2y0/ (xd*xd)) +" dys "+aa(dys/(xd)) +" d2ys "+aa(d2ys)+" a "+aa(a)+" b "+aa(b)+" c "+aa(c)+" d "+aa(d)+" e "+aa(e));
	return 	(float)d2ys;
    }
    
    //************************************************
    public static void padequintic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0,  double ys, double dys, double d2ys) {
		/*
		Make Pad� type quintic curve  y = ( a + b.x + c.x.x + f.x.x.x ) / ( 1 + d.x + e.x.x )
		This one has an extra sixth term on top, to allow additional constraint on d2ys
		 */
	
	xd=(double)xs-x0; yd=ys-y0;
	dy0*=xd; dys*=xd; d2y0*=(xd*xd); d2ys*=(xd*xd);
	
	a= y0;
	d= ( (dys - yd) * (3.0*yd - dy0 - 2.0*dys) + d2ys * (yd -  dy0 - d2y0 / 4.0) ) /  ( (dys - yd)* (dys - yd) +  (dy0 - yd) * d2ys /2.0  );
	b= y0*d + dy0;
	e= (3.0 * yd - 2.0 * dy0 - d2y0/2.0 - dys -d * (dys + dy0 - 2.0*yd) ) / (dys - yd);
	c= e*y0 + d*dy0 + d2y0/2.0;
	f= yd - dy0 - c + d*yd + e*ys;
	
	for (int x=x0; x<=gey/*(xs < gey ? xs : gey)*/; x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)((a + b*xr + c*xr*xr + f*xr*xr*xr)/(1.0 + d*xr + e*xr*xr));
	}
	//debug (" xd "+aa(xd)+" yd "+aa(yd)+" dy0 "+aa(dy0/ (xd))+" d2y0 "+aa(d2y0/ (xd*xd)) +" dys "+aa(dys/(xd)) +" d2ys "+aa(d2ys)+" a "+aa(a)+" b "+aa(b)+" c "+aa(c)+" d "+aa(d)+" e "+aa(e));
    }
    
    
    //************************************************
    public static void padecubictop(float[] curve, int x0, int xs, double y0, double dy0, double d2y0, double ys) {
	xd=(double)(xs-x0); yd=ys-y0;
	dy0*=xd; d2y0*=(xd*xd);
	
	a= y0;
	d = d2y0 / (2.0*(yd-dy0)) - 1.0;
	c = dy0 * d + d2y0 / 2.0;
	b = y0 * d + dy0;
	
	for (int x=x0; x<=(xs < gey ? xs : gey); x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)((a + b*xr + c*xr*xr) / (1.0 + d * xr ));
	}
    }
    
    //************************************************
    public static void padecubicbottom(float[] curve, int x0,  int xs, double y0, double dy0, double d2y0,double ys) {
	xd=(double)(xs-x0); yd=ys-y0;
	dy0*=xd; d2y0*=(xd*xd);
	
	a= y0;
	d= ( yd - dy0 - (ys/y0)*(d2y0/2.0) ) / ( dy0*(ys/y0) - yd);
	e = - (d* dy0 + d2y0/2.0) / y0;
	b = y0 * d + dy0;
	
	for (int x=x0; x<=(xs < gey ? xs : gey); x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)((a + b*xr ) / (1.0 + d * xr + e* xr*xr));
	}
    }
    
    //****************************************************
    public static void flatquadratic(float[] curve, int x0,  int xs, double y0, double dy0,double ys) {
	//y = a + bp + cp^2 , p =x/(1+x)
	xd=(double)(xs-x0); yd=ys-y0;
	dy0*=xd;
	a = y0; b =dy0;
	c= 4.0 * yd - 2.0 * dy0;
	for (int x=x0; x<=gey; x++) {
	    xr=(double)(x-x0)/xd; p = xr/(1.0+xr);
	    curve[x-gsy]=(float)(a + b*p + c*p*p );
	}
    }
    
    public static void flatquartic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0,  double ys, double dys) {
	//y = a + bp + cp^2 + dp^3 +ep^4, p =x/(1+x)
	xd=(double)(xs-x0); yd=ys-y0;
	dy0*=xd; dys*=xd; d2y0*=(xd*xd);
	a = y0; b =dy0;
	c = dy0 + d2y0/2.0;
	e = 48.0 * yd - 8.0 * dys - 16.0 * b  - 4.0 * c;
	d = 8.0 * yd - 4.0* b -  2.0*c - e/2.0;
	for (int x=x0; x<=gey; x++) {
	    xr=(double)(x-x0)/xd; p = xr/(1.0+xr);
	    curve[x-gsy]=(float)(a + b*p + c*p*p + d*p*p*p + e*p*p*p*p );
	}
    }
    
    //************************************************
    public static void simplecubic(float[] curve, int x0, int xs,  double y0, double dy0, double d2y0, double ys) {
	/* 		normal cubic curve constrained by start y, dy/dx and d2y/dx2, plus y at end */
	xd=(double)(xs-x0);
	dy0*=xd; d2y0*=(xd*xd);
	
	a= y0; b=dy0; c=d2y0 / 2.0;
	d=ys-(a+b+c);
	
	for (int x=x0; x<=(xs < gey ? xs : gey); x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)(a + b*xr + c*xr*xr + d * xr*xr*xr );
	}
    }
    
    public static void cubicend(float[] curve, int x0, int xs,  double y0, double dy0, double ys, double dys ) {
	/* 		normal cubic curve constrained by y, dy/dx at start and end */
	xd=(double)(xs-x0);
	dy0*=xd; dys*=xd;
	
	a= y0; b=dy0;
	d=dys + b +2f*a  - 2f*ys; c=ys- a - b - d;
	
	for (int x=x0; x<=(xs < gey ? xs : gey); x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)(a + b*xr + c*xr*xr + d * xr*xr*xr );
	}
    }
  
      public static void cubictwo(float[] curve, int x0, int xs,  int xe, double y0, double dy0, double ys, double ye ) {
	/* normal cubic curve constrained by y, dy/dx at start and 2 other y points 
         * added jun08 for explore peaking controlling emissions
         * y =a + bx + cx^2 + dx^3
         * dy= b + 2cx + 3dx^2
         * a=y0, b=dy0
         * ys= a + b + c + d
         * ye = a + br + cr^2 + dr^3
         * c+d= ys - a -b
         * c+dr = (ye - a - br)/r2
         * d= ((ys - a - b) - (ye - a - br)/r2 ) /( 1-r)
         * 
         * test if r=2 => 
         */
          
	xd=(double)(xs-x0); r=(xe-x0)/ xd;
	
	a= y0; b=dy0*xd;
	d= ((ys - a - b) - (ye - a - b*r)/(r*r) ) /( 1f-r);
        c= ys- a - b - d;
	
	for (int x=x0; x<=xe; x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)(a + b*xr + c*xr*xr + d * xr*xr*xr );
	}
    }
  
    
    public static void quarticend(float[] curve, int x0, int xs,  double y0, double dy0, double ys, double dys, double inty ) {
	/* 		quartic curve constrained by y, dy/dx at start and end, plus integral of y (end-start) */
	xd=(double)(xs-x0);
	dy0*=xd; dys*=xd; inty/=xd;
	a= y0; b=dy0;
	c=(60f*inty +3f*dys -24f*ys - 36f*a - 9f*b)/2f;
	d=4f*ys - dys - 4f*a - 3f*b - 2f*b;
	e=ys- a - b - c -d;
	
	for (int x=x0; x<=(xs < gey ? xs : gey); x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)(a + b*xr + c*xr*xr + d * xr*xr*xr +e *xr* xr*xr*xr );
	}
    }
    
    
    
    //************************************************
    public static void setofcubics(float[] curve, int[] x, float[] y, float[] dy) { 
	for (int n=0; n<x.length-1; n++) {
	    xd=(double)(x[n+1]-x[n]);
	    dy[n]*=xd;
	    a=y[n]; b=dy[n];
	    c=3.0*y[n+1]-3.0*y[n]-2.0*dy[n]-dy[n+1];
	    d=2.0*y[n]-2.0*y[n+1]+dy[n]+dy[n+1];
	    for (int xx=x[n]; xx<=x[n+1]; xx++) {
		xr=(double)(xx-x[n])/xd;
		curve[xx-gsy]=(float)(a + b*xr + c*xr*xr + d * xr*xr*xr );
	    }
	}
    }
    
    //************************************************
    public static void setoflinear(float[] curve, int[] x, float[] y) {
	for (int n=0; n<x.length-1; n++) {
	    xd=(double)(x[n+1]-x[n]);
	    for (int xx=x[n]; xx<=x[n+1]; xx++) {
		xr=(double)(xx-x[n])/xd;
		curve[xx-gsy]=(float)(y[n]*(1f-xr) +y[n+1]*xr);
	    }
	}
    }
    
    //************************************************
    public static void simplequartic(float[] curve, int x0, int xs, double y0, double dy0, double d2y0, double ys, double yh) {
	/* 		as above plus halfway constraint (yh) */
	xd=(double)(xs-x0);
	dy0*=xd; d2y0*=(xd*xd);
	
	a= y0; b=dy0; c=d2y0 / 2.0;
	d= 16.0*yh - ys - 15.0*y0  -7.0*dy0 - 1.5*d2y0;
	e= 2.0*ys - 16.0*yh + 14.0*y0 + 6.0*dy0 +d2y0;
	
	for (int x=x0; x<=gey; x++) {
	    xr=(double)(x-x0)/xd;
	    curve[x-gsy]=(float)(a + b*xr + c*xr*xr + d * xr*xr*xr + e * xr*xr*xr*xr);
	}
    }
    
    //****************************************************
    public static void expdecay(float[] curve, int x0, double y0, double dy0, double d2y0) {
	// y = (a + bx) exp(-kx)
	k= (dy0 - Math.pow((dy0*dy0 - y0*d2y0) , 0.5) ) / y0;
	a=y0; b=dy0 + y0*k;
	for (int x=x0; x<= gey ; x++) 	curve[x-gsy]=(float)((a + b*(x-x0)) *Math.exp(-k*(x-x0)));
    }
    
    public static void expdecay(float[] c, int sy, int dx) {
	int is=sy-gsy;
	expdecay(c, sy, c[is], (c[is]-c[is-dx])/dx, (c[is]+c[is-2*dx] - 2.0*c[is-dx])/(dx*dx)  );
    }
    
    
    double aa(double d) {	return ((int) (d*10000.0))/10000.0; }
    
    
} //end class

//old pade formula! //d=(dy0/yd)-2.0, e=1.0 + d2y0/(2.0*yd), c= y0+ ys*d2y0/(2.0*yd);
	/*
	old cubic curve - not so good as tend to extreme slopes at end
	for (int x=xs; x<=gey; x++) {
	xr=(double)(x-xs)/(double)xd;
	target[x-gsy]=(float)(ys +(3.0*yde-dye)*(xr*xr)+(dye-2.0*yde)*(xr*xr*xr));
}
	 */
	/*
	if (halfway) {
	double yhd=dys/(double)xd - y0;
	d= ( 3.0*yd*yhd + dy0*(2.0*yd - yhd) + (yd-yhd)*d2y0/2.0 ) / (yd*yhd - dy0*(yd-yhd));
}
	else
	 */

//OLD code for temp target
	/*
	//ipcc enting 94 pade type curve
	dy0*=(double)xd; d2y0*=(double)(xd*xd);
	double a=y0, e=(dy0/yd)-2.0, b=y0*e+dy0, f=1.0+ d2y0/(2.0*yd), c= y0+ ys*d2y0/(2.0*yd);
	double xr;
	for (x=x0; x<=(xs < gey ? xs : gey); x++) {
	xr=(double)(x-x0)/(double)xd;
	target[x-gsy]=(float)((a + b*xr + c*xr*xr)/(1.0 + e*xr + f*xr*xr));
}
	 */



