/*
Future Regional Land Use Change Emissions
Separate from CalcLucEmit as different interactions
Also separate from globco2emit which handles global LUC,
 since this is module is quite slow (can be rate-limiting step when changing many params in loop)

 */
package jcm.mod.luc;

import jcm.mod.obj.regset;
import jcm.mod.regemit.emitbase;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.par.param;
import jcm.mod.obj.*;
import jcm.mod.carbon.*;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
//import jcm.mod.scen.sres_base;
//import jcm.mod.scen.sresdata;
import jcm.mod.scen.sspChooser;
import jcm.mod.scen.sspData;
import static jcm.core.report.*;

public class futureLUC extends module {    //
    //***************** CURVES ****************
    //Note: Aug 11 potlucfrac increased 0.5=> 0.7, gives better shor-term transition - Sep16 with new SSP further inc to 0.75 to avoid potlucsink > scenario base
    public param potlucfrac = new param("potlucfrac", "", green, 0.75, 0, 2, expert); //fraction of accumulated luc emissions that is potential sink in one year

    public param potlucconvergence = new param("potlucfracConverg", "", green, 0.5, 0, 2, expert); //fraction of emissions/sink decrease

    public param lucconv = new param("luchistscenconv", "percent&per&year", dkgreen, 5f, 0f, 100f, expert);    //moved from sres_base
    
   public curveset //these three curvesets are only needed for checking how it works, not needed for calc (output is in emitbase/shares)
            potlucregquotacurves = new curveset("regpotlucquota", "mega&ton&carbon", fsyluc, gey, expert), //
             potlucregbasecurves = new curveset("regpotlucbase", "mega&ton&carbon", fsyluc, gey, expert), //
             lucscenario = new curveset("LUC scenario", "mega&ton&carbon", 2010, 2100, experimental); //


    //*********************** WORKING VARIABLES ***********
    List<region>  regsetreg;
    interpolator scenlucinterpolator;
    CalcLucEmit cle;
    globco2emit gc;
    //sres_base sb;
    
    Map<region, Float> potlucregbase = new HashMap(), //
            scenpotluc = new HashMap(), //
            srb4conv = new HashMap(), //
            srinitial = new HashMap(), //
            scenlucemit = new HashMap(), //
            potlucregquota = new HashMap(), //
            potlucregquota_init = new HashMap(), //
            potluchist = new HashMap(); //historical - for nations (moved from CLE)
    Map<region, Map<region, Float>> weight = new HashMap();
    boolean nopolicy;
    float corrfac=1f, fu, plf;
    //region totalreg;
    curveset emitlucbase, emitlucquota, histluc;
    curveset trend=new curveset("sres-trend", "", 2000, gey); //for internal use - storing info from base to quota loopcalcs

    region REF=regman.allreg.findreg("REFSSP"), OECD=regman.allreg.findreg("OECDSSP");
    //
    //******************** INTERACTIONS ************
    public void initsetup() {
        /*
    	totalreg=regman.allreg.findreg("TOTAL"); 
        scenreg= new ArrayList<region>(6);
        List<region> sspreg_orig=regman.allreg.findreg("SRES4").reg;
        for (region sr : sspreg_orig) if (sr!=totalreg) scenreg.add(sr);
       */
    	
        cle = gm(CalcLucEmit.class);
        gc = gm(globco2emit.class);
        //sb=gm(sres_base.class);
        

        emitlucbase = gm(emitbase.class).emitlucbase;
        emitlucquota = gm(emitquota.class).emitluc;
        //affectsfutureonly = true;
        //lucscenario.getOrAddCurve(totalreg).type = curve.Type.total;

        history.follows(cle);
        history.setaffectedby(gm(regset.class).regions);
        //only recalc base following gc if params changed or lucfbase changed (due to scenario, scenext or cle history)
        base.follows(history);
        
        base.follows(gm(sspChooser.class));
        
        //base.follows(gc); //experiment 
        //base.setaffectedby(sb.scenario);
        base.setaffectedby(lucconv, potlucconvergence, potlucfrac);
        base.setaffectedby(gm(jcm.mod.scen.sresBase.class).sresext); //WHY - this just sets pop, gdp, fos???
        quota.follows(base);
        quota.follows(gc);
        quota.setaffectedby(gm(pledges.class));
    }    //
    //************* HISTORY ***********
    public loopcalc history = new loopcalc("futluc-setup") {
        public void precalc() {
            regsetreg = gm(regset.class).regions.chosen.reg;
            for (curveset qq : curvesets) gm(regset.class).clearoldregions(qq);
            histluc = cle.lucsource.chosen.equals("Houghton") ? LUCdata.lucCO2CAIT1 : cle.lucemit;
            fu = cle.lucsource.chosen.equals("Houghton") ? 1f : 1000f;
        }

        public void calcstep() {
            if (year < fsyluc) {
                for (region r : regsetreg) emitlucquota.set(r, emitlucbase.get(r));
                emitlucbase.calctot();
                emitlucquota.calctot();
            }
            if (year == fsyluc - 1) {
                //P2 check: put here for efficiency, but previously that didn't work with houghton=>ivig=>houghton?
                histpotluc();
                setupweights();
            }
        }
    };
    //************ BASE *********
    public loopcalc base = new loopcalc("futluc-base") {
        public void precalc() {
            //scenlucinterpolator = new interpolator(sresdata.sres4luc, "SRES4", 1990, 10, gm(sres_base.class).scre, 1000f);
            scenlucinterpolator = new interpolator(gm(sspChooser.class).chosenSSPrun.get(sspData.gases.CO2_LUC), sspData.scenreg, 2000, 10, 12f/44f);
            //note first year of SSP data is really 2005, but if use only after 2010 this works OK 
            nopolicy = gm(controller.class).objective.chosen==controller.objopt.nopolicy;
            plf = -(float) (gm(futureLUC.class).potlucfrac.getval() / 100f); 
        }

        public void calcstep() {
            if (year == fsyluc - 1) initfut();
            if (year >= fsyluc) {
                for (region r : regsetreg) {
                    //potluc - add previous year 
                    potlucregbase.put(r, potlucregbase.get(r) + emitlucbase.get(r, year - 1) * plf);
                    potlucregbasecurves.set(r, potlucregbase.get(r)); //for checking 
                    //regional emissions start at the potluc baseline then add
                    emitlucbase.set(r, potlucregbase.get(r));
                }
                potlucregbasecurves.calctot();

                //initialise scenluc to sum of nations from history for same regions
                float totssp5 = 0;
                //if (year <= 2100) lucscenario.set(totalreg, scenlucinterpolator.getdata(totalreg, year));
                for (region sr : sspData.scenreg)  {
                        if (year <= 2100) {
                            lucscenario.set(sr, scenlucinterpolator.getdata(sr, year));
                            //follow trend of SSP scenario and also converge the gap
                            int lastyear= (year==fsyluc ? year : year-1);
                            scenlucemit.put(sr, (float) (lucscenario.get(sr) + (1f - lucconv.getval() / 100f) * (scenlucemit.get(sr) - lucscenario.get(sr, lastyear))));
                        } else { // after 2100 - convergence towards the potluc
                            
                            float convfac = (scenlucemit.get(sr) < scenpotluc.get(sr)) ? 1f : (float) potlucconvergence.getval() / 100f;
                            scenlucemit.put(sr, convfac * scenpotluc.get(sr) + (1f - convfac) * scenlucemit.get(sr)); //convergence to potluc
                            
                            //checked sresluc OK
                        }
                        //if (year <2150 && year% 10 == 0) deb("year="+year+" "+sr.name+" scenluc "+scenlucemit.get(sr));
                        totssp5 += scenlucemit.get(sr);
                    }
                    
                //correction factor, to be consistent with globco2emit - if total very small, use same as previous year to avoid spike
                if (totssp5 > 10 || totssp5 < -10) corrfac = gc.lucfbase.get() / totssp5;
                //if (year <2150 && year% 10 == 0) deb("year="+year+ "corrfac=" + corrfac); 

                //apply SSP5 using weights for each region
                for (region sr : sspData.scenreg)  {
                        scenlucemit.put(sr, scenlucemit.get(sr) * corrfac);
                        
                        //correction Aug2011 - due to SRES positve while recent emissions negative => problems
                        //tried remove after switch to SSPs but still occasional problems => put back
                         if ((sr==REF || sr == OECD) && scenlucemit.get(sr)>-100)  scenlucemit.put(sr, -100f);
                        scenpotluc.put(sr, scenpotluc.get(sr) + scenlucemit.get(sr) * plf);
                        trend.set(sr, (scenlucemit.get(sr) - scenpotluc.get(sr)) / srinitial.get(sr));
                        //note srinitial is the (lucemit- potluc) in initial year (actually averaged over five)

                       //if (year% 10 == 0 && year>=2100) deb("year="+year+" "+sr.name+" trend="+trend.get(sr)+" emit "+sreslucemit.get(sr)+" potluc "+srespotluc.get(sr) + " init "+srinitial.get(sr)+ " calc "+(sreslucemit.get(sr) - srespotluc.get(sr)) / srinitial.get(sr));

                        for (region r : regsetreg) { //note region loop inside 4region loop - potentially inefficient!
                            //note - emitlucbase was first set to potlucbase then each r-sr combination adds a bit
                            //note - the weights are  (lucemit-potluc) summed over  nations within both r & sr in initial year
                            emitlucbase.set(r, emitlucbase.get(r) + weight.get(r).get(sr) * trend.get(sr));
                        }
                    }
                //this is hardly necessary any more, since hist LUC extended to 2009...
                for (region r : regsetreg) if (r.name.equals("BRA") && year<=2010 && gm(CalcLucEmit.class).usePRODES.istrue()) {
                    emitlucbase.set(r,  emitlucbase.get(r, 2002)*CalcLucEmit.desmat_inpe_prodes[year-1988]/CalcLucEmit.desmat_inpe_prodes[2002-1988]);
                }

                emitlucbase.calctot();
                //region world=jcm.core.reg.regman.world;
                //float tot=0;
                //if (year % 5 == 0 && year<=2100) for (region r : regsetreg) deb("year="+year+" "+r.name+" potlucregbase "+potlucregbase.get(r));
                //if (year % 5 == 0 && year<=2100) deb("year="+year/**+" corrfac="+corrfac+" gc.lucfbase="+ gc.lucfbase.get()**/ +" totsres4="+totsres4+"\temitlucbasetot="+ emitlucbase.get(world));
               // if (year % 5 == 0 && year<=2100) deb("year="+year+" gc.potlucbase="+gc.potlucbase.get()+"\tpotlucregbase tot="+ potlucregbasecurves.get(world));
            }//if year
        }//calcstep
    };//base
    //************ QUOTA *********
    public loopcalc quota = new loopcalc("futluc-quota") {
        public void calcstep() {
            if (year == fsyluc - 1) for (region r : regsetreg) potlucregquota.put(r, potlucregquota_init.get(r));

            if (year >= fsyluc) {
                for (region r : regsetreg) {
                    //potluc - add previous year 
                    potlucregquota.put(r, potlucregquota.get(r) + emitlucquota.get(r, year - 1) * plf);
                    potlucregquotacurves.set(r, potlucregquota.get(r)); //for checking 
                    //regional emissions start at the potluc baseline then add
                    if (!skip(r)) emitlucquota.set(r, potlucregquota.get(r));
                }
                //divisor and scaledown
              //scaledown based on previous year, because there is a feedback (luc=>fossil=>sd=>luc)
                float divisor = (year <= fsyluc) ? (gc.lucquota.get(year - 1) - gc.potlucquota.get(year - 1)) : (gc.lucfbase.get(year - 1) - gc.potlucbase.get(year - 1));
                if (year > fsyluc && divisor < 100 ) divisor = 100f; //experiment sep16 for new low SSPs  
                float scaledownquota = (gm(carboncycle.class).lucf.get(year - 1) - gc.potlucquota.get(year - 1)) / divisor; 	
                if (year == fsyluc) scaledownquota = 1f;
                
                //if  (year==fsyluc) deb("futLUC scaledownquota from "+year+": " ); if (year<2008) deb("-"+scaledownquota);

                //apply SRES4 using weights for each region
                for (region sr : sspData.scenreg)  {
                        for (region r : regsetreg) { //note region loop inside 4region loop - potentially inefficient!
                            if (!skip(r)) emitlucquota.set(r, emitlucquota.get(r) + weight.get(r).get(sr) * scaledownquota * trend.get(sr));
                        }
                    }
                //this is hardly necessary any more, since hist LUC extended to 2009...
                for (region r : regsetreg) if (r.name.equals("BRA") && year<=2010 && gm(CalcLucEmit.class).usePRODES.istrue()) {
                    emitlucquota.set(r,  emitlucquota.get(r, 2002)*CalcLucEmit.desmat_inpe_prodes[year-1988]/CalcLucEmit.desmat_inpe_prodes[2002-1988]);
                }
                emitlucquota.calctot();
            }
        }
    }; //quota

    //skip LUC for Brazil and Indonesia during period set by pledges
    boolean skip(region r) {
        //!! P4 this will only work if Brazil and Indonesia are separate regions!
        pledges pl=gm(pledges.class);
        return (year>=2010 && year <=2020 && pl.usepledges.istrue() && pl.sepLUC.istrue() && (pledges.LUCpledge.find(r)!=null));
    }

//********************** INITFUT  *********************
    void initfut() {
        //set up initial emissions and potential emissions
        for (region sr : sspData.scenreg) {
            Set<region> srsubnat = sr.subreg(regman.nations);
            scenpotluc.put(sr, 0f);
            float srli = 0;
            for (region rr : srsubnat) {
                scenpotluc.put(sr, scenpotluc.get(sr) + potluchist.get(rr) * plf);
                for (int i = -5; i < 0; i++) srli += histluc.get(rr, fsyluc + i) / (fu * 5f); //average over 5 previous years to smooth blips
            }
            scenlucemit.put(sr, srli);
            srinitial.put(sr, srli - scenpotluc.get(sr)); //for (region rr : srsubnat) loop removed apr10 makes no difference
        }
        //float testtot=0;
        for (region r : regsetreg) {
            potlucregbase.put(r, 0f);
            for (region rr : r.subreg(regman.nations)) potlucregbase.put(r, potlucregbase.get(r) + potluchist.get(rr) * plf);
            potlucregquota_init.put(r, potlucregbase.get(r)); //testtot+=potlucregbase.get(r);
        }
        //deb("initfut potlucregbase ="+testtot+" gc.potlucquota="+gc.potlucquota.get() );
    }
//********************** WEIGHTS  *********************
   
    void setupweights() {
        //calculate weights for small regions as frac of SRES regions
        for (region r : regsetreg) {
            weight.put(r, new HashMap<region, Float>());
            for (region sr : sspData.scenreg) weight.get(r).put(sr, 0f);
            for (region rr : r.subreg(regman.nations)) {
                for (region sr : sspData.scenreg) if (sr.contains(rr)) {
                    float w1=weight.get(r).get(sr);
                    float w2 = -potluchist.get(rr) * plf; // * (sr==REF? 2f : 1f); 
                    for (int i = -5; i < 0; i++) w2+=histluc.get(rr, fsyluc +i) / (fu * 5f); //average over 5 previous years to smooth blips
                    if (w2<0) w2=0; //if emit < potluc
                        weight.get(r).put(sr, w1+w2);
                    }
            }
//	    for (region sr : sresreg.reg) System.err.println(""+r+" "+sr+" "+weight.get(r).get(sr));
        } //r
    }
//****************HIST POTLUC *********************
    /*
    this is slow because calculates for all nations  for all historical years
    first part was previously in CalcLucEmit for efficiency (only recalc if history changed) but moved here for clarity
    P2 maybe reconsider if using nations in histpotluc  is really necessary - seems to be needed for weights interpolating from SRES4
     */
    /* Problem REF region - E.Europe and Russia
     * E.Europe LUC emit in 2009 is -70MtC, the potluc is only -32
     * This is sensitive to the potlucfrac => at certain value it explodes - div by zero?
     * Basic problem is the potluc is too low for east europe - but inc the plf makes it too high for other regions (=> too much global sink)
     * it's low because we didn't take into account deforestation prior to 1750 - mainly in europe (and china)?
     * temporarily fixed by tweaking histpotluc
     */

    void histpotluc() {

        for (region r : regman.nations.reg) {
            potluchist.put(r, 0f);
            //fix the houghton/cait option
            if (cle.lucsource.chosen.equals("IVIGmodel")){
                for (int y = 1750/**1700**/;y < fsyluc; y++) //fixed april 10 to be consistent with global from 1750
                    potluchist.put(r, potluchist.get(r) + cle.lucemit.get(r, y) / 1000f);
                // Aug11 temporary fix  - increase the potluc for the REF and OECD regions => avoid negative weights
                if (REF.contains(r)) potluchist.put(r, potluchist.get(r)*1.5f);
                if (OECD.contains(r)) potluchist.put(r, potluchist.get(r)*1.5f);
            }
            //P3 starting calc regional potluc in 1850 will be problematic - as global starts in 1750
            if (cle.lucsource.chosen.equals("Houghton")) for (int y = 1850; y < fsyluc; y++)
                    potluchist.put(r, potluchist.get(r) + LUCdata.lucCO2CAIT1.get(r, y)); ///1000f
        }
    }
} //class


//*****************************************

/*
old convergence method
if (year>2100 ) {
//gradual convergence towards the potluc
//note NO MORE ADJUSTING OF GLOBAL TOTAL TO BE CONSISTENT WITH THIS! - implement in globco2emit
for (region r : regset.reg) {
fbase = emitlucbase.get(r, year-1) < potlucregbase.get(r) ? 1f : (float)gc.potlucconvergence.getval()/100f;
fquota = emitlucquota.get(r, year-1) < potlucregquota.get(r) ? 1f : (float)gc.potlucconvergence.getval()/100f;

if (potlucregbase.get(r)>0) emitlucbase.set(r,  fbase * potlucregbase.get(r) + (1f - fbase) * emitlucbase.get(r, year-1) );
else if (emitlucbase.get(r, year)<0) emitlucbase.set(r,0);

if (gc.fixedfrac.istrue() ) emitlucquota.set(r, emitlucquota.get(r, year-1)*get(carboncycle.class).lucf.get()/get(carboncycle.class).lucf.get(year-1));
else {
if (potlucregquota.get(r)>0) emitlucquota.set(r, fquota * potlucregquota.get(r) + (1f - fquota) * emitlucquota.get(r, year-1));
else if (emitlucquota.get(r, year)<0) emitlucquota.set(r,0);
}

potlucregbase.put(r, potlucregbase.get(r) + emitlucbase.get(r, year)*plf);
potlucregquota.put(r, potlucregquota.get(r) + emitlucquota.get(r, year)*plf);
}
} // post 2100
 *///*******************************
//old code ex futbasescen
//	new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 2003, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 1991, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 2002, 10, scre, 1000f).fill(emitluc, regset, startscenluc, 2100, CalcLucEmit.lucCO2IVIG);

