

package jcm.mod.luc;
 
import static jcm.gui.gen.colfont.*;
import static java.lang.Math.*;

public class biomestock {
    /*
     These fields used to be set static for one biome classification, as this is constant for all regions within one world,
     But now with parallel worlds we might have two classifications running in parallel, so can't be fixed statically
    Instead we refer to the parameter in CalcLucEmit to choose which set to use,
     */
    CalcLucEmit CLE; //this is a reference to the instance of CalcLucEmit which contains this biomestock, since there may be several CalcLucEmit with different parameters
    
    static float[] decaytime= new float[]{0.5f, 1f, 10f, 1000f};
    
    static int[][] vegCarbon = new int[][]{
	{0,5 ,10,0,0,1,6,7,64,81,106,117,69,7,2,18,29,80,147},
	{0,5 ,10,114,100,110,100,117,64,81,84,29,7,18,10,6,2,0},
	{0,16,15,209,165,215,100,213,71,81,84,20,3,8 ,10,7,6,0}
    }; // (t C/ha) !!!!
    static int[][] soilCarbon = new int[][]{
	{0,16,29,0,0,1,127,167,206,170,134,134,98,153,2,77,153,63,116},
	{0,16,29,89 ,130,150,160,134,206,170,170,153,153,77,60,127,2 ,116},
	{0,16,29,106,60 ,140,160,110,263,170,170,192,47 ,88,88,127,56,116}
    }; // (t C/ha)
    
    static int[][] vegRegTime = new int[][]{
	{0,2,2,0,0,100,100,100,80,42,25,25,18,2,2,2,2,20,40},
	{0,2,2,30,11,21,22,25,61,80,49,10,13,5,6,71,2,0}}; // (years)
    static int[][] soilRegTime = new int[][]{
	{0,2,10,0,0,100,100,100,80,42,25,40,18,2,2,2,2,20,40},
	{0,2,10,30,11,29,22,33,61,80,49,10,13,5,6,71,2,0}}; //Soil regeneration time (years)
    
    float[] decay = new float[4];
    float totarea, vegstock, soilstock, soildecay, potvegstock, potsoilstock;
    int type;
    
    
    biomestock(int t, float f, CalcLucEmit creator){
	type = t; vegstock = f; potvegstock = vegstock; CLE=creator;
    } // constructor
    
    float getdecayfrac(int box){
	//note this was previously biomeclass.equals("A") instead of biomeclass.chosen.equals("A") therefore would never have been true
	boolean grassy =  CLE.biomeclass.chosen==LUCdata.biomeclassification.A ? (type<3 || type>12 && type <17) : (type<3 || type>10);
	if (CLE.biomeclass.chosen==LUCdata.biomeclassification.A) switch(box) {
	    case 0 : return grassy ? 0.5f : type == 17 ? 0.38f : 0.33f;
	    case 1 : return grassy ? 0.48f : 0.3f;
	    case 2 : return grassy ? 0 : type == 17 ? 0.3f : 0.35f;
	    case 3 : return 0.02f;
	} else switch(box) {
	    case 0 : return grassy ? 0.5f : type == 4 ? 0.38f : 0.33f;
	    case 1 : return grassy ? 0.48f : 0.3f;
	    case 2 : return grassy ? 0 : type == 4 ? 0.3f : 0.35f;
	    case 3 : return 0.02f;
	}
	return 0;
    }
    
    void decayregrow(int dt){
	for(int i=0; i<4; i++) decay[i] *= (float)exp((float)-dt/decaytime[i])  ;
	soildecay *= (float)exp((float)-dt*(-log(0.05)/CLE.soildecayrate.getval()))  ; //20 is the default decay time
	//for(int i=0; i<4; i++) decay[i] = 0; //instant decay
	vegstock = potvegstock - (potvegstock - vegstock) * (float)exp((float)-dt/vegRegTime[CLE.biomeclass.getchosenindex()][type]);
	soilstock = potsoilstock - (potsoilstock - soilstock) * (float)exp((float)-dt/soilRegTime[CLE.biomeclass.getchosenindex()][type]);
	//stock= pstock; //instant regrow
    }
    
    void cutdown(float area, biomestock biometo){
	
	float soillossagric = (float)CLE.soillossagric.getval()/100f,
		soillosspast = (float)CLE.soillosspast.getval()/100f;
	
	//note this was previously biomeclass.equals("A") instead of biomeclass.chosen.equals("A") therefore would never have been true
	boolean grassy =  CLE.biomeclass.chosen==LUCdata.biomeclassification.A ? (type<3 || type>12 && type <17) : (type<3 || type>10);// ADDED
	float change = (area / totarea) * vegstock ;
	vegstock -= change;
	potvegstock -= change;
	for (int i=0; i<4; i++) decay[i] += getdecayfrac(i) * change;
	
	float soilchange, soilloss=0;
	soilchange = (area/totarea) * soilstock;
	
	if (CLE.simplemethod.istrue()) soilloss = soilchange *  0.2f ;
	else {
	    if (!CLE.grassyon.istrue()) if (type >  2) soilloss = soilchange * (biometo.type == 1 ? soillossagric : soillosspast); //0.2f : 0.05f);
	    if (CLE.grassyon.istrue()) if (type >  2 && !grassy) soilloss = soilchange * (biometo.type == 1 ? soillossagric : soillosspast); //0.2f : 0.05f);
	    if (CLE.grassyon.istrue()) if (type >  2 && grassy) soilloss = soilchange * (biometo.type == 1 ? soillossagric : 0); //ADDED
	    if (type == 2) soilloss = soilchange * (biometo.type == 1 ? (1f/(1f-soillosspast)) * (soillossagric - soillosspast) : 0 );
	    if (type == 1) soilloss = 0;
	}
	
	soildecay += soilloss;
	soilstock -= soilchange;
	potsoilstock -= soilchange;
	biometo.soilstock += soilchange - soilloss;
	totarea -= area;
    }
    
    void setregrow(float area, biomestock biomefrom){
	
	potvegstock += area * vegCarbon[CLE.ccontentset][type] * 0.1 * CLE.vegcerror.getval(); // * 0.1 converts tC/ha to k tC/km2
	
	if (type > 2) potsoilstock += area * soilCarbon[CLE.ccontentset][type] * 0.1; // * 0.1 converts tC/ha to ktC/km2
	
	if (type == 1 || (type == 2 && biomefrom.type != 1)) potsoilstock = soilstock;
	
	if (!CLE.simplemethod.istrue() && type == 2 && biomefrom.type == 1)
	    potsoilstock += (1f+(100f/80f)*0.15f) * (area/biomefrom.totarea) * biomefrom.soilstock;
	
	totarea += area;
    }
    
    void addarea(float area){
	totarea += area;
	vegstock += area  * vegCarbon[CLE.ccontentset][type] * 0.1 * CLE.vegcerror.getval(); // * 0.1 converts tC/ha to ktC/km2
	soilstock += area * soilCarbon[CLE.ccontentset][type] * 0.1; // * 0.1 converts tC/ha to ktC/km2
    }
    
    float totstock() {
	float totstock = vegstock + soilstock + soildecay;
	for(float f : decay) totstock += f;
	return totstock;
    }
}//end of biomestock class