/*
Static datasets and methods to load them, moved from CalcLucEmit
 */

package jcm.mod.luc;

import java.awt.Color;
import jcm.core.*;
import java.util.HashMap;
import java.util.Map;
import jcm.core.cur.curveset;
import jcm.core.data.loadtable;
import jcm.core.data.interpolator;
import jcm.core.data.pngdata;
import jcm.core.itf.dataholder;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static java.lang.Math.*;
import static jcm.core.report.*;

public class LUCdata extends module implements dataholder {
    
    // inefficiency in startup: see todo in luc.todo
     public void initsetup() { if (!loadeddata) getdata();    } 
 
    
    //*************************************
    //qtsets holding fixed data -same for all worlds
    public static curveset lucCO2Houghton = new curveset("Houghton LUC emit", "mega&ton&carbon", 1750, 2002); //orig data from 1850, but scaled back linearly to assuming zero at 1700
    public static curveset lucCO2UNFCCC = new curveset("UNFCCC LUC emit","mega&ton&carbon", 1990, 2002);
    public static curveset lucCO2CAIT = new curveset("CAIT LUC emit", "mega&ton&carbon", 1950,2000);
    public static curveset lucCO2CAIT1 = new curveset("CAIT/Houghton LUC emit", "mega&ton&carbon", 1850,2000); //interpolated from houghton
    public static curveset faoagr = new curveset("FAO Agriculture Area", "mega&m2", 1961, 2009);
    public static curveset faopast = new curveset("FAO Pasture Area", "mega&m2", 1961, 2009);
    
    // to read the grid files from EDGAR, need some fix in the country/ocean borders
    public static curveset edgarff = new curveset("EDGAR fossil", "mega&ton&carbon", 1890, 2000, complexity.experimental);
    public static curveset edgarluc = new curveset("EDGAR LUC", "mega&ton&carbon", 1890, 2000, complexity.experimental);
    
    //***************************************
    //other static data
    static boolean loadeddata=false, loadingdata=false;
    
    static Map<region, Float> countryArcviewAreas = new HashMap();
    
    //OK P4 transfor luTables to static byte array, since we have only 2 biome maps and often > 2 worlds, and it takes a lot of memory
    //as luTables hold a lot of data, use a primitive byte array to save memory and make it faster
    //note 2x8x720x360= 4147200 (4MB even as bytes)
    static int[] periods =     {1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990, 2009}; //2002 before update FAO
    static byte[][][][] luTables = new byte[2][periods.length-1][][];  //[A/B][period][x][y]
     
    //note converted to enum for convenience of code using this, could in principle convert to enum of enums?
    public enum biomeclassification {
	A(
		new String[]  {
	    "Ocean","Cultivated land","Pasture","X","X",
	    "Ice","Tundra","Wooded tundra",
	    "Boreal forest","Cool conifer forest","Temperate mixed forest",
	    "Temperate deciduous forest",    "Warm mixed forest","Grassland/Steppe",
	    "Hot desert","Scrubland",	    "Savanna",
	    "Tropical woodland", "Tropical forest"
	},
	new Color[]  {
	    black, red, pink, black, black,
	    white, cyan, dkcyan,
	    browngreen, dkredgreen, dkyellowgreen,
	    yellowgreen, olive, orange,
	    yellow, brown, ltgreen,
	    green, dkgreen
	}
	),
	B(
		new String[] {
	    "Ocean",
	    "Cultivated land","Pasture", "Tropical Evergreen Forest/Woodland", "Tropical Deciduous Forest/Woodland",
	    "Temperate Broadleafed Evergreen Forest/Woodland", "Temperate Needleleafed Evergreen Forest/Woodland", "Temperate Decidous Forest/Woodland",
	    "Boreal Evergreen Forest/Woodland", "Boreal Deciduous Forest/Woodland", "Evergreen/Deciduous Mixed Forest/Woodland",
	    "Savanna", "Grassland/Steppe", "Dense Shrubland",
	    "Open Shrubland", "Tundra", "Hot Desert",
	    "Polar Deser/Rock/Ice"
	},
	new Color[]  {
	    black,
	    red, pink, dkgreen, green,
	    dkgrey, olive, yellowgreen,
	    dkredgreen, dkyellowgreen, browngreen,
	    ltgreen, orange, brown,
	    dkbrown, cyan, yellow,
	    white, black
	}
	);
	
	public String[] names;
	public Color[] colors;
	boolean loaded=false;
	biomeclassification(String[] n, Color[]c) { names=n; colors=c; } //constructor
    };
    
    public static biomeclassification defaultBC=biomeclassification.B;
    
     
    //******** GET DATA ************************************
    
    /* note, we only load static data once and it same for all worlds
     however it takes time which is not good for display of first plot.
     therefore this is also called from startJCM,
     and since there is possibility of simultaneous call from event dispatching thread
     we have to make sure that one waits for the other
     */
    public static void getdata() {
	if (loadingdata)  while (!loadeddata) { Thread.yield(); }
	if (loadeddata) return;
	loadingdata=true;
	reporttime("begin make region polygons");
	for (region r : regman.nations.reg) r.makepolys(); //this is essential if not done already
	reporttime("loading static LUCdata curve sets");
	loadStaticData();
	reporttime("Loading LUC Biome Data");
	loadHYDEdata(defaultBC); //note this replaces former call to CLE precalc
	reporttime("end CLE loaddata");
	loadeddata=true; loadingdata=false;
    }
    
    static void loadStaticData(){
   //fileio.use_UTF_16=true;
        try {
	//loadtable.loaddata(faopast, "lucdata/FAO_pasture.csv", "\t", true, 1f, 1961, 2002, 1961);
	//loadtable.loaddata(faoagr, "lucdata/FAO_agriculture.csv", "\t", true, 1f, 1961, 2002, 1961);
            
    loadtable.loaddata(faopast, "data/lucnew/FAO11_Past.txt", "\t", false, 10f, 1961, 2009, 1961);
	loadtable.oldsplit(faopast, 2009);
    loadtable.loaddata(faoagr, "data/lucnew/FAO11_AraPC.txt", "\t", false, 10f, 1961, 2009, 1961); //note * 10 to convert 1000ha = 1000.00.00 => mega&m2
    loadtable.oldsplit(faoagr, 2009);
	loadtable.loaddata(lucCO2Houghton, "lucdata/houghtondata2000.csv", ";", true, 1f, 1850, 2000, 1850);
	} catch(Exception e) { e.printStackTrace(); }
    fileio.use_UTF_16=false;    
        
    	String[][] countrya = fileio.loadtab("lucdata/Country_areas.csv", "\t");
	for (int y = 3; y < countrya.length; y++) {
	    region r = regman.allreg.findormakereg(countrya[y][0], "LUC countryareas ");
	    float area =  Float.parseFloat(countrya[y][1]);
	    countryArcviewAreas.put(r, !countryArcviewAreas.containsKey(r) ? area : countryArcviewAreas.get(r)+area);
	}
       
        
    	//histdata.loaddata(lucCO2UNFCCC, "UNFCCC_LUC_emit.tab", "\t", true, 12f/44f, 1990, 2002, 1990);
	loadtable.loaddata(lucCO2UNFCCC, "lucdata/UNFCCC_LUC_emit_v1.tab", "\t", true, 1f, 1990, 2002, 1990);
        
        //problem is line above
        
	loadtable.loaddata(lucCO2CAIT, "lucdata/CAIT_LUC_emit.tab", "\t", true, 0.001f, 1950, 2000, 1950);
	
        
	for (region r : regman.allreg.findormakereg("HOUGHTON").reg) {
	    for (int y=1750; y<1850; y++) lucCO2Houghton.set(r, y, lucCO2Houghton.get(r, 1850)*(y-1700)/150f );
	}
	
	new interpolator(lucCO2Houghton, "HOUGHTON", 1950, 1f).fill(lucCO2CAIT1, regman.nations, 1850, 2000, lucCO2CAIT);
	//new interpolator(jcm12en, "JCM12", 1900, 1, false).fill(energy, regset, 1900, 2000, hydepop);
//	loadEDGAR(); //metrhod to read the grid files from EDGAR, need some fix in the contry/ocean borders
    }
    
    static void loadHYDEdata(biomeclassification AB) {
	for (int p=0; p<periods.length-1; p++) {
	    String filename = "lu_"+AB+"_"+periods[p];
	    luTables[AB.ordinal()][p]  = pngdata.load("lucdata/"+filename+".png",  AB.colors );
	} //p
	AB.loaded=true;
    }

    
} //end class

