package jcm.mod.energy;

import java.awt.Color;
import java.util.*;
import jcm.core.*;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.*;
import jcm.core.tls.*;
import jcm.mod.regemit.emitquota;
import jcm.mod.socio.*;
import static jcm.core.complexity.*;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;
import static jcm.mod.energy.old_fuel_experi_module.fueltype.*;

public class old_fuel_experi_module extends module {

float total1990;
 emitquota eq;
 int endyear=2050;

    public curveset fuels = new curveset("Fuel Consumption", "kilo&ton&PET", 1990, endyear);
    public curveset fuel_totals = new curveset("Fuel Consumption Totals", "kilo&ton&PET", 1990, endyear);
public param applychangefac = new param("Apply change fac", false);


   public enum fueltype {
       sol (dkgrey, "Solidos"), liq(orange, "Liquidos"), gas(green, "Gasosos)");
        fueltype(Color c, String s) { col=c; ln=s;}
        public Color col;
       public String ln;
   };
   EnumMap<fueltype, Float> ft=new EnumMap(fueltype.class);

    public enum fuel {
        Gasolina (yellow, 7454f, 1.01f,  liq),
        Querosene_de_Aviação(dkbrown, 1897f, 1.02f, liq),
        Querosene_Iluminante(brown, 190f, 1.03f, liq),
        Óleo_Diesel(orange, 21173f, 0.99f, liq),
        Óleo_Combustível(dkorange, 9436f, 0.98f, liq),
        GLP(dkred, 5472f, 0.97f, liq),
        Nafta(red, 972f, 1.05f, liq),
        Lubrificantes(cyan, 348f, 1.01f, liq),
        Outros_Prod_Sec_Petróleo(purple, 943f, 1.01f, liq),
        Outras_Primárias_Fósseis(pink, 205f,  1.01f, liq),
        Gás_de_Refinaria(blue, 1631f, 1.01f, liq),
        Coque_de_Petróleo(dkblue, 250f, 1.01f, liq),
        Carvão_Vapor(black, 1210f,  1.01f, sol),
         Alcatrão(dkgrey, 105f, 1.01f, sol),
         Coque_de_Carvão_Mineral(grey, 3632f, 1.01f, sol),
         Gás_Natural_SECO(dkgreen, 2515f,  1.01f, gas),
         Gás_Canalizado(green, 518f, 1.01f, gas),
         Gás_de_Coqueria(ltgreen, 4620f,  1.01f, gas);
    public Color col;
    public float val1990, changefac; //consumption in thousands tons of petroleum equivalent
    public fueltype type;
    fuel (Color c, float a, float b, fueltype t) { col=c; val1990=a; changefac=b; type=t;}

    };


    public void initsetup() {
         total1990=0;
        this.mycomplexity=experimental;
        for (fuel f: fuel.values()) {
                fuels.addcurve (new curve (f.name(), f.col, 1990, endyear));
                fuels.set(f.name(), 1990, f.val1990);
                total1990+=f.val1990;
                }
        for (fueltype t : fueltype.values()) fuel_totals.addcurve(new curve (t.ln, t.col, 1990, endyear));
        eq=gm(emitquota.class);
         follows(eq);

    }


    public void precalc() {
    }

    public void calcstep() {
       
        region brazil=regman.nations.findreg("Brazil");
        float total=eq.emitfos_nat.get(brazil), val, totfac=0;
        for (fueltype t : fueltype.values()) ft.put(t, 0f);

        if (applychangefac.istrue()) for (fuel f: fuel.values()) totfac+= f.val1990*Math.pow(f.changefac, year-1990);

        for (fuel f: fuel.values()) {
            if (applychangefac.istrue()) val= f.val1990*(float)Math.pow(f.changefac, year-1990)*total/totfac;
            else val=f.val1990*total/total1990;
            fuels.set(f.name(), val);
            ft.put(f.type, ft.get(f.type)+val);
        }
        for (fueltype t : fueltype.values()) {
            fuel_totals.set(t.ln,ft.get(t));
        }

    }



   /**
    //COMBUSTÍVEL	LÍQUIDOS	 Carvão_Metalúrgico (Nacional)		SÓLIDOS		 Emissões

    *
    */
  /**
   *
   *         String[][] fueltab = fileio.loadtab("jcm/mod/experi/fuels0.csv", ";");
        for (String[] a : fueltab) { String c="\n"; for (String b : a) c+=b+"\t"; deb(c); }

   *
   *  public static curveset faoagr = new curveset("FAO Agriculture Area", "mega&m2", 1961, 2002);
    public static curveset faopast = new curveset("FAO Pasture Area", "mega&m2", 1961, 2002);

   * loadtable.loaddata(lucCO2UNFCCC, "lucdata/UNFCCC_LUC_emit_v1.tab", "\t", true, 1f, 1990, 2002, 1990);
	loadtable.loaddata(lucCO2CAIT, "lucdata/CAIT_LUC_emit.tab", "\t", true, 0.001f, 1950, 2000, 1950);

   *public param FAO2002 = new param("use FAO agric/past rates of change", true, complexity.expert);
    public param biomeList = new param("Biome chosen for plot", biomeclass.chosen.names, "Cultivated land", complexity.expert);

   *
   */

}
