package jcm.mod.energy;

import jcm.core.ob.module;

import java.util.*;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.energy.enerData.*;

import jcm.mod.socio.popgdp;
import static jcm.mod.energy.enerData.*;
import static jcm.mod.energy.enerData.eregion.*;
import static jcm.mod.energy.enerData.info_type.*;
import static jcm.mod.energy.enerData.sub_sector.*;
import static jcm.mod.energy.enerData.source.*;
import static jcm.mod.energy.enerData.WEO_scenario.*;
import static jcm.mod.energy.electricity.methods.*;
import static  jcm.mod.energy.electricity.techpotopts.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.report.*;

public class fuels extends module {

    public curveset dummy=new curveset("dummy_curve");

    public param pricecoal=new param("price coal", "dollar&per&kilo&watt&year", fuelcost(Coal), 0,  fuelcost(Coal)*3);
    public param priceoil=new param("price oil", "dollar&per&kilo&watt&year", fuelcost(Oil), 0,  fuelcost(Oil)*3);
    public param pricegas=new param("price gas", "dollar&per&kilo&watt&year", fuelcost(Gas), 0,  fuelcost(Gas)*3);
    public param pricebiof=new param("price biofuel", "dollar&per&kilo&watt&year", fuelcost(Biomass_and_waste), 0,  fuelcost(Biomass_and_waste)*3);
    public param pricenuclear=new param("pricenuclear", "dollar&per&kilo&watt&year", fuelcost(Nuclear), 0,  fuelcost(Nuclear)*3);
    public param priceyear = new param("price year", "", 2030, 2010, 2050);

     enerGeneral ea; 

       // ======== LOOP METHODS ===========

    public void initsetup() {
        ea=gm(enerGeneral.class);
        follows(ea);
    }

    //==================================

    
     //applies the fuel price parameters
 float fuelprice(source c, int y) {
     int y2=(int)priceyear.getval();
     if (c==Oil) return (y>y2) ? (float)priceoil.getval() :     ((float)priceoil.getval()*(y-2010)+fuelcost(c)*(y2-y))/(y2-2010);
     if (c==Coal) return (y>y2) ? (float)pricecoal.getval() :     ((float)pricecoal.getval()*(y-2010)+fuelcost(c)*(y2-y))/(y2-2010);
     if (c==Gas) return (y>y2) ? (float)pricegas.getval() :     ((float)pricegas.getval()*(y-2010)+fuelcost(c)*(y2-y))/(y2-2010);
     if (c==Nuclear) return (y>y2) ? (float)pricenuclear.getval() :     ((float)pricenuclear.getval()*(y-2010)+fuelcost(c)*(y2-y))/(y2-2010);
     if (c==Biomass_and_waste) return (y>y2) ? (float)pricebiof.getval() :     ((float)pricebiof.getval()*(y-2010)+fuelcost(c)*(y2-y))/(y2-2010);
     return 0;
 }


}
