package jcm.mod.energy;

import java.util.*;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.energy.enerData.*;

import jcm.mod.socio.popgdp;
import static jcm.mod.energy.enerData.*;
import static jcm.mod.energy.enerData.eregion.*;
import static jcm.mod.energy.enerData.info_type.*;
import static jcm.mod.energy.enerData.sub_sector.*;
import static jcm.mod.energy.enerData.source.*;
import static jcm.mod.energy.enerData.WEO_scenario.*;
import static jcm.mod.energy.electricity.methods.*;
import static  jcm.mod.energy.electricity.techpotopts.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.report.*;

public class enerGeneral extends module {

    public curveset total_energy_use = new curveset("total_energy_use", "tera&Watt_hours", 2010, 2050);
    public curveset total_CO2 = new curveset("CO2_energy_total", "mega&ton&CO2", 2010, 2050);
    public curveset totcostplot = new curveset("costs_energy_total", "mega&dollar", 2010, 2050);
    //note - this is based only on IEA scenario in en_inData but changes depending on the scenario chosen
    public curveset IEAtotCO2=new curveset("IEA_TotalCO2", "mega&ton&carbon", 1990, 2035);

    public param<eregion> ch_reg=new param("Region", modelregions, World);
    public param<WEO_scenario> WEOscenario = new param("WEOscenario", futscen, New_Policies);
    public param regdisco = new param("regional discount rates", true);
    public param discount=new param("discount rate", "%", 6, 0, 15);
    public param carbonprice=new param("carbon_price", "dollar&per&ton&CO2", 50, 0, 200);
    public param demelasticity=new param("demand elasticity", "", 0.5, 0, 2);

    //====== variables ====

    popgdp pg;
    electricity el;
    transport tr;
    fuels fu;
    buildings bu;
    industry in;

     //========== MOD DATA ===========================

    public Map<eregion, ensec> enmap=new EnumMap(eregion.class);

     // ======== LOOP METHODS ===========

    public void initsetup() {
        
        fu=gm(fuels.class);
        el=gm(electricity.class);
        pg=gm(popgdp.class);
        tr=gm(transport.class);
        in=gm(industry.class);
        bu=gm(buildings.class);

        follows (pg);
        setaffectedby(fu);
        setaffectedby(el);
        setaffectedby(tr);
        setaffectedby(in);
        setaffectedby(bu);

        for (eregion r : modelregions )  enmap.put(r, new ensec(r));

    }

    public void setinteractions() {
        setaffectedby(discount, !regdisco.istrue());
    }

    public void precalc() {
       for (eregion r : modelregions )  if (r!=World) {
           data(r, WEOscenario.chosen, 2010);
           el.rmap.get(r).init();
           el.rmap.get(r).gettp(r);
       }
       fillIEAplot();
    }

      
         public void calcstep() {
            if (year<2010 || year>2050) return;
            for (eregion r : modelregions )  if (r!=World)  {
                 if (year<=2035) data (r, WEOscenario.chosen, year);
                enmap.get(r).getgdppop();
                //enmap.get(r).adjust();
                 el.rmap.get(r).adjust();
            }
        el.calcworld();
        el.fillplots();

        }


    void normaldisco() {

    }


    void fillIEAplot() {
        for (eregion r : worldregions) {
            //deb(r+" => "+r.jcmreg);
            //Object jcmrego=(r==International_Bunkers ? "bunker" : r.jcmreg);
            //note -exclude bunker because this is used by emitbase interpolator which expects regions only - would be ok if bunker were a region
            if (r==International_Bunkers) continue;
            for (int y=1990; y<=2035 ; y++) IEAtotCO2.set(r.jcmreg, y, getf(r, CO2_emissions, Total_CO2, Total, WEOscenario.chosen, y)*12f/44f); //note convert CO2 to carbon
        }
    }

    //============ GET DATA =================
 eregion last_reg;  info_type  last_type; sub_sector last_sec; source last_source; WEO_scenario last_scen; int last_year;
 int data(Object ... oo) {
     for (Object o : oo) {
     if (o instanceof eregion) last_reg= (eregion)o;
     if (o instanceof info_type) last_type=(info_type) o;
     if (o instanceof sub_sector) last_sec =(sub_sector) o;
     if (o instanceof source) last_source=(source) o;
     if (o instanceof WEO_scenario) last_scen=(WEO_scenario) o;
     if (o instanceof Integer) last_year=(Integer) o;
    }
     return get(last_reg, last_type, last_sec, last_source, last_scen, last_year);
}
         
    //======== ENERGY SECTOR - ONE REGION ========
    //=== put here data belonging to whole energy sector, not submodules  ===

    class ensec {
        //data for whole energy sector
        float gdp, pop;
        float disco;
        float gdpold, gdporig;
        eregion myreg;

        ensec(eregion reg) {
            myreg=reg;
        } //construct

        void getgdppop() {
            if (myreg.jcmreg==null) return;

            gdpold=gdp;
            gdp=0; pop=0;
             for (region r : myreg.jcmreg.subreg(regman.nations)) {
                 if (!Float.isNaN(pg.gdp_ppp_nat.get(r, year))) gdp+=pg.gdp_ppp_nat.get(r, year);
                if (!Float.isNaN(pg.pop_nat.get(r, year)))pop+=pg.pop_nat.get(r, year);
             }

     if (year==2020) gdporig=gdp;

     if ( regdisco.istrue() && year>2010) {
         disco=- (float)Math.log( (gdpold/gdp) );
     }
     else disco=- (float)Math.log( (100f - discount.getval())/100f);

     //if (year%5==0) deb("yr="+year+" "+ reg.name()+"  regdisc= " +gdpold/gdp);
     //if (year%5==0) deb("yr="+year+" reg="+reg.name()+" gdp="+gdp+" pop="+pop);
 }

    }


} //ensec
