/* module to hold the data from WEO, BP etc.
 * only needs to be run once, on startup (as for LUCdata)

 */

package jcm.mod.energy;

import java.awt.Color;
import java.util.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.dataholder;
import jcm.core.itf.hasColor;
import jcm.core.ob.*;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.*;

import static jcm.mod.energy.enerData.eregion.*;
import static jcm.mod.energy.enerData.info_type.*;
import static jcm.mod.energy.enerData.sub_sector.*;
import static jcm.mod.energy.enerData.source.*;
import static jcm.mod.energy.enerData.WEO_scenario.*;
import static jcm.core.report.*;
import static jcm.gui.gen.colfont.*;

public class enerData extends module implements dataholder {

 interface ismod extends hasColor {}
 
enum eregion implements hasColor {
    World,
    Brazil, Latin_America, Africa, Middle_East (grey, "MEA"), India, China, Non_OECD_Asia,
    Russia, Caspian (cream, "STA"), East_Europe_Eurasia, Japan, OECD_Pacific,
    European_Union (orange, "EU27"), OECD_Europe, United_States, OECD_North_America,
    Other_Latin_America (dkgreen, "IEAOLA"), Other_Asia (ltblue, "IEAOA"), Other_East_Europe (dkorange, "IEAOEE"), Aust_NewZ_Korea(pink, "IEAANK"), Other_OECD_Europe(yellow, "EUO"), Canada_Mexico (purple, "IEACAMX"),
    International_Bunkers (dkgrey); 
//IEAWEO + BRA IEAOLA AFR MEA IND CHI IEAOA RUS STA IEAOEE JAP IEAANK EU27 EUO USA IEACAMX
    Color color; region jcmreg;

    eregion (Object ... args) {
        String name= this.toString().replace("_", " ");
        for (Object o : args) {
            if (o instanceof String) name=(String)o;
            if (o instanceof Color) color= (Color)o;
        }
        jcmreg=regman.allreg.findreg(name); 
        if (color==null) color = (jcmreg!=null) ? jcmreg.color : infob.rcol();
    }
    public Color getColor() { return color; }
    }
static eregion[] WEOregions ={ Brazil, Latin_America, Africa, Middle_East, India, China, Non_OECD_Asia, Russia, Caspian, East_Europe_Eurasia, Japan, OECD_Pacific, European_Union, OECD_Europe, United_States, OECD_North_America,  International_Bunkers  };
static eregion[] worldregions={Brazil, Other_Latin_America,  Africa, Middle_East, India, China, Other_Asia, Russia, Caspian, Other_East_Europe, Japan, Aust_NewZ_Korea,  European_Union, Other_OECD_Europe, United_States, Canada_Mexico, International_Bunkers};
static eregion[] modelregions={World, Brazil, Other_Latin_America,  Africa, Middle_East, India, China, Other_Asia, Russia, Caspian, Other_East_Europe, Japan, Aust_NewZ_Korea,  European_Union, Other_OECD_Europe, United_States, Canada_Mexico};
static eregion[] worldsum={Latin_America, Africa, Middle_East, Non_OECD_Asia, East_Europe_Eurasia, OECD_Pacific, OECD_Europe, OECD_North_America,  International_Bunkers};
static eregion[][] otherregions={
    {Other_Latin_America, Latin_America, Brazil},
    {Other_Asia, Non_OECD_Asia, India, China},
    {Other_East_Europe, East_Europe_Eurasia, Russia, Caspian},
    {Aust_NewZ_Korea, OECD_Pacific, Japan},
    {Other_OECD_Europe, OECD_Europe, European_Union},
    {Canada_Mexico, OECD_North_America, United_States}
};

static eregion[][]  invest_info_regions ={
     {European_Union, Other_OECD_Europe},
     {United_States, Canada_Mexico },
     { Japan, Aust_NewZ_Korea },
     {Russia, Caspian, Other_East_Europe },
     {China,  Other_Asia, Brazil, Other_Latin_America },
     { India, Africa, Middle_East  }
};


enum info_type {
    Energy_Demand ("mega&ton&oil_equivalent"), Electricity_Generation ("tera&watt&hours"), Electrical_capacity ("giga&watt"), CO2_emissions("mega&ton&CO2"),
    Invest_costs("dollar&(2009)&per&kilo&watt"), Efficiency("%");
    String units;
    info_type(String s) { units=s;}
    }

enum sub_sector implements  ismod {
    TPED (dkorange), TFC (dkred), Total_generation(dkgrey), Total_capacity(dkgrey), Total_CO2(black),
    Power_generation(dkgrey), Other_energy_sector(dkblue), Industry(brown), Transport(red), Buildings(dkgreen), Other(purple),
    //        Heavy_Industry, Light_Industry, Transport, Commercial, Domestic, Construction, AgricForestFish, //End use sectors
    //below from investments table - subtype
    Capital_costs, O_and_M_costs, Efficiency_Generation, Capacity_Factor;
    sub_sector (Color c) {color=c;}
    sub_sector() { color=infob.rcol();}
    Color color;   public Color getColor() { return color; }
    }

// more useful EnumSet.of()?
static sub_sector[]
        totsecs  = { TPED, TFC, Total_generation, Total_capacity, Total_CO2},
        bigsecs = {Power_generation, Other_energy_sector, Industry, Transport, Buildings, Other };

enum energy_intensive_product {
    Steel, Cement, Metals, //High energy products + food...?;
}
enum service {
    Heat_Cool, Gadgets, Housing, Mobility, Food, Consumables;
    }

enum source  implements  ismod {
    Total(black), Coal (dkgrey), Oil (brown), Gas (grey),  Other_fuels(dkorange),  // split conventional , unconventional, shale gas etc. ??
    Biomass_and_waste(dkgreen), Biofuels(dkgreen), Biomass(dkgreen), //waste?
    Nuclear(pink), Hydro(ltblue), Wind(ltgreen), Geothermal(red), Solar(yellow), Solar_PV(yellow), CSP(olive), //Concentrating_Solar_Power
    Marine(dkblue), Other_renewables(cyan),
    Electricity(cream), Heat(orange),  //Refinery?
    //below from the investments table
    Coal_Subcritical, Coal_Supercritical, Coal_Ultrasupercritical, IGCC,
    CCGT, Gas_Turbine, CCGT_CHP, Fuel_Cell,
    Coal_Ultrasupercritical_CCS, IGCC_CCS, CCGT_CCS,
    Biomass_Power_Plant, Biogas_DG_Industry, Biomass_Cofiring, Biomass_CHP_Medium, Biomass_CHP_Small, Biomass_Waste_Incineration_CHP,
    Hydropower_Large_Scale, Hydropower_Small_Scale,
    Solar_Photovoltaics_Large_Scale, Solar_Photovoltaics_Buildings,
    Wind_Onshore, Wind_Offshore;
    
    Color color;
    source (Color c) {color=c;}
    source() { color=infob.rcol();}
    public Color getColor() { return color; }
    }

//for a given electricity source, find the set of related investment costs
//not data about oil, ignore the ccs and chp for now
//Nuclear,  CSP, Marine,  Geothermal : no_change
static source[][]invsources= {
    {Coal,   Coal_Subcritical, Coal_Supercritical, Coal_Ultrasupercritical, IGCC}, 
    {Gas, CCGT, Gas_Turbine },
    {Biomass_and_waste, Biomass_Power_Plant },
    {Hydro, Hydropower_Large_Scale, Hydropower_Small_Scale},
    {Wind, Wind_Onshore, Wind_Offshore},
    {Solar_PV, Solar_Photovoltaics_Large_Scale, Solar_Photovoltaics_Buildings}
};


static EnumSet<source>
        fuels=EnumSet.of( Coal, Oil, Gas, Biofuels, Other_fuels),
        thermal=EnumSet.of( Coal, Oil, Gas, Biomass_and_waste),
        renewables=EnumSet.of(Nuclear, Hydro, Wind, Solar_PV, CSP, Marine,  Geothermal),
        transformers= EnumSet.of( Electricity /*, Refinery*/),
        electricity_sources= renewables.clone();
static { electricity_sources.addAll(thermal); }
//below not yet used
static source[]  primary={Coal, Oil, Gas, Nuclear, Hydro, Biomass_and_waste, Other_renewables};
static source[]  secondary={Electricity, Heat, Biofuels, Other_fuels};



public enum WEO_scenario implements hasColor {
    Current_Policies (dkred, 2020,2030,2035),
    New_Policies (blue, 2020, 2025, 2030, 2035),
    S450_Scenario (dkgreen, 2020, 2030, 2035),
    history (black, 1990, 2008, 2015);
    int[] years;
    WEO_scenario (Color c, int... f) {color=c; years=f;}
    Color color;
    public Color getColor() { return color; }
    int i(int y) { for (int i=0 ; i<years.length; i++) if (years[i]==y) return i; return -1; }
    }
static WEO_scenario[] futscen= { Current_Policies, New_Policies,  S450_Scenario };



//============== PARAMS and PLOTs ===============
static boolean loadeddata=false, fixedcolors=false, changeplots=false;

public param<info_type> ch_type=new param("Type", info_type.values(), Energy_Demand){
    public void precalc() { try{
        //note we use European_Union because it also has the sector cost info
        ch_sector.menulist=regmap.get(European_Union /*ch_reg.chosen*/).get(ch_type.chosen).keySet().toArray(new sub_sector[0]);
        //note - can't use the chosen  region because might not be one for which have data stored in map
        ch_sector.chosen=ch_sector.menulist[0];
        ch_sector.precalc();
        } catch (Exception e) {deb("!! Error changing type "+ch_type.chosen); e.printStackTrace();}
}};
public param<sub_sector> ch_sector=new param("Sector", sub_sector.values(), TPED) {
    public void precalc() { try{
        ch_source.menulist=regmap.get(European_Union /*ch_reg.chosen*/).get(ch_type.chosen).get(ch_sector.chosen).keySet().toArray(new source[0]);
        ch_source.chosen=ch_source.menulist[0];
        changeplots=true;
        } catch (Exception e) {deb("!! Error changing sector "+ch_sector.chosen);  e.printStackTrace();}
}};
public param<source> ch_source=new param("Source", source.values(), Total);


public curveset regplot=new curveset("Regions", "", 1990, 2035, 5);
public curveset scenplot=new curveset("Scenarios", "", 1990, 2035, 5);
public curveset sourceplot=new curveset("Sources", "", 1990, 2035, 5);
public curveset sectorplot=new curveset("Sectors", "", 1990, 2035, 5);

//===== MAKE PLOTS ===

public void initsetup() { 
    if (!loadeddata) getdata();
}

public void setinteractions() {
    setaffectedby(gm(enerGeneral.class));  //for parameters - can't do in initsetup as data module sets up before others
}

public void precalc() {
    enerGeneral ea=gm(enerGeneral.class);
    WEO_scenario scen=ea.WEOscenario.chosen;
    eregion reg=ea.ch_reg.chosen;
    info_type type=ch_type.chosen;
    sub_sector sec=ch_sector.chosen;
    source source=ch_source.chosen;
    

    if (changeplots) { //triggered by param change
        String u=ch_type.chosen.units;
        regplot.units=u; scenplot.units=u; sourceplot.units=u; sectorplot.units=u;
        regplot.unitschanged=true; scenplot.unitschanged=true; sourceplot.unitschanged=true; sectorplot.unitschanged=true;
        sectorplot.map.clear();
        sourceplot.map.clear();
        changeplots=false;
    }
    for (eregion r : worldregions) {
       setupcurve(regplot, r);
        for (int y=1990; y<=2035 ; y+=5) regplot.set(r, y, getf(r, type,sec, source, scen, y));
    }
    for (WEO_scenario s : futscen) {
        setupcurve(scenplot, s);
        for (int y=1990; y<=2035 ; y+=5)  scenplot.set(s, y, getf(reg, type,sec, source, s, y));
    }
     for (source s : ch_source.menulist) {
         setupcurve(sourceplot, s);
        for (int y=1990; y<=2035 ; y+=5)  sourceplot.set(s, y, getf(reg, type,sec, s, scen, y));
    }
    for (sub_sector s : ch_sector.menulist) {
        setupcurve(sectorplot, s);
        for (int y=1990; y<=2035 ; y+=5)  sectorplot.set(s, y, getf(reg, type,s, source, scen, y));
    }

} //precalc

static String[] tots=new String[]{"Total", "TPED", "TFC"};
void setupcurve(curveset cs, hasColor o) {
    curve c=cs.getOrAddCurve(o);
    //c.color=o.getColor();
    String s=o.toString();
    for (String t : tots) if (s.startsWith(t))c.type=c.type.total;
}


//====== GET DATA =====

 static String oldmsg="", msg;

 public static float gettechpot(eregion reg, source c, int hilo) {
     return potentialmap.get(reg).get(c)[hilo];
 }

public static  float getf(eregion reg, info_type type, sub_sector sec, source source, WEO_scenario scen, int year) {
    int i=get(reg, type, sec, source, scen, year);
    return (i==0 ? Float.NaN : (float)i );
}

public static  int get(eregion reg, info_type type, sub_sector sec, source source, WEO_scenario scen, int year) {

    if (type==Invest_costs || type==Efficiency)  {
        for (eregion[] rr :  invest_info_regions)  for (eregion r :  rr) if (reg==r && reg!=rr[0]) return get(rr[0], type, sec, source, scen, year);
    }
    else {
        if (reg==World) {
        int d=0;
        for (eregion r : worldsum) d+=get(r, type, sec, source, scen, year);
        return d;
       }
        for (eregion[] rs : otherregions) if (reg==rs[0]) {
            int d=get(rs[1], type, sec, source, scen, year);
            for (int i=2; i<rs.length; i++) d-=get(rs[i], type, sec, source, scen, year);
            return d;
        }
    } //else
   
    try {
        int[] d=regmap.get(reg).get(type).get(sec).get(source).get(scen);
        int[] h=regmap.get(reg).get(type).get(sec).get(source).get(history);
        if (type==Invest_costs || type==Efficiency) {
            if (d==null || year<2009) return h[0];
            if (year>=2009 && year<2020) return (h[0]*(2020-year)+d[0]*(year-2009))/11;
            if (year>=2020 && year<=2035) return (d[0]*(2035-year)+d[1]*(year-2020))/15;
        }
        else {
            if (scen.i(year)>=0) return d[scen.i(year)]; //if got data for that year, use it
            if (year>=1990 && year<2008) return h[0]==0 ? h[1] : (h[0]*(2008-year)+h[1]*(year-1990))/18;
            if (year>=2008 && year<=2015) return (h[1]*(2015-year)+h[2]*(year-2008))/7;
            if (year==2025 && (scen==S450_Scenario || scen==Current_Policies)) return (d[0]+d[1])/2;
                if (year>2015 && year<2035) {
                int yd=year%5, y1=year-yd;
                return (get(reg, type, sec, source, scen, y1)*(5-yd)+get(reg, type, sec, source, scen, y1+5)*yd)/5;
            }
        }
        throw (new RuntimeException("Check Year"));
    } catch (Exception e) { 
        msg="No data: \t"+reg+" \t"+type+" \t"+sec+" \t"+source+" \t"+scen+" \t"; 
        if (oldmsg.startsWith(msg)) { System.out.print(" "+year); return 0; }
        else oldmsg=msg; deb(msg+year); return 0;
    }
}


//===== LOAD THE DATA ===
static Map<eregion, Map<info_type, Map<sub_sector, Map<source, Map<WEO_scenario, int[]>>>>> regmap = new EnumMap(eregion.class);
//static Map<eregion, Map<invest_info, Map<invest_plant, Map<WEO_scenario, int[]>>>> reginvmap= new EnumMap(eregion.class);
static Map<eregion, Map<source, float[]>> potentialmap = new EnumMap(eregion.class);

 static void getdata(){
    reporttime("start load Energy Data");
    String row=""; String[][] indata;
    try {
    Map<info_type, Map<sub_sector, Map<source, Map<WEO_scenario, int[]>>>> typemap;
    Map<sub_sector, Map<source, Map<WEO_scenario, int[]>>> secmap=null;
    Map<source, Map<WEO_scenario, int[]>> sourcemap=null;
    Map<WEO_scenario, int[]> scenmap;
    int[] d=new int[14];

    for (eregion reg : WEOregions) {
            typemap=new EnumMap(info_type.class);
            regmap.put(reg, typemap);
            indata  = fileio.loadtab("data/energy/"+reg+".txt", "\t");
             readline: for (String[] line : indata) {
                if (line.length==0) continue readline;
                row= line[0];
                if (row.equals("History") || row.equals("1990")) continue readline;  //skip column header rows
                for (info_type t : info_type.values()) if (row.startsWith(t.name())) { // identify data type
                            secmap=new EnumMap(sub_sector.class);
                            typemap.put(t, secmap);
                            continue readline;
                }
                source source=null;
                for (sub_sector c : sub_sector.values()) if (row.equals(c.toString())) { //identify sector
                                if (c==Transport && typemap.get(CO2_emissions)==secmap) continue readline; //skip the row CO2-TFC-oil-transport - out of order, and can be derived from TPED info
                                sourcemap=new EnumMap(source.class); source =source.Total;
                                secmap.put(c, sourcemap);
                  }
                  if (source==null) for (source s : source.values()) if (row.equals(s.name())) source=s; //identify source
                  if (source==null) {  deb("\n EnergyData can't process row: "+row+" of "+reg);   continue readline; }
                  scenmap=new EnumMap(WEO_scenario.class);
                  sourcemap.put(source, scenmap);
                  for (int n=1; n<14; n++) d[n]=(line[n].equals("-") ? 0 : Integer.parseInt(line[n]));
                  scenmap.put(history, new int[]{d[1],d[2],d[3] });
                  scenmap.put(New_Policies, new int[]{d[4],d[5],d[6], d[7] });
                  scenmap.put(Current_Policies, new int[]{d[8],d[9],d[10] });
                  scenmap.put(S450_Scenario, new int[]{d[11],d[12],d[13] });
            } //line
        } //reg

   int li=0; d=new int[16];
   source so=null; eregion reg=null;

   for (eregion[] rr :  invest_info_regions) {
       //Capital_costs, O_and_M_costs, Efficiency_Generation,
       secmap=new EnumMap(sub_sector.class);
       secmap.put(Capital_costs, new EnumMap(source.class));
       secmap.put(O_and_M_costs, new EnumMap(source.class));
       regmap.get(rr[0]).put(Invest_costs, secmap); //duplicate ref to same map for several regions
       secmap=new EnumMap(sub_sector.class);
       secmap.put(Efficiency_Generation, new EnumMap(source.class));// the inv cost sources are not all for power_generation, but most are - assume so temporarily
       secmap.put(Capacity_Factor, new EnumMap(source.class));
       regmap.get(rr[0]).put(Efficiency, secmap); //duplicate ref to same map for several regions
   }
   
   indata = fileio.loadtab("data/energy/Investments.txt", "\t");
   boolean renewable=false;
   readline: for (String[] line : indata) {
                li++; if (li<=3) continue readline;  //skip column header rows
                readrow: {
                    row= line[0];
                    for (source i : source.values()) if (row.equals(i.toString())) { so=i;  continue readline; }
                    if (row.startsWith("SWITCH")) { renewable=true; continue readline;}
                    for (eregion r : eregion.values()) if (row.equals(r.toString())) { reg=r; break readrow;}
                    if (row.equals("Europe")) { reg=European_Union; break readrow; }
                    if (row.equals("US")) { reg=United_States; break readrow;}
                    deb("\n EnergyData can't process investments row: "+row+ " of "+ so);   continue readline;
                }
                //String s=""; for (int n=0; n<line.length; n++) s+=" "+line[n]; deb(s);
                //note Integer.parseInt doesn't like the fractional year construction time - skip for moment with avoiding "."
                 for (int n=1; n<line.length; n++) d[n]=(line[n].equals("-") ? 0 : line[n].contains(".") ? 0  : Integer.parseInt(line[n].replace("%", "")));
                secmap=regmap.get(reg).get(Invest_costs);
                scenmap=new EnumMap(WEO_scenario.class);
                secmap.get(Capital_costs).put(so, scenmap);
                scenmap.put(history, new int[]{d[1]});
                scenmap.put(New_Policies, new int[]{d[2], d[3]});
                scenmap.put(S450_Scenario, new int[]{d[4], d[5]});
                scenmap=new EnumMap(WEO_scenario.class);
                secmap.get(O_and_M_costs).put(so, scenmap);
                scenmap.put(history, new int[]{d[6]});
                scenmap.put(New_Policies, new int[]{d[7], d[8]});
                scenmap.put(S450_Scenario, new int[]{d[9], d[10]});

                if (renewable && d.length<12) regmap.get(reg).put(Efficiency, regmap.get(European_Union).get(Efficiency)); //all countries point to same map
                else {
                    secmap=regmap.get(reg).get(Efficiency);
                    scenmap=new EnumMap(WEO_scenario.class);
                    secmap.get(Efficiency_Generation).put(so, scenmap);
                    scenmap.put(history,  new int[]{d[11]});
                    if (renewable) {
                        scenmap=new EnumMap(WEO_scenario.class);
                        secmap.get(Capacity_Factor).put(so, scenmap);
                        scenmap.put(history,  new int[]{d[12]});
                        scenmap.put(New_Policies,  ((line.length>14) ? new int[]{d[13], d[14]} : new int[]{d[12], d[12]})); //for some, future same as history
                        //construction time would also be appended here - either d[15] or d[13] 
                    } else {
                        secmap.get(Efficiency_Generation).put(so, scenmap);
                        scenmap.put(New_Policies, new int[]{d[12], d[13]});
                        scenmap.put(S450_Scenario, new int[]{d[14], d[15]});
                    }
                }
       } //line of investments

   indata = fileio.loadtab("data/energy/Renewable_Potentials.txt", "\t");
        li=0;
        source[] sourcelist=null; float[] df=new float[12];
        readline: for (String[] line : indata) {
            li++;
            if (line.length==0) break readline; //ignore notes after  blank line
            if (li==1) continue readline;
            if (li==2) {
                sourcelist= new source [line.length/2];
                int i=0; for (String s : line) { sourcelist[i/2] = source.valueOf(s.split("-")[0]); i++;}
                continue readline;
            }
            row=line[0];
            for (int n=1; n<line.length; n++) df[n-1]=Float.parseFloat(line[n]);
            reg=eregion.valueOf(row);
            Map<source, float[]> smap=new EnumMap(source.class);
            potentialmap.put(reg, smap); //String ss=reg.name()+": ";
            for (int i=0; i<sourcelist.length; i++) {
                smap.put(sourcelist[i], new float[]{df[i*2], df[i*2+1] } );
                 //ss+=sourcelist[i]+" "+df[i*2]+" "+ df[i*2+1];
            }
            //deb(ss);
        }
   } catch(Exception e) { deb("Error loading energy data: "+ row + e); e.printStackTrace();}
   reporttime("finished load Energy Data");
   loadeddata=true;

   /*
   for (eregion r : potentialmap.keySet()) {
       String s=r.toString()+": "; for (source c : potentialmap.get(r).keySet()) {
           s+=c.name()+": "+potentialmap.get(r).get(c)[0]+ " - "+potentialmap.get(r).get(c)[1];
       }
       deb(s);
   }
*/
   
    } //getdata

 //=========== PROVISIONAL DATA ================

            /*  kg co2 / kWh output (or Mton co2 / TWh )
              these are lifecycle numbers from sovacool 
              if was kwh input, would need to divide by efficiency
             later - replace this approach with construction, transport and fuel emissions etc
             could get better from SRREN fig SPM8 ? - checked - broadly similar
             */
              static float calcemit(source c) {
                    return 0.001f*(
                         c==Coal ? 1000f
                        : c==Oil ? 780f
                        : c==Gas ? 450f
                        : c==Biomass_and_waste ? 25f
                        : c==Nuclear ? 65f
                        : c==Geothermal ? 38f
                        : c == Hydro ? 10f
                        : c == Wind ? 10f
                        : c == Marine ? 10f
                        : c==Solar_PV ? 32f
                         : c==CSP ? 15f
                        : 0 );
                }

              static float fuelcost(source c ) {
                    return
                        (24 * 365) * (/* data per kwh input => per year*/
                        (c==Coal) ? 90f /*$/ton*/ / 5233f  /* =0.0172 */
                        : (c==Oil) ? 13.5f / 293.07f           /* =0.0461 or calc from spot price => 0.0504*/
                        : (c==Gas) ? 7.77f / 293.07f          /* =0.0265 */
                        : (c==Nuclear) ? 0.015f /* temporary guess  - one source says 0.77c/kwh  - however model needs fuel cost per kw in not out, => need to multiply c/kwh out by the efficiency 33%  - but add some for disposal*/
                        : (c==Biomass_and_waste) ? 0.02f /* temporary guess*/
                        : 0 );
                 }


//======== MISC ==========
//general method to concatenate two arrays of same type
 static <T> T[] add( T[] a, T[] b ) {
    T[] c= (T[])new Object[a.length+b.length];
    for (int i=0; i<a.length; i++) c[i]=a[i];
    for (int i=0; i<b.length; i++) c[i+a.length]=b[i];
    return c;
}

} //end class
