/* Electricity Module
 
 */

package jcm.mod.energy;

import java.util.*;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.par.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.mod.energy.enerData.*;

import jcm.mod.socio.popgdp;
import static jcm.mod.energy.enerData.*;
import static jcm.mod.energy.enerData.eregion.*;
import static jcm.mod.energy.enerData.info_type.*;
import static jcm.mod.energy.enerData.sub_sector.*;
import static jcm.mod.energy.enerData.source.*;
import static jcm.mod.energy.enerData.WEO_scenario.*;
import static jcm.mod.energy.electricity.methods.*;
import static  jcm.mod.energy.electricity.techpotopts.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.report.*;

public class electricity extends module {

     //========== CURVES ===========================
    public curveset electric_capacity = new curveset("generation_capacity", "giga&Watt", 2010, 2050);
    public curveset electric_production = new curveset("electricity_production", "tera&Watt_hours", 2010, 2050);
    public curveset electric_CO2 = new curveset("CO2_electricity", "mega&ton&CO2", 2010, 2050);
    public curveset totcostplot = new curveset("costs_electricity", "mega&dollar", 2010, 2050);

     //========== PARAMS ===========================
    
    public param depreciation=new param("depreciation", "%", 4, 0, 10);
    public param lifetime=new param("lifetime", "years", 40, 0, 80); //typical power station lifetime - note we have to use same for each plant, as comparing cost for equal production in kw - can't assume less cost for shorter life!
    public param maxexpsec=new param("max_expand_sector", "%", 20, 0, 100);
    public param maxexptot=new param("max_expand_total", "%", 20, 0, 100);
    public param appeffgeo = new param("apply efficiency geothermal", true);
    public param method = new param("Algorithm", methods.values(), price_driven);
    public param usetechpot = new param("renewable Technical Potentials",  techpotopts.values(), midtp);
    
    // ======== constants ======
    //note also more in energyData module - linked here by static imports
    enum methods { meet_demand, price_driven, surplus}
    enum techpotopts {ignoretp, hightp, midtp, lowtp }
    enum demandopts {}

    static  float convcapgen = 24f * 365f / 1000f; // to convert capacity in GW to generation in TWh per year
    static  float convMtoe_to_TWh = 11.84f; //1 MtoE= 40.4 T BTUs => * 1.055kJ = 42.622 M-GJ  => / 3600kJ = 11.84 TWh
    static float gwyrtoexaj=0.031536f; //kWh=>J = x3.6e6, so GWyr => J = x3.6 * 24 * 365 e12 J = 0.031536 EJ

    //========== VARIABLES ===========================

    public Map<eregion, elecsec> rmap=new EnumMap(eregion.class);
     enerGeneral ea;

    // ======== LOOP METHODS ===========

    public void initsetup() {
        ea=gm(enerGeneral.class);
        follows(ea);
        for (eregion r : modelregions )  rmap.put(r, new elecsec(r));
    }
    
    //=============================

    void calcworld() {
            for (source c : electricity_sources) {
                mod m= rmap.get(World).elec_map.get(c);
                m.capacity=0; m.supply=0; m.co2emit=0; m.totcostnet=0;
                for (eregion r : modelregions )  if (r!=World)  {
                    mod n= rmap.get(r).elec_map.get(c);
                    m.capacity+=n.capacity*n.capfac;
                    m.supply+=n.supply;
                    m.co2emit+=n.co2emit;
                    m.totcostnet+=n.totcostnet;
                 }
             }
        }

    void fillplots() {
            for (mod m : rmap.get(ea.ch_reg.chosen).elec_suppliers) {
            electric_capacity.set(m.name, year, m.capacity*(ea.ch_reg.chosen==World ? 1f : m.capfac));
            electric_production.set(m.name, year, m.supply);
            electric_CO2.set(m.name, year, m.co2emit);
            totcostplot.set(m.name, year, m.totcostnet);
            }
    }

 

    //=========== ONE COUNTRY ENERGY SECTOR ========================
    //info and methods regarding the whole energy sector - all sources and sectors, within one region
    //contains a list of mods
    class elecsec {
        //lists maps of mods (sources)
        List<mod> elec_suppliers = new ArrayList();
        Map<source, mod> elec_map=new EnumMap(source.class);
        mod tot_elec = new mod(Electricity);
        eregion myreg;
        enerGeneral.ensec en;
        float demorig, demandpergdp,  intfac;
        
        //working variables passed between methods
        float gap; mod me;

        elecsec(eregion reg) {
            myreg=reg;
            for (source c : electricity_sources) { mod m=new mod(c);  elec_suppliers.add(m); elec_map.put(c, m); }
        } //construct

         void init() { //note: doesn't apply to World
         en=ea.enmap.get(myreg);
        for (mod m : elec_suppliers ) {
                ea.data (m.name);
                m.capacity = ea.data(Electrical_capacity, Total_capacity, m.name );
                m.supply=ea.data(Electricity_Generation, Total_generation, m.name);
            }
        }


         
         //adjust the internal evolution of the state of the regional electricity sector, called for each timestep
        void adjust() {

            intfac= (1f - (float)Math.exp(-en.disco*lifetime.getval())) / en.disco;
            setdemand();

            //depreciate old capacity
            for (mod m : elec_suppliers) m.capacity*=(100f-depreciation.getval())/100f;

            for (mod m : elec_suppliers) {
                m.calccosts();
                //below integrates running costs over lifetime, discounted
                m.totinvcost=m.invcost/m.capfac + m.runcostgross *intfac;
            }

            supply();
            invest();

        } //adjust

          void setdemand() {

             if (year<=2035) tot_elec.demand= convMtoe_to_TWh*(ea.data(Energy_Demand, Other_energy_sector, Electricity)+ea.data(Energy_Demand, TFC, Electricity));
             if (year>2035) { tot_elec.demand+=demandpergdp*(en.gdp - en.gdpold);   }
             if (year==2020) { demorig=tot_elec.demand; }
             if (year==2035) {demandpergdp=(tot_elec.demand - demorig) / (en.gdp - en.gdporig);  } //deb("dpg="+demandpergdp+" dold="+demold+" gold="+gdpold);

         }

        void supply() {
            Collections.sort(elec_suppliers, run_cost);
            ///use supply to meet demand, cheapest first
            tot_elec.supply=0;
            gap=0;
            me=null; //most expensive supplier used - sets price to beat
            for (mod m : elec_suppliers)  m.supply=0;
            fillsupply: for (mod m : elec_suppliers)    {
                gap=tot_elec.demand- tot_elec.supply;
                if (gap<=0) break fillsupply;
                if (!m.available) continue fillsupply;
                m.supply = Math.min(gap, m.capacity*m.capfac*convcapgen);
                m.totcostnet=m.runcostnet*m.supply/convcapgen;
                me=m;
                tot_elec.supply+=m.supply;
            }
         }//supply

         void invest() {

              //mod cheapest_new=Collections.min(elec_suppliers, inv_cost);
             tot_elec.capacity=0; for (mod m : elec_suppliers) tot_elec.capacity+=m.capacity;

            float seed=tot_elec.capacity/50f; //note:  a seed amount to apply to macexpcaprate - so new tech can get started from nothing
            float maxexpand, maxexpandtot=tot_elec.capacity*(float)maxexptot.getval()/100f;

            Collections.sort(elec_suppliers, inv_cost);

            if (method.chosen==price_driven) {
            float elasticity=0.5f;
            float price =  me.runcostgross + ((gap<=0) ? 0  :  me.runcostgross* (gap)/(tot_elec.demand * (float)ea.demelasticity.getval()));
            //deb(" "+year+"  price= "+price + " ("+me.runcost+ ") "+ me.name);

            investloop:  for (mod m : elec_suppliers) {
               if (m.totinvcost > price* intfac ) break investloop;
               if (!m.available || m.capfac<=0) continue investloop;
               maxexpand=Math.min((seed+m.capacity)*convcapgen*m.capfac*(float)maxexpsec.getval()/100f, maxexpandtot);
               float changecap=(maxexpand/convcapgen)/m.capfac;
                m.capacity+=changecap;
                maxexpandtot-=changecap;
                m.totcostnet+=m.invcost*changecap;

            }
           }//pricedriven

            if (method.chosen==meet_demand || method.chosen==surplus) {
            //make new investment to fill any gap,
            //or if new investment cheapest new (inc construc cost) less expensive than most expensive current supplier

                //inv cost is dollar / kw (/yr) - capacity is
                //terawatthr=> kilowatt yr = *10^9/24/365

            int i=0;
            investloop: while ( i<elec_suppliers.size()) {
                mod m=elec_suppliers.get(i);
                if (!m.available)  { i++; continue investloop; }
                if (method.chosen==meet_demand && gap<=0) break investloop;
                if (method.chosen==surplus && gap <=0 && m.totinvcost >= me.runcostgross* intfac ) break investloop;
                //if (cheapest.invcost < me.runcost* intfac) deb(" "+year+" "+cheapest.name +" "+cheapest.invcost+" < "+me.name+" "+me.runcost* intfac );
                maxexpand=Math.min(
                        (seed+m.capacity)*convcapgen*m.capfac*(float)maxexpsec.getval()/100f,
                        (method.chosen==surplus ? maxexpandtot /*me.capacity*convcapgen*me.capfac*/ :  gap)
                        );
                //deb(" " +year+" "+cheapest.name+" "+cheapest.capfac);
                float changecap=(maxexpand/convcapgen)/m.capfac;
                m.capacity+=changecap;
                maxexpandtot-=changecap;
                m.totcostnet+=m.invcost*changecap;
                if (gap>0) { m.supply+=maxexpand; gap-=maxexpand; m.totcostnet+=m.runcostnet*maxexpand/convcapgen; }
                i++;
                }
            }

            for (mod m : elec_suppliers)    { m.co2emit=m.supply*m.emit_kgperkwh; }
       } //invest


       Comparator inv_cost = new Comparator<mod>() {
                public int compare (mod a, mod b) { return (int)( a.totinvcost - b.totinvcost); }
       };

       Comparator run_cost = new Comparator<mod>() {
                public int compare (mod a, mod b) { return (int) (a.runcostgross -b.runcostgross); }
       };

           void gettp(eregion reg) {
            for (source c : new source[]{Biofuels, Hydro, Wind, Solar, Marine,  Geothermal}) {
                //note should not allocate all to PV, nor all biofuels to electricity generation - think more about this
                source cc=(c==Solar ? Solar_PV : c==Biofuels ? Biomass_and_waste : c  );
                elec_map.get(cc).tplo=gettechpot (reg, c, 0);
                elec_map.get(cc).tphi=gettechpot (reg, c, 1);
            }
         }


    } //class ensec
    // info and methods about one sector or energy source, within one region
        class mod {
            mod(ismod type) {
                name=type;
                for (source c : renewables) if (c==name) renewable=true;
            }
            ismod name;
            boolean renewable, available;
            float capacity;
            float capfac, efficiency;
            float supply;
            float demand;
            float fuelcost, opcost, runcostgross, runcostnet, invcost, totinvcost, totcostnet;
            float emit_kgperkwh;
            float co2emit;
            float tphi=0, tplo=0;
            float invcostold, invcostrate;
            
               //note: some of this maybe inefficient - don't need to repeat for every timestep?
               void calccosts() {
                   source c=(source) name;
                   emit_kgperkwh=calcemit(c);
                   fuelcost = ea.fu.fuelprice(c, year);
                   totcostnet=0; //depends supply and construction - but not tax
                
                if (year<=2035) {
                    opcost=0; invcost=0; capfac=0; efficiency=0;
                    findsource: {
                        if (c==Oil) { c=Gas; } //invcost= 999999; break findsource; } //no data in table - make it big!
                        for (source [] ic : invsources) if (c==ic[0]) {
                        for (int i=1; i<ic.length; i++) { 
                            opcost += ea.data(Invest_costs, O_and_M_costs, ic[i]);
                            invcost +=ea.data(Invest_costs, Capital_costs, ic[i]) ;
                            if (renewable) capfac +=ea.data(Efficiency, Capacity_Factor, ic[i]) ;
                            efficiency+=ea.data(Efficiency, Efficiency_Generation, ic[i]) ;
                        }
                        int num=ic.length-1; opcost/=num; invcost/=num; capfac/=num; efficiency/=num;
                        break findsource;
                        }
                        opcost = ea.data(Invest_costs, O_and_M_costs, c);
                        invcost =ea.data(Invest_costs, Capital_costs, c) ;
                        if (renewable) capfac +=ea.data(Efficiency, Capacity_Factor, c) ;
                         efficiency+=ea.data(Efficiency, Efficiency_Generation, c) ;
                    }
                  efficiency/=100f;   capfac/=100f;

                  if(appeffgeo.istrue()) {
                     if (c==Geothermal || c==CSP) capfac*=efficiency; //asssume the costs per kw were per kw heat no electricity ???
                    }
                 }
               
                if (usetechpot.chosen!=ignoretp && tphi>0) {
                    float tp=usetechpot.chosen==hightp ? tphi : usetechpot.chosen==midtp ? (tphi+tplo*2f)/3f : tplo;
                    //tp are in EJ/yr, capacity is in GW , 
                    //deb(name+" "+tp+" "+capacity*gwyrtoexaj);
                    float fac=(tp/(tp-capacity*gwyrtoexaj));
                    if (fac<0) fac=Float.POSITIVE_INFINITY;
                    invcost*=fac;
                }

                if (year==2020) invcostold=invcost;
               if (year==2035) { invcostrate=(invcost-invcostold)/15; invcostold=invcost; }
               if (year>2035) invcost=invcostold+invcostrate*(year-2035);


                if (!renewable) capfac=0.85f; //should put better numbers
                //if (year%10==0) deb(""+name+" "+renewable+" "+efficiency+" "+capfac);
                    //runcost is dollar per kW-year
                    //this assumes opcost and invcost are per kW at max capacity => divide by capfac
                    runcostnet= (fuelcost/efficiency + opcost)/capfac;
                    runcostgross = runcostnet + (float)ea.carbonprice.getval()*emit_kgperkwh*(24f *365f / 1000f);
                     available=!(Float.isNaN(runcostgross) || Float.isInfinite(runcostgross)) ; //rules out Jap+Russia CSP
                    //deb(name+" " + runcost+ " "+capfac);
                    
              } //calccosts
        } //class mod

 } //end class

 
