/**
 Glotemp module holds the curves for the global temperature plot
 and serves as a linker to ther modules
 most relevant calculations are done in UDEBclimod and histemp modules.
 */

 

package jcm.mod.cli;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.

public class glotemp extends module  {
    
    //temperature baseyear: just affect temp-plot (& temps shown on regclimap) not model calculations
    //P2 note  putting baseyear + baserange > 2000 is likely to cause problems! - should automatically prevent this
    public static param baseyear=new param("baseyear", "", 1850, 1760, 2000, blue);
    public static param baserange=new param("baseyearrange", "", 15, 0, 25, blue, expert);
    public boolean usehisttempdata=false; //for feedbacks, used by some scripts
    public double error=0; //for probabilistic calculations in scripts
    
    
//****************** INTERACTIONS ***********************************
    
    public void setinteractions() {
        follows(gm(radfor.class));
        follows(gm(histtemp.class));
        setaffectedby(gm(udebclimod.class));
    } //end interactions
    
    //************** CURVES*****************************************
    //global average temp change, wrt 1750 -note other base years in glotemp module
    //note avchange is the curve used in other modules, whereas avchangeby (adjusted to baseyear) is just for display
    public curve
            avchange=new curve(	"tempavfrom1750", brown , experimental),
            avchangeby=new curve(	"tempav", brown , simplest);
    
    public curve
            tempnl=new curve( "tempnl"  , red ,  expert ),
            tempno=new curve( "tempno" , blue ,  expert  ),
            tempso	=new curve(  "tempso" ,  cyan ,  expert   ),
            tempsl	=new curve( "tempsl"  ,  orange , expert   );
    
    public curveset
            //note order: to send the proxy to the back of the CRU and GISS
            temp=new curveset(avchange, avchangeby, histtemp.temptrend , histtemp.proxytemp,  histtemp.tempdataGISS, histtemp.tempdataCRU,    "glotempcurves", "degcbase", simplest),
            boxtemp=new curveset( tempnl, tempno, tempsl, tempso, "Box Temperature", "degcbase" )
            ;
    
    
    
    //************************************
    // CALCULATION STEPS
    
    
    public void initsetup() {
        temp.associate(baseyear);
        boxtemp.associate(baseyear);
    }
    
    public void startstate(int startyear) {	gm(udebclimod.class).startstate(startyear); }
    public void save99() {	gm(udebclimod.class).save99(); }
    
    public void precalc() { if (baserange.getval()+baseyear.getval()>2005) baseyear.set(2005-baserange.getval());}
    
    public void calcstep() {
        /*
        jan09: order adjusted: call to tempupwellfb was first instruction, which is wrong, now moved to after the adjust method (and if (year>gsy) removed)
        old notes in udeb make clear that uwfb should be calculated *after* the rest, i.e. affects next years Q -not iterated
        alternative could be to put back order and use year-1
         */ 
        udebclimod udeb=gm(udebclimod.class); radfor rf=gm(radfor.class);
        avchange.set(year, udeb.adjust(new float[] {rf.splitrf[0].get(year), rf.splitrf[1].get(year), rf.splitrf[2].get(year), rf.splitrf[3].get(year)} ));
        udeb.tempupwellfb(avchange.get(year)); //a feedback on self, using last-year temp
        if (year==((int)baseyear.getval()  + baserange.getval()))  calcoffset(); //Need in loop because used for stabilisation target
        gm(sealevel.class).thermexp.set(year, udeb.thermalexpansion());
    }
    
    public void postcalc() {
        applyoffset(); calcerror();
    }
    
    //********** normalise to baseyear ****************
    public double offset=0, oldoffset=1.0;
    
    //store offsets outside loop so remember old value if calcfutureonly
    float[] boxoffset=new float[4];
    curve[] boxtempqt=  {	tempnl, tempno, tempso, tempsl } ;
    
    public void calcoffset() {
        //normalise to baseyear temps -or actually +/-x yr average due to odd peaks
        //now apply to all the boxtemps separately
        //note hist data normalised in temptrend method as doesn't change unless baseyear changed
        oldoffset=offset; offset=0; for (int b=0; b<4; b++) boxoffset[b]=0;
        int r=(int)baserange.getval(), rw=1+r*2; 
        for (int i=0; i<rw; i++) {
            int dy=(int)baseyear.getval()+i-r; if (dy<gsy) dy=gsy;
            offset+=(float)((avchange.get(dy))/rw);
            for (int b=0; b<4; b++) boxoffset[b]+=(float)((boxtempqt[b].get(dy))/rw);
        }
    } //end calcoffset
    
    void applyoffset() {
        
        for (int y=0; y<=gey; y++) {
            for (int b=0; b<4; b++) boxtempqt[b].set(y,  boxtempqt[b].get(y) -boxoffset[b]);
            avchangeby.set(y, (float)(avchange.get(y)-offset));
        }
    }
    
    
   /*
    TEMPERATURE -  CARBONCYCLE FEEDBACK
     these methods are called from carboncycle feedbacks
     Need a temperature rise relative to preindustrial, based on the previous year,
     because carboncycle precedes this module in the calculation loop
    
     Beware temperature normalisation to baseyear which isn't done until postcalc!
     so if calcfutureonly boxtemp[0] and boxtemp[249] are still normalised (prev loop)
     but boxtemp[250] isn't yet
    
     Actually taking sum/2 isn't correct - should weight by areas of N / S boxes!
    
    beware - these methods called even when this module is not changed so doesn't run loop methods!
    eg when call carbonstorage - makes carboncycle run but doesn't change this
    then problem is to undo the normalisation
    
    */
    
    double gettemprise(int b) {
        if (usehisttempdata && year<2007) {     	//option for history use data normalised to 1850
            float nfac=0, temprise;
            for (int s=1848; s<1853; s++) nfac+=histtemp.proxytemp.get(s)/5f;
            temprise=(year<1850 ? histtemp.proxytemp.get(year) : histtemp.tempdataCRU.get(year))-nfac;
            return temprise* (b==0 ?  1.356 : 0.847); //higher on land than ocean
        } else {
            return (year>1750? ((boxtempqt[b].get(year-1)+boxtempqt[3-b].get(year-1))
            +(	((loop.calcfutureonly && year<=2000) || !changed) ? (boxoffset[b]+boxoffset[3-b]) : 0)
            ) /2.0: 0);
        }
    }
    public double getoceantemprise() { return(gettemprise(1)); }
    public double getlandtemprise() { return (gettemprise(0)); }
    
    
    /**
     calculate error (difference model - data) for probabilistic calculations
     must do after both avchangeby and histdata have been offset
     assume proxy temp error 0.5C, measured temp error 0.05C+0.0015*(1950-year) up to 1950 (based on info from CRU faq)
     
     Note doesn't yet make use of the GISS data
     */
    public void calcerror() {
        float sumdiff=0, sumdata=0, sumcalc=0, n=0, ct, mt, e;
        for (int y=gsy; y<2007; y++)  {
            ct=avchangeby.get(y);
            if (y<1850) {	mt=histtemp.proxytemp.get(y); e=0.5f; } else {	mt=histtemp.tempdataCRU.get(y); e=0.05f+0.0015f*(y<1950 ? 1950-y : 0); }
            sumdiff+=(ct-mt)*(ct-mt)/e;
            sumcalc+=ct/e;
            sumdata+=mt/e;
            n+=1f/e;
        }
        error= Math.pow(sumdiff/n - (sumcalc/n - sumdata/n)* (sumcalc/n - sumdata/n), 0.5);
    }
    
} //end  class

 /*
  * P1 CHECK TIDY is old code below to adjust yscale origin depending on baseyear still useful?
  * //new scalemodel(scalemodel.Type.Y, "degcbase", -1.2, 3.2, 0.4, 1.0);
  * //this isn't working - affects only the hist data and not the scale!!
  * //scale moves up/down with baseyear so that curve doesn't move -but can be many instances of it
  *
  * public scalemodel getyscale() {	return new  scalemodel(allqt, getunits()) {
  * float oldoffset=avchangeby.a[200]-avchange.a[200];
  * public void setinteractions() {  setaffectedby(baseyear); super.setinteractions(); }
  * public void precalc() {
  * float offset=avchangeby.a[200]-avchange.a[200], change=offset-oldoffset; oldoffset=offset;
  * min.val+=change*scaleu; max.val+=change*scaleu;
  * }
  * }; }
  *
  */

