/*
This class allows experimentation with Java 6 features whilst isolating problems for users with  only Java 5. 

To Ensure Java 6 methods will run in JRE without crashing, 
surround them with a try-catch Error (not Exception)

To Compile JCM using Java 5:
Set problematic methods below to do nothing (comment out the inside leaving a empty brackets {}, return null if necessary )
Delete also jcm/gui/substance_link.java
If you do this, please exclude this file from SVN commit!

To test that all java 6 methods are caught OK:
1. clean and build and check all OK in Java 6 
2. set the java platform to java 5 (in netbeans right click on the project => Properties => Java Sources Classpath => Java Platform and choose JDK 1.5)
Now any new compiler errors should all be isolated in this class and surrounded by try-catch Error clauses 

Note: javac -source and -target do *not* detect missing classes etc., only language features such as generics (same in java 5 and 6)
 */
package jcm;

import java.awt.Window;
import java.awt.print.PrinterException;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import jcm.core.register;
import jcm.gui.gen.iconFinder;
import static jcm.core.report.*;

// ========== printing  html documentation directly  ===========
public class java6methods {
    public static void print(JEditorPane ep) {
        try {
            ep.print();
        } catch (PrinterException ex) {
            deb("tried printing " + ex);
        } catch (Error err) {
            deb("tried printing " + err + "\n note this requires Java 6!");
        }
    }
    // ========== sets the Icon to use in taskbar / dock  ===========
    public static void setIconImage(Window win) {
        try {
            win.setIconImage(((ImageIcon) iconFinder.findIcon("worldicon")).getImage());
        } catch (Error e) {
            deb(e, "Couldn't set Splash Icon");
        }
    }
   
    // =========== installs  substance look and feel    ========
    // Note: Substance Look and Feel (v5+) uses Java 6, and must also be added in the classpath  
    public static void installSubstance() {
        try { 
            String[] names = org.jvnet.substance.SubstanceLookAndFeel.getAllSkins().keySet().toArray(new String[0]);
            for (org.jvnet.substance.skin.SkinInfo si : org.jvnet.substance.SubstanceLookAndFeel.getAllSkins().values()) {
                try {
                    String cn = si.getClassName().replace("skin.", "skin.Substance").replace("Skin", "LookAndFeel");
                    register.class.getClassLoader().loadClass(cn);
                    UIManager.installLookAndFeel("S__" + si.getDisplayName(), cn);

                } catch (ClassNotFoundException e) {
                    deb(e);
                }
            }
            deb("installed substance OK");
        } catch (Error e) {
            deb(e, "Error Installing Substance");
        }
    }

    public static Boolean checkIsSubstance() {
        return UIManager.getLookAndFeel() instanceof org.jvnet.substance.SubstanceLookAndFeel;
    }

}