package jcm.gui.plot;
import jcm.core.*;
import jcm.core.par.param;
import jcm.gui.doc.labman;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import jcm.core.cur.curveset;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.core.itf.menuFiller;
import static jcm.core.report.*;

public class scaleview extends JPanel implements MouseInputListener, menuFiller {
    
//    public static param
//            linkx=new param("linkx", false),
//            showscales=new param("showscales", true);
    
    param sp;
    float fac=colfont.normalfont.getSize()/12f;
    double origmin, origmax;
    Component aboveleft;
    int lw=0, w, h;
    boolean isyear=false;
    
    public scaleview() {} //don't use - to please compiler
    public scaleview(param sp) {
        this.sp=sp;
        sp.units.checkunitfac(sp.max()-sp.min());
        if (sp.units.allowfac) sp.units.checkunitcancel();
         sp.units.units=sp.units.units.replace("per&person", "per&capita" ); //added jun10
        origmin=sp.min; origmax=sp.max;
        origin=(sp.type==sp.type.Xscale) ? 2000 : 0 ;
        //setOpaque(true);
        setBackground(Color.white);
        if (sp.type==sp.type.Xscale && sp.units.units.equals("year")) isyear=true;
        setPreferredSize((sp.type==sp.type.Xscale) ? new Dimension(0, isyear ? (int)(24*fac) : (int)(45*fac) ) : new Dimension((int)(45*fac),0));
        setToolTipText(labman.getTitle(sp.getstate())); //name+"&"+sp.units.units)
        
        addMouseListener(this);
        addMouseMotionListener(this);
        setCursor(new Cursor(sp.type==sp.type.Xscale ? Cursor.E_RESIZE_CURSOR : Cursor.N_RESIZE_CURSOR));
        new jcmMenu(this);
        //if (sp.type==sp.type.Xscale) sp.setaffectedby(linkx);
    }
    
    
    public void fillMenu(jcmMenu popup) {
        popup.add(new jcmAction("Restore Original") { public void act() { restore(); }});
    }
    
    public void restore() { sp.min=origmin; sp.max=origmax; sp.changed=true; loop.golater("Scale Restore"); }
    
    public void paintComponent(Graphics g) {
        super.paintComponent(g); //paint background
        getdim();
        lookandfeel.setAntiAlias(g);
        
        if (sp.type==sp.type.Xscale) g.drawLine(lw, 0, lw+w, 0);
        if (sp.type==sp.type.Yscale) g.drawLine(w-1, 0, w-1, h);

        if (lookandfeel.bigscales.istrue()) g.setFont(colfont.normalfont); else g.setFont(colfont.smallfont);

        drawnums(g);

        if (lookandfeel.bigscales.istrue()) g.setFont(colfont.bigfont); else g.setFont(colfont.normalfont);

         if (sp.type==sp.type.Xscale && !isyear) {    
            g.drawString(labman.getTitle(sp.units.units), 40 , h-4);
        }

        if (sp.type==sp.type.Yscale) {
            Graphics2D g2=(Graphics2D) g;
            g.translate((int)(12*fac), 20+h/2);
            g2.rotate(-Math.PI/2.0);
            g.drawString(labman.getTitle(sp.units.units), -h/3 , 0);
        }
        g.setFont(colfont.normalfont);

    }
    
    void drawnums(Graphics g) {
        //	sp.units.checkunitfac(sp.range());
        //if (sp.units.scales!=0) System.err.println("sp "+sp.units.units+" "+sp.min()+" "+sp.max() +" "+sp.range()+"  "+ sp.units.scales+" "+sp.units.minstep(sp.min()));
        g.setColor(Color.black);
        double vststep=sp.units.scales / 5.0d;   // sub-ticks step
        double vstbase=vststep*(int)(Math.ceil(sp.min()/vststep));  // first sub-tick mark position
        if (sp.units.scales!=0) for (double v=vstbase; v<=sp.max(); v+=vststep) {
            int p=pixel(v);
            String s=sp.units.round(v); int sw=sw(g,s);
            if (sp.type == sp.type.Xscale) {
                if (w > 8 && Math.abs(Math.abs(v) - sp.units.scales * (int) (0.5f + Math.abs(v) / sp.units.scales)) < 0.01f) {
                    g.drawLine(p, 0, p, 6);
                    g.drawString(s, p - sw / 2, isyear ? h - 4 : (h/2)-4);
                } else {
                    g.drawLine(p, 0, p, 3);
                }
            }
            if (sp.type == sp.type.Yscale) {
                if (w > 8 && Math.abs(Math.abs(v) - sp.units.scales * (int) (0.5f + Math.abs(v) / sp.units.scales)) < 0.01f) {
                    g.drawLine(w - 6, p, w, p);
                    g.drawString(s, w - (sw + 5), p + 4);
                } else {
                    g.drawLine(w - 3, p, w, p);
                }
            }
           /* for (double vst = v+sp.units.scales/5.0f; vst < v+sp.units.scales; vst += sp.units.scales / 5.0f) {
                p = pixel(vst);
                s = sp.units.round(vst);
                sw = sw(g, s);
                if (sp.type == sp.type.Xscale) {
                    g.drawLine(p, 0, p, 5);
                }
                if (sp.type == sp.type.Yscale) {
                    g.drawLine(w - 5, p, w, p);
                }
            } */
        } else deb("sp.units.scales=0");
    }
    
    void getdim() {
        lw= (sp.type==sp.type.Xscale && aboveleft!=null) ? aboveleft.getWidth() : 0;
        w=getWidth()-lw; h=getHeight();
    }
    
    int pixel(double v) {
        if 	(sp.type==sp.type.Xscale)   return (int)(lw+w*(v-sp.min())/sp.range());
        else return h - (int)(h *(v-sp.min())/sp.range());
    }
    
    double real(int p) {
        if 	(sp.type==sp.type.Xscale)   return sp.min()+(p-lw)*sp.range()/w;
        else return  sp.min()+(h-p)*sp.range() / h;
    }
    
    
    public  int sw(Graphics g, String s) {	return colfont.sw(g, s); } 
    
    
    //**********************************************
    //adjusting by drag
    
    //for dragging scales
    public double origin, dp, oldmax, oldmin; int ep, op; boolean dragorigin=false;
    
    public void mouseDragged(MouseEvent e) {
        try {
            ep=  (sp.type==sp.type.Xscale ? e.getX() : e.getY());
            if (dragorigin) {
                dp=(double)((ep-op)*sp.range())/(double)(sp.type==sp.type.Xscale ? -w : h);
                sp.max += dp; sp.min+=dp;
            } else {
                dp= ((double)op - pixel(sp.min)) / ((double)ep - pixel(sp.min));
                if (dp<0.8f) dp=0.8f;
                //sp.max =sp.min()+(sp.max()-sp.min())*dp;
                 sp.max = origin + (sp.max()-origin)*dp;
                 sp.min = origin + (sp.min()-origin)*dp;
            }
            op= ep;
            sp.changed=true; loop.gonow(false);  //easier to drag if wait for the response?
//	sp.respond(true);
            setToolTipText(labman.getTitle(sp.getstate())); //name+"&"+sp.units.units)
            sp.units.checkunitfac(sp.max()-sp.min());
            sp.units.checkunitcancel();
            repaint();
        } catch (Exception ex) { deb("Mouse Dragging Scale => "+ex); sp.max=oldmax; sp.min=oldmin; sp.changed=true;   }
    }
    
    public void mousePressed(MouseEvent e) {
        op= (sp.type==sp.type.Xscale ? e.getX() : e.getY());
        dragorigin= e.getClickCount()>1; if (dragorigin) origin=real(op);
        oldmax=sp.max; oldmin=sp.min;
        //		dragorigin= (op - pixel(origin))<40 && (op - pixel(origin))>-40; // && !((graph)holder).stacked.istrue();
    }
    
    public void mouseReleased(MouseEvent e) {	dragorigin=false; }
    public void mouseClicked(MouseEvent e) {	}
    public void mouseMoved(MouseEvent e) {	}
    public void mouseExited(MouseEvent e) {	}
    public void mouseEntered(MouseEvent e) {	}

    public void changeunits(curveset c) {
        sp.units.units=c.units;
        sp.units.scales=1.0f; sp.units.scaleu=1.0f;
        sp.units.checkunitfac(sp.max()-sp.min());
        sp.units.checkunitcancel();
        repaint(); c.unitschanged=false;
        System.out.println("units changed!");
         }
} //end class

/*
 
 P1 TIDY old scaleview methods
 
Note: in principle this should have an iob to catch affectedby scalemodel,
but unnecessary while this is only changed by mouse-drag
 
        //*******************
        //linkx -adjust all plots x-axis together
 
        static {	linkx.owner=new scale(); showscales.owner=new scale(); }
 
//at end of drag		if (linkx.istrue() && this.type==Xscale) linkx();
 
        this is causing an error because no max/min for linkx dummy owner! linkx still works once start dragging a scale
        public void precalc(iob iob) {
        if (iob==linkx) if (linkx.istrue()) linkx();
}
 
 
        void linkx() {
                for (int p=0; p<holder.holder.cpl.np; p++) 	if (holder.holder.cpl.pan[p] instanceof graph) {
                        graph gpan=(graph) holder.holder.cpl.pan[p];
                        if (gpan!=owner && gpan.output) {
                                gpan.xscale.min.val=min.val; gpan.xscale.max.val=max.val; gpan.xscale.min.changed=true;
}}
}
 
//******************************************
                Could in principle replace the pixel, real and conversions etc. with translate/scale g2
                Beware lines could come out too thick!
 
                Graphics2D g2 = (Graphics2D) g;
                AffineTransform oldat = g2.getTransform();
                if (sp.type=sp.type.Xscale) { g2.scale(w/sp.range(), 1);  g2.translate(-xscale.min(), -yscale.max());  }
                else { g2.scale(1, -h/sp.range()); g2.translate(-xscale.min(), -yscale.max());  }
 */

