package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.*;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import static jcm.core.report.*;


public class lineplot extends baseplot   {
    
    boolean stacked=false, showarrows=true;
    public int[] labyear={1990,2020}; //years for labels - adjust in script
    Set<arrow> arrows;
    EnumMap<curve.linestyle, BasicStroke> strokes= new EnumMap(curve.linestyle.class);
    
    public lineplot(curveset qq) { this(new Object[]{qq}); }
    public lineplot(Object[] args) {
	for (Object o : args) {
	    if (o.toString().contains("stacked"))  stacked=true;
	    if (o instanceof curveset) qq=(curveset)o;
	    try { scalesetup.add(Float.parseFloat(o.toString())); } catch (NumberFormatException e) {}
	}
	setup();
	if (stacked && !hidelegend ) legend.stacked=true;
    }
    
    
    void extrasavesetup(List al) { if (stacked)  al.add("stacked");    }
    
    void makescales() {
	xscale=qq.getxscale();
	yscale=qq.getyscale(stacked);
    }
    
    void makeplot() { plot =new lineplotmainpan(); };
    
    public void fillMenu(jcmMenu popup) {
	if (!(qq.type==qq.type.ratio || qq.type==qq.type.ratefrac)) { //doesn't make sense to stack rate or ratio
	    popup.add(new jcmAction("Stack Curves", complexity.simplest)  { public void act()  { changestack(); }});
            if (arrows!=null) popup.add(new jcmAction("Remove/Show Arrows", complexity.simplest)  { public void act()  { changearrows(); }});
	    popup.addSeparator();
	}
	super.fillMenu(popup);
    }
    
    void changestack() {
	stacked=!stacked;
	if (!hidelegend) legend.stacked=stacked;
	yscale.max=qq.getmax(stacked);
	yscale.units.checkunitfac(yscale.max()-yscale.min());
	//yscale.units.checkunitcancel();
	ysv.repaint();
	doplot();
    }
    void changearrows() {
        showarrows=!showarrows;
        doplot();
    }
    
//****************** MAIN PLOT ***********************************
    
    public static int thin = 250;
    class lineplotmainpan extends JPanel implements MouseListener, MouseMotionListener {
	
	backImage b;
	
	public  lineplotmainpan() {
	    setLayout(null); //setLayout(new BorderLayout());
	    setBackground(Color.white); //info.setBackground(getBackground());
	    add(info);
	    info.setOpaque(true);
	    setOpaque(true);
	    addMouseMotionListener(this);
	    addMouseListener(this);
	    setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	    if (qq.assocparams!=null)  {
		arrows=new HashSet(qq.assocparams.size());
		for (param p : qq.assocparams) arrows.add(new arrow(p, xscale, yscale, this));
	    }
	}
	
	public void validate() {} //override to do nothing: this stops resizing just because of info changing
	
	public void paintComponent(Graphics g) {
	    // if (backImage.usebackim.isfalse())
	    super.paintComponent(g); //paint background
	    lookandfeel.setAntiAlias(g);
        g.setFont(colfont.smallfont);
	    Graphics2D g2 = (Graphics2D) g;
	    
	    AffineTransform oldat = g2.getTransform();
	    
	    float xsf=getWidth()/xscale.range(), ysf=-getHeight()/yscale.range(), xyf=xsf/ysf;
	    g2.scale( ysf, ysf);
	    /*
	     Have to scale same for x and y, otherwise relation pixel:real is not same for x and y,
	     therefore get distorted line shape
	     */
	    g2.translate(-xscale.min()*xyf, -yscale.max());

        float w=Math.abs(yscale.range()/thin);
        try{
        	strokes.put(curve.linestyle.line, new BasicStroke(Math.abs(yscale.range())/thin));
        	strokes.put(curve.linestyle.dotted, new BasicStroke(w, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, w/2f, new float[] { w*1f, w*4f }, 0f));
        	strokes.put(curve.linestyle.dashed, new BasicStroke(w, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, w/2f, new float[] { w*4f, w*3f }, 0f));
        	strokes.put(curve.linestyle.dotdash, new BasicStroke(w, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, w/2f, new float[] { w*1f, w*4f, w*4f, w*3f }, 0f));
        } catch (Exception e) {};
	    g2.setStroke(strokes.get(curve.linestyle.line));
	    
	    if (stacked) {
		//note assumes all curves have same x-range/step
		int xmin=(int) xscale.min(), xmax=(int)xscale.max();
		curve c = qq.map.values().iterator().next();
		int xstep=(int)(Math.max(c.xstep, xscale.range()/getWidth())); if (xstep<1) xstep=1;
		
		if (xmax>c.ey) xmax=c.ey; if (xmin<c.sy) xmin=c.sy;
		if (xstep>1) {   xmin+=(c.sy-xmin) % xstep; xmax+=(c.ey-xmax) % xstep;    }
		int ns=(xmax-xmin) / xstep;
		
		float[] totpos=new float[1+ns], totneg=new float[1+ns];
		GeneralPath linepos, lineneg, basepos = new GeneralPath(), baseneg = new GeneralPath();
		basepos.moveTo(xmin*xyf, 0); baseneg.moveTo(xmin*xyf, 0);
		basepos.lineTo(qq.ey*xyf, 0);  baseneg.lineTo(qq.ey*xyf, 0);
		
		for (int x=xmin, i=0; x<=xmax; x+=xstep, i++) {  totpos[i]=0; totneg[i]=0;  }
		boolean even=true;
		boolean first=true;
		
		for (curve q : qq.mapwithouttotal().values()) if (q.checkcomplexity()) {  try {
		    even=!even;
		    linepos=basepos; lineneg=baseneg;
		    first=true;
		    for (int x=(even ? xmin : xmax), i=(even ? 0 : ns); (even ? x<=xmax : x>=xmin); x+=(even ? xstep : -xstep), i+= (even ? 1 : -1)) {
			//if (q.gotdata(x)) {
			float dy=q.gotdata(x) ? q.get(x) : 0;
			totpos[i]+= (dy>0 ?  dy : 0);    totneg[i]+= (dy<0 ?  dy : 0);
			linepos.lineTo(x*xyf, totpos[i]); lineneg.lineTo(x*xyf, totneg[i]);
			if (first) 	{
			    basepos= new GeneralPath(); baseneg= new GeneralPath();
			    basepos.moveTo(x*xyf, totpos[i]); baseneg.moveTo(x*xyf, totneg[i]);
			    first=false;
			} else {
			    basepos.lineTo(x*xyf, totpos[i]); baseneg.lineTo(x*xyf, totneg[i]);
			}
			//}
		    }
		    g2.setColor(q.color);
		    g2.fill(linepos);   g2.fill(lineneg);
		} catch (Exception e) { deb("! lineplot => "+e+" for curve "+q.name); }
		}
		
	    } else { //not stacked
		for (curve q : qq.map.values()) if (q.checkcomplexity()) {
            g2.setStroke(strokes.get(q.style));
            //if (q.style!=curve.linestyle.line) deb(qq.name + " -  " +q.name+ ": "+q.style);
		    GeneralPath line = new GeneralPath(); //GeneralPath.WIND_EVEN_ODD, c.a.length);
		    boolean haddata=false;
		    int xstep=(int)(Math.max(q.xstep, xscale.range()/getWidth())); if (xstep<1) xstep=1;
		    for (int x=(int)xscale.min(); x<=(int)xscale.max(); x+=xstep) {
			if (!q.gotdata(x)) haddata=false;
			if (q.gotdata(x) && !haddata) {	line.moveTo(x*xyf, q.get(x)); haddata=true; }
			if (q.gotdata(x) && haddata) line.lineTo(x*xyf, q.get(x));
			//root.debug(" "+x+" "+ q.get(x));
		    }
		    g2.setColor(q.color);
		    try {
			g2.draw(line);
		    } catch (Throwable e) { } //deb(e, "line drawing error");  }
        }
	    }
	    
	    g2.setTransform(oldat);

         if (labels==true && !stacked)  {
             for (curve q : qq.map.values()) if (q.checkcomplexity()) {
                String s=labman.getShort(q.name);
                int sw=colfont.sw(g, s), sh=colfont.sh(g), sd=colfont.sd(g), sx, sy;
                   g2.setColor(q.color);
                for (int yr : labyear) {
                    sx=(int)((yr-xscale.min())*getWidth()/xscale.range()) - sw/2;
                    sy=getHeight()-(int)((q.get(yr)-yscale.min())*getHeight()/yscale.range()) + sh/2 -sd;
                    g.drawString(s, sx, sy);
                        }
                }
        }

	    
	    ready=true;
	    
	    if (showarrows && arrows!=null) for (arrow a : arrows) if (a.checkenabled())  {
		try {
		    a.getpos();
		    a.draw(g);
		}  catch (Throwable e) { deb(e, "arrow drawing error" + a+" "+e);  }
	    }
	    
	    if (dragarrow==null ) info.repaint();
	    g2.dispose();
	} //end paint component
	
	
	//************************** EVENT HANDLING ***********************
	//shows the x,y info
	public void mouseMoved(MouseEvent e) {
	    // if (dragarrow==null ) {
	    try {
		checkarrow: {
		    if (showarrows && arrows!=null)  for (arrow a : arrows) if (a.checkenabled() && a.poly.contains(e.getPoint())) { info.setText(a.getinfo()); break checkarrow; }
                    }
		    curve best=null;
		    float x=xscale.min()+xscale.range()*e.getX()/getWidth(), y=yscale.max()-yscale.range()*e.getY()/getHeight(), y2=0;
		    int xi=(int)(x+0.5);
		    if (x>xscale.min() && x<xscale.max() && y>yscale.min() && y<yscale.max()) {
			int locx=Math.min(e.getX()+4, getWidth()-info.getWidth()-4);
			info.setLocation(locx, e.getY()+4);
			if (stacked) {
			    float sum=0;
			    search: for  (curve q : qq.mapwithouttotal().values()) if (q.checkcomplexity()) {
				y2=q.get(xi);
				if (Math.signum(y)==Math.signum(y2)) {  sum+=y2; best=q;}
				if (Math.abs(sum)>Math.abs(y)) break search;
				best=null;
			    }
			} else {
			    for (curve q : qq.map.values()) if (q.checkcomplexity())  {
				float y2t=q.get(xi);
				if (Math.abs(y2t-y)< (best==null ? yscale.range()/20 : Math.abs(y2-y)) ) { best=q; y2=y2t; }
			    }
			}
			info.setText(
				( best==null ?  "" : "<html>"+best.hashcolor() +labman.getTitle( best.name )+" </font>")
				+xi+": "+yscale.units.round(( best==null ? y : y2) ,2));
			//info.setText(String.format("<html>%1$.4g<p>%2$.3g", xi, y));
		    }
		
		info.setSize(info.getPreferredSize());
	    } catch (Throwable ex) {deb(ex, "lineplot mouse moved error");  }
	}
	
	arrow dragarrow=null;
	public void mouseDragged(MouseEvent e) { if (dragarrow!=null) dragarrow.move(e.getX(), e.getY()); }
	public void mousePressed(MouseEvent e) {   if (dragarrow==null && showarrows && arrows!=null) for (arrow a : arrows) if (a.poly.contains(e.getPoint())) { dragarrow=a; info.setSize(0,0); }	}
	public void mouseReleased(MouseEvent e) {    dragarrow=null; 	}
	public void mouseClicked(MouseEvent e) {  }
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {info.setText(""); info.setSize(new Dimension(0,0)); }
	
	
    } //end lineplotmain
    
    
} //end class




