package jcm.gui.plot;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curveset;
import jcm.core.cur.curvar;
import jcm.core.itf.hasSetupInfo;
import jcm.core.itf.plotlink;
import jcm.core.ob.module;
import jcm.gui.doc.labman;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.jcmMenu;
import jcm.core.itf.menuFiller;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.showpan;

public abstract class baseplot  extends JSplitPane implements plotlink, menuFiller, hasSetupInfo  {
    
    JPanel plot;
    public legend legend; //set public so can set size in script
    jcmMenu popup;
    JLabel info=new JLabel();
    
    public param xscale, yscale;
    scaleview xsv, ysv;
    curveset qq;
    java.util.List<Float> scalesetup=new ArrayList(5);
    //P2 could be simpler to save setup as pair / value map?
    
    boolean ready=false;
    public boolean labels=false;
    public static boolean hidelegend=false;
    
    void setup() {
	register.addlink(this, qq);
	loop.gonow();
	if (qq instanceof curvar) ((curvar)qq).refreshregs();
	if (!hidelegend) legend = new legend(qq, this);
	/*note:  for some (esp regional) modules, curves are made only after loop.go,    so autoscale only only works after link has set output force calc    */
	setname();
	makescales();
	restorescalesetup();
	makescaleviews();
	makeplot();
	setlayout();
	setcolor();
	setToolTipText(getToolTip());
	jcmMenu popup=new jcmMenu(plot,  this);
	popup.addFiller(qq);

    //these links make sure this will be updated if main view options change  - added may2011 - maybe superfluous?
    // or should generalise in a jcmpanel?
        register.addlink(this, complexity.defaultcomplexity);
        register.addlink(this, lookandfeel.fontSize);
        register.addlink(this, lookandfeel.bigscales);
        register.addlink(this, lookandfeel.antiAlias);

	setVisible(true);
    }
    
    
    public void paintComponent(Graphics g) {
	super.paintComponent(g);
	backImage.paint(qq, this, g, getWidth(), getHeight());
    }
    
    void makeplot() { } //does nothing - must override
    
    public void savesetup() {
	List al=register.getargs(this); al.clear();
	al.add(qq);
	al.add(xscale.min()); al.add(xscale.max()); al.add(yscale.min()); al.add(yscale.max());
	al.add(plot.getWidth()); //for legend size, note this is not proportional, but we cannot restore proportional width in setup
	extrasavesetup(al);
    }
    
    void extrasavesetup(List al) { } //for subclasses to extend
    
    void  restorescalesetup() {
	if (scalesetup.size()>3) { xscale.min=scalesetup.get(0); xscale.max=scalesetup.get(1); yscale.min=scalesetup.get(2); yscale.max=scalesetup.get(3); }
    }
    
    String getlabcode() {
	String s=(this instanceof lineplot) ? "" : getClass().getSimpleName()+"&";
	s+= qq.getNameWithWorld();
	return s;
	//+"&ob&"+ yscale.units.units+"&cb");
    }
    
    String getToolTip() { return labman.getTitle(getlabcode());   }
    void setname() { setName(labman.getShort(getlabcode()));   }
    
//*****************************************************
//POPUP
    
    
    public void fillMenu(jcmMenu popup) {
	popup.add(imagesaver.copyaction(this));
	popup.add(imagesaver.saveimagemenu(this, qq.name));
    popup.add(new jcmAction("Labels", complexity.normal)  { public void act()  { labels=!labels; doplot(); }});
	popup.addSeparator();
    }
    
    
    
//*****************************************************
//SCALES
    
    abstract void makescales();
    void makescaleviews() {
	ysv=new scaleview(yscale);
	xsv=new scaleview(xscale);
	register.addlink(this, xscale, yscale);
    }
    
    
//*****************************************************
//PLOTLINK
    public void doplot() {
	if (ready) plot.repaint();
	if (ready && qq.unitschanged) { ysv.changeunits(qq);  }
    if (ready && loop.changeTreeStruc && !hidelegend) legend.makelabs(true); //P1 inefficient, only need to do this when legend changed
	if (ready && loop.changeTreeStruc) savesetup();
    }
    public boolean isShowing(){ return (!ready || super.isShowing()); } //so loop.go has an effect, before its showing
    
    
    
//*****************************************************
//LAYOUT
    void setlayout() {
	JPanel plotsca=new JPanel(new BorderLayout());
//	plotsca.setOpaque(false);
	ysv.setMinimumSize(new Dimension(40,0));
	xsv.setMinimumSize(new Dimension(0,20));
	xsv.aboveleft=ysv;
//	Box botbox= Box.createHorizontalBox();
//	botbox.add(Box.createHorizontalStrut(40));
//	botbox.add(xsv);
	//legend.setMinimumSize(new Dimension(40,0) );
	plot.setMinimumSize(new Dimension(60,60) );
	plot.setPreferredSize(new Dimension(400,400) );
	plotsca.add(ysv, BorderLayout.WEST);
	plotsca.add(plot, BorderLayout.CENTER);
	plotsca.add(xsv, BorderLayout.SOUTH);
	setOrientation(JSplitPane.HORIZONTAL_SPLIT);
	setLeftComponent(plotsca);
    if (!hidelegend) {
         setRightComponent(legend);
         setBorder(null);
         legend.setBorder(null);
         plotsca.setBorder(null);
         setResizeWeight(0.85);
        this.setDividerSize(4);
    }
    if (hidelegend) {
        setRightComponent(null);
        setBorder(null);
        plotsca.setBorder(null);
        setResizeWeight(1.0);
        this.setDividerSize(0);
    }
	//if (scalesetup.size()>4) setDividerLocation((int)scalesetup.get(4).floatValue());
    }
    
//*****************************************************
//CLOSE
    public void removeNotify() { //called when plot is closed
	super.removeNotify();
	if (showpan.moulist.carrying!=this) { xscale.disposeLater(); yscale.disposeLater(); }
	loop.golater("Plot Removed");
    }
    
    public void addNotify() {
	super.addNotify();
	loop.golater("Plot Shown");
    }
    
    
//*****************************************************
//COLOR
    void setcolor() {
	Color bcol= Color.white;
	//remove  backcol by world to facilitate transparent svg ? 
	if (qq.owner instanceof module) bcol= brighter(((module)qq.owner).world.color);
	setBackground(bcol);
	info.setBackground(bcol);
	plot.setBackground(bcol);
	ysv.setBackground(bcol);
	xsv.setBackground(bcol);
	if (!hidelegend) legend.setBackground(bcol);
	
	setOpaque(true);
	plot.setOpaque(true);
	ysv.setOpaque(true);
	xsv.setOpaque(true);
	if (!hidelegend) legend.setOpaque(true);
    }
    
    Color brighter(Color c) {
	if (c.equals(Color.black)) return Color.white;
	return new Color(255-(255-c.getRed())/8, 255-(255-c.getGreen())/8, 255-(255-c.getBlue())/8);
    }
    
    Color variant(Color c) { return new Color(vary(c.getRed()), vary(c.getGreen()), vary(c.getBlue()) ); }
    int vary(int c) { if (c<127) return (int)(c*1.5); return (int)(c*0.67); }
    
//note also rcol(Color) in infob
    
    
} //end class

//*****************************************************
// OLD LAYOUT
//    void setlayout() {
//	GridBagLayout g= new GridBagLayout();
//	GridBagConstraints c=new GridBagConstraints();
//	setPreferredSize(new Dimension(400,300));
//	setLayout(g);
//	ysv.setMinimumSize(new Dimension(40,0));
//	xsv.setMinimumSize(new Dimension(0,20));
//	legend.setMinimumSize(new Dimension(40,0) );
//	plot.setMinimumSize(new Dimension(60,60) );
//	plot.setPreferredSize(new Dimension(200,200) );
//	//gridy=0 left for adding a top-bar if needed
//	c.gridx=0; c.gridy=1; c.fill = c.VERTICAL; c.weightx=0; c.weighty=1; g.setConstraints(ysv, c); add(ysv);
//	c.gridx=1; c.gridy=1; c.fill = c.BOTH; c.weightx=1; c.weighty=1; g.setConstraints(plot, c); add(plot);
//	c.gridx=2; c.gridy=1; c.fill = c.BOTH; c.weightx=0; c.weighty=0; g.setConstraints(legend, c); add(legend);
//	c.gridx=1; c.gridy=2; c.fill = c.HORIZONTAL; c.weightx=1; c.weighty=0; g.setConstraints(xsv, c); add(xsv);
//    }
//
//*****************************************************

////RESPONSE TO RESIZING
//    int ow=0;
//    public void repaint() {
//	super.repaint();
//	int w=getSize().width;
//	if (w>500 && ow<=500) legend.expand();
//	if (w<=400 && ow>400) legend.contract();
//	ow=w;
//    }