package jcm.gui.plot;

import java.awt.*;
import java.awt.image.*;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.*;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jcm.core.ob.*;
import jcm.core.par.param;
import jcm.gui.nav.showpan;
import jcm.core.tls.fileio;
import static jcm.core.report.*;

public class backImage {
    /*
    Designed to economise on memory:
    Use weak hashmaps and soft references so they can be garbage collected if memory short, they will be remade as needed
    Also only store one copy of each original image, plus one converted for each panel
    P2 the lineplot mouseovers don't work when not Opaque! Also, Opacity is not restoring right in substance
     */
    public static Map<String, String> alias = new HashMap();
    public static Map<String, SoftReference<BufferedImage>> orig = new HashMap();
    public static Map<Object, SoftReference<BufferedImage>> conv = new WeakHashMap();
    public static Map<JComponent, Boolean> origopaque = new WeakHashMap();
    public static param usebackim = new param("BackImage", false) {
        public void respond() {
            SwingUtilities.updateComponentTreeUI(showpan.mf);
            showpan.mf.repaint();
        }
    };
    

    static {
        try {
            String[][] sss = fileio.loadtab("backpic/backpics.txt", ",");
            for (String[] ss : sss) for (String s : ss) alias.put(s, ss[0]);
        } catch (Exception e) {
            deb("Problem loading backpics.txt");
        }
    }

    public static BufferedImage getImage(Object o, int w, int h) {
        BufferedImage bi = null;
        if (conv.containsKey(o)) bi = conv.get(o).get();
        if (bi != null) return bi;
        if (bi == null || bi.getWidth() != w || bi.getHeight() != h) {
            String filename = getFileName(o);
            if (filename == null) return null;
            BufferedImage or = null;
            if (orig.containsKey(filename)) or = orig.get(filename).get();
            if (or == null) {
                or = loadImage(filename);
                if (or != null) orig.put(filename, new SoftReference(or));
            }
            if (or != null) {
                bi = convert(or, w, h);
                conv.put(o, new SoftReference(bi));
                return bi;
            }
        }
        return null;
    }

    public static String getFileName(Object o) {
        if (o instanceof String) return alias.get(o.toString());
        if (o instanceof infob) {
            infob i = (infob) o;
            if (alias.containsKey(i.name)) return alias.get(i.name);
            if (i.owner != i) return getFileName(i.owner);
        }
        return null;
    }

    public static BufferedImage loadImage(String filename) {
        try {
            URL u = fileio.getURL("backpic/" + filename);
            return ImageIO.read(u);
        } catch (Exception e) {
            deb("can't get background for " + filename);
            return null;
        }
    }

    public static BufferedImage convert(BufferedImage orig, int w, int h) {
        float ow = orig.getWidth(), oh = orig.getHeight();
        float f = Math.min(ow / w, oh / h);
        int nw = (int) (f * w), nh = (int) (f * h), x = (int) (ow - nw) / 2, y = (int) (oh - nh) / 2;
        BufferedImage bi = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, w, h);
        g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.33f));
        g2.drawImage(orig, 0, 0, w, h, x, y, x + nw, y + nh, null);
        g2.dispose();
        return bi;
    }

    public static void setOpaque(JComponent c, boolean opaque) {
        if (opaque && origopaque.containsKey(c)) c.setOpaque(origopaque.get(c));
        else {
            origopaque.put(c, c.isOpaque());
            c.setOpaque(false);
        }
        for (Component c2 : c.getComponents()) if (c2 instanceof JComponent) setOpaque((JComponent) c2, opaque);
    }

    public static void paint(Object o, JComponent c, Graphics g, int w, int h) {
        setOpaque(c, usebackim.isfalse());
        if (usebackim.istrue()) {
            BufferedImage bi = getImage(o, w, h);
            if (bi != null) try {
                    g.drawImage(bi, 0, 0, null);
                } catch (Exception e) {
                    deb(e, "backimage");
                }
        }
    }
} //end class
