
package jcm.gui.nav;
import jcm.core.*;
import jcm.core.ob.*;
import jcm.core.itf.menuFiller;
import jcm.gui.nav.jcmAction;
import jcm.core.report;
import jcm.gui.doc.*;
import jcm.gui.gen.*;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jcm.StartJCM;
import jcm.java6methods;
import static  jcm.core.report.*;


public class showpan  {
    
    
    //********************************
    //FIELDS
    
    public static JFrame mf;
    public static dragdrop moulist=new dragdrop();
    public static JMenuBar mb=new JMenuBar();
    //mb.setBackground(showpan.bg);
    
    
    //******* SCREEN ************************
    
    public static Rectangle screenbounds() { return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds(); }
    //return Toolkit.getDefaultToolkit().getScreenSize(); };
    public static Point screencenter() { return GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();  }
    
    public static Point pointForCenter(Component c) { return pointForCenter(c.getSize()); }
    public static Point pointForCenter(Dimension d) {
	//JOptionPane.showMessageDialog(null, "sc= "+screencenter()+" sb= "+screenbounds());
	//System.err.println("sc= "+screencenter()+" sb= "+screenbounds());
	return new Point(screencenter().x - d.width/2,  screencenter().y - d.height/2);
	//return new Point((screensize().width-c.getSize().width)/2, (screensize().height-c.getSize().height)/2);  }
    }
    
    public static Color bg=new Color(217,255,217);
    
    //**************SETUP *****************
    
    
    public static JFrame makeMainframeDefSize() { Dimension d= new Dimension(800,600); 	return makeMainframe(pointForCenter(d), d ); }
    public static JFrame makeMainframeMaximised() { return makeMainframe(screenbounds()); }
    public static JFrame makeMainframe(Rectangle r) { return makeMainframe(r.getLocation(), r.getSize()); }
    
    public static JFrame makeMainframe(Point p, Dimension d) {
	
	//beware lookandfeel precalc from within reset can crash with substance and complex setup - but it will get called later anyway
	lookandfeel.lookAndFeelParam.precalc(); //set this before showing anything, to avoid change twice
	//JFrame.setDefaultLookAndFeelDecorated(true); //this works, but the platform look&feel usually looks better
	//loop.gonow(false);
	
	mf=new JFrame("Java Climate Model ( www.climate.be / jcm ) [version:"+ StartJCM.revisiondate+"]");
	mf.addWindowListener(new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {	close(); }
	} );
	mf.addComponentListener(new ComponentAdapter() {
	    public void componentResized(ComponentEvent e) {jcm.gui.gen.lookandfeel.setFontSizeForFrame(); }
	});
	
	
	JSplitPane
		right=new JSplitPane(JSplitPane.VERTICAL_SPLIT, new jcmTabbedPane(), new jcmTabbedPane()),
		main=new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new jcmTabbedPane(), right);
	
	right.setResizeWeight(0.5); main.setResizeWeight(0.3);
	mf.setContentPane(main);
	mf.setJMenuBar(mb);
	mf.setLocation(p);
	mf.setPreferredSize(d);
        try { 	mf.setIconImage(((ImageIcon)iconFinder.findIcon("worldicon")).getImage()); } catch (Exception e) {}
	//try { 	mf.setIconImage(((ImageIcon)iconFinder.findIcon("World 1")).getImage()); } catch (Exception e) {}
	
	topMenus.makemenus();
        
        java6methods.setIconImage(mf);
	mf.validate(); 	mf.pack(); mf.setVisible(true);
	try { mf.toFront(); } catch (Exception e) { deb(e, "couldn't bring JCM main window to front!");}
	
	logn("(showpan) ====================JCM Main Window Ready========================\n");
	
	return mf;
	
    }
    
    //************ MAKEJDP ***************
    
    public static  JDesktopPane makejdp() {
	JDesktopPane jdp=new JDesktopPane();
	showpan.addpanmenu(jdp);
	return jdp;
    }
    
    
    //************** CLOSE ******************************
    
    public static void close() {
	try {	    labman.saveonexit(); } catch (Exception e) { deb(e, "close: error during labman saveonexit"); }
	try {     setup.savesetupdefault(); } catch (Exception e) { deb(e, "close: error during setup savedefault"); }
	loop.waitUntilLoopDone();
	System.exit(0);
    }
    
    
    // ************** FIND / DISPOSE / TOFRONT***************
    //Note might simplify using SwingUtilities convert methods?
    
    public static JComponent findContainerAbsolute(Point p) { JRootPane rp=mf.getRootPane(); Point q=rp.getLocationOnScreen(); return  findContainer(rp.findComponentAt(p.x-q.x, p.y-q.y));    }
    public static JComponent findContainer(Point p) { return findContainer(mf.getRootPane().findComponentAt(p));   }
    
    public static JComponent findContainer(Component c) {
	while (c!=null && c!=c.getParent() && !(c instanceof jcmTabbedPane || c instanceof JDesktopPane)) c=c.getParent();
	return (JComponent) c;
    }
    
    public static jcmTabbedPane findTabbedPane(Component c) {
	return (jcmTabbedPane) findContainer(c);
    }
    
    public static void dispose(JComponent c) {
	try {
	    Container cont=c.getRootPane().getParent();
	    c.removeNotify();
	    if (cont!=null && cont!=mf && (cont instanceof JInternalFrame || cont instanceof JFrame))  try {
		cont.removeAll();
		cont.removeNotify();
		//this causes some uncaught exceptions - maybe better to let garbage collector catch later?
		if (cont instanceof JInternalFrame) { ((JInternalFrame)cont).dispose();  }
		if (cont instanceof JFrame)  { ((JFrame)cont).dispose();  }
		return;
	    } catch (Exception e) { deb(e, "showpan error disposing frame "+c); return;  }
	    //so it must be in a tabbed pane:
	    findTabbedPane(c).remove(c);
	    //((JSplitPane)jtp.getParent()).resetToPreferredSizes();
	} catch (Exception e) { deb(e, "showpan error disposing "+c); }
    }
    
    public static void toFront(JComponent c) {
	try {
	    Container cont=c.getRootPane().getParent();
	    if (cont instanceof JInternalFrame) { ((JInternalFrame)cont).toFront();  return ; }
	    if ((cont instanceof JFrame) && cont !=mf)  { ((JFrame)cont).toFront();  return ; }
	    //so it must be in a tabbed pane
	    findTabbedPane(c).setSelectedComponent(c);
	    //jtp.setPreferredSize(c.getPreferredSize());
	    //((JSplitPane)jtp.getParent()).resetToPreferredSizes();
	    
	} catch (Exception e) { deb(e, "showpan: error setting toFront "+c ); }
    }
    
    
    //******************* SHOW **********************
    public static Container show(JComponent c, Object ... args) {
	String name=c.getName(); Point po=null; Icon i=null;
	Component cont=null;
	
	for (Object o : args) if (o!=null) {
	    if (o instanceof String) name=(String)o;
	    if (o instanceof Point) po=(Point)o;
	    if (o instanceof Icon) i =(Icon)o;
	    if (o instanceof Component) cont=(Component)o;
	    if (o instanceof infob && i==null) i=((infob)o).getIcon();
	}
	
	if (i==null) i=iconFinder.findIcon(name);
	if (i==null) i=iconFinder.findIcon(c);
	
	if (cont==null) {
	    if (po==null) po=
		    c instanceof jcmTree ? new Point(100,100)
		    :  c instanceof docview || c instanceof sourceview ? new Point(mf.getWidth()-100,100)
		    : c instanceof report ||  c instanceof Box ? new Point(mf.getWidth()/2, mf.getHeight()-100)
		    : new Point(mf.getWidth()/2, mf.getHeight()/2);
	    
	    
	    cont=findContainer(po);
	    
	    // in case it lands on a bar - try moving up and left
	    if (cont==null) { po.translate(-20, -20); cont=findContainer(po); }
	    if (cont==null) { po.translate(40, 40); cont=findContainer(po); }
	    //spot shows where it tries
	    if (cont==null) {   mf.getGlassPane().setVisible(true);   mf.getGlassPane().getGraphics().fillRect(po.x-10, po.y-10, 20,20); }
	    if (cont==null)   deb("Try to Show " + c + "\n in " + cont +"\n at "+po);
	}
	
	if (cont instanceof jcmTabbedPane) {
	    
	    jcmTabbedPane jtp=(jcmTabbedPane)cont;
	    if (i!=null) jtp.addTab(labman.getTitle(name)+"  ", i, c); else jtp.addTab(labman.getTitle(name)+"  ", c);
	    toFront(c);
	    return jtp;
	}
	
	if (cont instanceof JDesktopPane) {
	    JDesktopPane jdp=(JDesktopPane)cont;
	    //if (po==null) { //note po now used for position in whole mf
	    JInternalFrame[] fa=jdp.getAllFrames();
	    po=(fa.length>0 ? new Point((fa[fa.length-1].getX()+40) % jdp.getWidth(), (fa[fa.length-1].getY()+40) % jdp.getHeight() ) : new Point(20,20)) ;
	    //}
	    
	    JInternalFrame f=new JInternalFrame(labman.getTitle(name), true, true, true);
	    f.add(c); f.pack();
	    if (i!=null) f.setFrameIcon(i);
	    jdp.add(f);   f.setLocation(po); f.setVisible(true);
	    toFront(c);
	    return f;
	}
	
	if (cont instanceof JFrame) {
	    JFrame f=(JFrame)cont;
	    f.add(c); f.pack();
	    if (i!=null && i instanceof ImageIcon) f.setIconImage(((ImageIcon)i).getImage());
	    if (po!=null) f.setLocation(po);
	    f.setVisible(true);
	    toFront(c);
	    return f;
	}
	
	return null;
    }
    
    
//********************************
    /*ACTIONS & MAKEPAN
     The idea is to return Actions without making the components before the menu item is clicked
     (since making components can be slow, calls loop and consumes memory)
    && using Object... args below could simplify panel constructors and help with save/load windows ?
     */
    
    
    public static jcmAction pan(final Class<? extends JComponent> c) { return pan(c.getSimpleName(), c, null); }
    public static jcmAction pan(final Class<? extends JComponent> c, complexity  complex) { return pan(c.getSimpleName(), c, null, complex); }
    public static jcmAction pan(final Class<? extends JComponent> c, Object o) { return pan(o.toString(),  c, o);  }
    public static jcmAction pan(String name, final Class<? extends JComponent> c, final Object o)  { return pan(name, c, o, complexity.simplest); }
    
    public static jcmAction pan(String name, final Class<? extends JComponent> c, final Object o, complexity complex)  {
	jcmAction a = new jcmAction(name, complex) { public void act() {
	    SwingUtilities.invokeLater(new Runnable(){  public void run()  {  makepan(c, o); }});
	} } ;
	a.addIcon(name, o, c);
	return a;
    }
    
    //note: now got SwingUtilities invokeLater in both makepan and action
    
//can this be extended to varargs Object ...  ?
//problem is that register stores only one Object[] instead of a list of objects, harder to manipulate later
//public static JComponent makepan(Class<? extends JComponent> c, final Object o) { return makepan(c,o,null);  }
    public static JComponent makepan(Class<? extends JComponent> c, final Object o, final Object ... args) {
	try {
	    JComponent com;
	    if (o==null) com=c.newInstance();
	    else {
		Class ic=o.getClass();
		Constructor<? extends JComponent> con=null;
		findconstructor : do {
		    try {
			con=c.getConstructor(ic);  break findconstructor;
		    } catch (Exception ex) { }
		    if (ic.isArray()) {
			Class ac=ic.getComponentType().getSuperclass();
			ic=  ac!=null ? Array.newInstance(ac, 1).getClass() : null;
		    } else ic=ic.getSuperclass();
		} while (ic!=null);
		if (con==null) { deb("can't find constructor for "+c+ " / "+o); return null; }
		com=con.newInstance(o);
	    }
	    final JComponent com2=com;
	    SwingUtilities.invokeLater(new Runnable(){  public void run()  {  show(com2, args);   } } );
	    register.addargs(com, o);
	    return com;
	}    catch (Exception ex) { deb(ex); return null; }
    } //makepan
    
    
// **************** CHANGE / SPLIT  FRAME **********
    public static void  addpanmenu(final JComponent c) {
	new jcmMenu(c, new menuFiller() {
	    public void fillMenu(jcmMenu pop) {
		
		if (c instanceof jcmTabbedPane) pop.add(new jcmAction("Convert to Internal Frames"){ public void act() {
		    JDesktopPane jdp=makejdp();
		    JSplitPane jsp=(JSplitPane) c.getParent();
		    jcmTabbedPane jtp=(jcmTabbedPane)c;
		    //remap(jtp, jdp);
		    if (jsp.getTopComponent()==c) jsp.setTopComponent(jdp);    else jsp.setBottomComponent(jdp);  mf.validate();
		    for (int i=0; i< jtp.getTabCount(); /*i++*/ ) show((JComponent) jtp.getComponentAt(i), jdp, jtp.getIconAt(i), jtp.getTitleAt(i));
		    //it seems that showing the component elsewhere automatically removes it from the tabbed pane (and shifts the indexing accordingly)
		    //but beware, if this is not the case, loop will get stuck!
		    //for (int i=0; i< jtp.getTabCount(); i++)  jtp.remove(jtp.getComponentAt(i));
		}});
		
		if (c instanceof JDesktopPane) pop.add(new jcmAction("Convert to Tabbed Pane"){ public void act() {
		    jcmTabbedPane jtp=new jcmTabbedPane();
		    JSplitPane jsp=(JSplitPane) c.getParent();
		    //remap(c, jtp);   pc.put(findpan(c), jtp);
		    if (jsp.getTopComponent()==c) jsp.setTopComponent(jtp);   else jsp.setBottomComponent(jtp); mf.validate();
		    for (JInternalFrame jif : ((JDesktopPane)c).getAllFrames()) {
			show((JComponent)jif.getContentPane(), jtp, jif.getFrameIcon(), jif.getTitle());
			jif.dispose();
		    }
		}});
		
		
		pop.add(new jcmAction("Remove Panel"){public void act() {
		    JSplitPane jsp=(JSplitPane) c.getParent(),  jsp2=(JSplitPane) jsp.getParent();
		    JComponent other=(JComponent) (jsp.getTopComponent()==c ? jsp.getBottomComponent() :  jsp.getTopComponent());
		    // remap(c, other);
		    if (jsp2.getTopComponent()==jsp)  jsp2.setTopComponent(other);   else jsp2.setBottomComponent( other);
		}});
		
		pop.add(new jcmAction("Split Vertical"){ public void act() { split(c, true); }});
		pop.add(new jcmAction("Split Horizontal"){ public void act() { split(c, false); }});
	    }
	});
    }
    
//Component split(boolean vertical) { return split(vertical,  getTabCount()>0 ? (JComponent)getComponentAt(getTabCount()-1) : null );  }
    
    
    static JComponent split(JComponent c, boolean vertical) {
	JSplitPane jsp=(JSplitPane) c.getParent();
	JSplitPane  jspn=new JSplitPane(vertical ? JSplitPane.VERTICAL_SPLIT : JSplitPane.HORIZONTAL_SPLIT);
	//jspn.setBackground(bg);
	jspn.setResizeWeight(0.5);
	jcmTabbedPane jtpn=new jcmTabbedPane();
	if (jsp.getTopComponent()==c) jsp.setTopComponent(jspn); else jsp.setBottomComponent(jspn);
	jspn.setTopComponent(c);
	jspn.setBottomComponent(jtpn);
	return jtpn;
    }
    
//jspn.setPreferredSize(jsp.getTopComponent().getPreferredSize());
//jtpn.setPreferredSize(jspn.getBottomComponent().getPreferredSize());
    
    
    
//********* EXTERNAL WINDOWS *******************
//used by circmenu
    
    public static void addwindow( JComponent c) { addwindow( c, new Point(200,200));   }
    public static void addwindow( JComponent c, Point p) {
//	if (pantype.chosen.equals("external windows")) topwindow(mf, c, p); else
	{   JLayeredPane lp=mf.getLayeredPane(); lp.add(c); lp.setLayer(c, JLayeredPane.POPUP_LAYER); c.setLocation(p);  }
    }
    
    public static void topwindow(Window w, JComponent c, Point p) {
	Rectangle cap=new Rectangle(p.x, p.y, c.getSize().width+10, c.getSize().height+10);
	JWindow win=new capwin(w, cap);
	win.add(c);
	try {
	    win.setAlwaysOnTop(true);
	} catch (SecurityException e) { deb(e, "Can't Set OnTop"); }
	win.setLocation(p);
	win.pack(); win.setVisible(true);
    } //topcircmen
    
    
} //end showpan class
//*************************

class capwin extends JWindow {
    public capwin(Window w, Rectangle cap) {
	super(w);
	try {
	    Robot ro = new Robot();
	    final Image back=ro.createScreenCapture(cap );
	    setContentPane(new JPanel() {
		public void paintComponent(Graphics g) { g.drawImage(back, 0, 0, this);    }
	    });
	} catch (Exception e) { deb(e, "can't capture background");  }
	//note both awt Exception and security exception possible
    }
}








