//*************** TABBED PANE*********************
//a TabbedPane with closeable  tabs (used with showpan mouselistener)

package jcm.gui.nav;

import java.awt.*;
import java.awt.event.*;
import java.util.LinkedList;
import javax.swing.*;
import jcm.gui.gen.lookandfeel;
import static jcm.core.report.*;
import jcm.gui.doc.labman;

public class jcmTabbedPane extends JTabbedPane  {
    
    java.util.List<Rectangle> rect=new LinkedList();
    JSplitPane jsp;
    java.util.List<String> names= new LinkedList();
    
    public jcmTabbedPane() {
	super();
	setPreferredSize(new Dimension(100,200));
	addMouseListener(showpan.moulist);
	addMouseMotionListener(showpan.moulist);
	//setBackground(showpan.bg);
	//setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT); //might be nicer but kills the tab-close button - still works but you don't see it'
	setOpaque(false);
	showpan.addpanmenu(this);
    }
    
    public void addTab(String s, Component c) {	addTab(s, null, c);   }
    
    public void addTab(String s, Icon i, Component c) {
	names.add(s);
	super.addTab(labman.getTitle(s), i, c);
	int n=getTabCount()-1;
	setToolTipTextAt(n, labman.getTitle(names.get(n))) ;
	adjustToSpace();
    }
    
    void adjustToSpace() {
	if (getTabRunCount()<2) for (int n=0; n<getTabCount(); n++) this.setTitleAt(n, labman.getTitle(names.get(n))); revalidate();
	if (getTabRunCount()>1) for (int n=0; n<getTabCount(); n++) this.setTitleAt(n, labman.getShort(names.get(n))); revalidate();
	if (getTabRunCount()>1) for (int n=0; n<getTabCount(); n++) this.setTitleAt(n, "");
    }
    
    //note there are a lot of tab paint and layout errors that don't seem to matter, so we catch them here
    
    public void doLayout() {
	try {   super.doLayout(); } catch (Exception ex) {  }
    } //deb(ex, "tab layout error" ); }     }
    
    public void remove(int i) {
	remove(this.getComponentAt(i));
    }
    
    public void remove(Component c) {
	int i=indexOfComponent(c);
	names.remove(i);
	super.remove(c);
	try {  c.removeNotify(); }   catch (Exception e) { deb(e, " removing tabbed pane"); }
	c=null;
	revalidate();
	adjustToSpace();
    }
    
    public void setBounds(int x, int y, int w, int h) { super.setBounds(x,y,w,h); adjustToSpace(); }
    
    public void paintComponent(Graphics g) {
	try {
	    lookandfeel.setAntiAlias(g);
	    super.paintComponent(g);
	    rect.clear();
	    for (int i=0; i<getTabCount(); i++) {
		Rectangle r=getUI().getTabBounds(this, i);
		int w=9, h=9, x=r.x+r.width-5-w, y=r.y+r.height/2-h/2;
		rect.add(new Rectangle(x, y, w, h));
		g.setColor(Color.red);
		g.drawRoundRect(x,y,w,h,4,4);
		g.drawLine(x+w,y, x, y+h);
		g.drawLine(x,y,x+w,y+h);
	    }
	} catch (Exception ex) { } // System.err.println("tab paint error" +ex);  ex.printStackTrace(); }
    }
    
    int intab(MouseEvent e) {
        try {
    	for (int i=0; i<getTabCount(); i++) if (getUI().getTabBounds(this, i).contains(e.getPoint() )) return i; return -1;
        } catch (Exception ex) { deb("JCMTabbedPane intab=> "+ex); return -1; }
    }
    
    void tryclose(MouseEvent e) {
	for (int i=0; i<getTabCount(); i++) {
		try {
			if (rect.get(i).contains(e.getPoint())) remove(i);
			} catch (Exception ex) { deb ("! ---- Problem closing tab ----"); } 
		}
    }
    
} // jcmTabbedPane

