 
package jcm.gui.nav;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.TreePath;
import jcm.core.*;
import jcm.core.cur.curveset;
import jcm.core.par.param;
import jcm.core.ob.*;
import jcm.core.cur.*;
import jcm.gui.*;
import jcm.gui.plot.lineplot;
import static jcm.core.report.*;


//******************* DRAG DROP / MOUSE LISTENER ***********************
/*
Generalise  to accept any current dragging object, replace dragtab
 JComponent, or (for potential components) Class + Object (for makepan)
 + generalise makepan so don't include show, or pass the container argument
 
 */


public class dragdrop  implements MouseListener, MouseMotionListener  {
    
    JComponent source;
    public Object carrying;
    String dragname;
    Icon dragicon;
    int x, y, oldx=0, oldy=0, w, h, iw, ih;
    Point p, rp;
    boolean inside, maysplit;
    public Map<Component, infob> cimap=new WeakHashMap();
    
    
    boolean getAbsLocation(MouseEvent e) {
	try {
        source=(JComponent)e.getComponent();
	p=source.getLocationOnScreen(); 
        rp=showpan.mf.getRootPane().getLocationOnScreen();
	x= p.x -rp.x + e.getX()-10; y= p.y-rp.y+e.getY()-10;
	w=source.getWidth(); h=source.getHeight();
	inside=source.contains(e.getPoint())
	&&  !(source instanceof JInternalFrame && ((JInternalFrame) source).getRootPane().getContentPane().contains(e.getPoint()));
	maysplit=inside &&  source instanceof jcmTabbedPane && ((jcmTabbedPane) source).intab(e)<0;
        return true;
        } catch (Exception ex) { deb("\n!-- dragdrop can't locate:"+source.getName()+" "+ex); return false; }
    }
    
    public void mouseDragged(MouseEvent e) {
	if (carrying!=null && dragicon!=null) {
	    getAbsLocation(e);
	    int iw=dragicon.getIconWidth(), ih=dragicon.getIconHeight();
	    Graphics g=showpan.mf.getRootPane().getGlassPane().getGraphics();
	    
	    //lines to indicate potential split
	    g.setColor(maysplit && e.getY()<h/2 ? Color.red : Color.white);   g.drawLine(p.x -rp.x+w/2,  p.y-rp.y, p.x -rp.x+w/2,  p.y-rp.y+h);
	    g.setColor(maysplit && e.getY()>=h/2 ? Color.red : Color.white);  g.drawLine(p.x -rp.x,  p.y-rp.y+h/2,  p.x -rp.x+w,  p.y-rp.y+h/2);
	    
	    g.setClip(oldx, oldy, iw , ih);
	    showpan.mf.getRootPane().paint(g);
	    g.setClip(x, y, iw, ih);
	    dragicon.paintIcon(showpan.mf.getRootPane().getGlassPane(), g,  x, y);
	    oldx=x; oldy=y;
	    g.dispose();
	}
    }
    
    public void mousePressed(MouseEvent e) {
	getAbsLocation(e);
	
	
	if (cimap.get(source) !=null && !(source instanceof paramValueChooser.jcmslider)) {
	    infob io=cimap.get(source);
	    dragicon=io.getIcon();
	    dragname=io.getName();
	    carrying=io;
	}
	
	if (source instanceof JTree) {
	    JTree tree= (JTree) source;
	    TreePath tp= tree.getClosestPathForLocation(e.getX(), e.getY() );
	    if (tp==null) return;
	    Object o=tp.getLastPathComponent();
	    if (o instanceof infob && !(o instanceof param))  {
		infob io=(infob)o;
		dragicon=io.getIcon();
		dragname=io.getName();
		carrying=io;
		//if (io.actions!=null) carrying=io.actions.get(0);
		//could be useful to pick up the action IF we had filtered the tree for tables etc.
	    }
	}
	
	if (source instanceof jcmTabbedPane) {
	    jcmTabbedPane jtp = (jcmTabbedPane)source;
	    int i= jtp.intab(e);
	    if (i>=0)  {
		carrying=(JComponent) jtp.getComponentAt(i);
		dragicon= jtp.getIconAt(i);
		dragname=jtp.names.get(i); //getTitleAt(i);
	    }
	}
	
	if (source instanceof JInternalFrame) { //this doesn't work yet
	    deb("MousePressed JIF");
	    if (inside) {
		carrying=(JComponent) ((JInternalFrame)source).getContentPane();
		dragicon= ((JInternalFrame)source).getFrameIcon();
	    }
	}
	
	
	if (carrying!=null) showpan.mf.getRootPane().getGlassPane().setVisible(true);
    }
    
    public void mouseClicked(MouseEvent e) {
	getAbsLocation(e);
	if (source instanceof jcmTabbedPane) ((jcmTabbedPane)source).tryclose(e);
    }
    
    
    public void mouseReleased(MouseEvent e) {
	if (!getAbsLocation(e)) return;
	showpan.mf.getRootPane().getGlassPane().setVisible(false);
	if (carrying!=null)  {
	    if (maysplit) {
		drop(showpan.split(source, e.getY()>h/2));
	    } else if (!inside) {
		if (!showpan.mf.contains(new Point(x,y))) {
		    JFrame f=new JFrame(dragname); f.setLocation(new Point(p.x+e.getX(), p.y+e.getY())); 
                    jcmTabbedPane jtp = new jcmTabbedPane(); 
                      f.setSize(source.getSize());  f.show();
                     jtp.setSize(source.getSize()); f.add(jtp); drop(jtp);
		    //drop(f);
		} else {
		    drop(showpan.findContainer(new Point(x,y))); 
		}
	    }
	    carrying=null; source=null;
	}
    }
    
    
    void drop(Container dest) {
	if (carrying!=null) {
	    if (carrying instanceof JComponent) {
		if (source !=null) source.remove((JComponent)carrying);
		showpan.show((JComponent)carrying,  dest, dragicon, dragname);
	    } else if (carrying instanceof curveset) {
		showpan.makepan(lineplot.class, carrying, dest, dragicon, dragname);
	    } else if (carrying instanceof infob) {
		showpan.makepan(jcmTree.class, new Object[]{carrying}, dest, dragicon, dragname);
		//((infob)carrying).getIcon(), ((infob)carrying).getName()
	    }
	}
    }
    
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
} //end moulist





//*******************************