/*
pops up a progress box for any slow processes: iterations, data-loading etc.

currently used by:
 * optimisation
 * calcscript (general)
 * regseacli
 * regcli (load gcm data)
 * labman (load all labels)
 * attribMarginal

Code for pasting elsewhere:
implements Runnable
processdialog pd=new processdialog(this, "Title", new JLabel("Please Wait..."), new JProgressBar(0,100), new JCheckBox("Running:", true) );
public void run() {}

P2 could be better if pops up only after a minimum delay?

note alternative: Swing ProgressMonitor class:

 */
package jcm.gui.gen;

import java.awt.Point;
import javax.swing.*;
import jcm.gui.nav.showpan;
import static jcm.core.report.*;

public class processdialog implements Runnable {
    public boolean running = false;
    public Runnable caller;
    public Box b = Box.createVerticalBox();
    String name = "please wait...";
    JFrame f;

    public processdialog(Object... args) {

        argloop:
        for (Object a : args) {
            if (a instanceof Runnable) caller = (Runnable) a;
            if (a instanceof String) {
                name = (String) a;
            }
            if (a instanceof JComponent) {
                b.add((JComponent) a);
            }
        }

        displayandgo();
    }

    /*
    note: although go starts a new thread, it is important not to do this before the pd frame is showing!
    also - should wait until initial setup has finished
    variant - not eventdispatchthread - principally, for startjcm, maybe also scripts
    
     */
    void displayandgo() {
        try {
            if (jcm.core.setup.doingsetup) {
                new Thread("processdialog waiting for setup") {
                    public void run() {
                        try {
                            while (jcm.core.setup.doingsetup) sleep(100);
                        } catch (Exception e) {
                            deb(e);
                        }
                    }
                }.start();
            }

            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(this);
            } else {
                SwingUtilities.invokeLater(this);
            }
        } catch (Exception e) {
            deb("exeption in showing and running process dialog");
            e.printStackTrace();
        }
    }
    public Thread mythread; //needed for reference by optimisation

    public void run() {
        makeFrame();
        //rest of this method is used when the Runnable caller is not itself a thread
        if (!running && caller != null && !(caller instanceof Thread)) {
            mythread = new Thread("Process Dialog") {
                public void run() {
                    running = true;
                    //setPriority(Thread.MIN_PRIORITY);
                    caller.run();
                    f.dispose();
                    running = false;
                }
            };
            mythread.start();
        //Thread.currentThread().yield();
        }
    }

    void makeFrame() {
        f = new JFrame(name);
        f.setUndecorated(true);
        f.setSize(200, 160);
        f.add(b);
        Point p = showpan.screencenter();
        p.translate(-100, -80);
        f.setLocation(p);
        f.show();
        try {
            f.toFront();
        } catch (Exception e) {
        }
    }
} //end class

/*

P1 TIDY old processdialog methods

public JLabel pinfo;
public JProgressBar pb;
public JCheckBox cb;


int bc=0, sc=0; //counters

if (a instanceof Boolean)  {
//could make pb and cb arguments instead?
if (bc==0) if ((Boolean)a==true) { pb=new JProgressBar(0,100); }
if (bc==1) if ((Boolean)a ==true) { cb=new JCheckBox("Running:", true); b.add(cb); }
bc++;
}
 */

/*
if (a instanceof String) {
String s=a.toString();
if (sc==0)  { setName(s); repaint(); }
if (sc==1)  b.add(new JLabel(s));
if (sc==2)  {pinfo=new JLabel(s); pinfo.setForeground(Color.red); b.add(pinfo); }

sc++;
}
}
 */
