package jcm.gui.gen;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import jcm.core.*;
import javax.swing.*;
import javax.swing.plaf.metal.*;
import jcm.core.par.param;
import jcm.gui.nav.showpan;
import jcm.core.tls.fileio;
import jcm.java6methods;
import static jcm.core.report.*;

public class lookandfeel {
    static final MetalTheme ocean = MetalLookAndFeel.getCurrentTheme(),  metal = new DefaultMetalTheme();
    static UIManager.LookAndFeelInfo systemlf,  substance,  nimrod,  lastchosen, deflaf;
    public static boolean gotmac = false;
    
    static {
        try {
            for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
                if (lafi.getName().contains("Mac")) {
                    gotmac = true;
                    deb("Found Mac Look and Feel");
                }
            }
 //	    install(fileio.loadtab("defsetup/lookandfeel.info", ","));
            UIManager.installLookAndFeel("Ocean", "javax.swing.plaf.metal.MetalLookAndFeel");
          /*call to substance will not compile unless substance v5+ jar is in your classpath and you are using Java 6+, but substance just looks nice, it's not essential for JCM */
                java6methods.installSubstance();
            
            String[][] elfs = fileio.loadtab(new File(fileio.getOutDir("lookfeel"), "lookandfeel.info"), ",");
            for (String[] elf : elfs) if (elf.length > 0) UIManager.installLookAndFeel(elf[0], elf[1]);
        } catch (Exception ex) {
            deb(ex, "look&feel install not complete: ");
        }

        for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
            if (lafi.getClassName().equals(UIManager.getSystemLookAndFeelClassName())) systemlf = lafi;
            if (lafi.getName().equals("Substance")) substance = lafi;
            if (lafi.getName().equals("NimROD")) nimrod = lafi;
        }
        //set default l&f 
        deflaf=gotmac ? systemlf : nimrod != null ? nimrod : substance != null ? substance : systemlf; 
    }
    //****************** PARAMS ********************
    public static param antiAlias = new param("AntiAlias", true) {
        public void precalc() {
            if (showpan.mf != null) showpan.mf.repaint();
        }

    };
    public static param fontSize = new param("FontSize", "", 12f, 0f, 36f, complexity.simplest) {
        public void precalc() {
            colfont.setFontSize(val);
            if (showpan.mf != null) showpan.mf.repaint();
        }
    };

    public static param bigscales = new param("Larger Scales", false) {
        public void precalc() {
                  if (showpan.mf != null) showpan.mf.repaint();
      }
    };

    public static param<UIManager.LookAndFeelInfo> lookAndFeelParam = new param<UIManager.LookAndFeelInfo>("lookandfeelmenu", UIManager.getInstalledLookAndFeels(), deflaf, complexity.simplest) {
        public void precalc() {
            if (chosen != null && !chosen.equals(lastchosen)) setlf( getchosen());
            lastchosen =  chosen; 
        }

    };
    public static param macMenuBar = new param("Use Mac Menu Bar", false) {
        public void precalc() {
            System.setProperty("apple.laf.useScreenMenuBar", Boolean.toString(istrue()));
            if (lastchosen.getName().contains("Mac")) setlf( lastchosen);
        }

    };
    
    static {
        register.setAlwaysOutput(lookAndFeelParam);
        register.setAlwaysOutput(antiAlias);
        register.setAlwaysOutput(fontSize);
        register.setAlwaysOutput(bigscales);
        if (gotmac) register.setAlwaysOutput(macMenuBar);
    //for (Object o : UIManager.getDefaults().keySet()) System.err.println(o+" => "+UIManager.getDefaults().get(o));
    }

    public static void setFontSizeForFrame() {
        int size = (int) (12.0 * showpan.mf.getWidth() / 1024);
        if (size < 8) size = 10;
        if (size > 16) size = 16;
        if ((int) fontSize.getval() != size) fontSize.set(size);
    }
    //*****************************************************
    public static void setAntiAlias(Graphics g) {
        if (antiAlias.istrue()) ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    //g2.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY); //SPEED);
    }

    static void setlf(UIManager.LookAndFeelInfo lfi) {

        if (lfi != null) {

            String name = lfi.getName(), classname = lfi.getClassName();
            if (name.startsWith("Metal")) MetalLookAndFeel.setCurrentTheme(metal);
            if (name.equals("Ocean")) MetalLookAndFeel.setCurrentTheme(ocean);

            try {
                UIManager.setLookAndFeel(classname);

                deb("L&F updating UI");
                if (showpan.mf != null) {
                    //try to avoid crash during complex reset when panels removed...
                    SwingUtilities.invokeLater(new Runnable() {
                                           public void run() {
                                               SwingUtilities.updateComponentTreeUI(showpan.mf);
                                           }
                                       });
                }
            } catch (Exception ex) {
                deb(ex, "problem for " + classname + " look & feel: ");
            }
        }
    }

} //class

              /* 
                register.class.getClassLoader().loadClass("com.nilo.plaf.nimrod.NimRODLookAndFeel");
                UIManager.installLookAndFeel("NimROD", "com.nilo.plaf.nimrod.NimRODLookAndFeel");
                deb("installed nimROD");
                 */
 
