

package jcm.gui.gen;

import java.awt.*;

import de.erichseifert.vectorgraphics2d.SVGGraphics2D;

import java.awt.datatransfer.*;
import java.awt.image.*;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.imageio.ImageIO;

import jcm.core.complexity;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.core.tls.fileio;
import static  jcm.core.report.*;

public class imagesaver  {
    

    
/*
 Copy into a popupmenu p
	p.add(imagesaver.copyaction(painter));
	p.add(imagesaver.saveimagemenu(painter, name));
 */
    
    public static jcmAction copyaction(final Component painter) {
	return new jcmAction("Copy image") {  public void act() { copy(painter); }};
    }
    
    public static jcmMenu saveimagemenu(final Component painter, final String name) {
	jcmMenu saveimage=new jcmMenu("Save image", complexity.simplest);
	// ImageIO.getWriterFileNames()
	for (final String s : new String[]{ "svg", "png", "png-transparent", "jpg"})  saveimage.add( new jcmAction(s, complexity.simplest) {  public void act() { saveimage(painter, name, s); }});
	return saveimage;
    }
    
    static BufferedImage getimage(Component c, boolean transparent) {
	//showpan.mf.setDefaultLookAndFeelDecorated(true); //so we see the title bar
	BufferedImage bi=new BufferedImage(c.getSize().width, c.getSize().height, transparent ? BufferedImage.TYPE_4BYTE_ABGR : BufferedImage.TYPE_3BYTE_BGR);
	c.paintAll(bi.getGraphics());
	//showpan.mf.setDefaultLookAndFeelDecorated(false);
	return transparent ? maketrans(bi) : bi;
    }
    
    
    static BufferedImage maketrans(BufferedImage bi) {
	try {
	    BufferedImage bi2=new BufferedImage(bi.getWidth(), bi.getHeight(),  BufferedImage.TYPE_INT_ARGB);
	    int mask=bi.getRGB(0,0);
	    for (int x=0; x<bi.getWidth(); x++) for (int y=0; y<bi.getHeight(); y++) bi2.setRGB( x,y,
		    bi.getRGB(x,y)==mask ? 0 : bi.getRGB(x,y)
		    );
	    return bi2;
	} catch (Exception e) { return null; }
    }
    
    static String converttype(String type) { String type2=type.substring(0,3); if (type2.equals("jpg")) type2="jpeg"; return type2; }
    static boolean transparent(String type) { return type.endsWith("transparent"); }
    
    //called from menus - opens a dialog
    public static void saveimage(Component painter, String name, String type){
	fileio f=new fileio("images", name,  type.substring(0,3), "Save Image", "save");
	saveimage(painter, type, f);
    }
    
    //called directly from scripts
    public static void saveimage(Component painter, String type, File f){
	saveimage(painter, type, new fileio(f));
    }
    
    public static void saveimage(Component painter, String type, fileio f){
    	Runnable isav=new Runnable()  {
        	public void run() { 
        		try {
        			deb("Trying to save image "+f.fullname);
        			if(type.equals("svg")) {
        				SVGGraphics2D g = new SVGGraphics2D(0.0, 0.0, painter.getWidth(), painter.getHeight());
        				  
        				painter.paintAll(g);

        		        try {
        		        	deb("making SVG");
        		            byte[] ggb=g.getBytes();
        		        	//Note g.getBytes() is very slow!!
        		            deb("adjust and save SVG"); 
        		            f.os.write( removewhiteboxes(/*reducedp(*/ggb));
        		        } finally {
        		            f.os.close();
        		        }
        			}
        			else {
        				BufferedImage b = getimage(painter, transparent(type));
        				ImageIO.write(b, converttype(type), f.os);
        				f.save();
        			}
        			deb("Saving completed");
        		} catch (Exception e) { deb(e, "Couldn't Save Image");  e.printStackTrace(); } 
        	}
        };
        new Thread(isav).start();
    }
    
    /* Code below reduces SVG file size by cutting decimal places - beyond 3 seems to work ok, less => quality loss
     * Problem is cutting dp may also apply to eg matrix transform info, which may distort results a bit - hence also preserve sigfigs
     * And maybe poor if very small numbers in original table -eg for aviation RF 
     * Rather than fixing further -consider implementing my own SVG output - using relative rather than absolute data for paths..
     */

    static byte[] reducedp(byte[] a) {
    	
    	byte[] b = new byte[a.length];
    	int  ca=0, cb=0, cd=0, cs=0; boolean num=false, sig=false, adp=false, keep=true;   
    	//cs is significant figures, cd is decimal places
    	char dot='.' , zero= '0', nine='9' ;
    	
    	while (ca<a.length ){
    		char c=(char)a[ca];
    		//boolean dig=Character.isDigit(c);
    		boolean dig=(c>=zero && c<=nine);
    		if (num && c==dot) adp=true;
    		if (dig)   num=true;  
    		if (dig && c!=zero) sig=true;
    		if (sig) cs++;
    		if (num && !dig && c!=dot) { //end num
    			num=false; sig=false; cd=0; cs=0; adp=false; keep=true;
    		}
    		if (dig && adp) {
    			cd++;
    			if (cd>3 && cs>5) keep=false;
    		}
    		if (keep) { b[cb]=a[ca]; cb++; }
    		ca++;
      	}
    	  
    	byte[] out=new byte[cb];
    	System.arraycopy(b, 0, out, 0, cb); 
    	return out;
    }
    
    static byte[] removewhiteboxes(byte[] a)   {
    	
    	StringBuilder sb=new StringBuilder("");
    	
    	try {
			String[] ss = new String (a, "UTF-8").split("\n");
			for (String s : ss) {
				if (s.contains("<rect") && (s.contains("fill:rgb(255,255,255)") ||  s.contains("fill:rgb(238,238,238)") )) continue;
				else sb.append(s+"\n");
			}
    	
    	byte[] out= sb.toString().getBytes("UTF-8");
      	//sb.getBytes(0,sb.length(), out, 0);
      	
    	return out;
    	} catch (Exception e) {  e.printStackTrace(); return null; }

    }
    
    
    //******************************
    
    
    public static void copy(final Component c) {
	try {
	    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(
		    new Transferable() {
		public DataFlavor[] getTransferDataFlavors() { return new DataFlavor[]{DataFlavor.imageFlavor}; }
		public boolean isDataFlavorSupported(DataFlavor flavor) { return flavor.equals(DataFlavor.imageFlavor); }
		public Object getTransferData(DataFlavor flavor)  throws UnsupportedFlavorException, IOException { return getimage(c, false);   }
	    } ,
		    new ClipboardOwner() {
		public void lostOwnership(Clipboard clipboard, Transferable contents) {}
	    }
	    );
	   log("copied image");
	} catch (Exception ex) {	deb(ex, "Error copying "+c); };
    }
    
}
