package jcm.gui.gen;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.*;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.gui.doc.labman;
import static jcm.gui.gen.colfont.*;

public class Gauge extends JButton implements MouseListener, MouseMotionListener {
    
    public int lev, max, ov=-1;
    int w, h;
    int xs=6, ys=5;
    Color ca=dkred, cb=dkgreen, cc=orange;
    param<complexity> p;
    
    public Gauge(int l, int n) {
	lev=l; max=n;
	setSize();
    }
    
    public Gauge(param<complexity> p) {
	this.p=p;
	lev=p.chosen.ordinal(); max=p.chosen.values().length;
	setTip();
	setSize();
    }
    
    void setSize() {
	w=max*xs+2; h=max*ys+4;
	Dimension d=new Dimension(w+4, h+2);
	setPreferredSize(d);
	setMinimumSize(d);
	setMaximumSize(d);
	addMouseMotionListener(this);
	addMouseListener(this);
    }
    
    void setTip() {
	setToolTipText(labman.getShort("complexity&colon&"+p.chosen.toString()));
    }
    
    public void paint(Graphics g) {
	super.paint(g);
	lookandfeel.setAntiAlias(g);
	//g.setColor(getBackground().darker());
	//g.drawRoundRect(0,0,w, h,2,2);
	for (int i=0; i<max; i++){
	    int bh=(i+1)*ys;
	    Color base=(i==ov ? cc : i<=lev ? ca : cb);
	    g.setColor(base.brighter());
	    g.drawRect(1+i*xs, h-(i+1)*ys -2, xs-1, bh );
	    g.setColor(base.darker());
	    g.drawRect(2+i*xs, h-(i+1)*ys-1, xs-2, bh-1);
	    g.setColor(base);
	    g.fillRect(2+i*xs, h-(i+1)*ys-1, xs-2, bh-1);
	}
    }
    
    public void mouseMoved(MouseEvent e) { int nov=e.getX()/xs; if (nov!=ov) { ov=nov; repaint(); } }
    public void mouseDragged(MouseEvent e) { }
    public void mousePressed(MouseEvent e) {  }
    public void mouseReleased(MouseEvent e) { int nov=e.getX()/xs; lev=ov; if (p!=null) { p.set(lev); setTip(); }  repaint();  }
    public void mouseClicked(MouseEvent e) {  }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) { ov=-1; repaint(); }
    
}
