package jcm.core.tls;

import jcm.core.*;
import jcm.core.anno.*;
import jcm.core.ob.*;
import java.lang.reflect.*;
import java.lang.annotation.Annotation;
import java.util.*;
import static jcm.core.report.*;

/**
A set of convenience methods using java reflection to find JCM components
Mostly predates update to java 5, maybe no longer optimal methods
 */
public class ref {

    public static float[] copy(float[] a) {
        float[] f = new float[a.length];
        System.arraycopy(a, 0, f, 0, a.length);
        return f;
    }

    public static Object add(Object a, double d) {
        return add(a, new Double(d));
    }

    public static Object add(Object a, Object o) {
        int al = Array.getLength(a);
        Object b = Array.newInstance(a.getClass().getComponentType(), al + 1);
        System.arraycopy(a, 0, b, 0, al);
        if (o instanceof Double) Array.setDouble(b, al, ((Double) o).doubleValue());
        else Array.set(b, al, o);
        return b;
    }

    public static Class findclass(String name) {
        for (String s : root.packages) {
            try {
                return Class.forName(s + name);
            } catch (ClassNotFoundException e) {
            }
            infob o = root.rootob.find(s + name);
            if (o != null) try {
                    return Class.forName(o.name);
                } catch (ClassNotFoundException e) {
                } //to find even if case different
        }
        return null;
    }

    //***********************
    public static LinkedHashSet getallobs(Object o ) { return getallobs(o, false) ;}
    public static LinkedHashSet getallobs(Object o, boolean incprivate) {
        LinkedHashSet s = new LinkedHashSet();
        try {
            Class c = o.getClass();
            while (c != null) {
                java.lang.reflect.Field[] f = (incprivate ? c.getDeclaredFields() : c.getFields());
                /*
                note problem with getFields: The elements in the array returned are not sorted and are not in any particular order.
                note getFields gets only public fields but includes superclasses,
                getDeclaredFields gets all fields but excludes superclasses
                 */
                for (java.lang.reflect.Field ff : f) if (ff.getDeclaringClass() == c) {
                        s.add(ff.get(o));
                    }
                c = c.getSuperclass();
            }
        } catch (IllegalAccessException e) {
            deb(e);
        }
        ;
        return s;
    }

    /**
    Looks in the owner's class to find a Field that is the declaration of this object
     */
    //P1 check:  don't need to use getfield any more for infobs, if declaration is filled when module created"
    public static Field getfield(Object o, Object owner) {
        Class c = owner.getClass();
        Field[] ff;
        try {
            ff = c.getDeclaredFields();
        } catch (SecurityException e) {
            ff = c.getFields();
        } //note getFields only find the public ones
        for (Field f : ff) {
            try {
                if (f.get(owner) == o) return f;
            } catch (IllegalAccessException e) {
            } // deb("get field "+f+": "+e); }
        }
        return null;
    }

    /**
    Searches for infob Fields within the class of the owner, and tells them their annotations 
     */
    public static void getAnnotations(Object owner) {
        try {
            Field[] ff;
            Annotation[] aa;
            Class c = owner.getClass();
            if (owner instanceof infob) ((infob) owner).notes = c.getDeclaredAnnotations();

            try {
                ff = c.getDeclaredFields();
            } catch (SecurityException e) {
                ff = c.getFields();
            } //note getFields only find the public ones

            if (ff != null) for (Field f : ff) {
                    aa = f.getDeclaredAnnotations();
                    if (aa.length > 0) try {
                            Object o = f.get(owner);
                            if (o != null && o instanceof infob) ((infob) o).notes = aa;
//		deb("reg annotation "+aa+" for "+o);
                        } catch (IllegalAccessException e) {
                        }
                }
        } catch (Exception e) {
            deb(e);
            e.printStackTrace();
        }
    }

    /**
    Looks in this class to find a field of the specified name
     */
    public static Field getfield(Object o, String name) {
        try {
            return o.getClass().getField(name);
        } catch (Exception e) {
            deb(e);
            return null;
        }
    }

    public static boolean isstatic(Object o, Object owner) {
        if (o == owner) return false; // this will apply to all modules
        Field f = getfield(o, owner);
        if (f == null) return false;
        return Modifier.isStatic(f.getModifiers());
    }

    public static Object get(Object o, String name) {
        try {
            return o.getClass().getField(name).get(o);
        } catch (Exception e) {
            deb(e);
            return null;
        }
    }

    public static boolean isarray(Field f) {
        return f.getType().isArray();
    }

    public static String fieldval(interacob i, Field f) {
        try {
            return f.get(i).toString();
        } catch (IllegalAccessException e) {
            deb(e);
            return "";
        }
    }

    public static String arrayval(interacob i, Field f, int ci) {
        try {
            return Array.get(f.get(i), ci).toString();
        } catch (IllegalAccessException e) {
            deb(e);
            return "";
        }
    }

    public static String fieldinfo(interacob i, Field f) {
        return i.name + "." + f.getName() + " " + fieldval(i, f);
    }

    public static String arrayinfo(interacob i, Field f, int ci) {
        return i.name + "." + f.getName() + "[" + ci + "] " + arrayval(i, f, ci);
    }

    //add shorts and longs and Objects here too!
    public static void setarray(interacob i, Field f, int ci, String g) {
        try {
            if (Array.get(f.get(i), ci) instanceof Double) {
                Array.setDouble(f.get(i), ci, txt.dv(g));
                return;
            }
            if (Array.get(f.get(i), ci) instanceof Float) {
                Array.setFloat(f.get(i), ci, txt.fv(g));
                return;
            }
            if (Array.get(f.get(i), ci) instanceof Integer) {
                Array.setInt(f.get(i), ci, txt.iv(g));
                return;
            }
            if (Array.get(f.get(i), ci) instanceof Boolean) {
                Array.setBoolean(f.get(i), ci, txt.bv(g));
                return;
            }
            Array.set(f.get(i), ci, g); //object reference (including string)
        } catch (IllegalAccessException e) {
            deb(e);
        }
    }

    public static void setfield(interacob i, Field f, String g) {
        try {
            if (f.get(i) instanceof Double) {
                f.setDouble(i, txt.dv(g));
                return;
            }
            if (f.get(i) instanceof Float) {
                f.setFloat(i, txt.fv(g));
                return;
            }
            if (f.get(i) instanceof Integer) {
                f.setInt(i, txt.iv(g));
                return;
            }
            if (f.get(i) instanceof Boolean) {
                f.setBoolean(i, txt.bv(g));
                return;
            }
            f.set(i, g); //object reference (including string)
        } catch (IllegalAccessException e) {
            deb(e);
        }
    }

    public static boolean anymatch(Object[] a, Object[] b) {
        for (int i = 0; i < a.length; i++) for (int j = 0; j < b.length; j++) if (a[i] == b[j]) return true;
        return false;
    }
} //end class


//P1 tidy use or cut old code
//*****************************

/*
static Field getfield(iob iob, String name) {
if (iob!=null) {
Field[] f=root.getClass().getFields();
for (int i=0; i<f.length; i++) if (f[i].getName().equals(name)) return f[i];
}
return null;
}
 */

//************************************
    /* old no longer used QUERY JAVA FIELDS
//used by player
//note also getiobs in iob, and autofindinteractions in graph
public static String readval(String name, boolean fullinfo) {
String[] s= txt.split(name, "."); if (s!=null && s.length>1) {
interacob i = register.findiob(s[0]); if (i!=null) {
Field f = ref.getfield(i, s[1]); if (f!=null)  {
if (ref.isarray(f) && s.length>2)  return (fullinfo ? ref.arrayinfo(i, f, txt.iv(s[2]))  :  ref.arrayval(i, f, txt.iv(s[2])) );
else return (fullinfo ? ref.fieldinfo(i, f)  : ref.fieldval(i, f) );
}
}
}
return null;
}
public static boolean writeval(String name, String a) {
String[] s= txt.split(name, "."); if (s!=null && s.length>1) {
interacob i = register.findiob(s[0]); if (i!=null) {
Field f = ref.getfield(i, s[1]); if (f!=null)  {
if (ref.isarray(f) && s.length>2)  {	ref.setarray(i, f, txt.iv(s[2]), a); return true; } else {	ref.setfield(i, f, a); return true; }
}
}
}
return false;
}
 */

