/*
PERSISTENCE OF JCM SETUP (BOTH PARAMETERS AND WINDOWS)
 */
package jcm.core;

import java.awt.*;
import javax.swing.*;
import java.io.*;
import java.lang.ref.WeakReference;
import java.util.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.cur.curvar;
import jcm.core.par.param;
import jcm.core.cur.*;
import jcm.core.ob.*;
import jcm.core.itf.hasSetupInfo;
import jcm.core.tls.fileio;
import jcm.gui.nav.*;
import jcm.gui.doc.labman;
import jcm.gui.gen.splash;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmTree;
import static jcm.core.complexity.*;
import static jcm.core.report.*;

public class setup {
    public static String savedir = "setup",  current = "current";
    public static boolean loadcurrent = true,  doingsetup = false,  restart = false;
    static Rectangle orig,  newr;
    static float sx = 1f,  sy = 1f;
    static JFrame mf; //set on loading
    static Set<JComponent> onTop = new HashSet(8); //only used during loading (to avoid references)
    //**************** SETUP MENU **************************************

    public static void fillMenu(jcmMenu setupm) {
        setupm.add(new jcmAction("Reset All Parameters", simplest) {
               public void act() {
                   register.resetall(true, false);
               }
           });
        setupm.add(new jcmAction("Reset Sci-Model Params") {
               public void act() {
                   register.resetall(false, false);
               }
           });
        setupm.add(new jcmAction("Reset Sci-Model Params +Force All Calc") {
               public void act() {
                   register.resetall(false, true);
               }
           });

        //check if any sci params not owned by  a module?
        //setupm.add(new jcmAction("Reset All including Layout") {	public void act() {	loadsetup(fileio.loadtab("defsetup/default.jcms", "\t"));  }});
        setupm.addSeparator();
        setupm.add(new jcmAction("Load Setup") {
               public void act() {
                   loadsetupdialog();
               }
           });
        setupm.add(new jcmAction("Save Setup") {
               public void act() {
                   savesetupdialog();
               }
           });
        setupm.add(new jcmAction("Set Directory") {
               public void act() {
                   fileio.setDefDir();
               }
           });
        setupm.addSeparator();
        makemenu(setupm, root.rootob.find("defsetup"));
        setupm.addSeparator();
    }

    static void makemenu(jcmMenu m, infob io) {
        for (infob o : io.getObs()) {
            if (o.getObs() != null) {
                final String s1 = o.toString().substring(o.toString().lastIndexOf(".") + 1);
                jcmMenu m2 = new jcmMenu(s1, simplest);
                makemenu(m2, o);
                m.add(m2);
            } else {
                final String s1 = o.toString();
                int ld = s1.lastIndexOf(".");
                final String s2 = s1.substring(s1.lastIndexOf(".", ld - 1) + 1, ld),  s3 = s1.substring(0, ld).replace(".", "/") + ".jcms";
                m.add(new jcmAction(s2, simplest) {
                  public void act() {
                      deb("called loadsetup from menu action");
                      loadsetup(fileio.loadtab(s3, "\t"), s2);
                  }
              });
            }
        }
    }
    //************** SAVE ****************************************
    public static void savesetupdialog() {
        fileio f = new fileio(savedir, current, "jcms", "Save Setup", "save");
        fileio.savetextfile(new OutputStreamWriter(f.os), savesetup());
        f.save();
    }

    public static void savesetupdefault() {
        fileio.savetextfile(savedir, current + ".jcms", savesetup());
    }
//***********************************************
    public static String savesetup() {
        mf = showpan.mf;
        String list = "";
        for (world w : world.worlds) list += "world\t" + w.getName() + "\t" + w.getColor().getRed() + "\t" + w.getColor().getGreen() + "\t" + w.getColor().getBlue() + "\n";
        for (interacob i : register.alliobs) {
            if (i instanceof param && !((param) i).isdefault()) list += "param\t" + ((param) i).save();
            if (i instanceof curveset && ((curveset) i).temporary) list += saveqtset((curveset) i);
        }

        list += savemainwin();
        list += recordSplit((JSplitPane) mf.getContentPane()) + "\n";

        panloop:
        for (WeakReference<JComponent> wrc : register.winmap.keySet()) {
            if (wrc.get() == null || wrc.get().getParent() == null) continue panloop;
            if (!wrc.get().getRootPane().isShowing()) continue panloop; //gets rid of closed external or internal frames
            list += savecomp(wrc);
        }
        return list;
    }
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//************ LOAD - variants  ******************************************
    //** reload the previous setup saved as current.jcms*/
    public static boolean loadcurrentsetup() {
        deb("called loadcurrentsetup");
        try {
            if (loadcurrent && loadsetup(fileio.loadtabfrompersist(savedir, current + ".jcms", "\t"), current)) return true;
        } catch (Exception e) {
            deb(e);
        }
        return loadpacksetup("default");
    }

    //** load a setup chosen by user via a load file dialog*/
    static boolean loadsetupdialog() {
        deb("called loadsetupdialog");
        return loadsetup(fileio.loadtabfromdialog(savedir, current + ".jcms", "Load Setup", "\t"), fileio.lastloaded);
    }
    //**load one of the pre-defined setups within the defsetup folder in jcm.jar*/
    public static boolean loadpacksetup(String s) {
        deb("called loadpacksetup");
        return loadsetup(fileio.loadtab("defsetup/" + s + ".jcms", "\t"), s);
    }

    /* this is the (internal) method that manages the setup loading thread
    Re-fixed winter 08 after thread issues identified as source of bugs reloading setups (see emails Philippe). 
    General problem is - setup takes a long time -  we need the GUI of model to remain responsive - so don't run in EventDispatching Thread
    But shouldn't do anything else at the same time that modifies the model to cause - for example -  concurrent modification exception when changing register
    Particularly sensitive when setup includes slow plots/calculations such as regclimap (in 9 plot setup).
    Note: calls to setup from within the JCM gui are usually within EDT, but initial call from the startjcm main thread is *not*.
    
    Ph discovered majority (but not all) problems solved just by pausing 1s after the setup - i.e. shouldn't continue to next step (in EDT response to menu) until setup finished. 
    So - try solving this by requiring doingsetup to be false before continuing
    Also tidied up loadsetup2 up using an "invoke" method for EDT and moved closeold into this  
     - running closeold in EDT helped with exceptions but causes "blank" panels for a second or so - maybe ok as indicates that user needs to wait.
     */
    static boolean loadsetup(final String[][] list, final String name) {
        if (SwingUtilities.isEventDispatchThread()) {
            deb("starting new thread for loading setup");
            new Thread("Setup Thread") {
                public void run() {
                    loadsetup2(list, name);
                }
            }.start();
            try {
                while (doingsetup) Thread.sleep(100);
            } catch (InterruptedException ex) {
                deb(ex, "waiting for setup to finish interrupted");
            }
            return true;
        } else return loadsetup2(list, name);
    }
//************** LOAD all items **************************************
    /** this is the main loop going through all items in the setup in turn*/
    static boolean loadsetup2(String[][] list, String name) {
        if (list.length == 0) return false;
        
        doingsetup = true;
        deb("setup start");
        invoke(new String[]{"closeold"});
        for (final String[] s : list) invoke(s);
        invoke(new String[]{"loopgonow"});
        setontop();
        deb("setup finished");
        doingsetup = false;

        if (restart) { //restart may be triggered by user pressing the restart button on splash screen after the setup began
            restart = false;
            loadcurrentsetup();
        }
        return true;
    }
    
// invoke calls each item in the event dispatching thread separately, allows elements to display one at a time - otherwise swing would put all 'show' to the end of the queue'
    static void invoke(final String[] s) {
        try {
            if (SwingUtilities.isEventDispatchThread()) deb("error - shouldn't call setup from Event Dispatch Thread! - setup ignored ");
            else SwingUtilities.invokeAndWait(new Runnable() {
                                          public void run() {
                                              setup(s);
                                          }
                                      });
        } catch (Exception ex) {
            String a = "";
            for (String ss : s) a += " _ " + ss;
            deb(ex, "setup error " + a); 
        }
    }
//****************** LOAD- SETUP one item ******************
    static void setup(final String[] s) {
        if (restart) return;
        if (s.length == 0) return;
        String type = s[0];
        if (type.equals("closeold")) closeold();
        if (type.equals("loopgonow")) loop.gonow();


//temporary - convert old setups
        if (s[0].equals("worlds")) {
            for (int i = 1; i < s.length; i++) {
                String[] s2 = new String[2];
                s2[0] = "world";
                s2[1] = s[i];
                setup(s2);
            }
            return;
        }
        if (s[0].equals("window") && s[1].equals("Main")) {
            String[] s2 = new String[6];
            s2[0] = "mainwin";
            s2[1] = s[4];
            s2[2] = s[5];
            s2[3] = s[2];
            s2[4] = s[3];
            s2[5] = "maximised";
            setup(s2);
            return;
        }
        if (s[0].equals("window")) {
            String[] s2 = new String[s.length + 1];
            s2[0] = "panel";
            s2[1] = s[1];
            s2[2] = s[4];
            s2[3] = s[5];
            s2[4] = s[2];
            s2[5] = s[3];
            s2[6] = "true";
            for (int i = 6; i < s.length; i++) s2[i + 1] = s[i];
            setup(s2);
            return;
        }

        interacob i;
        param p;
        mf = showpan.mf;
        loop.waitUntilLoopDone();

        String all = "Setup: ";
        for (String ss : s) all += " \t " + ss;
        splash.report(all);

        try {
            if (s[0].equals("world")) {
                String wname = s[1];
                Color wcol = (s.length > 2) ? new Color(Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])) : Color.black;
                world.makeworld(wname, wcol);
            }

            if (s[0].equals("param") && (i = register.findiobfullname(s[1])) != null) {
                ((param) i).load(s[2]);
                if (mf != null) mf.validate();
            }

            if (s[0].equals("qtset")) addqtset(s);

            if (s[0].equals("split")) {
                if (mf == null) showpan.makeMainframeDefSize();
                applySplit(s, 1, (JSplitPane) mf.getContentPane());
            }

            if (s[0].equals("mainwin")) setmainwin(s);
            if (s[0].equals("panel")) loadcomp(s);

        // mf.setResizable(true); mf.setMaximizedBounds(null); //allow resizing and maximising only after finished setup
        } catch (Exception e) {
            deb(e, "setup error \n"); //e.printStackTrace();
        }
    } //setup one item
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// ***************** CURVESETS *****************
    //only for temporary derived qtsets

    static String saveqtset(curveset qq) {
        String s = "qtset\t" + qq.type;
        if (qq.name.startsWith("Compare&")) s += "\t" + qq.owner.name + "\t" + qq.name;
        if (qq instanceof curvar) {
            curvar qv = (curvar) qq;
            if (qv.linkqq != null) for (curveset qqb : qv.linkqq) s += "\t" + qqb.getFullName();
        }
        return s + "\n";
    }
    //note - older save code had type after first qt name => accomodate both
    static void addqtset(String[] s) {
        curve.Type type = null;
        java.util.List<curveset> lqq = new ArrayList(3);
        interpret:
        for (int i = 1; i < s.length; i++) {
            String ss = s[i];
            if (type == null) for (curve.Type ty : curve.Type.values()) if (ty.toString().equals(ss)) {
                        type = ty;
                        continue interpret;
                    }
            if (ss.startsWith("Compare&")) {
                makederiv.addderiv(lqq.get(0), makederiv.compareworld(lqq.get(0), ss.substring(8)));
                return;
            }

            interacob io = register.findiobfullname(ss);
            if (io instanceof curveset) lqq.add((curveset) io);
        }
        if (type == null) {
            deb("can't match type " + s[2]);
            return;
        }
        makederiv.addnewderiv(type, lqq);
    }
// ***************** SETUP MAIN  WINDOW **************
    static void setname(String name) {
        showpan.mf.setTitle(showpan.mf.getTitle() + " :-" + name);
    }

    static String savemainwin() {
        Point loc = mf.getLocationOnScreen();
        loc.translate(8, 8); //maximising  can shift left pos to -4 , on wrong screen, hence the translate
        boolean mfonscreen = (showpan.screenbounds().contains(loc));
        return "mainwin" + sizelocinfo(mf) + "\t" + (mfonscreen ? mf.getExtendedState() == JFrame.MAXIMIZED_BOTH ? "maximised" : "normal" : "other_screen") + "\n";
    }

    static void setmainwin(String[] s) {

        orig = new Rectangle(pin(s[1]), pin(s[2]), pin(s[3]), pin(s[4]));

        if (s.length > 5 && s[5].equals("maximised")) {
            if (mf == null) mf = showpan.makeMainframeMaximised();
            mf.setExtendedState(JFrame.MAXIMIZED_BOTH);
            newr = showpan.screenbounds();
        } else {
            newr = (s[5].equals("other_screen")) ? orig : orig.intersection(showpan.screenbounds());
            if (mf == null) mf = showpan.makeMainframe(newr);
            else mf.setBounds(newr);
        }

        jcm.gui.gen.lookandfeel.setFontSizeForFrame();
        //jcm.gui.gen.colfont.setFontSize();

        mf.validate();
        setwindim();
        deb("main window: scale: " + sx + " " + sy + " origpos:  " + orig.x + " " + orig.y + " newpos: " + newr.x + " " + newr.y);
//	mf.setResizable(false); mf.setMaximizedBounds(mf.getBounds()); //prevent resizing during setup - maximised doesn't work'
        Thread.currentThread().yield();
    }
// ************** close open windows etc. *******************
    static void closeold() {
        loop.waitUntilLoopDone();
        deb("removing old window refs");
        try {
            for (WeakReference<JComponent> wrc : register.winmap.keySet()) if (wrc.get() != null) {
                    showpan.dispose(wrc.get());
                }
        } catch (Exception ex) {
            deb(ex, "setup dispose error ");
        }

        register.winmap.clear();

        deb("removing temporary interacobs");
        for (interacob i : register.alliobs) {
            if (i.temporary) {
                i.owner.removeOb(i);
                i.disposeLater();
            }
        }

        deb("removing old worlds");
        world.disposeAllButOne();

        deb("reset all");
        jcmTree.restruclink.changed = true; //forces trees to replot
        complexity.defaultcomplexity.changed = true; //forces menus to replot?
        //reset params and run loop (in case any affect window layout etc.) - also calls loop go
        register.resetall(true, true);

        System.gc();
    }
//**************** PANELS  ********************
    static String savecomp(WeakReference<JComponent> wrc) {
        JComponent c = wrc.get();
        //isShowing() || )  { //otherwise lose hidden tabs
        // if (!c.isShowing()) showpan.toFront(c);


        if (c.isShowing()) onTop.add(c);
        if (c instanceof hasSetupInfo) ((hasSetupInfo) c).savesetup();

        String info = "panel\t" + c.getClass().getName() + sizelocinfo(c) + "\t" + c.isShowing();

        for (Object o : register.winmap.get(wrc)) {
            if (o instanceof WeakReference) o = ((WeakReference) o).get();
            if (o instanceof Object[]) for (Object oo : (Object[]) o) info += "\t" + getname(oo);
            else info += "\t" + getname(o);
        }
        info += "\n";
        return info;
    }

    static void loadcomp(String[] s) {

        try {
//	    if (mf==null) mf=showpan.makeMainframeDefSize();
            int a1 = 7;
            int nargs = s.length - a1;
            Object args;
            if (nargs > 1) {
                Object[] args2 = new Object[nargs];
                for (int a = 0; a < nargs; a++) args2[a] = findob(s[a1 + a]);
                args = args2;
            } else args = findob(s[a1]);

            setwindim(); //in case mf was resized during the process
            Point p = convert(new Point(Integer.parseInt(s[2]), Integer.parseInt(s[3])));
            Dimension d = convert(new Dimension(Integer.parseInt(s[4]), Integer.parseInt(s[5])));
            Container co = showpan.findContainerAbsolute(p);

            //below co==null is almost duplicating showpan.show (called from makepan) but not exactly same as here we have absolute point
            if (co == null) {
                Point p2 = new Point(p);
                p2.translate(20, 20);
                co = showpan.findContainerAbsolute(p2);
            }
            if (co == null) {
                Point p2 = new Point(p);
                p2.translate(-20, -20);
                co = showpan.findContainerAbsolute(p2);
            }
            if (co == null) {
                Point p2 = new Point(p);
                p2.translate(-d.width / 2, -d.height / 2); //convert back from middle to top-left
                co = new JFrame(labman.getTitle(s.length > 7 ? s[7] : s[1]));
                co.setLocation(p2);
            }

            JComponent c = showpan.makepan((Class<JComponent>) Class.forName(s[1]), args, co);
            c.setPreferredSize(d);
            if (Boolean.parseBoolean(s[6])) onTop.add(c);
        //loop.go(); //shouldn't be necessary, one loop at end of setup should suffice

        } catch (Exception e) {
            deb("setup window error" + e);
        }
    }
//loc=new Point(loc.x-mf.getX(), loc.y-mf.getY());
//c.setLocation(loc); //expt oct06
//Point q=co.getLocationOnScreen();
//deb("point "+p+" co: "+q);
//***************  SIZE LOC*********
    static String sizelocinfo(Component c) {
        try {
            Dimension d = c.getSize();
            Point p = (c.isShowing() ? c.getLocationOnScreen()
                    : (c.getParent() != null && c.getParent().isShowing()) ? c.getParent().getLocationOnScreen()
                    : new Point(4, 4) //new Point(c.getLocation().x+c.getParent().getLocationOnScreen().x, c.getLocation().y+c.getParent().getLocationOnScreen().y
                    );
            if (!(c instanceof JFrame)) {
                p.x += d.width / 2;
                p.y += d.height / 2;
            } // save centre of component, rather than top-left corner    
            //removed the restriction on negative points, to cope with second screen arranged above or to left of main - may cause other problems?
            //if (p.x < 0) p.x = 0;
            //if (p.y < 0) p.y = 0;
            return "\t" + p.x + "\t" + p.y + "\t" + d.width + "\t" + d.height;
        } catch (Exception e) {
            deb(e + " for sizeloc of " + c);
            return "\t50\t50\t50\t50";
        }
    }
//    public static Component getsizecomp(JComponent c) {
//	return (c instanceof treemaker) ? c : c.getRootPane().getParent();
//    }
    // ************ Convert ******************
    static void setwindim() {
        newr = mf.getBounds();
        sx = (float) newr.width / orig.width;
        sy = (float) newr.height / orig.height;
    }
    //convert to be consistent with dimensions of new window
    static Point convert(Point p) {
        return new Point(newr.x + (int) (sx * (p.x - orig.x)), newr.y + (int) (sy * (p.y - orig.y)));
    }

    static Dimension convert(Dimension d) {
        return new Dimension((int) (sx * d.width), (int) (sy * d.height));
    }
// ************ only used by calcscript **************
    public static void setsizeloc(JComponent c, Point p, Dimension d) {
        JTabbedPane jtp = showpan.findTabbedPane(c);
        if (jtp != null) {
            c.setPreferredSize(convert(d));
            jtp.getParent().validate();
        } else setsizeloc(c.getRootPane().getParent(), convert(p), convert(d));
    }

    public static void setsizeloc(Container c, Point p, Dimension d) {
        c.setLocation(convert(p));
        c.setSize(convert(d));
        mf.validate();
        Thread.currentThread().yield();
    }
//****************** SPLIT PANES ****************
    static String recordSplit(JSplitPane jsp) {
        String s = "split\t" + jsp.getOrientation() + "\t" + jsp.getDividerLocation();
        Component c = jsp.getTopComponent();
        s += "\t" + ((c instanceof JSplitPane) ? recordSplit((JSplitPane) c) : (c instanceof JTabbedPane) ? "tab" : "dtp");
        c = jsp.getBottomComponent();
        s += "\t" + ((c instanceof JSplitPane) ? recordSplit((JSplitPane) c) : (c instanceof JTabbedPane) ? "tab" : "dtp");
        return s;
    }

    static int applySplit(String[] s, int i, JSplitPane jsp) {
        int orient = Integer.parseInt(s[i]);
        int divloc = (int) (Integer.parseInt(s[i + 1]) * (orient == jsp.HORIZONTAL_SPLIT ? sx : sy));

        jsp.setOrientation(orient);
        jsp.setDividerLocation(divloc);

        i += 2;
        if (s[i].equals("split")) {
            JSplitPane jsp2 = new JSplitPane();
            jsp2.setResizeWeight(0.5);
            jsp.setTopComponent(jsp2);
            i = applySplit(s, i + 1, jsp2);
        } else {
            jsp.setTopComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            i++;
        }
        if (s[i].equals("split")) {
            JSplitPane jsp2 = new JSplitPane();
            jsp2.setResizeWeight(0.5);
            jsp.setBottomComponent(jsp2);
            i = applySplit(s, i + 1, jsp2);
        } else {
            jsp.setBottomComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            i++;
        }
        Thread.currentThread().yield();
        return i;
    }

    static void setontop() {
        for (JComponent c : onTop) showpan.toFront(c);
        onTop.clear();
    }

//******************* MISC *********************************
    static int pin(String s) {
        return Integer.parseInt(s);
    }

    static Object findob(String s) {
        Object o = register.findiobfullname(s);
        return o != null ? o : s.equals("null") ? null : s;
    }

    static String getname(Object o) {
        return o == null ? "null" : (o instanceof infob) ? ((infob) o).getFullName() : o.toString();
    }
//*****************************************************************
} //end class

/*
try {
ObjectOutputStream oos=new ObjectOutputStream(new FileOutputStream(file));
oos.writeObject(c); oos.close();
} catch (IOException e) { e.printStackTrace(); }
 */

